/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.crs.repository;

import es.idr.teledeteccion.connection.EpsgConnection;
import es.idr.teledeteccion.connection.Query;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.gvsig.crs.Crs;
import org.gvsig.crs.CrsException;
import org.gvsig.crs.ICrs;
import org.gvsig.crs.repository.ICrsRepository;
import org.gvsig.tools.dispose.Disposable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoAuthRepository
implements ICrsRepository,
Disposable {
    private static final Logger logger = LoggerFactory.getLogger(NoAuthRepository.class);
    EpsgConnection connection = new EpsgConnection();

    public NoAuthRepository() {
        this.connection.setConnectionNoAuth();
    }

    public ICrs getCrs(String code) {
        String cadWKT = "";
        Crs crs = null;
        String sentence = "SELECT crs_code, crs_wkt, crs_proj, crs_geog, crs_datum FROM NOAUTHCRS WHERE crs_code = " + code;
        ResultSet result = Query.select(sentence, this.connection.getConnection());
        try {
            if (!result.next()) {
                return null;
            }
            cadWKT = result.getString("crs_wkt");
        }
        catch (SQLException e1) {
            logger.info("Error executing the SQL", (Throwable)e1);
            return null;
        }
        cadWKT = cadWKT.substring(0, cadWKT.length() - 1) + ", AUTHORITY[\"CRS\"," + Integer.parseInt(code) + "]]";
        try {
            crs = new Crs(Integer.parseInt(code), cadWKT);
        }
        catch (CrsException e) {
            logger.info("Impossible to parse the CRS", (Throwable)e);
        }
        return crs;
    }

    public void dispose() {
        try {
            this.connection.close();
            this.connection = null;
        }
        catch (SQLException ex) {
            logger.warn("Con't shutdown the connection.", (Throwable)ex);
        }
    }
}

