/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.crs.spatialReferenceIdentifyStrategies;

import org.apache.commons.lang3.StringUtils;
import org.gdal.osr.SpatialReference;
import org.gvsig.crs.SpatialReferenceIdentifyStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIdentifyStrategy
implements SpatialReferenceIdentifyStrategy {
    protected static Logger logger = LoggerFactory.getLogger(AbstractIdentifyStrategy.class);

    protected String normalizeEsriSrName(String sr_name) {
        String name = StringUtils.replace((String)sr_name, (String)"GCS_", (String)"");
        name = StringUtils.replaceChars((String)name, (String)"()", (String)"");
        name = StringUtils.replace((String)name, (String)"WGS_19", (String)"WGS ");
        name = StringUtils.replace((String)name, (String)"_19", (String)"");
        name = StringUtils.replace((String)name, (String)"_20", (String)"20");
        name = StringUtils.replace((String)name, (String)"_Adj_1958", (String)"(58)");
        name = StringUtils.replace((String)name, (String)"_Bern", (String)" (Bern)");
        name = StringUtils.replace((String)name, (String)"_CGQ77", (String)"(CGQ77)");
        name = StringUtils.replace((String)name, (String)"_CORS96", (String)"(CORS96)");
        name = StringUtils.replace((String)name, (String)"_CSRS", (String)"(CSRS)");
        name = StringUtils.replace((String)name, (String)"_DEF_1976", (String)"(76)");
        name = StringUtils.replace((String)name, (String)"_ED77", (String)"(ED77)");
        name = StringUtils.replace((String)name, (String)"_HARN", (String)"(HARN)");
        name = StringUtils.replace((String)name, (String)"_MA11", (String)"(MA11)");
        name = StringUtils.replace((String)name, (String)"_NSRS2007", (String)"(NSRS2007)");
        name = StringUtils.replace((String)name, (String)"_PA11", (String)"(PA11)");
        name = StringUtils.replace((String)name, (String)"_StatePlane", (String)"");
        name = StringUtils.replaceAll((String)name, (String)"(_FIPS_)\\d{4}", (String)"");
        name = StringUtils.replaceAll((String)name, (String)"_m$", (String)"(m)");
        name = StringUtils.replace((String)name, (String)"1870_Madrid", (String)"1870 (Madrid)");
        name = StringUtils.replace((String)name, (String)"83_2011", (String)"83(2011)");
        name = StringUtils.replaceAll((String)name, (String)"Feet_Intl$", (String)"(ft)");
        name = StringUtils.replaceAll((String)name, (String)"Feet$", (String)"(ftUS)");
        name = StringUtils.replace((String)name, (String)"Ferro", (String)"(Ferro)");
        name = StringUtils.replaceAll((String)name, (String)"ftUS$", (String)"(ftUS)");
        name = StringUtils.replaceAll((String)name, (String)"ft$", (String)"(ft)");
        name = StringUtils.replace((String)name, (String)"Hungarian_1972", (String)"HD72");
        name = StringUtils.replace((String)name, (String)"Indonesian_1974", (String)"ID74");
        name = StringUtils.replace((String)name, (String)"Lisboa", (String)"Lisbon");
        name = StringUtils.replace((String)name, (String)"Lisbon_Lisbon", (String)"Lisbon (Lisbon)");
        name = StringUtils.replace((String)name, (String)"MGI_M", (String)"MGI Austria M");
        name = StringUtils.replace((String)name, (String)"New_Brunswick_Stereographic", (String)"New Brunswick Stereographic (ATS77)");
        name = StringUtils.replace((String)name, (String)"Oslo_Norway", (String)"(Oslo) NGO");
        name = StringUtils.replace((String)name, (String)"Paris", (String)"(Paris)");
        name = StringUtils.replace((String)name, (String)"St_", (String)"St. ");
        name = StringUtils.replace((String)name, (String)"TC_1948", (String)"TC(1948)");
        name = StringUtils.replace((String)name, (String)"ETRS_1989", (String)"ETRS89");
        name = StringUtils.replace((String)name, (String)"ETRS_89", (String)"ETRS89");
        name = StringUtils.replace((String)name, (String)"_", (String)" ");
        name = StringUtils.replace((String)name, (String)"-", (String)" ");
        name = StringUtils.lowerCase((String)name);
        name = StringUtils.replace((String)name, (String)"'", (String)"''");
        return name;
    }

    protected String normalizeEPSGSrName(String sr_name) {
        String name = StringUtils.replace((String)sr_name, (String)" / ", (String)" ");
        name = StringUtils.replace((String)name, (String)"-", (String)" ");
        name = StringUtils.lowerCase((String)name);
        name = StringUtils.replace((String)name, (String)"'", (String)"''");
        return name;
    }

    protected SpatialReference createSpatialReferenceFromEPSGCode(int code) {
        if (code < 1) {
            return null;
        }
        SpatialReference sr2 = new SpatialReference();
        try {
            sr2.ImportFromEPSG(code);
            return sr2;
        }
        catch (Exception e4) {
            logger.warn("Can't cant create from EPSG code " + code + ".", (Throwable)e4);
            return null;
        }
    }

    protected SpatialReference createSpatialReferenceFromESRICode(int code) {
        if (code < 1) {
            return null;
        }
        SpatialReference sr2 = new SpatialReference();
        try {
            sr2.ImportFromEPSG(code);
            if (code > 33000) {
                if (sr2.IsGeographic() == 1) {
                    sr2.SetAuthority("GEOGCS", "ESRI", code);
                } else {
                    sr2.SetAuthority("PROJCS", "ESRI", code);
                }
            }
            return sr2;
        }
        catch (Exception e4) {
            logger.warn("Can't cant create from ESRI code " + code + ".", (Throwable)e4);
            return null;
        }
    }

    protected String getProj4String(SpatialReference sr) {
        String proj4str = null;
        try {
            proj4str = sr.ExportToProj4();
            logger.debug("Source proj4: {}", (Object)proj4str);
        }
        catch (Exception e2) {
            logger.debug("Can't ExportToProj4.", (Throwable)e2);
        }
        return proj4str;
    }

    protected boolean autoIdentifyEPSG(SpatialReference sr) {
        try {
            sr.AutoIdentifyEPSG();
            String authorityCode = sr.GetAuthorityCode(null);
            if (!StringUtils.isEmpty((CharSequence)authorityCode)) {
                logger.debug("AuthorityCode: " + authorityCode);
                return true;
            }
        }
        catch (Exception e) {
            logger.debug("Can't AutoIdentifyEPSG.", (Throwable)e);
        }
        return false;
    }
}

