/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.crs.spatialReferenceIdentifyStrategies;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gdal.osr.SpatialReference;
import org.gvsig.crs.spatialReferenceIdentifyStrategies.AbstractIdentifyStrategy;

public class IdentifyEPSGCustom
extends AbstractIdentifyStrategy {
    private int best_code = 0;
    private int best_dist = 1000;
    private static Map<Pattern, Integer> regexps = new LinkedHashMap<Pattern, Integer>();

    public static void addCustomIdentifyExpression(String regexp, int epsgcode) {
        regexps.put(Pattern.compile(regexp), epsgcode);
    }

    public IdentifyEPSGCustom() {
    }

    public IdentifyEPSGCustom(int accuracy) {
    }

    public IdentifyEPSGCustom setAccuracy(int accuracy) {
        return this;
    }

    public int getBestAccuracy() {
        return this.best_dist;
    }

    public SpatialReference getBest() {
        SpatialReference sr = this.createSpatialReferenceFromEPSGCode(this.best_code);
        return sr;
    }

    public SpatialReference identify(SpatialReference sr) {
        if (this.autoIdentifyEPSG(sr)) {
            return sr;
        }
        String wkt = sr.ExportToWkt();
        for (Map.Entry<Pattern, Integer> entry : regexps.entrySet()) {
            Pattern pattern = entry.getKey();
            Integer epsgcode = entry.getValue();
            Matcher m = pattern.matcher(wkt);
            if (!m.matches()) continue;
            this.best_code = epsgcode;
            this.best_dist = 0;
            SpatialReference sr2 = this.createSpatialReferenceFromEPSGCode(this.best_code);
            if (sr2 == null) continue;
            return sr2;
        }
        return null;
    }
}

