/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.proj.lib.jcrs;

import es.idr.teledeteccion.connection.EpsgConnection;
import es.idr.teledeteccion.connection.Query;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gvsig.crs.Crs;
import org.gvsig.crs.CrsException;
import org.gvsig.crs.CrsFactory;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.proj.CoordinateReferenceSystem;
import org.gvsig.proj.CoordinateReferenceSystemManager;
import org.gvsig.proj.CoordinateReferenceSystemNotFoundException;
import org.gvsig.proj.lib.jcrs.JCRSCoordinateReferenceSystem;
import org.gvsig.tools.dynobject.DynObject;

public class JCRSCoordinateReferenceSystemManager
implements CoordinateReferenceSystemManager {
    Map codesByAuthorityNames = new HashMap();

    JCRSCoordinateReferenceSystemManager() {
        this.codesByAuthorityNames.put("EPSG", null);
        this.codesByAuthorityNames.put("ESRI", null);
        this.codesByAuthorityNames.put("IAU2000", null);
        this.codesByAuthorityNames.put("CRS", null);
        this.codesByAuthorityNames.put("USR", null);
    }

    public List getAuthorityNames() {
        return new ArrayList(this.codesByAuthorityNames.keySet());
    }

    public List getCodes(String authorityName) {
        if (!this.codesByAuthorityNames.containsKey(authorityName)) {
            return null;
        }
        ArrayList<String> codes = (ArrayList<String>)this.codesByAuthorityNames.get(authorityName);
        if (codes != null) {
            return codes;
        }
        String sentence = null;
        EpsgConnection connect = new EpsgConnection();
        codes = new ArrayList<String>();
        if ("EPSG".equalsIgnoreCase(authorityName)) {
            connect.setConnectionEPSG();
            sentence = "SELECT coord_ref_sys_name as name FROM epsg_coordinatereferencesystem ";
        } else if ("ESRI".equalsIgnoreCase(authorityName)) {
            connect.setConnectionEsri();
            sentence = "SELECT esri_wkt as name FROM ESRI ";
        } else if ("IAU2000".equalsIgnoreCase(authorityName)) {
            connect.setConnectionIAU2000();
            sentence = "SELECT iau_wkt as name FROM IAU2000 ";
        } else if ("USR".equalsIgnoreCase(authorityName)) {
            connect.setConnectionUsr();
            sentence = "SELECT usr_wkt as name FROM USR ";
        } else if ("CRS".equalsIgnoreCase(authorityName)) {
            connect.setConnectionNoAuth();
            sentence = "SELECT crs_wkt as name FROM NOAUTHCRS ";
        }
        ResultSet result = Query.select(sentence, connect.getConnection());
        try {
            while (result.next()) {
                codes.add(result.getString("name"));
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Can't retrive list of codes for autority " + authorityName, e);
        }
        this.codesByAuthorityNames.put(authorityName, codes);
        return codes;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem(String authorityName, String code) throws CoordinateReferenceSystemNotFoundException {
        Crs jcrs;
        CrsFactory jcrsFactory = (CrsFactory)CRSFactory.cp;
        try {
            jcrs = (Crs)jcrsFactory.getCRS(authorityName + ":" + code);
        }
        catch (CrsException e) {
            throw new CoordinateReferenceSystemNotFoundException(authorityName, code, (Throwable)e);
        }
        return new JCRSCoordinateReferenceSystem(jcrs);
    }

    public DynObject createParameters() {
        return null;
    }

    public void initialize(DynObject parameters) {
    }
}

