/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.timesupport.swing.impl.components;

import com.toedter.calendar.JDateChooser;
import com.toedter.components.JSpinField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.gvsig.timesupport.Instant;
import org.gvsig.timesupport.RelativeInstant;
import org.gvsig.timesupport.Time;
import org.gvsig.timesupport.TimeSupportLocator;
import org.gvsig.timesupport.TimeSupportManager;
import org.gvsig.timesupport.swing.impl.components.TemporalComponent;
import org.gvsig.timesupport.swing.impl.rdv.TimeAdjustmentListener;
import org.gvsig.timesupport.swing.impl.rdv.TimeEvent;

public class RelativeTemporalComponent
extends JPanel
implements TemporalComponent,
PropertyChangeListener {
    private static final long serialVersionUID = -4793729838825841885L;
    private static TimeSupportManager timeSupportManager = TimeSupportLocator.getManager();
    private JDateChooser jdDateChooser = null;
    public static int width = 300;
    public static int height = 40;
    private JSpinField jsfHours = null;
    private JSpinField jsfMinutes = null;
    private JSpinField jsfSeconds = null;
    private JSpinField jsfMillis = null;
    private RelativeInstant lowerTime = null;
    private RelativeInstant upperTime = null;
    private RelativeInstant initTime = null;
    private TimeAdjustmentListener listener = null;
    private JLabel lblLabel = null;
    private String lastLabel = null;

    public RelativeTemporalComponent() {
        this.initComponents();
    }

    @Override
    public TimeAdjustmentListener getListener() {
        return this.listener;
    }

    @Override
    public void setListener(TimeAdjustmentListener listener) {
        this.listener = listener;
    }

    @Override
    public void setTimes(String label, Time init, Time lower, Time upper) {
        this.lastLabel = label;
        this.lowerTime = (RelativeInstant)lower;
        this.upperTime = (RelativeInstant)upper;
        this.initTime = (RelativeInstant)init;
        this.setMinInstantToCalendar(this.lowerTime);
        this.setMaxInstantToCalendar(this.upperTime);
        Date date = new Date(this.initTime.getYear() - 1900, this.initTime.getMonthOfYear() - 1, this.initTime.getDayOfMonth());
        this.setInstantToCalendar(this.initTime);
        this.setHours(this.initTime.getHourOfDay());
        this.setMinutes(this.initTime.getMinuteOfHour());
        this.setSeconds(this.initTime.getSecondOfMinute());
        this.setMilis(this.initTime.getMillisOfSecond());
        this.lblLabel.setText(label + " " + this.initTime.toString());
    }

    private void setInstantToCalendar(RelativeInstant time) {
        this.getJdDateChooser().setDate(new Date(time.getYear() - 1900, time.getMonthOfYear() - 1, time.getDayOfMonth()));
    }

    private void setMaxInstantToCalendar(RelativeInstant time) {
        this.getJdDateChooser().setMaxSelectableDate(new Date(time.getYear() - 1900, time.getMonthOfYear() - 1, time.getDayOfMonth()));
    }

    private void setMinInstantToCalendar(RelativeInstant time) {
        this.getJdDateChooser().setMinSelectableDate(new Date(time.getYear() - 1900, time.getMonthOfYear() - 1, time.getDayOfMonth()));
    }

    public void setTime(int hours, int minutes, int seconds, int milis) {
        this.setHours(hours);
        this.setMinutes(minutes);
        this.setSeconds(seconds);
        this.setMilis(milis);
    }

    public void setHours(int hours) {
        if (hours >= this.getJsfHours().getMinimum() && hours <= this.getJsfHours().getMaximum()) {
            this.getJsfHours().setValue(hours);
        }
    }

    public void setMinutes(int minutes) {
        if (minutes >= this.getJsfMinutes().getMinimum() && minutes <= this.getJsfMinutes().getMaximum()) {
            this.getJsfMinutes().setValue(minutes);
        }
    }

    public void setSeconds(int seconds) {
        if (seconds >= this.getJsfSeconds().getMinimum() && seconds <= this.getJsfSeconds().getMaximum()) {
            this.getJsfSeconds().setValue(seconds);
        }
    }

    public void setMilis(int milis) {
        if (milis >= this.getJsfMillis().getMinimum() && milis <= this.getJsfMillis().getMaximum()) {
            this.getJsfMillis().setValue(milis);
        }
    }

    public int getHours() {
        return this.getJsfHours().getValue();
    }

    public int getMinutes() {
        return this.getJsfMinutes().getValue();
    }

    public int getSeconds() {
        return this.getJsfSeconds().getValue();
    }

    public int getMilis() {
        return this.getJsfMillis().getValue();
    }

    @Override
    public void setCurrentInstant(Time time) {
        RelativeInstant date = (RelativeInstant)time;
        this.setInstantToCalendar(date);
        this.setTime(date.getHourOfDay(), date.getMinuteOfHour(), date.getSecondOfMinute(), date.getMillisOfSecond());
    }

    @Override
    public void setStartTime(Time date) {
        this.setMinInstantToCalendar((RelativeInstant)date);
    }

    @Override
    public void setEndTime(Time date) {
        this.setMaxInstantToCalendar((RelativeInstant)date);
    }

    @Override
    public Time getTime() {
        Date temp = this.getJdDateChooser().getDate();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(temp);
        RelativeInstant date = timeSupportManager.createRelativeInstant(calendar.get(1), calendar.get(2) + 1, calendar.get(5), this.getJsfHours().getValue(), this.getJsfMinutes().getValue(), this.getJsfSeconds().getValue(), this.getJsfMillis().getValue());
        return date;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        try {
            if (this.listener != null) {
                TimeEvent t = new TimeEvent(this);
                this.listener.timeChanged(t);
                this.listener.rangeChanged(t);
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.getJdDateChooser().setEnabled(enabled);
        this.getJsfHours().setEnabled(enabled);
        this.getJsfMinutes().setEnabled(enabled);
        this.getJsfSeconds().setEnabled(enabled);
        this.getJsfMillis().setEnabled(enabled);
    }

    @Override
    public void resetLowertTime() {
        this.setMinInstantToCalendar(this.lowerTime);
        this.setInstantToCalendar((RelativeInstant)this.getTime());
    }

    @Override
    public void resetUpperTime() {
        this.setMaxInstantToCalendar(this.upperTime);
    }

    @Override
    public void resetValues() {
        this.setTimes(this.lastLabel, (Time)this.initTime, (Time)this.lowerTime, (Time)this.upperTime);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.lblLabel = new JLabel();
        this.add((Component)this.lblLabel, "North");
        this.getJdDateChooser().addPropertyChangeListener((PropertyChangeListener)this);
        this.getJsfHours().setMaximum(23);
        this.getJsfHours().setMinimum(0);
        this.getJsfHours().setName("jSpinFieldHour");
        this.getJsfHours().addPropertyChangeListener((PropertyChangeListener)this);
        this.getJsfMinutes().setMaximum(59);
        this.getJsfMinutes().setMinimum(0);
        this.getJsfMinutes().setName("jSpinFieldMinute");
        this.getJsfMinutes().addPropertyChangeListener((PropertyChangeListener)this);
        this.getJsfSeconds().setMaximum(59);
        this.getJsfSeconds().setMinimum(0);
        this.getJsfSeconds().setName("jSpinFieldSecond");
        this.getJsfSeconds().addPropertyChangeListener((PropertyChangeListener)this);
        this.getJsfMillis().setMaximum(999);
        this.getJsfMillis().setMinimum(0);
        this.getJsfMillis().setName("jSpinFieldMillis");
        this.getJsfMillis().addPropertyChangeListener((PropertyChangeListener)this);
        this.add((Component)this.getCalendarLayout(), "Center");
    }

    private JPanel getCalendarLayout() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        panel.add((Component)this.getJdDateChooser(), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        panel.add((Component)this.getJsfHours(), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        panel.add((Component)this.getJsfMinutes(), gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        panel.add((Component)this.getJsfSeconds(), gridBagConstraints);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        panel.add((Component)this.getJsfMillis(), gridBagConstraints);
        return panel;
    }

    private JDateChooser getJdDateChooser() {
        if (this.jdDateChooser == null) {
            this.jdDateChooser = new JDateChooser();
        }
        return this.jdDateChooser;
    }

    private JSpinField getJsfHours() {
        if (this.jsfHours == null) {
            this.jsfHours = new JSpinField();
            this.jsfHours.addPropertyChangeListener((PropertyChangeListener)this);
        }
        return this.jsfHours;
    }

    private JSpinField getJsfMinutes() {
        if (this.jsfMinutes == null) {
            this.jsfMinutes = new JSpinField();
        }
        return this.jsfMinutes;
    }

    private JSpinField getJsfSeconds() {
        if (this.jsfSeconds == null) {
            this.jsfSeconds = new JSpinField();
        }
        return this.jsfSeconds;
    }

    private JSpinField getJsfMillis() {
        if (this.jsfMillis == null) {
            this.jsfMillis = new JSpinField();
        }
        return this.jsfMillis;
    }

    private void updateLimits() {
        RelativeInstant maxDate = timeSupportManager.createRelativeInstant(this.getJdDateChooser().getMaxSelectableDate());
        RelativeInstant minDate = timeSupportManager.createRelativeInstant(this.getJdDateChooser().getMinSelectableDate());
        RelativeInstant date = (RelativeInstant)this.getTime();
        if (date.compareTo((Instant)maxDate) >= 0) {
            this.getJsfHours().setMaximum(maxDate.getHourOfDay());
            this.getJsfMinutes().setMaximum(maxDate.getMinuteOfHour());
            this.getJsfSeconds().setMaximum(maxDate.getSecondOfMinute());
            this.getJsfMillis().setMaximum(maxDate.getMillisOfSecond());
        } else if (date.compareTo((Instant)minDate) <= 0) {
            this.getJsfHours().setMinimum(minDate.getHourOfDay());
            this.getJsfMinutes().setMinimum(minDate.getMinuteOfHour());
            this.getJsfSeconds().setMinimum(minDate.getSecondOfMinute());
            this.getJsfMillis().setMinimum(minDate.getMillisOfSecond());
        } else if (date.compareTo((Instant)this.lowerTime) <= 0) {
            this.getJsfHours().setMinimum(this.lowerTime.getHourOfDay());
            this.getJsfMinutes().setMinimum(this.lowerTime.getMinuteOfHour());
            this.getJsfSeconds().setMinimum(this.lowerTime.getSecondOfMinute());
            this.getJsfMillis().setMinimum(this.lowerTime.getMillisOfSecond());
        } else if (date.compareTo((Instant)this.upperTime) >= 0) {
            this.getJsfHours().setMaximum(this.upperTime.getHourOfDay());
            this.getJsfMinutes().setMaximum(this.upperTime.getMinuteOfHour());
            this.getJsfSeconds().setMaximum(this.upperTime.getSecondOfMinute());
            this.getJsfMillis().setMaximum(this.upperTime.getMillisOfSecond());
        } else {
            this.getJsfHours().setMaximum(23);
            this.getJsfMinutes().setMaximum(59);
            this.getJsfSeconds().setMaximum(59);
            this.getJsfMillis().setMaximum(999);
            this.getJsfHours().setMinimum(0);
            this.getJsfMinutes().setMinimum(0);
            this.getJsfSeconds().setMinimum(0);
            this.getJsfMillis().setMinimum(0);
        }
    }
}

