/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.jexcel.dynformfield.point;

import java.awt.Cursor;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.LinkedBlockingDeque;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.jexcel.Spread;
import org.gvsig.jexcel.dynformfield.point.PointFieldsSelector;
import org.gvsig.tools.dynform.DynFormFieldDefinition;
import org.gvsig.tools.dynform.JDynForm;
import org.gvsig.tools.dynform.JDynFormField;
import org.gvsig.tools.dynform.services.dynformfield.String.JDynFormFieldString;
import org.gvsig.tools.dynform.spi.DynFormSPIManager;
import org.gvsig.tools.dynform.spi.dynformfield.JDynFormFieldFactory;
import org.gvsig.tools.task.CancellableTask;

public class JDynFormFieldExcelPointFields
extends JDynFormFieldString {
    private JDynFormField.JDynFormFieldListener updateSelectorListener;
    private PointFieldsSelector pointFieldsSelector = null;
    private Spread.Sheet currentSheet;
    private final TaskList tasks = new TaskList();

    public JDynFormFieldExcelPointFields(DynFormSPIManager serviceManager, DynFormSPIManager.ComponentsFactory componentsFactory, JDynFormFieldFactory factory, DynFormFieldDefinition definition, Object value) {
        super(serviceManager, componentsFactory, factory, definition, value);
    }

    public void initComponent() {
        this.pointFieldsSelector = new PointFieldsSelector();
        if (this.getDefinition().isReadOnly()) {
            this.pointFieldsSelector.setEnabled(false);
        }
        this.addListenerToFields();
        this.contents = this.pointFieldsSelector;
    }

    public void setValue(Object value) {
        this.pointFieldsSelector.setSelectedFields((String)value);
    }

    public Object getValue() {
        return this.pointFieldsSelector.getSelectedFields();
    }

    public void addListenerToFields() {
        if (this.updateSelectorListener != null) {
            return;
        }
        JDynForm form = this.getForm();
        if (form == null) {
            return;
        }
        JDynFormField fileField = form.getField("file");
        JDynFormField sheetField = form.getField("sheet");
        JDynFormField isFirstRowHeaderField = form.getField("isFirstRowHeader");
        if (fileField == null || sheetField == null || isFirstRowHeaderField == null) {
            return;
        }
        JDynFormField.JDynFormFieldListener listener = new JDynFormField.JDynFormFieldListener(){

            public void fieldEnter(JDynFormField jdff) {
            }

            public void fieldExit(JDynFormField jdff) {
            }

            public void fieldChanged(JDynFormField jdff) {
                JDynFormFieldExcelPointFields.this.doUpdateSelector();
            }

            public void message(JDynFormField jdff, String string) {
            }
        };
        fileField.addListener(listener);
        sheetField.addListener(listener);
        isFirstRowHeaderField.addListener(listener);
        this.updateSelectorListener = listener;
        this.pointFieldsSelector.clear();
        this.pointFieldsSelector.setAvailableFields(null);
    }

    public Spread.Sheet getCurrentSheet() {
        return this.currentSheet;
    }

    private Spread.Sheet getSheet(File spreadFile, Locale locale, int sheetIndex) {
        if (this.currentSheet != null && sheetIndex == this.currentSheet.getSheetIndex() && StringUtils.equals((CharSequence)Objects.toString(spreadFile, null), (CharSequence)Objects.toString(this.currentSheet.getFile(), null))) {
            return this.currentSheet;
        }
        Spread spread = Spread.create(spreadFile, locale);
        this.currentSheet = spread.getSheet(sheetIndex);
        return this.currentSheet;
    }

    private void doUpdateSelector() {
        this.pointFieldsSelector.clear();
        this.pointFieldsSelector.setAvailableFields(null);
        JDynForm form = this.getForm();
        JDynFormField fileField = form.getField("file");
        JDynFormField localeField = form.getField("locale");
        JDynFormField sheetField = form.getField("sheet");
        JDynFormField isFirstRowHeaderField = form.getField("isFirstRowHeader");
        if (fileField != null && sheetField != null && isFirstRowHeaderField != null) {
            File spreadFile = (File)fileField.getValue();
            int sheetIndex = (Integer)ObjectUtils.defaultIfNull((Object)sheetField.getValue(), (Object)-1);
            boolean isFirstRowHeader = (Boolean)ObjectUtils.defaultIfNull((Object)isFirstRowHeaderField.getValue(), (Object)false);
            Locale locale = Locale.getDefault();
            String x = Objects.toString(localeField.getValue(), null);
            if (!StringUtils.isBlank((CharSequence)x)) {
                locale = new Locale(x);
            }
            this.tasks.cancelAll();
            this.tasks.add(new TaskUpdateAvailbleFields(spreadFile, sheetIndex, isFirstRowHeader, locale));
        }
    }

    private class TaskUpdateAvailbleFields
    implements Task {
        private final File spreadFile;
        private final int sheetIndex;
        private final boolean isFirstRowHeader;
        private boolean cancelled;
        private Locale locale;

        public TaskUpdateAvailbleFields(File spreadFile, int sheetIndex, boolean isFirstRowHeader, Locale locale) {
            this.spreadFile = spreadFile;
            this.isFirstRowHeader = isFirstRowHeader;
            this.sheetIndex = sheetIndex;
            this.cancelled = false;
            this.locale = locale;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Cursor save_cursor = JDynFormFieldExcelPointFields.this.pointFieldsSelector.getCursor();
            try {
                JDynFormFieldExcelPointFields.this.pointFieldsSelector.setCursor(Cursor.getPredefinedCursor(3));
                Spread.Sheet sheet = JDynFormFieldExcelPointFields.this.getSheet(this.spreadFile, this.locale, this.sheetIndex);
                if (sheet != null) {
                    final List<String> columnNames = sheet.getColumnNames(this.isFirstRowHeader);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (!TaskUpdateAvailbleFields.this.cancelled) {
                                JDynFormFieldExcelPointFields.this.pointFieldsSelector.setAvailableFields(columnNames);
                                if (JDynFormFieldExcelPointFields.this.pointFieldsSelector.isEmpty()) {
                                    JDynFormFieldExcelPointFields.this.pointFieldsSelector.detect();
                                }
                            }
                        }
                    });
                }
            }
            finally {
                JDynFormFieldExcelPointFields.this.pointFieldsSelector.setCursor(save_cursor);
            }
        }

        public boolean isCancellationRequested() {
            return this.cancelled;
        }

        public void cancelRequest() {
            this.cancelled = true;
        }
    }

    private static class TaskList
    extends Thread {
        private final LinkedBlockingDeque<Task> tasks = new LinkedBlockingDeque();

        public TaskList() {
            super("ExcelPointFields-tasklist");
        }

        @Override
        public void run() {
            while (true) {
                Task task = null;
                try {
                    task = this.tasks.take();
                    if (task.isCancellationRequested()) continue;
                    task.run();
                    continue;
                }
                catch (Exception ex) {
                    LOGGER.warn("Problems processing task (" + (task == null ? "null" : Integer.valueOf(task.hashCode())) + ")", (Throwable)ex);
                    continue;
                }
                break;
            }
        }

        public void add(Task task) {
            if (!this.isAlive()) {
                this.start();
            }
            this.tasks.add(task);
        }

        public void cancelAll() {
            for (Task task : this.tasks) {
                task.cancelRequest();
            }
        }
    }

    private static interface Task
    extends Runnable,
    CancellableTask {
    }
}

