/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.algorithm.lateralbuffer;

import es.unex.sextante.core.Sextante;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.OptionalParentParameterException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.exceptions.UndefinedParentParameterNameException;
import es.unex.sextante.gui.algorithm.GeoAlgorithmParametersPanel;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.geoprocess.algorithm.buffer.BufferAlgorithm;
import org.gvsig.geoprocess.algorithm.buffer.ConstantDistance;
import org.gvsig.geoprocess.algorithm.buffer.FieldDistance;
import org.gvsig.geoprocess.algorithm.buffer.IDistance;
import org.gvsig.geoprocess.algorithm.lateralbuffer.LateralBufferOperation;
import org.gvsig.geoprocess.algorithm.lateralbuffer.LateralBufferParametersPanel;
import org.gvsig.geoprocess.lib.sextante.AbstractSextanteGeoProcess;
import org.gvsig.geoprocess.lib.sextante.dataObjects.FlyrVectIVectorLayer;

public class LateralBufferAlgorithm
extends BufferAlgorithm {
    public static final String LATERAL = "LATERAL";
    public static final String IGNOREINVALIDLINES = "IGNORENOTVALIDLINES";
    public static final String USESIMPLIFIEDGEOMETRIES = "USESIMPLIFIEDGEOMETRIES";
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    private int lateral = 0;

    public void defineCharacteristics() {
        this.setName(this.getTranslation("lateral_buffer"));
        this.setGroup(this.getTranslation("basic_vect_algorithms"));
        try {
            this.m_Parameters.addInputVectorLayer("LAYER", this.getTranslation("Input_layer"), -1, true);
            this.m_Parameters.addBoolean("SELECTED_GEOM", this.getTranslation("Selected_geometries"), false);
            this.m_Parameters.addNumericalValue("DISTANCE", this.getTranslation("area_distance"), 0.0, 2);
            this.m_Parameters.addTableField("FIELD", this.getTranslation("area_field"), "LAYER");
            this.m_Parameters.addBoolean("DISSOLVE", this.getTranslation("Dissolve_entities"), false);
            this.m_Parameters.addSelection("RING_NUMBER", this.getTranslation("Number_of_rings"), new String[]{"1", "2", "3", "4"});
            this.m_Parameters.addBoolean("ROUND_BORDER", this.getTranslation("Round_border"), true);
            this.m_Parameters.addBoolean(IGNOREINVALIDLINES, this.getTranslation("ignore_invalid_lines"), true);
            this.m_Parameters.addBoolean(USESIMPLIFIEDGEOMETRIES, this.getTranslation("Use_simplified_geometries"), true);
            this.m_Parameters.addNumericalValue(LATERAL, this.getTranslation("select_lateral"), 0.0, 1);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (UndefinedParentParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (OptionalParentParameterException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        this.addOutputVectorLayer("RESULT", this.getTranslation("lateral_buffer"), 2);
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        if (this.existsOutPutFile("RESULT", 0)) {
            throw new GeoAlgorithmExecutionException(this.getTranslation("file_exists"));
        }
        int attributePosition = this.m_Parameters.getParameterValueAsInt("FIELD");
        double distanceValue = this.m_Parameters.getParameter("DISTANCE").getParameterValueAsDouble();
        this.lateral = this.m_Parameters.getParameterValueAsInt(LATERAL);
        boolean ignoreInvalidLines = this.m_Parameters.getParameterValueAsBoolean(IGNOREINVALIDLINES);
        boolean useSimplifiedGeometries = this.m_Parameters.getParameterValueAsBoolean(USESIMPLIFIEDGEOMETRIES);
        this.readParameters();
        if (!(this.sextanteInputLayer instanceof FlyrVectIVectorLayer)) {
            return false;
        }
        this.inputStore = ((FlyrVectIVectorLayer)this.sextanteInputLayer).getFeatureStore();
        try {
            Object distance = null;
            distance = distanceValue == 0.0 ? new FieldDistance(this.sextanteInputLayer.getFieldName(attributePosition)) : new ConstantDistance(distanceValue);
            LateralBufferOperation operation = new LateralBufferOperation((IDistance)distance, this.inputStore, (AbstractSextanteGeoProcess)this, this.getTableFieldsStructure(), this.lateral, ignoreInvalidLines, useSimplifiedGeometries);
            operation.setTypeOfCap(this.round_border ? (byte)1 : 0);
            operation.setNumberOfRadialBuffers(this.rings + 1);
            operation.setGeoProcess((AbstractSextanteGeoProcess)this, 100);
            this.outputStore = this.buildOutPutStore(2, this.getTranslation("lateral_buffer"), "RESULT");
            if (!this.dissolve) {
                this.computesBufferAlgWithoutDissolve(operation);
            } else {
                this.computesBufferAlgWithDissolve(operation);
            }
        }
        catch (DataException e) {
            Sextante.addErrorToLog((Throwable)e);
            return false;
        }
        return true;
    }

    public Class<? extends GeoAlgorithmParametersPanel> getCustomParametersPanelClass() {
        return LateralBufferParametersPanel.class;
    }
}

