/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.algorithm.lateralbuffer;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.operation.buffer.BufferOp;
import com.vividsolutions.jts.operation.buffer.BufferParameters;
import com.vividsolutions.jts.simplify.TopologyPreservingSimplifier;
import es.unex.sextante.core.Sextante;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.geoprocess.algorithm.base.util.GeometryUtil;
import org.gvsig.geoprocess.algorithm.base.util.JTSFacade;
import org.gvsig.geoprocess.algorithm.buffer.BufferOperation;
import org.gvsig.geoprocess.algorithm.buffer.IDistance;
import org.gvsig.geoprocess.lib.sextante.AbstractSextanteGeoProcess;

public class LateralBufferOperation
extends BufferOperation {
    private BufferParameters bufParams = null;
    private int lateral = 0;
    private boolean ignoreInvalidLines = false;
    private final GeometryManager geomManager = GeometryLocator.getGeometryManager();
    private boolean useSimplifiedGeometries = true;

    public LateralBufferOperation(IDistance distance, FeatureStore inputStore, AbstractSextanteGeoProcess p, byte tableFieldStructure, int lateral, boolean ignoreInvalidLines, boolean useSimplifiedGeometries) {
        super(distance, inputStore, p, tableFieldStructure);
        this.lateral = lateral;
        this.ignoreInvalidLines = ignoreInvalidLines;
        this.useSimplifiedGeometries = useSimplifiedGeometries;
        this.bufParams = new BufferParameters();
        this.bufParams.setSingleSided(true);
        this.bufParams.setEndCapStyle(this.capBuffer == 1 ? 1 : 3);
    }

    public EditableFeature invoke(org.gvsig.fmap.geom.Geometry g, Feature feature) {
        Geometry originalGeometry;
        Geometry newGeom = null;
        Geometry previousExteriorRing = null;
        Geometry simplifiedGeometry = originalGeometry = GeometryUtil.geomToJTS((org.gvsig.fmap.geom.Geometry)g);
        this.distance.setFeature(feature);
        double bufferDistance = this.distance.getBufferDistance(this.projection, this.getDistanceUnits(), this.getMapUnits());
        if (originalGeometry == null) {
            return null;
        }
        if (this.ignoreInvalidLines && this.geomManager.isSubtype(18, g.getGeometryType().getType())) {
            try {
                Line newg = null;
                newg = (Line)g;
                if (newg.getVertex(0) == newg.getVertex(newg.getNumVertices() - 1) && newg.getNumVertices() == 2 || newg.perimeter() < 1.0) {
                    return null;
                }
            }
            catch (GeometryOperationNotSupportedException e) {
                Sextante.addErrorToLog((Throwable)e);
                return null;
            }
            catch (GeometryOperationException e) {
                Sextante.addErrorToLog((Throwable)e);
                return null;
            }
        }
        if (originalGeometry.getDimension() != 0 & this.useSimplifiedGeometries) {
            simplifiedGeometry = TopologyPreservingSimplifier.simplify((Geometry)originalGeometry, (double)(bufferDistance / 10.0));
        }
        for (int i = 1; i <= this.numberOfRadialBuffers; ++i) {
            double distRing = (double)i * bufferDistance;
            if (this.lateral == 1) {
                distRing *= -1.0;
            }
            newGeom = BufferOp.bufferOp((Geometry)simplifiedGeometry, (double)distRing, (BufferParameters)this.bufParams);
            if (i == 1) {
                previousExteriorRing = newGeom;
            } else {
                Geometry complete = newGeom;
                newGeom = JTSFacade.difference((Geometry)newGeom, (Geometry)previousExteriorRing);
                previousExteriorRing = complete;
            }
            try {
                if (newGeom == null || newGeom.isEmpty()) continue;
                this.lastEditFeature = this.getTableFieldStructure() == 0 ? this.persister.addFeature(feature, newGeom) : this.persister.addFeature(newGeom, this.id, distRing);
                ++this.id;
                continue;
            }
            catch (CreateGeometryException e) {
                Sextante.addErrorToLog((Throwable)e);
                continue;
            }
            catch (DataException e) {
                Sextante.addErrorToLog((Throwable)e);
            }
        }
        return this.lastEditFeature;
    }

    public void invoke(org.gvsig.fmap.geom.Geometry g, EditableFeature feature) {
        this.invoke(g, (Feature)feature);
    }
}

