/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.json;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;
import org.gvsig.json.JsonManagerImpl;

public class JsonArrayImpl
implements JsonArray {
    private final JsonArray jsonArray;

    public JsonArrayImpl(JsonArray jsonArray) {
        this.jsonArray = jsonArray;
    }

    public JsonObject getJsonObject(int index) {
        JsonObject value = this.jsonArray.getJsonObject(index);
        return (JsonObject)JsonManagerImpl.wrap((JsonValue)value);
    }

    public JsonArray getJsonArray(int index) {
        JsonArray value = this.jsonArray.getJsonArray(index);
        return (JsonArray)JsonManagerImpl.wrap((JsonValue)value);
    }

    public JsonNumber getJsonNumber(int index) {
        JsonNumber value = this.jsonArray.getJsonNumber(index);
        if (value == null || value == JsonValue.NULL) {
            return null;
        }
        return value;
    }

    public JsonString getJsonString(int index) {
        JsonString value = this.jsonArray.getJsonString(index);
        if (value == null || value == JsonValue.NULL) {
            return null;
        }
        return value;
    }

    public <T extends JsonValue> List<T> getValuesAs(Class<T> clazz) {
        return this.jsonArray.getValuesAs(clazz);
    }

    public String getString(int index) {
        JsonValue value = (JsonValue)this.jsonArray.get(index);
        if (value == null || value == JsonValue.NULL) {
            return null;
        }
        return ((JsonString)value).getString();
    }

    public String getString(int index, String defaultValue) {
        JsonValue value = (JsonValue)this.jsonArray.get(index);
        if (value == null || value == JsonValue.NULL) {
            return defaultValue;
        }
        return ((JsonString)value).getString();
    }

    public int getInt(int index) {
        return this.jsonArray.getInt(index);
    }

    public int getInt(int index, int defaultValue) {
        return this.jsonArray.getInt(index, defaultValue);
    }

    public boolean getBoolean(int index) {
        return this.jsonArray.getBoolean(index);
    }

    public boolean getBoolean(int index, boolean defaultValue) {
        return this.jsonArray.getBoolean(index, defaultValue);
    }

    public boolean isNull(int index) {
        return this.jsonArray.isNull(index);
    }

    public JsonValue.ValueType getValueType() {
        return this.jsonArray.getValueType();
    }

    public int size() {
        return this.jsonArray.size();
    }

    public boolean isEmpty() {
        return this.jsonArray.isEmpty();
    }

    public boolean contains(Object o) {
        return this.jsonArray.contains(o);
    }

    public Iterator<JsonValue> iterator() {
        ListIteratorWrapper r = new ListIteratorWrapper(this.jsonArray.listIterator());
        return r;
    }

    public Object[] toArray() {
        return this.jsonArray.toArray();
    }

    public <T> T[] toArray(T[] a) {
        return this.jsonArray.toArray((Object[])a);
    }

    public boolean add(JsonValue e) {
        return this.jsonArray.add((Object)e);
    }

    public boolean remove(Object o) {
        return this.jsonArray.remove(o);
    }

    public boolean containsAll(Collection<?> c) {
        return this.jsonArray.containsAll(c);
    }

    public boolean addAll(Collection<? extends JsonValue> c) {
        return this.jsonArray.addAll(c);
    }

    public boolean addAll(int index, Collection<? extends JsonValue> c) {
        return this.jsonArray.addAll(index, c);
    }

    public boolean removeAll(Collection<?> c) {
        return this.jsonArray.removeAll(c);
    }

    public boolean retainAll(Collection<?> c) {
        return this.jsonArray.retainAll(c);
    }

    public void clear() {
        this.jsonArray.clear();
    }

    public JsonValue get(int index) {
        JsonValue value = (JsonValue)this.jsonArray.get(index);
        return JsonManagerImpl.wrap(value);
    }

    public JsonValue set(int index, JsonValue element) {
        return (JsonValue)this.jsonArray.set(index, (Object)element);
    }

    public void add(int index, JsonValue element) {
        this.jsonArray.add(index, (Object)element);
    }

    public JsonValue remove(int index) {
        return (JsonValue)this.jsonArray.remove(index);
    }

    public int indexOf(Object o) {
        return this.jsonArray.indexOf(o);
    }

    public int lastIndexOf(Object o) {
        return this.jsonArray.lastIndexOf(o);
    }

    public ListIterator<JsonValue> listIterator() {
        ListIteratorWrapper r = new ListIteratorWrapper(this.jsonArray.listIterator());
        return r;
    }

    public ListIterator<JsonValue> listIterator(int index) {
        ListIteratorWrapper r = new ListIteratorWrapper(this.jsonArray.listIterator(index));
        return r;
    }

    public List<JsonValue> subList(int fromIndex, int toIndex) {
        return this.jsonArray.subList(fromIndex, toIndex);
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        JsonWriterFactory writerFactory = Json.createWriterFactory(Collections.singletonMap("javax.json.stream.JsonGenerator.prettyPrinting", true));
        try (JsonWriter jsonWriter = writerFactory.createWriter((Writer)sw);){
            jsonWriter.writeArray(this.jsonArray);
        }
        String s = sw.toString();
        return s;
    }

    private static class ListIteratorWrapper
    implements ListIterator<JsonValue> {
        private final ListIterator<JsonValue> delegated;

        public ListIteratorWrapper(ListIterator<JsonValue> delegated) {
            this.delegated = delegated;
        }

        @Override
        public boolean hasNext() {
            return this.delegated.hasNext();
        }

        @Override
        public JsonValue next() {
            JsonValue value = this.delegated.next();
            return JsonManagerImpl.wrap(value);
        }

        @Override
        public boolean hasPrevious() {
            return this.delegated.hasPrevious();
        }

        @Override
        public JsonValue previous() {
            JsonValue value = this.delegated.previous();
            return JsonManagerImpl.wrap(value);
        }

        @Override
        public int nextIndex() {
            return this.delegated.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.delegated.previousIndex();
        }

        @Override
        public void remove() {
            this.delegated.remove();
        }

        @Override
        public void set(JsonValue e) {
            this.delegated.set(e);
        }

        @Override
        public void add(JsonValue e) {
            this.delegated.add(e);
        }
    }
}

