/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.json;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.ReadContext;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonStructure;
import org.gvsig.json.JsonManager;
import org.gvsig.json.JsonPathContext;
import org.gvsig.json.PathNotFoundException;
import org.gvsig.tools.dataTypes.DataTypeUtils;

public class JsonPathContextImpl
implements JsonPathContext {
    private JsonStructure jsonObject;
    private String json;
    private ReadContext context;
    private final JsonManager manager;

    public JsonPathContextImpl(JsonManager manager) {
        this.manager = manager;
        this.jsonObject = null;
        this.context = null;
    }

    public JsonPathContextImpl(JsonManager manager, JsonStructure jsonObject) {
        this(manager);
        this.jsonObject = jsonObject;
        this.json = jsonObject.toString();
        if (this.jsonObject != null) {
            try {
                this.context = JsonPath.parse((String)this.json);
            }
            catch (com.jayway.jsonpath.PathNotFoundException ex) {
                throw new PathNotFoundException("Can't parse json path", (Throwable)ex);
            }
        }
    }

    public JsonPathContextImpl(JsonManager manager, String json) {
        this(manager);
        this.jsonObject = null;
        this.json = json;
        if (this.json != null) {
            try {
                this.context = JsonPath.parse((String)json);
            }
            catch (com.jayway.jsonpath.PathNotFoundException ex) {
                throw new PathNotFoundException("Can't parse json path", (Throwable)ex);
            }
        }
    }

    public JsonStructure getJsonObject() {
        if (this.jsonObject == null && this.json != null) {
            this.jsonObject = this.manager.createObject(this.json);
        }
        return this.jsonObject;
    }

    public void setJsonObject(JsonStructure jsonObject) {
        this.jsonObject = jsonObject;
        if (this.jsonObject != null) {
            try {
                this.context = JsonPath.parse((String)jsonObject.toString());
            }
            catch (com.jayway.jsonpath.PathNotFoundException ex) {
                throw new PathNotFoundException("Can't parse json path", (Throwable)ex);
            }
        }
    }

    public Object get(String path) {
        try {
            Object r = this.context.read(path, new Predicate[0]);
            return r;
        }
        catch (com.jayway.jsonpath.PathNotFoundException ex) {
            throw new PathNotFoundException("Can't parse json path", (Throwable)ex);
        }
    }

    public int getInt(String path, int defaultValue) {
        Object r = this.get(path);
        if (r == null) {
            return defaultValue;
        }
        if (r instanceof Number) {
            return ((Number)r).intValue();
        }
        return DataTypeUtils.toInteger((Object)r, (int)defaultValue);
    }

    public long getLong(String path, long defaultValue) {
        Object r = this.get(path);
        if (r == null) {
            return defaultValue;
        }
        if (r instanceof Number) {
            return ((Number)r).longValue();
        }
        return DataTypeUtils.toLong((Object)r, (long)defaultValue);
    }

    public double getDouble(String path, double defaultValue) {
        Object r = this.get(path);
        if (r == null) {
            return defaultValue;
        }
        if (r instanceof Number) {
            return ((Number)r).doubleValue();
        }
        return DataTypeUtils.toDouble((Object)r, (double)defaultValue);
    }

    public float getFloat(String path, float defaultValue) {
        Object r = this.get(path);
        if (r == null) {
            return defaultValue;
        }
        if (r instanceof Number) {
            return ((Number)r).floatValue();
        }
        return DataTypeUtils.toFloat((Object)r, (float)defaultValue);
    }

    public Date getDate(String path) {
        Object r = this.get(path);
        if (r == null) {
            return null;
        }
        if (r instanceof Date) {
            return (Date)r;
        }
        return DataTypeUtils.toDate((Object)r);
    }

    public Time getTime(String path) {
        Object r = this.get(path);
        if (r == null) {
            return null;
        }
        if (r instanceof Time) {
            return (Time)r;
        }
        return DataTypeUtils.toTime((Object)r);
    }

    public Timestamp getTimestamp(String path) {
        Object r = this.get(path);
        if (r == null) {
            return null;
        }
        if (r instanceof Timestamp) {
            return (Timestamp)r;
        }
        return DataTypeUtils.toTimestamp((Object)r);
    }

    public JsonObject getJsonObject(String path) {
        Object r = this.get(path);
        if (r == null) {
            return null;
        }
        return this.manager.createObject(r.toString());
    }

    public JsonArray getJsonArray(String path) {
        Object r = this.get(path);
        if (r == null) {
            return null;
        }
        return this.manager.createArray(r.toString());
    }
}

