/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.duplicate;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.service.spi.ProviderServices;
import org.gvsig.vectorediting.lib.api.EditingServiceParameter;
import org.gvsig.vectorediting.lib.api.exceptions.InvalidEntryException;
import org.gvsig.vectorediting.lib.prov.duplicate.MeasureEditingProvider;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameter;

public class DivideEditingProvider
extends MeasureEditingProvider {
    private final EditingServiceParameter segmentsNumberParameter;

    public DivideEditingProvider(DynObject parameters, ProviderServices services) {
        super(parameters, services);
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        this.segmentsNumberParameter = new DefaultEditingServiceParameter("segments_number", "_segments_number", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.VALUE}).setDataType(4);
    }

    @Override
    public EditingServiceParameter next() {
        if (this.values.get(this.selection) == null) {
            return this.selection;
        }
        if (this.values.get(this.insertionPointParameter) == null) {
            return this.insertionPointParameter;
        }
        if (this.values.get(this.geometryBaseParameter) == null) {
            return this.geometryBaseParameter;
        }
        if (this.values.get(this.segmentsNumberParameter) == null) {
            return this.segmentsNumberParameter;
        }
        if (this.values.get(this.alignParameter) == null) {
            return this.alignParameter;
        }
        if (((Boolean)this.values.get(this.alignParameter)).booleanValue() && this.isPointType() && this.values.get(this.rotateFieldParameter) == null) {
            return this.rotateFieldParameter;
        }
        if (this.values.get(this.deleteOriginalGeometriesParameter) == null) {
            return this.deleteOriginalGeometriesParameter;
        }
        return null;
    }

    @Override
    public List<EditingServiceParameter> getParameters() {
        ArrayList<EditingServiceParameter> parameters = new ArrayList<EditingServiceParameter>();
        parameters.add(this.selection);
        parameters.add(this.insertionPointParameter);
        parameters.add(this.geometryBaseParameter);
        parameters.add(this.segmentsNumberParameter);
        parameters.add(this.alignParameter);
        parameters.add(this.rotateFieldParameter);
        parameters.add(this.deleteOriginalGeometriesParameter);
        return parameters;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void validateAndInsertValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        if (parameter.equals(this.segmentsNumberParameter)) {
            if (!(value instanceof Double)) throw new InvalidEntryException(null);
            this.values.put(parameter, value);
            return;
        } else {
            super.validateAndInsertValue(parameter, value);
        }
    }

    @Override
    public String getName() {
        return "modify-divide";
    }

    @Override
    public Object getValue(EditingServiceParameter parameter) {
        return this.values != null ? this.values.get(parameter) : null;
    }

    @Override
    protected List<MeasureEditingProvider.PointAndRotation> getPointsAndRotations(Line line) throws CreateGeometryException, GeometryOperationNotSupportedException, GeometryOperationException, CloneNotSupportedException {
        Double segmentsNumberValue = (Double)this.values.get(this.segmentsNumberParameter);
        if (segmentsNumberValue == null) {
            return null;
        }
        double measureValue = line.perimeter() / segmentsNumberValue;
        return this.getPointsAndRotations(line, measureValue);
    }
}

