/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.dgn.legend;

import java.awt.Color;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.fmap.dal.feature.spi.FeatureStoreProvider;
import org.gvsig.fmap.dal.store.dgn.LegendBuilder;
import org.gvsig.fmap.dal.store.dgn.lib.DGNReader;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.fmap.mapcontext.rendering.legend.IVectorialUniqueValueLegend;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.symbology.SymbologyLocator;
import org.gvsig.symbology.fmap.mapcontext.rendering.legend.styling.IAttrInTableLabelingStrategy;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.fill.IFillSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.line.ILineSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.IMarkerSymbol;

public class DGNLegendBuilder
implements LegendBuilder {
    private MapContextManager mapContextManager = MapContextLocator.getMapContextManager();
    private IVectorialUniqueValueLegend defaultLegend = null;
    private IAttrInTableLabelingStrategy labelingStragegy = null;

    public void begin() {
    }

    public void end() {
    }

    public Object getLegend() {
        return this.defaultLegend;
    }

    public LegendBuilder initialize(FeatureStoreProvider store) {
        this.defaultLegend = (IVectorialUniqueValueLegend)this.mapContextManager.createLegend("VectorialUniqueValue");
        this.defaultLegend.setShapeType(0);
        this.defaultLegend.setClassifyingFieldNames(new String[]{"Color"});
        this.defaultLegend.setClassifyingFieldTypes(new int[]{4});
        ISymbol myDefaultSymbol = this.mapContextManager.getSymbolManager().createSymbol(0);
        this.defaultLegend.setDefaultSymbol(myDefaultSymbol);
        this.labelingStragegy = SymbologyLocator.getSymbologyManager().createAttrInTableLabelingStrategy();
        this.labelingStragegy.setTextField("Text");
        this.labelingStragegy.setRotationField("Rotation");
        this.labelingStragegy.setHeightField("HeightText");
        this.labelingStragegy.setUnit(1);
        return this;
    }

    public void process(FeatureProvider feature, DGNReader dgnReader) {
        Integer clave = (Integer)feature.get("Color");
        if (clave == null) {
            return;
        }
        this.defaultLegend.useDefaultSymbol(false);
        if (this.defaultLegend.getSymbolByValue((Object)clave) == null) {
            Color color = dgnReader.DGNLookupColor(clave.intValue());
            if (color == null) {
                color = Color.BLACK;
            }
            ISymbol theSymbol = this.mapContextManager.getSymbolManager().createSymbol(0, color);
            theSymbol.setDescription(clave.toString());
            if (theSymbol instanceof IMarkerSymbol) {
                ((IMarkerSymbol)theSymbol).setSize(1.0);
            }
            if (theSymbol instanceof ILineSymbol) {
                ILineSymbol lineSymbol = (ILineSymbol)theSymbol;
                lineSymbol.setLineWidth(1.0);
                lineSymbol.setLineColor(color);
            }
            if (theSymbol instanceof IFillSymbol) {
                IFillSymbol fillSymbol = (IFillSymbol)theSymbol;
                fillSymbol.getOutline().setLineColor(color);
                fillSymbol.getOutline().setLineWidth(1.0);
                fillSymbol.setFillColor(null);
            }
            if (theSymbol != null) {
                this.defaultLegend.addSymbol((Object)clave, theSymbol);
            }
        }
        this.defaultLegend.useDefaultSymbol(true);
    }

    public Object getLabeling() {
        return this.labelingStragegy;
    }
}

