/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.date;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.Range;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.spi.AbstractFunction;
import org.gvsig.timesupport.RelativeInstant;
import org.gvsig.timesupport.TimeSupportLocator;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.Coercion;
import org.gvsig.tools.dataTypes.CoercionException;

public class RelativeInstantFunction
extends AbstractFunction {
    private final Coercion toInstant = ToolsLocator.getDataTypesManager().getCoercion(68);

    public RelativeInstantFunction() {
        super("Date", "RelativeInstant", Range.is((Comparable)Integer.valueOf(1)), "Returns a relative instant from the arguments", "RelativeInstant({{date}}, format)", new String[]{"date - a string with a date", "format - Optional. Format to use to parse the date"}, "RelativeInstant", false);
    }

    public boolean allowConstantFolding() {
        return true;
    }

    public Object call(Interpreter interpreter, Object[] args) {
        if (args.length == 1) {
            Object arg0 = this.getObject(args, 0);
            try {
                Object instant = this.toInstant.coerce(arg0);
                return instant;
            }
            catch (CoercionException ex) {
                throw new RuntimeException("Can't convert value '" + Objects.toString(arg0, "") + "' to instant.", ex);
            }
        }
        String format = this.getStr(args, 1);
        String date = this.getStr(args, 0);
        SimpleDateFormat df = new SimpleDateFormat();
        if (format != null) {
            df.applyPattern(format);
        }
        try {
            Date x = df.parse(date);
            RelativeInstant instant = TimeSupportLocator.getManager().createRelativeInstant(x);
            return instant;
        }
        catch (ParseException ex) {
            throw new RuntimeException("Can't parse date value '" + date + "' with format '" + format == null ? "" : format + "'", ex);
        }
    }
}

