/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.swing.legend.impl.colortable.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;

class ColorChooserEditor
extends AbstractCellEditor
implements TableCellEditor {
    private JButton delegate = new JButton();
    Color savedColor;

    public ColorChooserEditor() {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                I18nManager i18nManager = ToolsLocator.getI18nManager();
                Color color = JColorChooser.showDialog(ColorChooserEditor.this.delegate, i18nManager.getTranslation("_color_chooser"), ColorChooserEditor.this.savedColor);
                ColorChooserEditor.this.changeColor(color);
            }
        };
        this.delegate.addActionListener(actionListener);
    }

    @Override
    public Object getCellEditorValue() {
        return this.savedColor;
    }

    private void changeColor(Color color) {
        if (color != null) {
            this.savedColor = color;
            this.delegate.setBackground(color);
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.changeColor((Color)value);
        return this.delegate;
    }
}

