/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sldconverter.impl.legend;

import java.util.List;
import org.gvsig.fmap.mapcontext.rendering.legend.ILegend;
import org.gvsig.fmap.mapcontext.rendering.legend.ISingleSymbolLegend;
import org.gvsig.fmap.mapcontext.rendering.legend.IVectorialIntervalLegend;
import org.gvsig.fmap.mapcontext.rendering.legend.IVectorialUniqueValueLegend;
import org.gvsig.sldconverter.impl.legend.BasicLegendConverter;
import org.gvsig.sldconverter.impl.legend.IntervalsLegendUtils;
import org.gvsig.sldconverter.impl.legend.SingleSymbolLegendUtils;
import org.gvsig.sldconverter.impl.legend.UniqueSymbolLegendUtils;
import org.gvsig.sldconverter.legend.LegendToSLDConverter;
import org.gvsig.sldconverter.legend.LegendToSLDConverterFactory;
import org.gvsig.sldconverter.legend.SLDToLegendConverter;
import org.gvsig.sldconverter.legend.SLDToLegendConverterFactory;
import org.gvsig.sldsupport.sld.layer.SLDLayer;
import org.gvsig.sldsupport.sld.layer.SLDNamedLayer;
import org.gvsig.sldsupport.sld.layer.SLDUserLayer;
import org.gvsig.sldsupport.sld.style.SLDFeatureStyle;
import org.gvsig.sldsupport.sld.style.layer.SLDUserStyle;

public class BasicLegendConverterFactory
implements LegendToSLDConverterFactory,
SLDToLegendConverterFactory {
    public static int LEGEND_PARTIALLY_CONVERTED = 50;

    public int canConvert(ILegend legend) {
        if (legend instanceof ISingleSymbolLegend || legend instanceof IVectorialUniqueValueLegend || legend instanceof IVectorialIntervalLegend) {
            return 50;
        }
        return 0;
    }

    public LegendToSLDConverter createLegendToSLDConverter() {
        return new BasicLegendConverter();
    }

    public SLDToLegendConverter createSLDToLegendConverter() {
        return new BasicLegendConverter();
    }

    public int canConvert(SLDLayer layer) {
        if (layer == null) {
            return 0;
        }
        if (layer instanceof SLDNamedLayer) {
            return this.canConvertNamedLayer((SLDNamedLayer)layer);
        }
        if (layer instanceof SLDUserLayer) {
            return this.canConvertUserLayer((SLDUserLayer)layer);
        }
        return 0;
    }

    private int canConvertNamedLayer(SLDNamedLayer layer) {
        List stys = layer.getStyles();
        if (stys.size() == 0) {
            return 0;
        }
        if (stys.size() == 1 && stys.get(0) instanceof SLDUserStyle) {
            return this.canConvertUserStyle((SLDUserStyle)stys.get(0), 50);
        }
        for (int i = 0; i < stys.size(); ++i) {
            if (!(stys.get(i) instanceof SLDUserStyle)) continue;
            return this.canConvertUserStyle((SLDUserStyle)stys.get(0), 50);
        }
        return 0;
    }

    private int canConvertUserStyle(SLDUserStyle style, int max) {
        List fstys = style.getFeatureStyles();
        if (fstys.size() == 0) {
            return 0;
        }
        if (fstys.size() == 1) {
            return this.canConvertFeatureStyle((SLDFeatureStyle)fstys.get(0), max);
        }
        return this.canConvertFeatureStyle((SLDFeatureStyle)fstys.get(0), max / 2);
    }

    private int canConvertUserLayer(SLDUserLayer layer) {
        List stys = layer.getStyles();
        if (stys.size() == 0) {
            return 0;
        }
        if (stys.size() == 1) {
            return this.canConvertUserStyle((SLDUserStyle)stys.get(0), 50);
        }
        return this.canConvertUserStyle((SLDUserStyle)stys.get(0), 50);
    }

    private int canConvertFeatureStyle(SLDFeatureStyle sldFeatureStyle, int max) {
        List rules = sldFeatureStyle.getRules();
        if (rules == null || rules.size() == 0) {
            return 0;
        }
        if (SingleSymbolLegendUtils.areRulesOfSingleSymbol(rules)) {
            return max;
        }
        if (UniqueSymbolLegendUtils.areRulesOfUniqueSymbol(rules)) {
            return max;
        }
        if (IntervalsLegendUtils.areRulesOfIntervals(rules)) {
            return max;
        }
        return 0;
    }
}

