/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.sldconverter.impl.symbol;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.sldconverter.exception.UnsupportedSymbolException;
import org.gvsig.sldconverter.impl.symbol.LineSymbolUtils;
import org.gvsig.sldconverter.impl.symbol.PointSymbolUtils;
import org.gvsig.sldconverter.impl.symbol.PolygonSymbolUtils;
import org.gvsig.sldconverter.symbol.SLDToSymbolConverter;
import org.gvsig.sldconverter.symbol.SymbolToSLDConverter;
import org.gvsig.sldsupport.exception.UnsupportedSLDObjectException;
import org.gvsig.sldsupport.sld.symbol.SLDLineSymbol;
import org.gvsig.sldsupport.sld.symbol.SLDPointSymbol;
import org.gvsig.sldsupport.sld.symbol.SLDPolygonSymbol;
import org.gvsig.sldsupport.sld.symbol.SLDSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.fill.IFillSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.fill.IMultiLayerFillSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.line.ILineSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.line.IMultiLayerLineSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.IMarkerSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.IMultiLayerMarkerSymbol;

public class BasicSymbolConverter
implements SymbolToSLDConverter,
SLDToSymbolConverter {
    public ISymbol convert(SLDSymbol sldSym) throws UnsupportedSLDObjectException {
        if (sldSym == null) {
            throw new UnsupportedSLDObjectException("SLDSymbol", "Null");
        }
        if (sldSym instanceof SLDPointSymbol) {
            return PointSymbolUtils.toMarkerSymbol((SLDPointSymbol)sldSym);
        }
        if (sldSym instanceof SLDLineSymbol) {
            return LineSymbolUtils.toLineSymbol((SLDLineSymbol)sldSym);
        }
        if (sldSym instanceof SLDPolygonSymbol) {
            return PolygonSymbolUtils.toFillSymbol((SLDPolygonSymbol)sldSym);
        }
        throw new UnsupportedSLDObjectException("SLDSymbol", "Unexpected class: " + sldSym.getClass().getName());
    }

    public SLDSymbol convert(ISymbol sym) throws UnsupportedSymbolException {
        List<SLDSymbol> list = this.toSLDSymbol(sym);
        if (list == null || list.size() < 1) {
            throw new UnsupportedSymbolException(sym == null ? "Null" : sym.getClass().getName(), "Unsupported symbol");
        }
        return list.get(0);
    }

    private List<SLDSymbol> toSLDSymbol(ISymbol sym) throws UnsupportedSymbolException {
        ArrayList<SLDSymbol> resp = new ArrayList<SLDSymbol>();
        if (sym instanceof IMultiLayerFillSymbol) {
            IMultiLayerFillSymbol aux = (IMultiLayerFillSymbol)sym;
            for (int i = 0; i < aux.getLayerCount(); ++i) {
                resp.addAll(this.toSLDSymbol(aux.getLayer(i)));
            }
            return resp;
        }
        if (sym instanceof IMultiLayerLineSymbol) {
            IMultiLayerLineSymbol aux = (IMultiLayerLineSymbol)sym;
            for (int i = 0; i < aux.getLayerCount(); ++i) {
                resp.addAll(this.toSLDSymbol(aux.getLayer(i)));
            }
            return resp;
        }
        if (sym instanceof IMultiLayerMarkerSymbol) {
            IMultiLayerMarkerSymbol aux = (IMultiLayerMarkerSymbol)sym;
            for (int i = 0; i < aux.getLayerCount(); ++i) {
                resp.addAll(this.toSLDSymbol(aux.getLayer(i)));
            }
            return resp;
        }
        if (sym instanceof IFillSymbol) {
            resp.add((SLDSymbol)PolygonSymbolUtils.toSLDPolygonSymbol((IFillSymbol)sym));
            return resp;
        }
        if (sym instanceof ILineSymbol) {
            resp.add((SLDSymbol)LineSymbolUtils.toSLDLineSymbol((ILineSymbol)sym));
            return resp;
        }
        if (sym instanceof IMarkerSymbol) {
            resp.add((SLDSymbol)PointSymbolUtils.toSLDPointSymbol((IMarkerSymbol)sym));
            return resp;
        }
        throw new UnsupportedSymbolException(sym == null ? "Null" : sym.getClass().getName(), "Unsupported symbol");
    }
}

