/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard.plug;

import java.io.IOException;
import java.util.Formatter;
import java.util.StringTokenizer;
import ucar.ma2.DataType;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.CF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft.point.standard.CoordSysEvaluator;
import ucar.nc2.ft.point.standard.Evaluator;
import ucar.nc2.ft.point.standard.Table;
import ucar.nc2.ft.point.standard.TableConfig;
import ucar.nc2.ft.point.standard.TableConfigurerImpl;

public class CdmDirect
extends TableConfigurerImpl {
    private static final String Convention = "CDM";

    @Override
    public boolean isMine(FeatureType wantFeatureType, NetcdfDataset ds) {
        boolean ok = false;
        String conv = ds.findAttValueIgnoreCase(null, "Conventions", null);
        if (conv == null) {
            return false;
        }
        if (conv.equals(Convention)) {
            ok = true;
        }
        StringTokenizer stoke = new StringTokenizer(conv, ",");
        while (stoke.hasMoreTokens()) {
            String toke = stoke.nextToken().trim();
            if (!toke.equals(Convention)) continue;
            ok = true;
        }
        if (!ok) {
            return false;
        }
        CF.FeatureType ftype = CF.FeatureType.getFeatureTypeFromGlobalAttribute(ds);
        if (ftype == null) {
            ftype = CF.FeatureType.point;
        }
        return ftype == CF.FeatureType.timeSeries || ftype == CF.FeatureType.timeSeriesProfile;
    }

    @Override
    public TableConfig getConfig(FeatureType wantFeatureType, NetcdfDataset ds, Formatter errlog) throws IOException {
        CF.FeatureType ftype = CF.FeatureType.getFeatureTypeFromGlobalAttribute(ds);
        if (ftype == null) {
            ftype = CF.FeatureType.point;
        }
        switch (ftype) {
            case point: {
                return null;
            }
            case timeSeries: {
                return this.getStationConfig(ds, errlog);
            }
            case timeSeriesProfile: {
                return this.getStationProfileConfig(ds, errlog);
            }
        }
        throw new IllegalStateException("unimplemented feature ftype= " + (Object)((Object)ftype));
    }

    protected TableConfig getStationConfig(NetcdfDataset ds, Formatter errlog) throws IOException {
        CoordinateAxis lat = CoordSysEvaluator.findCoordByType(ds, AxisType.Lat);
        if (lat == null) {
            errlog.format("CdmDirect: Must have a Latitude coordinate%n", new Object[0]);
            return null;
        }
        CoordinateAxis lon = CoordSysEvaluator.findCoordByType(ds, AxisType.Lon);
        if (lon == null) {
            errlog.format("CdmDirect: Must have a Longitude coordinate%n", new Object[0]);
            return null;
        }
        if (lat.getRank() != lon.getRank()) {
            errlog.format("CdmDirect: Lat and Lon coordinate must have same rank", new Object[0]);
            return null;
        }
        TableConfig stnTable = new TableConfig(Table.Type.Structure, "station");
        stnTable.featureType = FeatureType.STATION;
        stnTable.structureType = TableConfig.StructureType.Structure;
        stnTable.lat = lat.getShortName();
        stnTable.lon = lon.getShortName();
        CoordinateAxis alt = CoordSysEvaluator.findCoordByType(ds, AxisType.Height);
        if (alt != null) {
            stnTable.stnAlt = alt.getShortName();
        }
        stnTable.stnId = Evaluator.getNameOfVariableWithAttribute(ds, "cf_role", "station_id");
        if (stnTable.stnId == null) {
            stnTable.stnId = Evaluator.getNameOfVariableWithAttribute(ds, "standard_name", "station_id");
        }
        if (stnTable.stnId == null) {
            errlog.format("Must have a Station id variable with standard name station_id%n", new Object[0]);
            return null;
        }
        stnTable.stnDesc = Evaluator.getNameOfVariableWithAttribute(ds, "standard_name", "station_desc");
        stnTable.stnWmoId = Evaluator.getNameOfVariableWithAttribute(ds, "standard_name", "station_WMO_id");
        Structure stnv = (Structure)ds.findVariable("station");
        Variable obsv = null;
        for (Variable v : stnv.getVariables()) {
            if (v.getDataType() != DataType.SEQUENCE) continue;
            obsv = (Structure)v;
        }
        TableConfig obs = new TableConfig(Table.Type.NestedStructure, obsv.getName());
        obs.nestedTableName = obsv.getShortName();
        obs.time = CoordSysEvaluator.findCoordShortNameByType(ds, AxisType.Time);
        if (obs.time == null) {
            errlog.format("Must have a time coordinate%n", new Object[0]);
            return null;
        }
        stnTable.addChild(obs);
        return stnTable;
    }

    protected TableConfig getStationProfileConfig(NetcdfDataset ds, Formatter errlog) throws IOException {
        TableConfig stnTable = this.getStationConfig(ds, errlog);
        if (stnTable == null) {
            return null;
        }
        stnTable.featureType = FeatureType.STATION_PROFILE;
        TableConfig timeSeries = stnTable.children.get(0);
        Structure obsv = (Structure)ds.findVariable(timeSeries.name);
        Variable profile = null;
        for (Variable v : obsv.getVariables()) {
            if (v.getDataType() != DataType.SEQUENCE) continue;
            profile = (Structure)v;
        }
        TableConfig profileTc = new TableConfig(Table.Type.NestedStructure, profile.getName());
        profileTc.nestedTableName = profile.getShortName();
        CoordinateAxis elev = this.findZAxisNotStationAlt(ds);
        profileTc.elev = elev.getShortName();
        if (profileTc.elev == null) {
            errlog.format("Must have a level coordinate%n", new Object[0]);
            return null;
        }
        timeSeries.addChild(profileTc);
        return stnTable;
    }
}

