/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.gempak;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayStructureBB;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.FileWriter;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.constants.CF;
import ucar.nc2.iosp.IOServiceProvider;
import ucar.nc2.iosp.gempak.AbstractGempakStationFileReader;
import ucar.nc2.iosp.gempak.GempakFileReader;
import ucar.nc2.iosp.gempak.GempakParameter;
import ucar.nc2.iosp.gempak.GempakStation;
import ucar.nc2.iosp.gempak.GempakStationFileIOSP;
import ucar.nc2.iosp.gempak.GempakSurfaceFileReader;
import ucar.nc2.util.CancelTask;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.StringUtil;
import visad.util.Trace;

public class GempakSurfaceIOSP
extends GempakStationFileIOSP {
    @Override
    protected AbstractGempakStationFileReader makeStationReader() {
        return new GempakSurfaceFileReader();
    }

    @Override
    public boolean isValidFile(RandomAccessFile raf) throws IOException {
        if (!super.isValidFile(raf)) {
            return false;
        }
        return this.gemreader.getFileSubType().equals("standard") || this.gemreader.getFileSubType().equals("ship");
    }

    @Override
    public String getFileTypeId() {
        return "GempakSurface";
    }

    @Override
    public String getFileTypeDescription() {
        return "GEMPAK Surface Obs Data";
    }

    @Override
    public String getCFFeatureType() {
        if (this.gemreader.getFileSubType().equals("ship")) {
            return CF.FeatureType.point.toString();
        }
        return CF.FeatureType.timeSeries.toString();
    }

    @Override
    public Array readData(Variable v2, Section section) throws IOException, InvalidRangeException {
        if (this.gemreader == null) {
            return null;
        }
        Array array = null;
        if (this.gemreader.getFileSubType().equals("ship")) {
            array = this.readShipData(v2, section);
        } else if (this.gemreader.getFileSubType().equals("standard")) {
            array = this.readStandardData(v2, section);
        }
        return array;
    }

    private Array readStandardData(Variable v2, Section section) throws IOException {
        ArrayStructureBB array = null;
        if (v2 instanceof Structure) {
            List<GempakParameter> params = this.gemreader.getParameters("SFDT");
            Structure pdata = (Structure)v2;
            StructureMembers members = pdata.makeStructureMembers();
            List<StructureMembers.Member> mbers = members.getMembers();
            int i = 0;
            int numBytes = 0;
            int totalNumBytes = 0;
            for (StructureMembers.Member member : mbers) {
                member.setDataParam(4 * i++);
                numBytes = member.getDataType().getSize();
                totalNumBytes += numBytes;
            }
            members.setStructureSize(totalNumBytes);
            float[] missing = new float[mbers.size()];
            int missnum = 0;
            for (Variable v : pdata.getVariables()) {
                Attribute att = v.findAttribute("missing_value");
                missing[missnum++] = att == null ? -9999.0f : att.getNumericValue().floatValue();
            }
            boolean num = false;
            Range stationRange = section.getRange(0);
            Range timeRange = section.getRange(1);
            int size = stationRange.length() * timeRange.length();
            byte[] bytes = new byte[totalNumBytes * size];
            ByteBuffer buf = ByteBuffer.wrap(bytes);
            array = new ArrayStructureBB(members, new int[]{size}, buf, 0);
            for (int y = stationRange.first(); y <= stationRange.last(); y += stationRange.stride()) {
                for (int x = timeRange.first(); x <= timeRange.last(); x += timeRange.stride()) {
                    GempakFileReader.RData vals = this.gemreader.DM_RDTR(x + 1, y + 1, "SFDT");
                    if (vals == null) {
                        int k = 0;
                        for (StructureMembers.Member member : mbers) {
                            if (member.getDataType().equals((Object)DataType.FLOAT)) {
                                buf.putFloat(missing[k]);
                            } else {
                                buf.put((byte)1);
                            }
                            ++k;
                        }
                        continue;
                    }
                    float[] reals = vals.data;
                    int var = 0;
                    for (GempakParameter param : params) {
                        if (members.findMember(param.getName()) != null) {
                            buf.putFloat(reals[var]);
                        }
                        ++var;
                    }
                    buf.put((byte)0);
                }
            }
        }
        return array;
    }

    private Array readShipData(Variable v2, Section section) throws IOException {
        ArrayStructureBB array = null;
        if (v2 instanceof Structure) {
            boolean needToReadData;
            List<GempakParameter> params = this.gemreader.getParameters("SFDT");
            Structure pdata = (Structure)v2;
            StructureMembers members = pdata.makeStructureMembers();
            List<StructureMembers.Member> mbers = members.getMembers();
            int ssize = 0;
            boolean stnVarNum = false;
            List<String> stnKeyNames = this.gemreader.getStationKeyNames();
            for (StructureMembers.Member member : mbers) {
                if (stnKeyNames.contains(member.getName())) {
                    int varSize = this.getStnVarSize(member.getName());
                    member.setDataParam(ssize);
                    ssize += varSize;
                    continue;
                }
                if (member.getName().equals("time")) {
                    member.setDataParam(ssize);
                    ssize += 8;
                    continue;
                }
                if (member.getName().equals("_isMissing")) {
                    member.setDataParam(ssize);
                    ++ssize;
                    continue;
                }
                member.setDataParam(ssize);
                ssize += 4;
            }
            members.setStructureSize(ssize);
            Range recordRange = section.getRange(0);
            int size = recordRange.length();
            byte[] bytes = new byte[ssize * size];
            ByteBuffer buf = ByteBuffer.wrap(bytes);
            array = new ArrayStructureBB(members, new int[]{size}, buf, 0);
            List<GempakStation> stationList = this.gemreader.getStations();
            List<Date> dateList = this.gemreader.getDates();
            boolean bl = needToReadData = !pdata.isSubset();
            if (!needToReadData) {
                for (GempakParameter param : params) {
                    if (members.findMember(param.getName()) == null) continue;
                    needToReadData = true;
                    break;
                }
            }
            boolean hasTime = members.findMember("time") != null;
            for (int x = recordRange.first(); x <= recordRange.last(); x += recordRange.stride()) {
                GempakStation stn = stationList.get(x);
                for (String varname : stnKeyNames) {
                    if (members.findMember(varname) == null) continue;
                    String temp = null;
                    if (varname.equals("STID")) {
                        temp = StringUtil.padRight(stn.getName(), 8);
                    } else if (varname.equals("STNM")) {
                        buf.putInt(stn.getSTNM());
                    } else if (varname.equals("SLAT")) {
                        buf.putFloat((float)stn.getLatitude());
                    } else if (varname.equals("SLON")) {
                        buf.putFloat((float)stn.getLongitude());
                    } else if (varname.equals("SELV")) {
                        buf.putFloat((float)stn.getAltitude());
                    } else if (varname.equals("STAT")) {
                        temp = StringUtil.padRight(stn.getSTAT(), 2);
                    } else if (varname.equals("COUN")) {
                        temp = StringUtil.padRight(stn.getCOUN(), 2);
                    } else if (varname.equals("STD2")) {
                        temp = StringUtil.padRight(stn.getSTD2(), 4);
                    } else if (varname.equals("SPRI")) {
                        buf.putInt(stn.getSPRI());
                    } else if (varname.equals("SWFO")) {
                        temp = StringUtil.padRight(stn.getSWFO(), 4);
                    } else if (varname.equals("WFO2")) {
                        temp = StringUtil.padRight(stn.getWFO2(), 4);
                    }
                    if (temp == null) continue;
                    buf.put(temp.getBytes());
                }
                if (members.findMember("time") != null) {
                    Date time = dateList.get(x);
                    buf.putDouble((double)time.getTime() / 1000.0);
                }
                if (!needToReadData) continue;
                int column = stn.getIndex();
                GempakFileReader.RData vals = this.gemreader.DM_RDTR(1, column, "SFDT");
                if (vals == null) {
                    for (GempakParameter param : params) {
                        if (members.findMember(param.getName()) == null) continue;
                        buf.putFloat(-9999.0f);
                    }
                    buf.put((byte)1);
                    continue;
                }
                float[] reals = vals.data;
                int var = 0;
                for (GempakParameter param : params) {
                    if (members.findMember(param.getName()) != null) {
                        buf.putFloat(reals[var]);
                    }
                    ++var;
                }
                buf.put((byte)0);
            }
        }
        return array;
    }

    public static void main(String[] args) throws IOException {
        GempakSurfaceIOSP mciosp = new GempakSurfaceIOSP();
        RandomAccessFile rf = new RandomAccessFile(args[0], "r", 2048);
        MakeNetcdfFile ncfile = new MakeNetcdfFile(mciosp, rf, args[0], null);
        if (args.length > 1) {
            FileWriter.writeToFile(ncfile, args[1]);
        } else {
            System.out.println(ncfile);
        }
    }

    @Override
    protected void fillNCFile() throws IOException {
        String fileType = this.gemreader.getFileSubType();
        if (fileType.equals("standard")) {
            this.buildStandardFile();
        } else if (fileType.equals("ship")) {
            this.buildShipFile();
        } else {
            this.buildClimateFile();
        }
    }

    private void buildStandardFile() {
        List<GempakStation> stations = this.gemreader.getStations();
        Trace.msg("GEMPAKSIOSP: now have " + stations.size() + " stations");
        Dimension station = new Dimension("station", stations.size(), true);
        this.ncfile.addDimension(null, station);
        this.ncfile.addDimension(null, DIM_LEN8);
        this.ncfile.addDimension(null, DIM_LEN4);
        this.ncfile.addDimension(null, DIM_LEN2);
        List<Variable> stationVars = this.makeStationVars(stations, station);
        for (Variable stnVar : stationVars) {
            this.ncfile.addVariable(null, stnVar);
        }
        List<Date> timeList = this.gemreader.getDates();
        int numTimes = timeList.size();
        Dimension times = new Dimension("time", numTimes, true);
        this.ncfile.addDimension(null, times);
        ArrayDouble.D1 varArray = null;
        Variable timeVar = new Variable(this.ncfile, null, null, "time", DataType.DOUBLE, "time");
        timeVar.addAttribute(new Attribute("units", "seconds since 1970-01-01 00:00:00"));
        timeVar.addAttribute(new Attribute("long_name", "time"));
        varArray = new ArrayDouble.D1(numTimes);
        int i = 0;
        for (Date date : timeList) {
            varArray.set(i, (double)date.getTime() / 1000.0);
            ++i;
        }
        timeVar.setCachedData(varArray, false);
        this.ncfile.addVariable(null, timeVar);
        ArrayList<Dimension> stationTime = new ArrayList<Dimension>();
        stationTime.add(station);
        stationTime.add(times);
        Structure sfData = this.makeStructure("SFDT", stationTime, true);
        if (sfData == null) {
            return;
        }
        sfData.addAttribute(new Attribute("coordinates", "time SLAT SLON SELV"));
        this.ncfile.addVariable(null, sfData);
        this.ncfile.addAttribute(null, new Attribute("CF:featureType", CF.FeatureType.timeSeries.toString()));
    }

    private void buildShipFile() {
        List<GempakStation> stations = this.gemreader.getStations();
        int numObs = stations.size();
        Trace.msg("GEMPAKSIOSP: now have " + numObs + " stations");
        Dimension record = new Dimension("record", numObs, true, numObs == 0, false);
        this.ncfile.addDimension(null, record);
        ArrayList<Dimension> records = new ArrayList<Dimension>(1);
        records.add(record);
        Variable timeVar = new Variable(this.ncfile, null, null, "time", DataType.DOUBLE, null);
        timeVar.addAttribute(new Attribute("units", "seconds since 1970-01-01 00:00:00"));
        timeVar.addAttribute(new Attribute("long_name", "time"));
        this.ncfile.addDimension(null, DIM_LEN8);
        this.ncfile.addDimension(null, DIM_LEN4);
        this.ncfile.addDimension(null, DIM_LEN2);
        List<Variable> stationVars = this.makeStationVars(stations, null);
        List<GempakParameter> params = this.gemreader.getParameters("SFDT");
        if (params == null) {
            return;
        }
        Structure sVar = new Structure(this.ncfile, null, null, "Obs");
        sVar.setDimensions(records);
        boolean hasElevation = false;
        for (Variable stnVar : stationVars) {
            if (stnVar.getName().equals("SELV")) {
                hasElevation = true;
            }
            sVar.addMemberVariable(stnVar);
        }
        sVar.addMemberVariable(timeVar);
        for (GempakParameter param : params) {
            Variable var = this.makeParamVariable(param, null);
            sVar.addMemberVariable(var);
        }
        sVar.addMemberVariable(this.makeMissingVariable());
        String coords = "Obs.time Obs.SLAT Obs.SLON";
        if (hasElevation) {
            coords = coords + " Obs.SELV";
        }
        sVar.addAttribute(new Attribute("coordinates", coords));
        this.ncfile.addVariable(null, sVar);
        this.ncfile.addAttribute(null, new Attribute("CF:featureType", CF.FeatureType.point.toString()));
    }

    private void buildClimateFile() {
    }

    protected static class MakeNetcdfFile
    extends NetcdfFile {
        MakeNetcdfFile(IOServiceProvider spi, RandomAccessFile raf, String location, CancelTask cancelTask) throws IOException {
            super(spi, raf, location, cancelTask);
        }
    }
}

