/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.grads;

public class GradsVariable {
    private String varName;
    private int numLevs;
    private int[] levVals;
    private int unit;
    private int[] unitVals;
    private String description;
    private String unitName = null;

    public GradsVariable(String varDescriptor) {
        int uEnd;
        int i;
        String levelString;
        String[] toks = varDescriptor.split("\\s+");
        this.varName = toks[0].trim();
        int arrowIndex = this.varName.indexOf("=>");
        if (arrowIndex > 0) {
            this.varName = this.varName.substring(arrowIndex + 2);
        }
        if ((levelString = toks[1]).indexOf(",") > 0) {
            String[] levs = levelString.split(",");
            this.levVals = new int[levs.length];
            for (int i2 = 0; i2 < levs.length; ++i2) {
                if (levs[i2].trim().isEmpty()) continue;
                this.levVals[i2] = Integer.parseInt(levs[i2]);
            }
            this.numLevs = this.levVals[0];
        } else {
            this.numLevs = Integer.parseInt(levelString);
        }
        String unitString = toks[2];
        if (unitString.indexOf(",") > 0) {
            String[] units = unitString.split(",");
            this.unitVals = new int[units.length];
            for (i = 0; i < units.length; ++i) {
                if (units[i].trim().isEmpty()) continue;
                this.unitVals[i] = Integer.parseInt(units[i]);
            }
            this.unit = this.unitVals[0];
        } else {
            this.unit = Integer.parseInt(unitString);
        }
        StringBuffer buf = new StringBuffer();
        for (i = 3; i < toks.length; ++i) {
            buf.append(toks[i]);
            buf.append(" ");
        }
        this.description = buf.toString().trim();
        int uStart = this.description.indexOf("[");
        if (uStart >= 0 && (uEnd = this.description.indexOf("]")) > uStart) {
            this.unitName = this.description.substring(uStart + 1, uEnd);
        }
    }

    public String getName() {
        return this.varName;
    }

    public int getNumLevels() {
        return this.numLevs;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUnitName() {
        return this.unitName;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Variable: ");
        buf.append(this.varName);
        buf.append("\n");
        buf.append("\tNum levels: ");
        buf.append(this.numLevs);
        buf.append("\n");
        buf.append("\tUnit: ");
        buf.append(this.unit);
        buf.append("\n");
        buf.append("\tDescription: ");
        buf.append(this.description);
        buf.append("\n");
        return buf.toString();
    }
}

