/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.mcidas;

import edu.wisc.ssec.mcidas.GridDirectory;
import edu.wisc.ssec.mcidas.McIDASException;
import java.util.Formatter;
import ucar.grid.GridRecord;
import ucar.grid.GridTableLookup;
import ucar.nc2.iosp.mcidas.McGridDefRecord;

public class McIDASGridRecord
extends GridDirectory
implements GridRecord {
    private int offsetToHeader;
    private McGridDefRecord gridDefRecord;
    private int decimalScale = 0;

    public McIDASGridRecord(int offset, int[] header) throws McIDASException {
        super(header);
        this.gridDefRecord = new McGridDefRecord(header);
        this.offsetToHeader = offset;
    }

    @Override
    public double getLevel1() {
        return this.getLevelValue();
    }

    @Override
    public double getLevel2() {
        return this.getSecondLevelValue();
    }

    @Override
    public int getLevelType1() {
        int gribLevel = this.getDirBlock()[51];
        int levelType = 0;
        levelType = gribLevel != -2139062144 && gribLevel != 0 ? gribLevel : 1;
        return levelType;
    }

    @Override
    public int getLevelType2() {
        return this.getLevelType1();
    }

    public int getValidTimeOffset() {
        return this.getForecastHour();
    }

    @Override
    public String getParameterName() {
        return this.getParamName();
    }

    @Override
    public String getParameterDescription() {
        return this.getParamName();
    }

    @Override
    public int getDecimalScale() {
        return this.decimalScale;
    }

    @Override
    public String getGridDefRecordId() {
        return this.gridDefRecord.toString();
    }

    public McGridDefRecord getGridDefRecord() {
        return this.gridDefRecord;
    }

    public int getOffsetToHeader() {
        return this.offsetToHeader;
    }

    public boolean hasGribInfo() {
        int gribSection = this.getDirBlock()[48];
        return gribSection != -2139062144 && gribSection != 0;
    }

    @Override
    public int getTimeUnit() {
        return 0;
    }

    @Override
    public String getTimeUdunitName() {
        return "minutes";
    }

    @Override
    public int cdmVariableHash() {
        return this.getParamName().hashCode() + 37 * this.getLevelType1();
    }

    @Override
    public String cdmVariableName(GridTableLookup lookup, boolean useLevel, boolean useStat) {
        String levelName;
        Formatter f = new Formatter();
        f.format("%s", this.getParameterName());
        if (useLevel && (levelName = lookup.getLevelName(this)).length() != 0) {
            if (lookup.isLayer(this)) {
                f.format("_%s_layer", lookup.getLevelName(this));
            } else {
                f.format("_%s", lookup.getLevelName(this));
            }
        }
        return f.toString();
    }
}

