/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.trimline;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.aggregate.MultiCurve;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Arc;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.service.spi.ProviderServices;
import org.gvsig.vectorediting.lib.api.DrawingStatus;
import org.gvsig.vectorediting.lib.api.EditingServiceParameter;
import org.gvsig.vectorediting.lib.api.exceptions.DrawServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.FinishServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.InvalidEntryException;
import org.gvsig.vectorediting.lib.api.exceptions.StartServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.StopServiceException;
import org.gvsig.vectorediting.lib.prov.trimline.operation.TrimLineOperation;
import org.gvsig.vectorediting.lib.prov.trimline.operation.TrimLineOperationUtils;
import org.gvsig.vectorediting.lib.spi.AbstractEditingProvider;
import org.gvsig.vectorediting.lib.spi.DefaultDrawingStatus;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameter;
import org.gvsig.vectorediting.lib.spi.EditingProvider;
import org.gvsig.vectorediting.lib.spi.EditingProviderLocator;
import org.gvsig.vectorediting.lib.spi.EditingProviderManager;
import org.gvsig.vectorediting.lib.spi.EditingProviderServices;

public class TrimLineEditingProvider
extends AbstractEditingProvider
implements EditingProvider {
    private final int TOLERANCE_PIXELS = 3;
    private final EditingServiceParameter selectionParameter;
    private final EditingServiceParameter geometryToTrimWithParameter;
    private final EditingServiceParameter shearingPointParameter;
    protected Map<EditingServiceParameter, Object> values;
    private final FeatureStore featureStore;
    private final MapContext mapContext;
    private List<Feature> selectedFeatures;

    public TrimLineEditingProvider(ProviderServices services, DynObject parameters) {
        super(services);
        this.featureStore = (FeatureStore)parameters.getDynValue("featureStore");
        this.mapContext = (MapContext)parameters.getDynValue("mapContext");
        this.selectionParameter = new DefaultEditingServiceParameter("selection", "selection", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.SELECTION});
        this.geometryToTrimWithParameter = new DefaultEditingServiceParameter("geometry_to_trim_with", "geometry_to_trim_with", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION});
        this.shearingPointParameter = new DefaultEditingServiceParameter("shearing_point", "shearing_point", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION});
    }

    public EditingServiceParameter next() {
        if (this.values.get(this.selectionParameter) == null) {
            return this.selectionParameter;
        }
        if (this.values.get(this.geometryToTrimWithParameter) == null) {
            return this.geometryToTrimWithParameter;
        }
        if (this.values.get(this.shearingPointParameter) == null) {
            return this.shearingPointParameter;
        }
        return null;
    }

    public DrawingStatus getDrawingStatus(Point mousePosition) throws DrawServiceException {
        FeatureSelection selection = (FeatureSelection)this.values.get(this.selectionParameter);
        Geometry shears = (Geometry)this.values.get(this.geometryToTrimWithParameter);
        if (selection != null && shears != null) {
            DefaultDrawingStatus drawingStatus = new DefaultDrawingStatus();
            EditingProviderManager editingProviderManager = EditingProviderLocator.getProviderManager();
            ISymbol lineSymbolEditing = editingProviderManager.getSymbol("line-symbol-editing");
            try {
                for (Feature feature : this.selectedFeatures) {
                    if (feature == null) continue;
                    ISymbol previewSymbol = this.getPreviewSymbol(feature);
                    Geometry geometry = feature.getDefaultGeometry();
                    if (geometry == null || !geometry.intersects(shears)) continue;
                    if (geometry instanceof MultiCurve) {
                        MultiCurve multiCurve = (MultiCurve)geometry;
                        for (int i = 0; i < multiCurve.getPrimitivesNumber(); ++i) {
                            Curve curve = multiCurve.getCurveAt(i);
                            MultiCurve trimmedCurve = this.trimLine(mousePosition, curve, shears);
                            for (int j = 0; j < trimmedCurve.getPrimitivesNumber(); ++j) {
                                Curve primitive = trimmedCurve.getCurveAt(j);
                                drawingStatus.addStatus((Geometry)primitive, lineSymbolEditing, "");
                                drawingStatus.addStatus((Geometry)primitive, previewSymbol, "");
                            }
                        }
                        continue;
                    }
                    if (!(geometry instanceof Curve)) continue;
                    Curve curve = (Curve)geometry;
                    MultiCurve extendedCurve = this.trimLine(mousePosition, curve, shears);
                    for (int j = 0; j < extendedCurve.getPrimitivesNumber(); ++j) {
                        Curve primitive = extendedCurve.getCurveAt(j);
                        drawingStatus.addStatus((Geometry)primitive, lineSymbolEditing, "");
                        drawingStatus.addStatus((Geometry)primitive, previewSymbol, "");
                    }
                }
            }
            catch (BaseException ex) {
                throw new DrawServiceException((Throwable)ex);
            }
            return drawingStatus;
        }
        return null;
    }

    private MultiCurve trimLine(Point shearingPoint, Curve curve, Geometry shearsGeometry) throws GeometryOperationNotSupportedException, GeometryOperationException, DataException, CreateGeometryException {
        TrimLineOperation operation = TrimLineOperationUtils.getOperation((Primitive)curve);
        return operation.trimLine(curve, shearingPoint, shearsGeometry);
    }

    public void stop() throws StopServiceException {
        this.values.clear();
        this.selectedFeatures = Collections.EMPTY_LIST;
    }

    public List<EditingServiceParameter> getParameters() {
        ArrayList<EditingServiceParameter> parameters = new ArrayList<EditingServiceParameter>();
        parameters.add(this.selectionParameter);
        parameters.add(this.geometryToTrimWithParameter);
        parameters.add(this.shearingPointParameter);
        return parameters;
    }

    public void setValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        this.validateAndInsertValue(parameter, value);
    }

    public void setValue(Object value) throws InvalidEntryException {
        EditingServiceParameter parameter = this.next();
        this.validateAndInsertValue(parameter, value);
    }

    private void validateAndInsertValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        if (parameter == this.selectionParameter) {
            FeatureSelection featureSelection;
            if (value instanceof FeatureSelection && (featureSelection = (FeatureSelection)value).getSelectedCount() > 0L) {
                try {
                    featureSelection.accept(obj -> {
                        Feature feature = (Feature)obj;
                        Geometry geometry = feature.getDefaultGeometry();
                        if (!this.isValidGeometryToSelect(geometry)) {
                            throw new InvalidEntryException(null);
                        }
                    });
                    this.values.put(parameter, featureSelection);
                    this.selectedFeatures = this.getSelectedFeaturesCopy(featureSelection);
                    return;
                }
                catch (BaseException e) {
                    throw new InvalidEntryException((Throwable)e);
                }
            }
        } else if (parameter == this.geometryToTrimWithParameter && value instanceof Point) {
            Point point;
            Geometry geometry;
            if (value instanceof Point && (geometry = this.getGeometry(point = (Point)value)) != null) {
                try {
                    this.values.put(parameter, geometry.toLines());
                }
                catch (GeometryException ex) {
                    throw new InvalidEntryException((Throwable)ex);
                }
                return;
            }
        } else if (parameter == this.shearingPointParameter && value instanceof Point && value instanceof Point) {
            Point point = (Point)value;
            this.values.put(parameter, point);
            return;
        }
        throw new InvalidEntryException(null);
    }

    private boolean isValidGeometryToSelect(Geometry geometry) {
        GeometryType geoType = geometry.getGeometryType();
        if (!geoType.isTypeOf(2) && !geoType.isTypeOf(8)) {
            return false;
        }
        if (geoType.isTypeOf(2)) {
            if (geometry instanceof Line) {
                Line line = (Line)geometry;
                return !line.isClosed();
            }
            if (geometry instanceof Arc) {
                Arc arc = (Arc)geometry;
                return !arc.getInitPoint().equals(arc.getEndPoint());
            }
            return false;
        }
        if (geoType.isTypeOf(8)) {
            MultiCurve multiCurve = (MultiCurve)geometry;
            for (Geometry geom : multiCurve) {
                if (this.isValidGeometryToSelect(geom)) continue;
                return false;
            }
        }
        return true;
    }

    private Geometry getGeometry(Point point) {
        EditingProviderServices editingProviderServices = this.getProviderServices();
        Geometry geometry = editingProviderServices.getGeometryOfVisibleLayers(point, this.featureStore, this.mapContext);
        return geometry;
    }

    public Geometry finish() throws FinishServiceException {
        return null;
    }

    public void finishAndStore() throws FinishServiceException {
        FeatureSelection selection = (FeatureSelection)this.values.get(this.selectionParameter);
        Geometry shearsGeometry = (Geometry)this.values.get(this.geometryToTrimWithParameter);
        Point point = (Point)this.values.get(this.shearingPointParameter);
        if (selection != null && shearsGeometry != null && point != null) {
            try {
                for (Feature feature : this.selectedFeatures) {
                    int i;
                    Geometry geometry = feature.getDefaultGeometry();
                    EditableFeature eFeature = feature.getEditable();
                    if (!geometry.intersects(shearsGeometry)) continue;
                    if (geometry instanceof Curve) {
                        Curve curveToTrim = (Curve)geometry;
                        MultiCurve result = this.trimLine(point, curveToTrim, shearsGeometry);
                        eFeature.setDefaultGeometry((Geometry)result);
                        selection.update(eFeature);
                        continue;
                    }
                    if (!(geometry instanceof MultiCurve)) continue;
                    int subType = geometry.getGeometryType().getSubType();
                    MultiCurve trimmedMultiCurve = this.createMultiCurve(subType);
                    MultiCurve multiCurveToTrim = (MultiCurve)geometry;
                    double minDistance = Double.POSITIVE_INFINITY;
                    int nearestCurveIndex = -1;
                    for (int i2 = 0; i2 < multiCurveToTrim.getPrimitivesNumber(); ++i2) {
                        Curve primitive = multiCurveToTrim.getCurveAt(i2);
                        double distance = primitive.distance((Geometry)point);
                        if (!(distance < minDistance)) continue;
                        nearestCurveIndex = i2;
                        minDistance = distance;
                    }
                    MultiCurve result = this.trimLine(point, multiCurveToTrim.getCurveAt(nearestCurveIndex), shearsGeometry);
                    for (i = 0; i < result.getPrimitivesNumber(); ++i) {
                        trimmedMultiCurve.addCurve(result.getCurveAt(i));
                    }
                    for (i = 0; i < multiCurveToTrim.getPrimitivesNumber(); ++i) {
                        if (i == nearestCurveIndex) continue;
                        trimmedMultiCurve.addCurve(multiCurveToTrim.getCurveAt(i));
                    }
                    eFeature.setDefaultGeometry((Geometry)trimmedMultiCurve);
                    selection.update(eFeature);
                }
            }
            catch (BaseException ex) {
                throw new FinishServiceException((Throwable)ex);
            }
        }
    }

    private MultiCurve createMultiCurve(int subtype) throws FinishServiceException, CreateGeometryException {
        GeometryManager geoManager = GeometryLocator.getGeometryManager();
        MultiCurve extendedMultiCurve = geoManager.createMultiCurve(subtype);
        return extendedMultiCurve;
    }

    public void start() throws StartServiceException, InvalidEntryException {
        this.values = new HashMap<EditingServiceParameter, Object>();
        this.selectedFeatures = Collections.EMPTY_LIST;
        if (this.featureStore != null) {
            FeatureSelection selected = null;
            try {
                selected = (FeatureSelection)this.featureStore.getFeatureSelection().clone();
            }
            catch (DataException e) {
                throw new StartServiceException((Throwable)e);
            }
            catch (CloneNotSupportedException ex) {
                LOGGER.debug("Can't init selection", (Throwable)ex);
            }
            if (selected != null && selected.getSelectedCount() > 0L) {
                this.values.put(this.selectionParameter, selected);
                this.selectedFeatures = this.getSelectedFeaturesCopy(selected);
            }
        }
    }

    public String getName() {
        return "modify-trim-line";
    }

    public Object getValue(EditingServiceParameter parameter) {
        return this.values != null ? this.values.get(parameter) : null;
    }
}

