/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.trimline.operation;

import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.aggregate.MultiCurve;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.locator.LocatorException;
import org.gvsig.vectorediting.lib.prov.trimline.operation.TrimLineOperation;
import org.gvsig.vectorediting.lib.prov.trimline.operation.TrimLineOperationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurveTrimLineOperation
implements TrimLineOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger(CurveTrimLineOperation.class);

    @Override
    public MultiCurve trimLine(Curve curveToTrim, Point shearingPoint, FeatureSelection shears) throws GeometryOperationNotSupportedException, GeometryOperationException, DataException, CreateGeometryException, LocatorException {
        GeometryManager geometryManager = GeometryLocator.getGeometryManager();
        int subType = curveToTrim.getGeometryType().getSubType();
        DisposableIterator it = shears.fastIterator();
        MultiCurve segmentedLine = geometryManager.createMultiCurve(subType);
        segmentedLine.addCurve(curveToTrim);
        while (it.hasNext()) {
            Geometry enchancedGeometry;
            Feature feature = (Feature)it.next();
            Geometry geometry = feature.getDefaultGeometry();
            Geometry tmpDifference = segmentedLine.difference(geometry);
            if (tmpDifference instanceof MultiCurve) {
                segmentedLine = (MultiCurve)tmpDifference;
                continue;
            }
            if (!(tmpDifference instanceof Curve) || !((enchancedGeometry = this.enhancedDifference(geometry, (Curve)tmpDifference)) instanceof MultiCurve)) continue;
            segmentedLine = (MultiCurve)enchancedGeometry;
        }
        if (segmentedLine.getPrimitivesNumber() == 1) {
            return segmentedLine;
        }
        int index = 0;
        double minDistance = Double.POSITIVE_INFINITY;
        for (int i = 0; i < segmentedLine.getPrimitivesNumber(); ++i) {
            Curve curve = segmentedLine.getCurveAt(i);
            double distance = curve.distance((Geometry)shearingPoint);
            if (!(distance < minDistance)) continue;
            index = i;
            minDistance = distance;
        }
        MultiCurve trimmedCurve = geometryManager.createMultiCurve(subType);
        Curve tmpCurve = null;
        for (int i = 0; i < segmentedLine.getPrimitivesNumber(); ++i) {
            if (i == index) {
                if (tmpCurve == null) continue;
                trimmedCurve.addCurve(tmpCurve);
                tmpCurve = null;
                continue;
            }
            tmpCurve = tmpCurve != null ? this.union(tmpCurve, segmentedLine.getCurveAt(i)) : segmentedLine.getCurveAt(i);
        }
        if (tmpCurve != null) {
            trimmedCurve.addCurve(tmpCurve);
        }
        return trimmedCurve;
    }

    private Curve union(Curve firstCurve, Curve secondCurve) throws CreateGeometryException, LocatorException, GeometryOperationNotSupportedException, GeometryOperationException {
        int subtype2;
        int subtype1 = firstCurve.getGeometryType().getSubType();
        if (subtype1 == (subtype2 = secondCurve.getGeometryType().getSubType())) {
            Line union = GeometryLocator.getGeometryManager().createLine(subtype1);
            for (int i = 0; i < firstCurve.getNumVertices() - 1; ++i) {
                union.addVertex(firstCurve.getVertex(i));
            }
            Point lastVertex = firstCurve.getVertex(firstCurve.getNumVertices() - 2);
            for (int i = 0; i < secondCurve.getNumVertices(); ++i) {
                if (i == 0) {
                    Line tmpLine = GeometryLocator.getGeometryManager().createLine(subtype1);
                    tmpLine.setPoints(lastVertex, secondCurve.getVertex(1));
                    if (TrimLineOperationUtils.intersects((Curve)tmpLine, secondCurve.getVertex(0))) continue;
                }
                union.addVertex(secondCurve.getVertex(i));
            }
            return union;
        }
        return null;
    }

    private Geometry enhancedDifference(Geometry splitter, Curve curve) throws GeometryOperationNotSupportedException, GeometryOperationException {
        Geometry snapTo = curve.snapTo(splitter, 0.1);
        return snapTo.difference(splitter);
    }

    @Override
    public MultiCurve trimLine(Curve curveToTrim, Point shearingPoint, Geometry shears) throws GeometryOperationNotSupportedException, GeometryOperationException, DataException, CreateGeometryException, LocatorException {
        Geometry enchancedGeometry;
        GeometryManager geometryManager = GeometryLocator.getGeometryManager();
        int subType = curveToTrim.getGeometryType().getSubType();
        MultiCurve segmentedLine = geometryManager.createMultiCurve(subType);
        segmentedLine.addCurve(curveToTrim);
        Geometry tmpDifference = segmentedLine.difference(shears);
        if (tmpDifference instanceof MultiCurve) {
            segmentedLine = (MultiCurve)tmpDifference;
        } else if (tmpDifference instanceof Curve && (enchancedGeometry = this.enhancedDifference(shears, (Curve)tmpDifference)) instanceof MultiCurve) {
            segmentedLine = (MultiCurve)enchancedGeometry;
        }
        if (segmentedLine.getPrimitivesNumber() == 1) {
            return segmentedLine;
        }
        double side = TrimLineOperationUtils.getSide(shears, shearingPoint);
        int index = -1;
        if (!Double.isNaN(side)) {
            double minDistance = Double.POSITIVE_INFINITY;
            for (int i = 0; i < segmentedLine.getPrimitivesNumber(); ++i) {
                Double segmentSide;
                Curve curve = segmentedLine.getCurveAt(i);
                double distance = curve.distance((Geometry)shearingPoint);
                if (!(distance < minDistance) || (segmentSide = TrimLineOperationUtils.getSide(shears, curve)) != side) continue;
                index = i;
                minDistance = distance;
            }
        }
        MultiCurve trimmedCurve = geometryManager.createMultiCurve(subType);
        Curve tmpCurve = null;
        for (int i = 0; i < segmentedLine.getPrimitivesNumber(); ++i) {
            if (i == index) {
                if (tmpCurve == null) continue;
                trimmedCurve.addCurve(tmpCurve);
                tmpCurve = null;
                continue;
            }
            tmpCurve = tmpCurve != null ? this.union(tmpCurve, segmentedLine.getCurveAt(i)) : segmentedLine.getCurveAt(i);
        }
        if (tmpCurve != null) {
            trimmedCurve.addCurve(tmpCurve);
        }
        return trimmedCurve;
    }
}

