/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.trimline.operation;

import java.util.HashMap;
import java.util.Map;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Arc;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.tools.locator.LocatorException;
import org.gvsig.vectorediting.lib.prov.trimline.operation.TrimLineOperation;

public class TrimLineOperationUtils {
    public static final String START_SIDE = "start";
    public static final String END_SIDE = "end";
    private static final Map<Integer, TrimLineOperation> operations = new HashMap<Integer, TrimLineOperation>();
    public static final double SNAP_TOLERANCE = 0.1;

    public static void register(TrimLineOperation operation, int geometryType) {
        operations.put(geometryType, operation);
    }

    public static TrimLineOperation getOperation(Primitive geom) {
        Integer type = geom.getGeometryType().getType();
        TrimLineOperation operation = operations.get(type);
        return operation;
    }

    public static Arc createArc(Point center, double radius, Point initPoint, Point endPoint, int subtype) throws CreateGeometryException, LocatorException, GeometryOperationNotSupportedException, GeometryOperationException {
        Arc arc = (Arc)GeometryLocator.getGeometryManager().create(12, subtype);
        double startAngle = GeometryUtils.calculateAngle((Point)center, (Point)initPoint);
        double endAngle = GeometryUtils.calculateAngle((Point)center, (Point)endPoint);
        arc.setPointsStartEnd(center, radius, startAngle, endAngle);
        return arc;
    }

    public static boolean intersects(Curve curve, Point projectedPoint) throws GeometryOperationNotSupportedException, GeometryOperationException {
        double tolerance = 1.0;
        return curve.buffer(tolerance).intersects((Geometry)projectedPoint);
    }

    public static Double getSide(Geometry geometry, Point point) throws GeometryOperationNotSupportedException, GeometryOperationException, CreateGeometryException {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        int subtype = geometry.getGeometryType().getSubType();
        Geometry[] closestPoints = geometry.closestPoints((Geometry)point);
        if (geometry instanceof Line) {
            Line line = (Line)geometry;
            int index = 0;
            Point previousVertex = null;
            for (Point vertex : line) {
                if (index < line.getNumVertices() - 1) {
                    Point nextVertex = line.getVertex(index + 1);
                    Line segment = geomManager.createLine(subtype);
                    segment.addVertex(vertex);
                    segment.addVertex(nextVertex);
                    Geometry p = closestPoints[0];
                    double coef = TrimLineOperationUtils.getSide(vertex, nextVertex, point);
                    if (segment.isWithinDistance(p, 0.1)) {
                        if (vertex.isWithinDistance(p, 0.1) && previousVertex != null) {
                            double previousCoef = TrimLineOperationUtils.getSide(previousVertex, vertex, point);
                            if (previousCoef == coef) {
                                return coef;
                            }
                            return Double.NaN;
                        }
                        if (nextVertex.isWithinDistance(p, 0.1) && index < line.getNumVertices() - 2) {
                            Point nextNextVertex = line.getVertex(index + 2);
                            double nextCoef = TrimLineOperationUtils.getSide(nextVertex, nextNextVertex, point);
                            if (nextCoef == coef) {
                                return coef;
                            }
                            return Double.NaN;
                        }
                        return coef;
                    }
                    previousVertex = vertex;
                }
                ++index;
            }
        } else if (geometry instanceof MultiLine) {
            double minDistance = Double.POSITIVE_INFINITY;
            MultiLine multiline = (MultiLine)geometry;
            Geometry nearestComponent = null;
            for (Geometry component : multiline) {
                double distance = component.distance((Geometry)point);
                if (!(distance < minDistance)) continue;
                nearestComponent = component;
                minDistance = distance;
            }
            if (nearestComponent != null) {
                return TrimLineOperationUtils.getSide(nearestComponent, point);
            }
        }
        return Double.NaN;
    }

    public static double getSide(Point a, Point b, Point c) {
        if (a == null || b == null || c == null || a.equals(b) || a.equals(c) || b.equals(c)) {
            throw new IllegalArgumentException("Points must be different and not null.");
        }
        return Math.signum((b.getX() - a.getX()) * (c.getY() - a.getY()) - (b.getY() - a.getY()) * (c.getX() - a.getX()));
    }

    public static Double getSide(Geometry geometry, Curve curve) throws GeometryOperationNotSupportedException, GeometryOperationException, CreateGeometryException {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        Double segmentSide = Double.NaN;
        if (curve.getNumVertices() == 1) {
            segmentSide = TrimLineOperationUtils.getSide(geometry, curve.getVertex(0));
        }
        if (curve.getNumVertices() == 2) {
            int steps = 100;
            for (int t = 1; t < steps; ++t) {
                double xLen = curve.getVertex(1).getX() - curve.getVertex(0).getX();
                double yLen = curve.getVertex(1).getY() - curve.getVertex(0).getY();
                double diffX = xLen / (double)steps;
                double diffY = yLen / (double)steps;
                Point anyPoint = geomManager.createPoint(curve.getVertex(0).getX() + (double)t * diffX, curve.getVertex(0).getY() + (double)t * diffY, geometry.getGeometryType().getSubType());
                segmentSide = TrimLineOperationUtils.getSide(geometry, anyPoint);
                if (segmentSide.isNaN()) {
                    continue;
                }
                break;
            }
        } else {
            Point anyPoint;
            for (int j = 1; j < curve.getNumVertices() - 1 && (segmentSide = TrimLineOperationUtils.getSide(geometry, anyPoint = curve.getVertex(j))).isNaN(); ++j) {
            }
        }
        return segmentSide;
    }
}

