/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.algorithm;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.OutputObjectsSet;
import es.unex.sextante.core.ParametersSet;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.exceptions.WrongAnalysisExtentException;
import es.unex.sextante.exceptions.WrongInputException;
import es.unex.sextante.gui.algorithm.AnalysisExtentPanel;
import es.unex.sextante.gui.algorithm.GeoAlgorithmParametersPanel;
import es.unex.sextante.gui.algorithm.TridimensionalAnalysisExtentPanel;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.gui.exceptions.LayerCannotBeOverwrittenException;
import es.unex.sextante.gui.exceptions.OverwrittingNotAllowedException;
import es.unex.sextante.gui.exceptions.TooLargeGridExtentException;
import es.unex.sextante.gui.history.DateAndCommand;
import es.unex.sextante.gui.history.History;
import es.unex.sextante.outputs.Output;
import es.unex.sextante.outputs.Output3DRasterLayer;
import es.unex.sextante.outputs.OutputRasterLayer;
import es.unex.sextante.outputs.OutputTable;
import es.unex.sextante.outputs.OutputVectorLayer;
import es.unex.sextante.parameters.Parameter;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class AlgorithmDialog
extends JDialog {
    protected GeoAlgorithm m_Algorithm;
    protected JTabbedPane jTabbedPane1;
    private JPanel jPanelButtons;
    private JPanel jMainPanel;
    protected JButton jButtonCancel;
    protected JButton jButtonOK;
    private int m_iDialogReturn;
    protected GeoAlgorithmParametersPanel jPanelParametersMain = null;
    private AnalysisExtentPanel jAnalysisExtentPanel;
    private JButton jButtonHelp;
    private String[] m_PreviousParameters;
    private String[] m_Extents;
    private JTextField jLabelCommand;
    private JButton jButtonPrevious;
    private JButton jButtonNext;
    private int m_iPreviousCommandIndex;
    private final ArrayList<DateAndCommand> m_sCommand;

    public AlgorithmDialog(GeoAlgorithm algorithm, JDialog parent, GeoAlgorithmParametersPanel panel, ArrayList<DateAndCommand> commands) {
        super(parent, algorithm.getName(), true);
        this.setResizable(true);
        this.m_Algorithm = algorithm;
        this.m_sCommand = commands;
        this.jPanelParametersMain = panel;
        this.jPanelParametersMain.init(this.m_Algorithm);
        this.initGUI();
        this.setLocationRelativeTo(null);
    }

    public AlgorithmDialog(GeoAlgorithm algorithm, GeoAlgorithmParametersPanel panel, ArrayList<DateAndCommand> commands) {
        super(SextanteGUI.getMainFrame(), algorithm.getName(), true);
        this.setResizable(false);
        this.m_sCommand = commands;
        this.m_Algorithm = algorithm;
        this.jPanelParametersMain = panel;
        this.jPanelParametersMain.init(this.m_Algorithm);
        this.initGUI();
        this.setLocationRelativeTo(null);
    }

    private void initGUI() {
        this.jMainPanel = new JPanel();
        this.add(this.jMainPanel);
        TableLayout thisLayout = new TableLayout((double[][])new double[][]{{10.0, -1.0, 10.0}, {1.0, 338.0, 37.0}});
        this.jMainPanel.setLayout((LayoutManager)thisLayout);
        this.setSize(696, 446);
        this.jTabbedPane1 = new JTabbedPane();
        this.jMainPanel.add((Component)this.jTabbedPane1, "1, 1");
        this.jTabbedPane1.addTab(Sextante.getText((String)"Parameters"), null, this.jPanelParametersMain, null);
        if (this.m_Algorithm.getUserCanDefineAnalysisExtent()) {
            this.jTabbedPane1.addTab(Sextante.getText((String)"Raster_output"), null, this.getAnalysisExtentPanel(), null);
        }
        this.jPanelButtons = new JPanel();
        TableLayout jPanelButtonsLayout = new TableLayout((double[][])new double[][]{{5.0, 45.0, 120.0, 120.0, 45.0, -1.0, 90.0, 90.0, 25.0, 15.0}, {-1.0, 25.0, -1.0}});
        jPanelButtonsLayout.setHGap(5);
        jPanelButtonsLayout.setVGap(5);
        this.jPanelButtons.setLayout((LayoutManager)jPanelButtonsLayout);
        this.jMainPanel.add((Component)this.jPanelButtons, "1, 2");
        this.jPanelButtons.setFocusable(false);
        this.jButtonOK = new JButton();
        this.jPanelButtons.add((Component)this.jButtonOK, "6, 1");
        this.jButtonOK.setText(Sextante.getText((String)"OK"));
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlgorithmDialog.this.executeAlgorithm();
            }
        });
        this.jButtonHelp = new JButton();
        this.jPanelButtons.add((Component)this.jButtonHelp, "8, 1");
        this.jButtonHelp.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("images/info.gif")));
        this.jButtonHelp.setPreferredSize(new Dimension(33, 0));
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AlgorithmDialog.this.showHelp();
            }
        });
        this.jButtonCancel = new JButton();
        this.jPanelButtons.add((Component)this.jButtonCancel, "7, 1");
        this.jButtonCancel.setText(Sextante.getText((String)"Cancel"));
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlgorithmDialog.this.m_iDialogReturn = 0;
                AlgorithmDialog.this.dispose();
                AlgorithmDialog.this.setVisible(false);
            }
        });
        this.retrievePreviouslyUsedParametersFromHistory();
        if (this.m_PreviousParameters != null) {
            try {
                this.jButtonPrevious = new JButton();
                this.jPanelButtons.add((Component)this.jButtonPrevious, "1, 1");
                this.jButtonPrevious.setText("<");
                this.jButtonPrevious.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        AlgorithmDialog.this.setPreviousSetOfPreviouslyUsedCommand();
                    }
                });
                this.jButtonNext = new JButton();
                this.jPanelButtons.add((Component)this.jButtonNext, "4, 1");
                this.jButtonNext.setText(">");
                this.jButtonNext.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        AlgorithmDialog.this.setNextSetOfPreviouslyUsedCommand();
                    }
                });
                this.jLabelCommand = new JTextField();
                this.jLabelCommand.setFont(new Font("Monospaced", 0, 10));
                this.jLabelCommand.setEditable(false);
                this.jPanelButtons.add((Component)this.jLabelCommand, "2, 1, 3, 1");
                this.m_iPreviousCommandIndex = this.m_PreviousParameters.length - 1;
                this.setPreviouslyUsedParameters(this.m_iPreviousCommandIndex);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void setPreviouslyUsedParameters(int iIndex) {
        this.jLabelCommand.setText("[" + Integer.toString(iIndex + 1) + "] " + this.m_PreviousParameters[iIndex]);
        String[] args = this.m_PreviousParameters[iIndex].split("\"");
        for (int j = 0; j < 2; ++j) {
            int i;
            ParametersSet ps = this.m_Algorithm.getParameters();
            for (i = 0; i < this.m_Algorithm.getNumberOfParameters(); ++i) {
                Parameter param = ps.getParameter(i);
                String sArg = args[i * 2 + 3];
                this.jPanelParametersMain.setParameterValue(param.getParameterName(), sArg.trim());
            }
            int iOutputIndex = i * 2 + 3;
            OutputObjectsSet ooSet = this.m_Algorithm.getOutputObjects();
            for (i = 0; i < ooSet.getOutputObjectsCount(); ++i) {
                Output out = ooSet.getOutput(i);
                if (!(out instanceof OutputRasterLayer) && !(out instanceof Output3DRasterLayer) && !(out instanceof OutputVectorLayer) && !(out instanceof OutputTable)) continue;
                String sValue = args[iOutputIndex].trim();
                this.jPanelParametersMain.setOutputValue(out.getName(), sValue);
                iOutputIndex += 2;
            }
        }
        if (this.m_Algorithm.getUserCanDefineAnalysisExtent()) {
            String sExtent = this.m_Extents[iIndex];
            if (sExtent != null) {
                sExtent = sExtent.substring(sExtent.indexOf("(") + 1, sExtent.indexOf(")"));
                AnalysisExtent ae = new AnalysisExtent();
                String[] sCoords = sExtent.split(",");
                double dCellSize = Double.parseDouble(sCoords[6]);
                double dCellSizeZ = Double.parseDouble(sCoords[7]);
                ae.setCellSize(dCellSize);
                ae.setCellSizeZ(dCellSizeZ);
                double xMin = Double.parseDouble(sCoords[0]);
                double xMax = Double.parseDouble(sCoords[3]);
                ae.setXRange(xMin, xMax, true);
                double yMin = Double.parseDouble(sCoords[1]);
                double yMax = Double.parseDouble(sCoords[4]);
                ae.setYRange(yMin, yMax, true);
                double zMin = Double.parseDouble(sCoords[2]);
                double zMax = Double.parseDouble(sCoords[5]);
                ae.setZRange(zMin, zMax, true);
                this.getAnalysisExtentPanel().setExtent(ae);
            } else {
                this.getAnalysisExtentPanel().setAutoExtent();
            }
        }
    }

    private void retrievePreviouslyUsedParametersFromHistory() {
        ArrayList<DateAndCommand> dac = this.m_sCommand != null ? this.m_sCommand : History.getHistory();
        ArrayList<String> previousParameters = new ArrayList<String>();
        ArrayList<String> extents = new ArrayList<String>();
        for (int i = 0; i < dac.size(); ++i) {
            String command = dac.get(i).getCommand();
            if (!command.startsWith("runalg(\"" + this.m_Algorithm.getCommandLineName() + "\"")) continue;
            previousParameters.add(command);
            if (!this.m_Algorithm.getUserCanDefineAnalysisExtent() || i == 0) continue;
            command = dac.get(i - 1).getCommand();
            if (command.startsWith("extent")) {
                extents.add(command);
                continue;
            }
            extents.add(null);
        }
        if (previousParameters.size() == 0) {
            this.m_PreviousParameters = null;
            this.m_Extents = null;
        } else {
            this.m_PreviousParameters = previousParameters.toArray(new String[0]);
            this.m_Extents = extents.toArray(new String[0]);
        }
    }

    public void setPreviousSetOfPreviouslyUsedCommand() {
        if (this.m_iPreviousCommandIndex > 0) {
            --this.m_iPreviousCommandIndex;
            this.setPreviouslyUsedParameters(this.m_iPreviousCommandIndex);
        }
    }

    public void setNextSetOfPreviouslyUsedCommand() {
        if (this.m_iPreviousCommandIndex < this.m_PreviousParameters.length - 1) {
            ++this.m_iPreviousCommandIndex;
            this.setPreviouslyUsedParameters(this.m_iPreviousCommandIndex);
        }
    }

    protected void showHelp() {
        SextanteGUI.getGUIFactory().showHelpDialog(this.m_Algorithm);
    }

    protected void executeAlgorithm() {
        try {
            block7: {
                try {
                    this.assignParameters();
                }
                catch (TooLargeGridExtentException e) {
                    int iRet = JOptionPane.showConfirmDialog(null, e.getMessage(), Sextante.getText((String)"Warning"), 0);
                    if (iRet == 0) break block7;
                    this.jTabbedPane1.setSelectedIndex(1);
                    return;
                }
            }
            this.m_iDialogReturn = 1;
            this.dispose();
            this.setVisible(false);
        }
        catch (WrongInputException e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), Sextante.getText((String)"Warning"), 2);
            this.jTabbedPane1.setSelectedIndex(0);
        }
        catch (WrongAnalysisExtentException e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), Sextante.getText((String)"Warning"), 2);
            this.jTabbedPane1.setSelectedIndex(1);
        }
        catch (OverwrittingNotAllowedException e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), Sextante.getText((String)"Warning"), 2);
            this.jTabbedPane1.setSelectedIndex(0);
        }
        catch (LayerCannotBeOverwrittenException e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), Sextante.getText((String)"Warning"), 2);
            this.jTabbedPane1.setSelectedIndex(0);
        }
    }

    protected void assignParameters() throws WrongInputException, OverwrittingNotAllowedException, LayerCannotBeOverwrittenException, WrongAnalysisExtentException, TooLargeGridExtentException {
        this.jPanelParametersMain.assignParameters();
        if (this.m_Algorithm.getUserCanDefineAnalysisExtent()) {
            this.getAnalysisExtentPanel().assignExtent();
        }
    }

    private AnalysisExtentPanel getAnalysisExtentPanel() {
        if (this.jAnalysisExtentPanel == null) {
            this.jAnalysisExtentPanel = this.m_Algorithm.is3D() ? new TridimensionalAnalysisExtentPanel(this.m_Algorithm) : new AnalysisExtentPanel(this.m_Algorithm);
        }
        return this.jAnalysisExtentPanel;
    }

    public int getDialogReturn() {
        return this.m_iDialogReturn;
    }
}

