/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.algorithm;

import es.unex.sextante.additionalInfo.AdditionalInfoBand;
import es.unex.sextante.additionalInfo.AdditionalInfoBoolean;
import es.unex.sextante.additionalInfo.AdditionalInfoFilepath;
import es.unex.sextante.additionalInfo.AdditionalInfoFixedTable;
import es.unex.sextante.additionalInfo.AdditionalInfoMultipleInput;
import es.unex.sextante.additionalInfo.AdditionalInfoNumericalValue;
import es.unex.sextante.additionalInfo.AdditionalInfoRasterLayer;
import es.unex.sextante.additionalInfo.AdditionalInfoSelection;
import es.unex.sextante.additionalInfo.AdditionalInfoString;
import es.unex.sextante.additionalInfo.AdditionalInfoTable;
import es.unex.sextante.additionalInfo.AdditionalInfoTableField;
import es.unex.sextante.additionalInfo.AdditionalInfoTableFilter;
import es.unex.sextante.additionalInfo.AdditionalInfoVectorLayer;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.ObjectAndDescription;
import es.unex.sextante.core.OutputObjectsSet;
import es.unex.sextante.core.ParametersSet;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.I3DRasterLayer;
import es.unex.sextante.dataObjects.IDataObject;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.ITable;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.NullParameterAdditionalInfoException;
import es.unex.sextante.exceptions.WrongInputException;
import es.unex.sextante.exceptions.WrongOutputChannelDataException;
import es.unex.sextante.exceptions.WrongOutputIDException;
import es.unex.sextante.exceptions.WrongParameterIDException;
import es.unex.sextante.gui.algorithm.FieldComboBoxRenderer;
import es.unex.sextante.gui.algorithm.FieldDescriptionComboBox;
import es.unex.sextante.gui.algorithm.FileSelectionPanel;
import es.unex.sextante.gui.algorithm.FixedTablePanel;
import es.unex.sextante.gui.algorithm.GeoAlgorithmParametersPanel;
import es.unex.sextante.gui.algorithm.LayerComboBoxRenderer;
import es.unex.sextante.gui.algorithm.OutputChannelSelectionPanel;
import es.unex.sextante.gui.algorithm.OutputParameterContainer;
import es.unex.sextante.gui.algorithm.ParameterContainer;
import es.unex.sextante.gui.algorithm.PointSelectionPanel;
import es.unex.sextante.gui.algorithm.TableFilterPanel;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.gui.exceptions.LayerCannotBeOverwrittenException;
import es.unex.sextante.gui.grass.GrassAlgorithm;
import es.unex.sextante.gui.help.HelpElement;
import es.unex.sextante.gui.help.HelpIO;
import es.unex.sextante.outputs.IOutputChannel;
import es.unex.sextante.outputs.Output;
import es.unex.sextante.outputs.Output3DRasterLayer;
import es.unex.sextante.outputs.OutputRasterLayer;
import es.unex.sextante.outputs.OutputTable;
import es.unex.sextante.outputs.OutputVectorLayer;
import es.unex.sextante.outputs.OverwriteOutputChannel;
import es.unex.sextante.parameters.FixedTableModel;
import es.unex.sextante.parameters.Parameter;
import es.unex.sextante.parameters.Parameter3DRasterLayer;
import es.unex.sextante.parameters.ParameterBand;
import es.unex.sextante.parameters.ParameterBoolean;
import es.unex.sextante.parameters.ParameterDataObject;
import es.unex.sextante.parameters.ParameterFilepath;
import es.unex.sextante.parameters.ParameterFixedTable;
import es.unex.sextante.parameters.ParameterMultipleInput;
import es.unex.sextante.parameters.ParameterNumericalValue;
import es.unex.sextante.parameters.ParameterPoint;
import es.unex.sextante.parameters.ParameterRasterLayer;
import es.unex.sextante.parameters.ParameterSelection;
import es.unex.sextante.parameters.ParameterString;
import es.unex.sextante.parameters.ParameterTable;
import es.unex.sextante.parameters.ParameterTableField;
import es.unex.sextante.parameters.ParameterTableFilter;
import es.unex.sextante.parameters.ParameterVectorLayer;
import es.unex.sextante.parameters.RasterLayerAndBand;
import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.japura.gui.Anchor;
import org.japura.gui.BatchSelection;
import org.japura.gui.CheckComboBox;
import org.japura.gui.EmbeddedComponent;
import org.japura.gui.model.ListCheckModel;

public class DefaultParametersPanel
extends GeoAlgorithmParametersPanel {
    protected static int CELL_HEIGHT = 18;
    protected static int COLUMN_WIDTH = 250;
    protected int m_iCurrentRow = 0;
    protected JScrollPane jScrollPanelParameters;
    protected JPanel jPanelParameters;
    protected ArrayList m_ParameterContainer = new ArrayList();
    protected ArrayList m_ComboBox = new ArrayList();
    protected GeoAlgorithm m_Algorithm;
    protected ArrayList m_OutputParameterContainer = new ArrayList();
    protected HashMap m_HelpElements;

    @Override
    public void init(GeoAlgorithm alg) {
        this.m_Algorithm = alg;
        try {
            ArrayList list = HelpIO.open(SextanteGUI.getAlgorithmHelpFilename(alg, false));
            this.m_HelpElements = list != null ? HelpIO.createMap(list) : new HashMap();
        }
        catch (Exception e) {
            this.m_HelpElements = new HashMap();
        }
        this.initGUI();
    }

    protected void initGUI() {
        double[][] outputs_matrix;
        double[][] options_matrix;
        this.m_ComboBox = new ArrayList();
        this.jScrollPanelParameters = new JScrollPane();
        this.jPanelParameters = new JPanel();
        int guiRows = 0;
        JPanel jInputs = new JPanel();
        JPanel jOptions = new JPanel();
        JPanel jOutputs = new JPanel();
        double[][] inputs_matrix = this.getInputsTableLayoutMatrix();
        if (inputs_matrix[1].length > 1) {
            TableLayout jInputsLayout = new TableLayout(inputs_matrix);
            jInputsLayout.setHGap(5);
            jInputsLayout.setVGap(5);
            jInputs.setLayout((LayoutManager)jInputsLayout);
            jInputs.setBorder(BorderFactory.createTitledBorder(Sextante.getText((String)"Inputs")));
            this.jPanelParameters.add((Component)jInputs, "North");
            guiRows += inputs_matrix[1].length;
        }
        if ((options_matrix = this.getOptionsTableLayoutMatrix())[1].length > 1) {
            TableLayout jOptionsLayout = new TableLayout(options_matrix);
            jOptionsLayout.setHGap(5);
            jOptionsLayout.setVGap(5);
            jOptions.setLayout((LayoutManager)jOptionsLayout);
            jOptions.setBorder(BorderFactory.createTitledBorder(Sextante.getText((String)"Options")));
            this.jPanelParameters.add((Component)jOptions, "Center");
            guiRows += options_matrix[1].length;
        }
        if ((outputs_matrix = this.getOutputsTableLayoutMatrix())[1].length > 1) {
            TableLayout jOutputsLayout = new TableLayout(this.getOutputsTableLayoutMatrix());
            jOutputsLayout.setHGap(5);
            jOutputsLayout.setVGap(5);
            jOutputs.setLayout((LayoutManager)jOutputsLayout);
            jOutputs.setBorder(BorderFactory.createTitledBorder(Sextante.getText((String)"Outputs")));
            this.jPanelParameters.add((Component)jOutputs, "South");
            guiRows += outputs_matrix[1].length;
        }
        if (this.m_Algorithm.requiresRasterLayers() || this.m_Algorithm.requiresMultipleRasterLayers() || this.m_Algorithm.requiresMultipleRasterBands()) {
            this.addRasterLayers(jInputs);
        }
        if (this.m_Algorithm.requires3DRasterLayers()) {
            this.add3DRasterLayers(jInputs);
        }
        if (this.m_Algorithm.requiresVectorLayers() || this.m_Algorithm.requiresMultipleVectorLayers()) {
            this.addVectorLayers(jInputs);
        }
        if (this.m_Algorithm.requiresTables() || this.m_Algorithm.requiresMultipleTables()) {
            this.addTables(jInputs);
        }
        if (this.m_Algorithm.requiresNonDataObjects()) {
            this.addNonDataObjects(jOptions);
        }
        if (this.m_Algorithm.generatesLayersOrTables()) {
            this.addOutputObjects(jOutputs);
        }
        int gui_height = (int)((double)(CELL_HEIGHT * guiRows) * 1.5);
        this.jPanelParameters.setPreferredSize(new Dimension(660, gui_height));
        this.jScrollPanelParameters.setHorizontalScrollBarPolicy(31);
        this.jScrollPanelParameters.setVerticalScrollBarPolicy(20);
        this.jScrollPanelParameters.setPreferredSize(new Dimension(680, 300));
        this.jScrollPanelParameters.setViewportView(this.jPanelParameters);
        this.add(this.jScrollPanelParameters);
        for (int i = 0; i < this.m_ParameterContainer.size(); ++i) {
            ParameterContainer pc = (ParameterContainer)this.m_ParameterContainer.get(i);
            HelpElement help = (HelpElement)this.m_HelpElements.get(pc.getParameter().getParameterName());
            if (this.m_Algorithm instanceof GrassAlgorithm && pc.getParameter().getParameterTooltip() != null) {
                pc.getContainer().setToolTipText(pc.getParameter().getParameterTooltip());
            }
            if (help == null) continue;
            pc.getContainer().setToolTipText("<html>" + help.getTextAsFormattedHTML() + "</html>");
        }
    }

    protected void addOutputObjects(JPanel pane) {
        OutputObjectsSet ooset = this.m_Algorithm.getOutputObjects();
        this.m_iCurrentRow = 0;
        for (int i = 0; i < ooset.getOutputObjectsCount(); ++i) {
            Output out = ooset.getOutput(i);
            if (!(out instanceof OutputRasterLayer) && !(out instanceof OutputVectorLayer) && !(out instanceof OutputTable) && !(out instanceof Output3DRasterLayer)) continue;
            String sDescription = out.getDescription() + "[" + out.getTypeDescription() + "]";
            this.addTitleLabel(pane, sDescription, this.m_iCurrentRow, false);
            OutputChannelSelectionPanel panel = new OutputChannelSelectionPanel(out, this.m_Algorithm.getParameters());
            HelpElement help = (HelpElement)this.m_HelpElements.get(out.getName());
            if (help != null) {
                panel.setToolTipText("<html>" + help.getTextAsFormattedHTML() + "</html>");
            }
            pane.add((Component)panel, this.getStringTableCoords(2, this.m_iCurrentRow));
            ++this.m_iCurrentRow;
            this.m_OutputParameterContainer.add(new OutputParameterContainer(out.getName(), panel));
        }
    }

    protected void addRasterLayers(JPanel pane) {
        boolean bAddNotSetField = false;
        ArrayList<Integer> childComboBoxIndex = new ArrayList<Integer>();
        ParametersSet parameters = this.m_Algorithm.getParameters();
        this.addTitleLabel(pane, Sextante.getText((String)"Raster_layers"), this.m_iCurrentRow, true);
        ++this.m_iCurrentRow;
        for (int i = 0; i < this.m_Algorithm.getNumberOfParameters(); ++i) {
            Parameter parameter = parameters.getParameter(i);
            if (parameter instanceof ParameterRasterLayer) {
                JComboBox comboBox;
                String sParameterName = parameter.getParameterName();
                childComboBoxIndex.clear();
                for (int j = 0; j < this.m_Algorithm.getNumberOfParameters(); ++j) {
                    Parameter subParameter = parameters.getParameter(j);
                    if (!(subParameter instanceof ParameterBand)) continue;
                    try {
                        if (!((AdditionalInfoBand)subParameter.getParameterAdditionalInfo()).getParentParameterName().equals(sParameterName)) continue;
                        ++this.m_iCurrentRow;
                        this.addTitleLabel(pane, "      " + subParameter.getParameterDescription(), this.m_iCurrentRow, false);
                        comboBox = this.getBandSelectionComboBox();
                        childComboBoxIndex.add(new Integer(this.m_ComboBox.size()));
                        this.m_ComboBox.add(comboBox);
                        pane.add((Component)comboBox, this.getStringTableCoords(2, this.m_iCurrentRow));
                        this.m_ParameterContainer.add(new ParameterContainer(subParameter, comboBox));
                        continue;
                    }
                    catch (NullParameterAdditionalInfoException e) {
                        Sextante.addErrorToLog((Throwable)e);
                    }
                }
                try {
                    if (((AdditionalInfoRasterLayer)parameter.getParameterAdditionalInfo()).getIsMandatory()) {
                        bAddNotSetField = false;
                        this.addTitleLabel(pane, parameter.getParameterDescription(), this.m_iCurrentRow - childComboBoxIndex.size(), false);
                    } else {
                        bAddNotSetField = true;
                        this.addTitleLabel(pane, parameter.getParameterDescription() + Sextante.getText((String)"[optional]"), this.m_iCurrentRow - childComboBoxIndex.size(), false);
                    }
                }
                catch (NullParameterAdditionalInfoException e) {
                    Sextante.addErrorToLog((Throwable)e);
                }
                comboBox = this.getRasterLayerSelectionComboBox(childComboBoxIndex, bAddNotSetField);
                if (bAddNotSetField) {
                    comboBox.setSelectedIndex(0);
                }
                pane.add((Component)comboBox, this.getStringTableCoords(2, this.m_iCurrentRow - childComboBoxIndex.size()));
                ++this.m_iCurrentRow;
                this.m_ParameterContainer.add(new ParameterContainer(parameter, comboBox));
                continue;
            }
            if (!(parameter instanceof ParameterMultipleInput)) continue;
            try {
                AdditionalInfoMultipleInput additionalInfo = (AdditionalInfoMultipleInput)parameter.getParameterAdditionalInfo();
                if (additionalInfo.getDataType() != 1 && additionalInfo.getDataType() != 7) continue;
                this.addMultipleInput(pane, (ParameterMultipleInput)parameter);
                continue;
            }
            catch (NullParameterAdditionalInfoException e) {
                Sextante.addErrorToLog((Throwable)e);
            }
        }
    }

    protected void add3DRasterLayers(JPanel pane) {
        boolean bAddNotSetField = false;
        ParametersSet parameters = this.m_Algorithm.getParameters();
        this.addTitleLabel(pane, Sextante.getText((String)"3DRaster_layers"), this.m_iCurrentRow, true);
        ++this.m_iCurrentRow;
        for (int i = 0; i < this.m_Algorithm.getNumberOfParameters(); ++i) {
            Parameter parameter = parameters.getParameter(i);
            if (!(parameter instanceof Parameter3DRasterLayer)) continue;
            try {
                if (((AdditionalInfoRasterLayer)parameter.getParameterAdditionalInfo()).getIsMandatory()) {
                    bAddNotSetField = false;
                    this.addTitleLabel(pane, parameter.getParameterDescription(), this.m_iCurrentRow, false);
                } else {
                    bAddNotSetField = true;
                    this.addTitleLabel(pane, parameter.getParameterDescription() + Sextante.getText((String)"[optional]"), this.m_iCurrentRow, false);
                }
            }
            catch (NullParameterAdditionalInfoException e) {
                Sextante.addErrorToLog((Throwable)e);
            }
            JComboBox comboBox = this.get3DRasterLayerSelectionComboBox(bAddNotSetField);
            if (bAddNotSetField) {
                comboBox.setSelectedIndex(0);
            }
            pane.add((Component)comboBox, this.getStringTableCoords(2, this.m_iCurrentRow));
            ++this.m_iCurrentRow;
            this.m_ParameterContainer.add(new ParameterContainer(parameter, comboBox));
        }
    }

    protected void addVectorLayers(JPanel pane) {
        boolean bAddNotSetField = false;
        ArrayList<Integer> childComboBoxIndex = new ArrayList<Integer>();
        ParametersSet parameters = this.m_Algorithm.getParameters();
        this.addTitleLabel(pane, Sextante.getText((String)"Vector_layer"), this.m_iCurrentRow, true);
        ++this.m_iCurrentRow;
        for (int i = 0; i < this.m_Algorithm.getNumberOfParameters(); ++i) {
            Parameter parameter = parameters.getParameter(i);
            if (parameter instanceof ParameterVectorLayer) {
                JComboBox comboBox;
                try {
                    int[] shapeTypes = ((AdditionalInfoVectorLayer)parameter.getParameterAdditionalInfo()).getShapeTypes();
                    String sParameterName = parameter.getParameterName();
                    childComboBoxIndex.clear();
                    for (int j = 0; j < this.m_Algorithm.getNumberOfParameters(); ++j) {
                        Parameter subParameter = parameters.getParameter(j);
                        if (subParameter instanceof ParameterTableField) {
                            try {
                                if (!((AdditionalInfoTableField)subParameter.getParameterAdditionalInfo()).getParentParameterName().equals(sParameterName)) continue;
                                ++this.m_iCurrentRow;
                                this.addTitleLabel(pane, "      " + subParameter.getParameterDescription(), this.m_iCurrentRow, false);
                                comboBox = this.getVectorLayerFieldSelectionComboBox(shapeTypes);
                                childComboBoxIndex.add(new Integer(this.m_ComboBox.size()));
                                this.m_ComboBox.add(comboBox);
                                pane.add((Component)comboBox, this.getStringTableCoords(2, this.m_iCurrentRow));
                                this.m_ParameterContainer.add(new ParameterContainer(subParameter, comboBox));
                            }
                            catch (NullParameterAdditionalInfoException e) {
                                Sextante.addErrorToLog((Throwable)e);
                            }
                            continue;
                        }
                        if (!(subParameter instanceof ParameterTableFilter) || !((AdditionalInfoTableFilter)subParameter.getParameterAdditionalInfo()).getParentParameterName().equals(sParameterName)) continue;
                        this.addTableFilter(pane, (ParameterVectorLayer)parameter, (ParameterTableFilter)subParameter, shapeTypes, childComboBoxIndex);
                    }
                }
                catch (NullParameterAdditionalInfoException e1) {
                    e1.printStackTrace();
                }
                try {
                    AdditionalInfoVectorLayer parameterAdditionalInfo = (AdditionalInfoVectorLayer)parameter.getParameterAdditionalInfo();
                    int[] shapeTypes = parameterAdditionalInfo.getShapeTypes();
                    if (((AdditionalInfoVectorLayer)parameter.getParameterAdditionalInfo()).getIsMandatory()) {
                        bAddNotSetField = false;
                        this.addTitleLabel(pane, parameter.getParameterDescription(), this.m_iCurrentRow - childComboBoxIndex.size(), false);
                    } else {
                        bAddNotSetField = true;
                        this.addTitleLabel(pane, parameter.getParameterDescription() + Sextante.getText((String)"[optional]"), this.m_iCurrentRow - childComboBoxIndex.size(), false);
                    }
                    comboBox = this.getVectorLayerSelectionComboBox(shapeTypes, childComboBoxIndex, bAddNotSetField);
                    if (bAddNotSetField) {
                        comboBox.setSelectedIndex(0);
                    }
                    pane.add(comboBox, this.getStringTableCoords(2, this.m_iCurrentRow - childComboBoxIndex.size()));
                    ++this.m_iCurrentRow;
                    this.m_ParameterContainer.add(new ParameterContainer(parameter, comboBox));
                }
                catch (NullParameterAdditionalInfoException e) {
                    Sextante.addErrorToLog((Throwable)e);
                }
                continue;
            }
            if (!(parameter instanceof ParameterMultipleInput)) continue;
            try {
                AdditionalInfoMultipleInput additionalInfo = (AdditionalInfoMultipleInput)parameter.getParameterAdditionalInfo();
                if (additionalInfo.getDataType() != 2 && additionalInfo.getDataType() != 3 && additionalInfo.getDataType() != 4 && additionalInfo.getDataType() != 5) continue;
                this.addMultipleInput(pane, (ParameterMultipleInput)parameter);
                continue;
            }
            catch (NullParameterAdditionalInfoException e) {
                Sextante.addErrorToLog((Throwable)e);
            }
        }
    }

    protected void addTables(JPanel pane) {
        boolean bAddNotSetField = false;
        ArrayList<Integer> childComboBoxIndex = new ArrayList<Integer>();
        ParametersSet parameters = this.m_Algorithm.getParameters();
        this.addTitleLabel(pane, Sextante.getText((String)"Tables"), this.m_iCurrentRow, true);
        ++this.m_iCurrentRow;
        for (int i = 0; i < this.m_Algorithm.getNumberOfParameters(); ++i) {
            Parameter parameter = parameters.getParameter(i);
            if (parameter instanceof ParameterTable) {
                JComboBox comboBox;
                String sParameterName = parameter.getParameterName();
                childComboBoxIndex.clear();
                for (int j = 0; j < this.m_Algorithm.getNumberOfParameters(); ++j) {
                    Parameter subParameter = parameters.getParameter(j);
                    if (subParameter instanceof ParameterTableField) {
                        try {
                            if (!((AdditionalInfoTableField)subParameter.getParameterAdditionalInfo()).getParentParameterName().equals(sParameterName)) continue;
                            ++this.m_iCurrentRow;
                            this.addTitleLabel(pane, "      " + subParameter.getParameterDescription(), this.m_iCurrentRow, false);
                            comboBox = this.getTableFieldSelectionComboBox();
                            childComboBoxIndex.add(new Integer(this.m_ComboBox.size()));
                            this.m_ComboBox.add(comboBox);
                            pane.add((Component)comboBox, this.getStringTableCoords(2, this.m_iCurrentRow));
                            this.m_ParameterContainer.add(new ParameterContainer(subParameter, comboBox));
                        }
                        catch (NullParameterAdditionalInfoException e) {
                            Sextante.addErrorToLog((Throwable)e);
                        }
                        continue;
                    }
                    if (!(subParameter instanceof ParameterTableFilter)) continue;
                    try {
                        if (!((AdditionalInfoTableFilter)subParameter.getParameterAdditionalInfo()).getParentParameterName().equals(sParameterName)) continue;
                        Object shapeTypes = null;
                        this.addTableFilter(pane, (ParameterTable)parameter, (ParameterTableFilter)subParameter, childComboBoxIndex);
                        continue;
                    }
                    catch (NullParameterAdditionalInfoException ex) {
                        Sextante.addErrorToLog((Throwable)ex);
                    }
                }
                try {
                    if (((AdditionalInfoTable)parameter.getParameterAdditionalInfo()).getIsMandatory()) {
                        bAddNotSetField = false;
                        this.addTitleLabel(pane, parameter.getParameterDescription(), this.m_iCurrentRow - childComboBoxIndex.size(), false);
                    } else {
                        bAddNotSetField = true;
                        this.addTitleLabel(pane, parameter.getParameterDescription() + Sextante.getText((String)"[optional]"), this.m_iCurrentRow - childComboBoxIndex.size(), false);
                    }
                }
                catch (NullParameterAdditionalInfoException e) {
                    Sextante.addErrorToLog((Throwable)e);
                }
                comboBox = this.getTableSelectionComboBox(childComboBoxIndex, bAddNotSetField);
                if (bAddNotSetField) {
                    comboBox.setSelectedIndex(comboBox.getItemCount() - 1);
                }
                pane.add((Component)comboBox, this.getStringTableCoords(2, this.m_iCurrentRow - childComboBoxIndex.size()));
                ++this.m_iCurrentRow;
                this.m_ParameterContainer.add(new ParameterContainer(parameter, comboBox));
                continue;
            }
            if (!(parameter instanceof ParameterMultipleInput)) continue;
            try {
                AdditionalInfoMultipleInput additionalInfo = (AdditionalInfoMultipleInput)parameter.getParameterAdditionalInfo();
                if (additionalInfo.getDataType() != 6) continue;
                this.addMultipleInput(pane, (ParameterMultipleInput)parameter);
                continue;
            }
            catch (NullParameterAdditionalInfoException e) {
                Sextante.addErrorToLog((Throwable)e);
            }
        }
    }

    protected void addNonDataObjects(JPanel pane) {
        ParametersSet parameters = this.m_Algorithm.getParameters();
        this.m_iCurrentRow = 0;
        for (int i = 0; i < this.m_Algorithm.getNumberOfParameters(); ++i) {
            Parameter parameter = parameters.getParameter(i);
            if (parameter instanceof ParameterNumericalValue) {
                this.addNumericalTextField(pane, (ParameterNumericalValue)parameter);
                continue;
            }
            if (parameter instanceof ParameterString) {
                this.addStringTextField(pane, (ParameterString)parameter);
                continue;
            }
            if (parameter instanceof ParameterSelection) {
                this.addSelection(pane, (ParameterSelection)parameter);
                continue;
            }
            if (parameter instanceof ParameterFixedTable) {
                this.addFixedTable(pane, (ParameterFixedTable)parameter);
                continue;
            }
            if (parameter instanceof ParameterPoint) {
                this.addPoint(pane, (ParameterPoint)parameter);
                continue;
            }
            if (parameter instanceof ParameterBoolean) {
                this.addCheckBox(pane, (ParameterBoolean)parameter);
                continue;
            }
            if (!(parameter instanceof ParameterFilepath)) continue;
            this.addFilepath(pane, (ParameterFilepath)parameter);
        }
    }

    protected void addMultipleInput(JPanel pane, ParameterMultipleInput parameter) {
        try {
            IRasterLayer[] objs;
            AdditionalInfoMultipleInput additionalInfo = (AdditionalInfoMultipleInput)parameter.getParameterAdditionalInfo();
            switch (additionalInfo.getDataType()) {
                case 1: {
                    objs = SextanteGUI.getInputFactory().getRasterLayers();
                    break;
                }
                case 5: {
                    objs = SextanteGUI.getInputFactory().getVectorLayers(-1);
                    break;
                }
                case 2: {
                    objs = SextanteGUI.getInputFactory().getVectorLayers(0);
                    break;
                }
                case 3: {
                    objs = SextanteGUI.getInputFactory().getVectorLayers(0);
                    break;
                }
                case 4: {
                    objs = SextanteGUI.getInputFactory().getVectorLayers(2);
                    break;
                }
                case 6: {
                    objs = SextanteGUI.getInputFactory().getTables();
                    break;
                }
                case 7: {
                    objs = SextanteGUI.getInputFactory().getBands();
                    break;
                }
                default: {
                    return;
                }
            }
            String sDescription = parameter.getParameterDescription();
            if (!additionalInfo.getIsMandatory()) {
                sDescription = sDescription + Sextante.getText((String)"[optional]");
            }
            this.addTitleLabel(pane, sDescription, this.m_iCurrentRow, false);
            CheckComboBox ccb = new CheckComboBox();
            ccb.setTextFor(CheckComboBox.NONE, Sextante.getText((String)"no_elements_selected"));
            ccb.setTextFor(CheckComboBox.MULTIPLE, Sextante.getText((String)"multiple_elements_selected"));
            ListCheckModel model = ccb.getModel();
            for (IRasterLayer obj : objs) {
                model.addElement(new Object[]{obj});
            }
            BatchSelection.CheckBox bs = new BatchSelection.CheckBox();
            EmbeddedComponent comp = new EmbeddedComponent((JComponent)bs, Anchor.NORTH);
            ccb.setEmbeddedComponent(comp);
            this.addTitleLabel(pane, parameter.getParameterDescription(), this.m_iCurrentRow, false);
            pane.add((Component)ccb, this.getStringTableCoords(2, this.m_iCurrentRow));
            this.m_ParameterContainer.add(new ParameterContainer((Parameter)parameter, (JComponent)ccb));
            ++this.m_iCurrentRow;
        }
        catch (NullParameterAdditionalInfoException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    protected void addFixedTable(JPanel pane, ParameterFixedTable parameter) {
        try {
            AdditionalInfoFixedTable additionalInfo = (AdditionalInfoFixedTable)parameter.getParameterAdditionalInfo();
            int iRows = additionalInfo.getRowsCount();
            String[] sCols = additionalInfo.getCols();
            boolean bIsNumberOfRowsFixed = additionalInfo.isNumberOfRowsFixed();
            this.addTitleLabel(pane, parameter.getParameterDescription(), this.m_iCurrentRow, false);
            FixedTablePanel fixedTablePanel = new FixedTablePanel(sCols, iRows, bIsNumberOfRowsFixed);
            this.addTitleLabel(pane, parameter.getParameterDescription(), this.m_iCurrentRow, false);
            pane.add((Component)fixedTablePanel, this.getStringTableCoords(2, this.m_iCurrentRow));
            this.m_ParameterContainer.add(new ParameterContainer((Parameter)parameter, fixedTablePanel));
            ++this.m_iCurrentRow;
        }
        catch (NullParameterAdditionalInfoException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    protected void addFilepath(JPanel pane, ParameterFilepath parameter) {
        try {
            AdditionalInfoFilepath additionalInfo = (AdditionalInfoFilepath)parameter.getParameterAdditionalInfo();
            this.addTitleLabel(pane, parameter.getParameterDescription(), this.m_iCurrentRow, false);
            String sExtension = "*.*";
            String[] sExtensions = additionalInfo.getExtensions();
            if (sExtensions != null) {
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < sExtensions.length; ++i) {
                    sb.append(sExtensions[i]);
                    if (i >= sExtensions.length - 1) continue;
                    sb.append(",");
                }
                sExtension = sb.toString();
            }
            FileSelectionPanel fileSelectionPanel = new FileSelectionPanel(additionalInfo.isFolder(), additionalInfo.isOpenDialog(), additionalInfo.getExtensions(), Sextante.getText((String)"Files") + " " + sExtension);
            this.addTitleLabel(pane, parameter.getParameterDescription(), this.m_iCurrentRow, false);
            pane.add((Component)fileSelectionPanel, this.getStringTableCoords(2, this.m_iCurrentRow));
            this.m_ParameterContainer.add(new ParameterContainer((Parameter)parameter, fileSelectionPanel));
            ++this.m_iCurrentRow;
        }
        catch (NullParameterAdditionalInfoException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    protected void addTableFilter(JPanel pane, ParameterTable parameter, ParameterTableFilter subParameter, ArrayList childComboBoxIndex) {
        TableFilterPanel tableFilterPanel;
        try {
            AdditionalInfoTable additionalInfo = (AdditionalInfoTable)parameter.getParameterAdditionalInfo();
            ++this.m_iCurrentRow;
            this.addTitleLabel(pane, "      " + subParameter.getParameterDescription(), this.m_iCurrentRow, false);
        }
        catch (NullParameterAdditionalInfoException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        List<ITable> tables = this.getTables();
        if (tables.size() > 0) {
            ITable table = tables.get(0);
            FeatureStore store = table.getFeatureStore();
            tableFilterPanel = new TableFilterPanel(store);
        } else {
            tableFilterPanel = new TableFilterPanel();
        }
        childComboBoxIndex.add(new Integer(this.m_ComboBox.size()));
        pane.add((Component)tableFilterPanel, this.getStringTableCoords(2, this.m_iCurrentRow));
        this.m_ComboBox.add(tableFilterPanel);
        this.m_ParameterContainer.add(new ParameterContainer((Parameter)subParameter, tableFilterPanel));
    }

    protected void addTableFilter(JPanel pane, ParameterVectorLayer parameter, ParameterTableFilter subParameter, int[] shapeTypes, ArrayList childComboBoxIndex) {
        TableFilterPanel tableFilterPanel;
        try {
            AdditionalInfoVectorLayer additionalInfo = (AdditionalInfoVectorLayer)parameter.getParameterAdditionalInfo();
            ++this.m_iCurrentRow;
            this.addTitleLabel(pane, "      " + subParameter.getParameterDescription(), this.m_iCurrentRow, false);
        }
        catch (NullParameterAdditionalInfoException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        List<IVectorLayer> layers = this.getVectorLayers(shapeTypes);
        if (layers.size() > 0) {
            IVectorLayer ivlayer = layers.get(0);
            FeatureStore store = ivlayer.getFeatureStore();
            tableFilterPanel = new TableFilterPanel(store);
        } else {
            tableFilterPanel = new TableFilterPanel();
        }
        childComboBoxIndex.add(new Integer(this.m_ComboBox.size()));
        pane.add((Component)tableFilterPanel, this.getStringTableCoords(2, this.m_iCurrentRow));
        this.m_ComboBox.add(tableFilterPanel);
        this.m_ParameterContainer.add(new ParameterContainer((Parameter)subParameter, tableFilterPanel));
    }

    protected void addPoint(JPanel pane, ParameterPoint parameter) {
        this.addTitleLabel(pane, parameter.getParameterDescription(), this.m_iCurrentRow, false);
        PointSelectionPanel pointSelectionPanel = new PointSelectionPanel();
        this.addTitleLabel(pane, parameter.getParameterDescription(), this.m_iCurrentRow, false);
        pane.add((Component)pointSelectionPanel, this.getStringTableCoords(2, this.m_iCurrentRow));
        this.m_ParameterContainer.add(new ParameterContainer((Parameter)parameter, pointSelectionPanel));
        ++this.m_iCurrentRow;
    }

    protected void addSelection(JPanel pane, ParameterSelection parameter) {
        try {
            JComboBox<String> comboBox = new JComboBox<String>();
            String[] sValues = ((AdditionalInfoSelection)parameter.getParameterAdditionalInfo()).getValues();
            DefaultComboBoxModel<String> defaultModel = new DefaultComboBoxModel<String>(sValues);
            comboBox.setModel(defaultModel);
            comboBox.setSelectedIndex(0);
            this.addTitleLabel(pane, parameter.getParameterDescription(), this.m_iCurrentRow, false);
            pane.add(comboBox, this.getStringTableCoords(2, this.m_iCurrentRow));
            ++this.m_iCurrentRow;
            this.m_ParameterContainer.add(new ParameterContainer((Parameter)parameter, comboBox));
        }
        catch (NullParameterAdditionalInfoException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    protected void addNumericalTextField(JPanel pane, ParameterNumericalValue parameter) {
        JTextField textField = new JTextField();
        try {
            AdditionalInfoNumericalValue additionalInfo = (AdditionalInfoNumericalValue)parameter.getParameterAdditionalInfo();
            final double dMinValue = additionalInfo.getMinValue();
            final double dMaxValue = additionalInfo.getMaxValue();
            final int iType = additionalInfo.getType();
            this.addTitleLabel(pane, parameter.getParameterDescription(), this.m_iCurrentRow, false);
            if (iType == 2) {
                textField.setText(Double.toString(additionalInfo.getDefaultValue()));
            } else {
                textField.setText(Integer.toString((int)additionalInfo.getDefaultValue()));
            }
            textField.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    JTextField textField = (JTextField)e.getSource();
                    String content = textField.getText();
                    if (content.length() != 0) {
                        try {
                            if (iType == 2) {
                                double d = Double.parseDouble(content);
                                if (d > dMaxValue) {
                                    textField.setText(Double.toString(dMaxValue));
                                }
                                if (d < dMinValue) {
                                    textField.setText(Double.toString(dMinValue));
                                }
                            } else {
                                int i = (int)Double.parseDouble(content);
                                if ((double)i > dMaxValue) {
                                    textField.setText(Integer.toString((int)dMaxValue));
                                }
                                if ((double)i < dMinValue) {
                                    textField.setText(Integer.toString((int)dMinValue));
                                }
                                textField.setText(Integer.toString(i));
                            }
                        }
                        catch (NumberFormatException nfe) {
                            DefaultParametersPanel.this.getToolkit().beep();
                            textField.requestFocus();
                        }
                    }
                }
            });
            pane.add((Component)textField, this.getStringTableCoords(2, this.m_iCurrentRow));
            this.m_ParameterContainer.add(new ParameterContainer((Parameter)parameter, textField));
            ++this.m_iCurrentRow;
        }
        catch (NullParameterAdditionalInfoException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    protected void addStringTextField(JPanel pane, ParameterString parameter) {
        try {
            AdditionalInfoString ai = (AdditionalInfoString)parameter.getParameterAdditionalInfo();
            JTextField textField = new JTextField(ai.getDefaultString());
            ToolsSwingLocator.getToolsSwingManager().setDefaultPopupMenu((JTextComponent)textField);
            this.addTitleLabel(pane, parameter.getParameterDescription(), this.m_iCurrentRow, false);
            pane.add((Component)textField, this.getStringTableCoords(2, this.m_iCurrentRow));
            this.m_ParameterContainer.add(new ParameterContainer((Parameter)parameter, textField));
            ++this.m_iCurrentRow;
        }
        catch (NullParameterAdditionalInfoException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    protected void addCheckBox(JPanel pane, ParameterBoolean parameter) {
        JCheckBox checkBox = new JCheckBox();
        try {
            AdditionalInfoBoolean ai = (AdditionalInfoBoolean)parameter.getParameterAdditionalInfo();
            checkBox.setSelected(ai.getDefaultValue());
            this.addTitleLabel(pane, parameter.getParameterDescription(), this.m_iCurrentRow, false);
            pane.add((Component)checkBox, this.getStringTableCoords(2, this.m_iCurrentRow));
            this.m_ParameterContainer.add(new ParameterContainer((Parameter)parameter, checkBox));
            ++this.m_iCurrentRow;
        }
        catch (NullParameterAdditionalInfoException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    protected void addTitleLabel(JPanel pane, String sText, int iRow, boolean isSectionTitleLabel) {
        JLabel label = new JLabel();
        label.setText(sText);
        label.setPreferredSize(new Dimension(COLUMN_WIDTH, CELL_HEIGHT));
        if (isSectionTitleLabel) {
            label.setFont(new Font("Tahoma", 1, 11));
            label.setForeground(Color.BLUE);
        }
        pane.add((Component)label, this.getStringTableCoords(1, iRow));
    }

    protected String getStringTableCoords(int iCol, int iRow) {
        StringBuffer sCellCoords = new StringBuffer();
        sCellCoords.append(Integer.toString(iCol));
        sCellCoords.append(",");
        sCellCoords.append(Integer.toString(iRow));
        return sCellCoords.toString();
    }

    protected double[][] getInputsTableLayoutMatrix() {
        int tf_num;
        int iRows = 1;
        if (this.m_Algorithm.requiresRasterLayers() || this.m_Algorithm.requiresMultipleRasterLayers() || this.m_Algorithm.requiresMultipleRasterBands()) {
            ++iRows;
            iRows += this.m_Algorithm.getNumberOfRasterLayers(true);
            tf_num = this.m_Algorithm.getNumberOfBandsParameters();
            if (tf_num > 0) {
                iRows += tf_num;
            }
        }
        if (this.m_Algorithm.requiresVectorLayers() || this.m_Algorithm.requiresMultipleVectorLayers()) {
            int tfilter_num;
            ++iRows;
            iRows += this.m_Algorithm.getNumberOfVectorLayers(true);
            tf_num = this.m_Algorithm.getNumberOfTableFieldsParameters();
            if (tf_num > 0) {
                iRows += tf_num;
            }
            if ((tfilter_num = this.m_Algorithm.getNumberOfTableFilterParameters()) > 0) {
                iRows += tfilter_num;
            }
        }
        if (this.m_Algorithm.requiresTables() || this.m_Algorithm.requiresMultipleTables()) {
            ++iRows;
            iRows += this.m_Algorithm.getNumberOfTables();
            tf_num = this.m_Algorithm.getNumberOfTableFieldsParameters();
            if (tf_num > 0) {
                iRows += tf_num;
            }
        }
        if (this.m_Algorithm.requires3DRasterLayers()) {
            ++iRows;
            iRows += this.m_Algorithm.getParameters().getNumberOf3DRasterLayers();
        }
        return this.getTableMatrixSize(iRows);
    }

    protected double[][] getOptionsTableLayoutMatrix() {
        int iRows = 1;
        if (this.m_Algorithm.requiresNonDataObjects()) {
            iRows += this.m_Algorithm.getNumberOfNoDataParameters();
        }
        return this.getTableMatrixSize(iRows);
    }

    protected double[][] getOutputsTableLayoutMatrix() {
        int iRows = 0;
        OutputObjectsSet ooSet = this.m_Algorithm.getOutputObjects();
        int iOutput = ooSet.getOutputDataObjectsCount();
        iRows += iOutput;
        if (this.m_Algorithm.generatesLayersOrTables()) {
            ++iRows;
        }
        return this.getTableMatrixSize(iRows);
    }

    protected double[][] getTableMatrixSize(int iRows) {
        double[] iSizeColumns = new double[]{10.0, -1.0, 360.0, 10.0};
        double[] iSizeRows = new double[iRows];
        for (int i = 0; i < iRows - 1; ++i) {
            iSizeRows[i] = CELL_HEIGHT;
        }
        if (iRows > 0) {
            iSizeRows[iRows - 1] = 5.0;
        }
        double[][] iSize = new double[][]{iSizeColumns, iSizeRows};
        return iSize;
    }

    protected JComboBox getRasterLayerSelectionComboBox(ArrayList childComboBoxes, boolean bAddNotSetField) {
        int i;
        final Integer[] childsArray = new Integer[childComboBoxes.size()];
        for (i = 0; i < childsArray.length; ++i) {
            childsArray[i] = (Integer)childComboBoxes.get(i);
        }
        IRasterLayer[] layers = SextanteGUI.getInputFactory().getRasterLayers();
        ObjectAndDescription[] oad = new ObjectAndDescription[layers.length];
        IconTheme tm = ToolsSwingLocator.getIconThemeManager().getCurrent();
        for (i = 0; i < layers.length; ++i) {
            ImageIcon rasterIcon = tm.get("layer-type-raster");
            IRasterLayer layer = layers[i];
            String viewName = layer.getContextName();
            String description = viewName != null ? layer.getName() + " [" + viewName + "]" : layer.getName();
            oad[i] = new ObjectAndDescription(description, (Object)layer, (Icon)rasterIcon);
        }
        final JComboBox<ObjectAndDescription> cb = new JComboBox<ObjectAndDescription>(oad);
        LayerComboBoxRenderer renderer = new LayerComboBoxRenderer();
        cb.setRenderer(renderer);
        if (bAddNotSetField) {
            DefaultComboBoxModel model = (DefaultComboBoxModel)cb.getModel();
            model.insertElementAt(new ObjectAndDescription(Sextante.getText((String)"[Not_selected]"), null), 0);
        }
        cb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                String[] sNames = null;
                for (int i = 0; i < childsArray.length; ++i) {
                    int iIndex = childsArray[i];
                    ObjectAndDescription ob = (ObjectAndDescription)cb.getSelectedItem();
                    IRasterLayer layer = (IRasterLayer)ob.getObject();
                    if (layer == null || (sNames = DefaultParametersPanel.this.getBandNames(layer)) == null) continue;
                    DefaultComboBoxModel<String> defaultModel = new DefaultComboBoxModel<String>(sNames);
                    ((JComboBox)DefaultParametersPanel.this.m_ComboBox.get(iIndex)).setModel(defaultModel);
                }
            }
        });
        return cb;
    }

    protected JComboBox get3DRasterLayerSelectionComboBox(boolean bAddNotSetField) {
        I3DRasterLayer[] layers = SextanteGUI.getInputFactory().get3DRasterLayers();
        ObjectAndDescription[] oad = new ObjectAndDescription[layers.length];
        for (int i = 0; i < layers.length; ++i) {
            oad[i] = new ObjectAndDescription(layers[i].getName(), (Object)layers[i]);
        }
        JComboBox<ObjectAndDescription> cb = new JComboBox<ObjectAndDescription>(oad);
        if (bAddNotSetField) {
            DefaultComboBoxModel model = (DefaultComboBoxModel)cb.getModel();
            model.insertElementAt(new ObjectAndDescription(Sextante.getText((String)"[Not_selected]"), null), 0);
        }
        return cb;
    }

    protected ObjectAndDescription[] getVectorLayersAsObjectAndDescription(int shapeTypes) {
        int[] shapeTypesList = new int[]{shapeTypes};
        return this.getVectorLayersAsObjectAndDescription(shapeTypesList);
    }

    protected ObjectAndDescription[] getVectorLayersAsObjectAndDescription(int[] shapeTypes) {
        List<IVectorLayer> layers = this.getVectorLayers(shapeTypes);
        ObjectAndDescription[] oad = new ObjectAndDescription[layers.size()];
        int i = 0;
        for (IVectorLayer layer : layers) {
            String viewName = layer.getContextName();
            String moreinfo = null;
            if (layer.hasSelection()) {
                moreinfo = " [" + layer.getShapesCount() + " selected]";
            }
            String description = viewName != null && moreinfo == null ? layer.getName() + " [" + viewName + "]" : (viewName != null && moreinfo != null ? layer.getName() + " [" + viewName + "]" + moreinfo : layer.getName());
            IconTheme tm = ToolsSwingLocator.getIconThemeManager().getCurrent();
            ImageIcon layerIcon = null;
            if (layer.hasSelection()) {
                switch (layer.getShapeType()) {
                    case 0: {
                        layerIcon = tm.get("layer-type-point-sel");
                        break;
                    }
                    case 4: {
                        layerIcon = tm.get("layer-type-multipoint-sel");
                        break;
                    }
                    case 1: {
                        layerIcon = tm.get("layer-type-line-sel");
                        break;
                    }
                    case 5: {
                        layerIcon = tm.get("layer-type-multiline-sel");
                        break;
                    }
                    case 2: {
                        layerIcon = tm.get("layer-type-polygon-sel");
                        break;
                    }
                    case 6: {
                        layerIcon = tm.get("layer-type-multipolygon-sel");
                        break;
                    }
                    case 3: {
                        layerIcon = tm.get("layer-type-mix-sel");
                        break;
                    }
                    case -1: {
                        layerIcon = tm.get("layer-type-wrong");
                    }
                }
            } else if (!layer.hasSelection()) {
                switch (layer.getShapeType()) {
                    case 0: {
                        layerIcon = tm.get("layer-type-point");
                        break;
                    }
                    case 4: {
                        layerIcon = tm.get("layer-type-multipoint");
                        break;
                    }
                    case 1: {
                        layerIcon = tm.get("layer-type-line");
                        break;
                    }
                    case 5: {
                        layerIcon = tm.get("layer-type-multiline");
                        break;
                    }
                    case 2: {
                        layerIcon = tm.get("layer-type-polygon");
                        break;
                    }
                    case 6: {
                        layerIcon = tm.get("layer-type-multipolygon");
                        break;
                    }
                    case 3: {
                        layerIcon = tm.get("layer-type-mix");
                        break;
                    }
                    case -1: {
                        layerIcon = tm.get("layer-type-wrong");
                    }
                }
            }
            oad[i] = new ObjectAndDescription(description, (Object)layers.get(i), (Icon)layerIcon);
            ++i;
        }
        return oad;
    }

    protected JComboBox getVectorLayerSelectionComboBox(int iShapeType, ArrayList childComboBoxes, boolean bAddNotSetField) {
        final Integer[] childsArray = new Integer[childComboBoxes.size()];
        for (int i = 0; i < childsArray.length; ++i) {
            childsArray[i] = (Integer)childComboBoxes.get(i);
        }
        ObjectAndDescription[] oad = this.getVectorLayersAsObjectAndDescription(iShapeType);
        final JComboBox<ObjectAndDescription> cb = new JComboBox<ObjectAndDescription>(oad);
        if (bAddNotSetField) {
            DefaultComboBoxModel model = (DefaultComboBoxModel)cb.getModel();
            model.insertElementAt(new ObjectAndDescription(Sextante.getText((String)"[Not_selected]"), null), 0);
        }
        cb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                for (int i = 0; i < childsArray.length; ++i) {
                    FieldDescriptionComboBox[] sNames;
                    int iIndex = childsArray[i];
                    ObjectAndDescription ob = (ObjectAndDescription)cb.getSelectedItem();
                    IVectorLayer layer = (IVectorLayer)ob.getObject();
                    if (layer == null) continue;
                    Object item = DefaultParametersPanel.this.m_ComboBox.get(iIndex);
                    if (item instanceof JComboBox && (sNames = DefaultParametersPanel.this.getVectorLayerFieldRendererComboBox(layer)) != null) {
                        DefaultComboBoxModel<FieldDescriptionComboBox> defaultModel = new DefaultComboBoxModel<FieldDescriptionComboBox>(sNames);
                        JComboBox cmb = (JComboBox)item;
                        cmb.setModel(defaultModel);
                    }
                    if (!(item instanceof TableFilterPanel)) continue;
                    TableFilterPanel pane = (TableFilterPanel)item;
                    pane.setStore(layer.getFeatureStore());
                }
            }
        });
        return cb;
    }

    protected JComboBox<ObjectAndDescription> getVectorLayerSelectionComboBox(int[] shapeTypes, List childComboBoxes, boolean bAddNotSetField) {
        final Integer[] childsArray = new Integer[childComboBoxes.size()];
        for (int i = 0; i < childsArray.length; ++i) {
            childsArray[i] = (Integer)childComboBoxes.get(i);
        }
        ObjectAndDescription[] oad = this.getVectorLayersAsObjectAndDescription(shapeTypes);
        final JComboBox<ObjectAndDescription> cb = new JComboBox<ObjectAndDescription>(oad);
        LayerComboBoxRenderer renderer = new LayerComboBoxRenderer();
        cb.setRenderer(renderer);
        if (bAddNotSetField) {
            DefaultComboBoxModel model = (DefaultComboBoxModel)cb.getModel();
            model.insertElementAt(new ObjectAndDescription(Sextante.getText((String)"[Not_selected]"), null), 0);
        }
        cb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                for (int i = 0; i < childsArray.length; ++i) {
                    FieldDescriptionComboBox[] sNames;
                    int iIndex = childsArray[i];
                    ObjectAndDescription ob = (ObjectAndDescription)cb.getSelectedItem();
                    IVectorLayer layer = (IVectorLayer)ob.getObject();
                    if (layer == null) continue;
                    Object item = DefaultParametersPanel.this.m_ComboBox.get(iIndex);
                    if (item instanceof JComboBox && (sNames = DefaultParametersPanel.this.getVectorLayerFieldRendererComboBox(layer)) != null) {
                        DefaultComboBoxModel<FieldDescriptionComboBox> defaultModel = new DefaultComboBoxModel<FieldDescriptionComboBox>(sNames);
                        JComboBox cmb = (JComboBox)item;
                        cmb.setModel(defaultModel);
                    }
                    if (!(item instanceof TableFilterPanel)) continue;
                    TableFilterPanel pane = (TableFilterPanel)item;
                    pane.setStore(layer.getFeatureStore());
                }
            }
        });
        return cb;
    }

    private List<ITable> getTables() {
        ArrayList<ITable> tables = new ArrayList<ITable>();
        ITable[] allTables = SextanteGUI.getInputFactory().getTables();
        for (int k = 0; k < allTables.length; ++k) {
            tables.add(allTables[k]);
        }
        return tables;
    }

    private List<IVectorLayer> getVectorLayers(int[] shapeTypes) {
        ArrayList<IVectorLayer> layers = new ArrayList<IVectorLayer>();
        for (int j = 0; j < shapeTypes.length; ++j) {
            IVectorLayer[] layersPerType = SextanteGUI.getInputFactory().getVectorLayers(shapeTypes[j]);
            for (int k = 0; k < layersPerType.length; ++k) {
                layers.add(layersPerType[k]);
            }
        }
        return layers;
    }

    protected JComboBox getTableSelectionComboBox(ArrayList childComboBoxes, boolean bAddNotSetField) {
        int i;
        final JComboBox<ObjectAndDescription> comboBox = new JComboBox<ObjectAndDescription>();
        final Integer[] childsArray = new Integer[childComboBoxes.size()];
        for (i = 0; i < childsArray.length; ++i) {
            childsArray[i] = (Integer)childComboBoxes.get(i);
        }
        ITable[] tables = SextanteGUI.getInputFactory().getTables();
        ObjectAndDescription[] oad = new ObjectAndDescription[tables.length];
        for (i = 0; i < tables.length; ++i) {
            oad[i] = new ObjectAndDescription(tables[i].getName(), (Object)tables[i]);
        }
        DefaultComboBoxModel<ObjectAndDescription> defaultModel = new DefaultComboBoxModel<ObjectAndDescription>(oad);
        comboBox.setModel(defaultModel);
        if (bAddNotSetField) {
            defaultModel.insertElementAt(new ObjectAndDescription(Sextante.getText((String)"[Not_selected]"), null), 0);
        }
        comboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                String[] sNames = null;
                for (int i = 0; i < childsArray.length; ++i) {
                    int iIndex = childsArray[i];
                    ObjectAndDescription ob = (ObjectAndDescription)comboBox.getSelectedItem();
                    ITable table = (ITable)ob.getObject();
                    if (table == null) continue;
                    Object item = DefaultParametersPanel.this.m_ComboBox.get(iIndex);
                    if (item instanceof JComboBox && (sNames = DefaultParametersPanel.this.getTableFieldNames(table)) != null) {
                        DefaultComboBoxModel<String> defaultModel = new DefaultComboBoxModel<String>(sNames);
                        ((JComboBox)item).setModel(defaultModel);
                    }
                    if (!(item instanceof TableFilterPanel)) continue;
                    TableFilterPanel pane = (TableFilterPanel)item;
                    pane.setStore(table.getFeatureStore());
                }
            }
        });
        return comboBox;
    }

    protected JComboBox getTableFieldSelectionComboBox() {
        ITable[] tables = SextanteGUI.getInputFactory().getTables();
        if (tables.length > 0) {
            JComboBox<String> comboBox = new JComboBox<String>();
            DefaultComboBoxModel<String> defaultModel = new DefaultComboBoxModel<String>(this.getTableFieldNames(tables[0]));
            comboBox.setModel(defaultModel);
            return comboBox;
        }
        return new JComboBox();
    }

    protected JComboBox getBandSelectionComboBox() {
        IRasterLayer[] layers = SextanteGUI.getInputFactory().getRasterLayers();
        if (layers.length > 0) {
            JComboBox<String> comboBox = new JComboBox<String>();
            DefaultComboBoxModel<String> defaultModel = new DefaultComboBoxModel<String>(this.getBandNames(layers[0]));
            comboBox.setModel(defaultModel);
            return comboBox;
        }
        return new JComboBox();
    }

    protected JComboBox getVectorLayerFieldSelectionComboBox(int iShapeType) {
        IVectorLayer[] layers = SextanteGUI.getInputFactory().getVectorLayers(iShapeType);
        if (layers.length > 0) {
            JComboBox<String> comboBox = new JComboBox<String>();
            DefaultComboBoxModel<String> defaultModel = new DefaultComboBoxModel<String>(this.getVectorLayerFieldNames(layers[0]));
            comboBox.setModel(defaultModel);
            return comboBox;
        }
        return new JComboBox();
    }

    protected FieldDescriptionComboBox[] getVectorLayerFieldRendererComboBox(IVectorLayer layer) {
        FieldDescriptionComboBox[] oad = new FieldDescriptionComboBox[layer.getFieldNames().length];
        for (int i = 0; i < layer.getFieldNames().length; ++i) {
            String fieldName = layer.getFieldName(i);
            Class fieldClass = layer.getFieldType(i);
            oad[i] = new FieldDescriptionComboBox(fieldName, fieldClass);
        }
        return oad;
    }

    protected JComboBox getVectorLayerFieldSelectionComboBox(int[] shapeTypes) {
        List<IVectorLayer> layers = this.getVectorLayers(shapeTypes);
        if (layers.size() > 0) {
            JComboBox<FieldDescriptionComboBox> comboBox = new JComboBox<FieldDescriptionComboBox>();
            IVectorLayer layer = layers.get(0);
            DefaultComboBoxModel<FieldDescriptionComboBox> defaultModel = new DefaultComboBoxModel<FieldDescriptionComboBox>(this.getVectorLayerFieldRendererComboBox(layer));
            FieldComboBoxRenderer renderer = new FieldComboBoxRenderer();
            comboBox.setRenderer(renderer);
            comboBox.setModel(defaultModel);
            return comboBox;
        }
        return new JComboBox();
    }

    protected String[] getTableFieldNames(ITable table) {
        return table.getFieldNames();
    }

    protected String[] getVectorLayerFieldNames(IVectorLayer vectorLayer) {
        return vectorLayer.getFieldNames();
    }

    protected String[] getBandNames(IRasterLayer layer) {
        String[] bands = null;
        int iBands = layer.getBandsCount();
        bands = new String[iBands];
        for (int j = 0; j < iBands; ++j) {
            bands[j] = Integer.toString(j + 1);
        }
        return bands;
    }

    @Override
    public void assignParameters() throws WrongInputException, LayerCannotBeOverwrittenException {
        int i;
        boolean bAssigningOK = true;
        for (i = 0; i < this.m_ParameterContainer.size(); ++i) {
            ParameterContainer parameterContainer = (ParameterContainer)this.m_ParameterContainer.get(i);
            String sType = parameterContainer.getType();
            if (sType.equals("Table")) {
                bAssigningOK = this.assignInputTable(parameterContainer);
            } else if (sType.equals("Vector Layer") || sType.equals("Raster Layer") || sType.equals("3D Raster Layer")) {
                bAssigningOK = this.assignInputLayer(parameterContainer);
            } else if (sType.equals("Numerical Value")) {
                bAssigningOK = this.assignInputNumericalValue(parameterContainer);
            } else if (sType.equals("String")) {
                bAssigningOK = this.assignInputString(parameterContainer);
            } else if (sType.equals("Boolean")) {
                bAssigningOK = this.assignInputBoolean(parameterContainer);
            } else if (sType.equals("Fixed Table")) {
                bAssigningOK = this.assignInputFixedTable(parameterContainer);
            } else if (sType.equals("Multiple Input")) {
                bAssigningOK = this.assignInputMultipleInput(parameterContainer);
            } else if (sType.equals("Point")) {
                bAssigningOK = this.assignInputPoint(parameterContainer);
            } else if (parameterContainer.getType().equals("Filepath")) {
                bAssigningOK = this.assignInputFilepath(parameterContainer);
            } else if (sType.equals("Table Field") || sType.equals("Selection") || sType.equals("Band")) {
                bAssigningOK = this.assignInputSelection(parameterContainer);
            } else if (sType.equals("Table Filter")) {
                bAssigningOK = this.assignInputTableFilter(parameterContainer);
            }
            if (bAssigningOK) continue;
            throw new WrongInputException();
        }
        OutputObjectsSet ooset = this.m_Algorithm.getOutputObjects();
        for (i = 0; i < this.m_OutputParameterContainer.size(); ++i) {
            OverwriteOutputChannel ooc;
            IOutputChannel channel;
            Output out;
            OutputParameterContainer opc = (OutputParameterContainer)this.m_OutputParameterContainer.get(i);
            try {
                out = ooset.getOutput(opc.getName());
            }
            catch (WrongOutputIDException e) {
                throw new WrongInputException();
            }
            OutputChannelSelectionPanel ocsp = (OutputChannelSelectionPanel)opc.getContainer();
            try {
                channel = ocsp.getOutputChannel();
            }
            catch (WrongOutputChannelDataException e) {
                throw new WrongInputException();
            }
            if (channel instanceof OverwriteOutputChannel && !(ooc = (OverwriteOutputChannel)channel).getLayer().canBeEdited()) {
                throw new LayerCannotBeOverwrittenException();
            }
            out.setOutputChannel(channel);
        }
    }

    protected boolean assignInputTable(ParameterContainer parameterContainer) {
        boolean bReturn = true;
        try {
            JComboBox comboBox = (JComboBox)parameterContainer.getContainer();
            Parameter parameter = this.m_Algorithm.getParameters().getParameter(parameterContainer.getName());
            ObjectAndDescription oad = (ObjectAndDescription)comboBox.getSelectedItem();
            bReturn = parameter.setParameterValue(oad.getObject());
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
            return false;
        }
        return bReturn;
    }

    protected boolean assignInputLayer(ParameterContainer parameterContainer) {
        boolean bReturn = true;
        try {
            JComboBox comboBox = (JComboBox)parameterContainer.getContainer();
            Parameter parameter = this.m_Algorithm.getParameters().getParameter(parameterContainer.getName());
            ObjectAndDescription oad = (ObjectAndDescription)comboBox.getSelectedItem();
            bReturn = parameter.setParameterValue(oad.getObject());
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
            return false;
        }
        return bReturn;
    }

    protected boolean assignInputMultipleInput(ParameterContainer parameterContainer) {
        boolean bReturn;
        try {
            CheckComboBox ccb = (CheckComboBox)parameterContainer.getContainer();
            ParameterMultipleInput parameter = (ParameterMultipleInput)this.m_Algorithm.getParameters().getParameter(parameterContainer.getName());
            List list = ccb.getModel().getCheckeds();
            AdditionalInfoMultipleInput ai = (AdditionalInfoMultipleInput)parameter.getParameterAdditionalInfo();
            boolean bMandatory = ai.getIsMandatory();
            if (bMandatory && list.size() == 0) {
                return false;
            }
            bReturn = parameter.setParameterValue((Object)list);
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
            return false;
        }
        return bReturn;
    }

    protected boolean assignInputSelection(ParameterContainer parameterContainer) {
        boolean bReturn = true;
        try {
            JComboBox comboBox = (JComboBox)parameterContainer.getContainer();
            Parameter parameter = this.m_Algorithm.getParameters().getParameter(parameterContainer.getName());
            int iIndex = comboBox.getSelectedIndex();
            bReturn = parameter.setParameterValue((Object)new Integer(iIndex));
            if (parameter instanceof ParameterTableField) {
                parameter.setParameterValue((Object)comboBox.getSelectedItem().toString());
            }
        }
        catch (WrongParameterIDException e) {
            Sextante.addErrorToLog((Throwable)e);
            return false;
        }
        return bReturn;
    }

    protected boolean assignInputNumericalValue(ParameterContainer parameterContainer) {
        boolean bReturn;
        try {
            JTextField txtField = (JTextField)parameterContainer.getContainer();
            Parameter parameter = this.m_Algorithm.getParameters().getParameter(parameterContainer.getName());
            bReturn = parameter.setParameterValue((Object)new Double(Double.parseDouble(txtField.getText())));
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
            return false;
        }
        return bReturn;
    }

    protected boolean assignInputFixedTable(ParameterContainer parameterContainer) {
        boolean bReturn;
        try {
            FixedTablePanel panel = (FixedTablePanel)parameterContainer.getContainer();
            Parameter parameter = this.m_Algorithm.getParameters().getParameter(parameterContainer.getName());
            bReturn = parameter.setParameterValue((Object)panel.getTableModel());
        }
        catch (WrongParameterIDException e) {
            Sextante.addErrorToLog((Throwable)e);
            return false;
        }
        return bReturn;
    }

    protected boolean assignInputString(ParameterContainer parameterContainer) {
        boolean bReturn;
        try {
            JTextField txtField = (JTextField)parameterContainer.getContainer();
            Parameter parameter = this.m_Algorithm.getParameters().getParameter(parameterContainer.getName());
            bReturn = parameter.setParameterValue((Object)txtField.getText());
        }
        catch (WrongParameterIDException e) {
            Sextante.addErrorToLog((Throwable)e);
            return false;
        }
        return bReturn;
    }

    protected boolean assignInputFilepath(ParameterContainer parameterContainer) {
        boolean bReturn;
        try {
            FileSelectionPanel fileSelectionPanel = (FileSelectionPanel)parameterContainer.getContainer();
            Parameter parameter = this.m_Algorithm.getParameters().getParameter(parameterContainer.getName());
            bReturn = parameter.setParameterValue((Object)fileSelectionPanel.getFilepath());
        }
        catch (WrongParameterIDException e) {
            Sextante.addErrorToLog((Throwable)e);
            return false;
        }
        return bReturn;
    }

    protected boolean assignInputTableFilter(ParameterContainer parameterContainer) {
        boolean bReturn;
        try {
            TableFilterPanel fileSelectionPanel = (TableFilterPanel)parameterContainer.getContainer();
            Parameter parameter = this.m_Algorithm.getParameters().getParameter(parameterContainer.getName());
            bReturn = parameter.setParameterValue((Object)fileSelectionPanel.getExpression());
        }
        catch (WrongParameterIDException e) {
            Sextante.addErrorToLog((Throwable)e);
            return false;
        }
        return bReturn;
    }

    protected boolean assignInputPoint(ParameterContainer parameterContainer) {
        boolean bReturn;
        try {
            PointSelectionPanel pointSelectionPanel = (PointSelectionPanel)parameterContainer.getContainer();
            Parameter parameter = this.m_Algorithm.getParameters().getParameter(parameterContainer.getName());
            bReturn = parameter.setParameterValue((Object)pointSelectionPanel.getPoint());
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
            return false;
        }
        return bReturn;
    }

    protected boolean assignInputBoolean(ParameterContainer parameterContainer) {
        boolean bReturn;
        try {
            JCheckBox checkBox = (JCheckBox)parameterContainer.getContainer();
            Parameter parameter = this.m_Algorithm.getParameters().getParameter(parameterContainer.getName());
            bReturn = parameter.setParameterValue((Object)new Boolean(checkBox.isSelected()));
        }
        catch (WrongParameterIDException e) {
            Sextante.addErrorToLog((Throwable)e);
            return false;
        }
        return bReturn;
    }

    @Override
    public void setOutputValue(String sOutputName, String sValue) {
        for (int i = 0; i < this.m_OutputParameterContainer.size(); ++i) {
            OutputParameterContainer container = (OutputParameterContainer)this.m_OutputParameterContainer.get(i);
            if (!sOutputName.equals(container.getName())) continue;
            OutputChannelSelectionPanel ocsp = (OutputChannelSelectionPanel)container.getContainer();
            ocsp.setText(sValue);
        }
    }

    @Override
    public void setParameterValue(String sParameterName, String sValue) {
        block39: {
            Parameter param;
            ParametersSet parameters = this.m_Algorithm.getParameters();
            try {
                param = parameters.getParameter(sParameterName);
            }
            catch (WrongParameterIDException e1) {
                return;
            }
            JComponent container = null;
            for (int i = 0; i < this.m_ParameterContainer.size(); ++i) {
                ParameterContainer pc = (ParameterContainer)this.m_ParameterContainer.get(i);
                if (!pc.getName().equals(sParameterName)) continue;
                container = pc.getContainer();
                break;
            }
            if (container == null) {
                return;
            }
            try {
                if (param instanceof ParameterDataObject) {
                    if (container instanceof JComboBox) {
                        JComboBox cb = (JComboBox)container;
                        ComboBoxModel model = cb.getModel();
                        for (int i = 0; i < model.getSize(); ++i) {
                            ObjectAndDescription oad = (ObjectAndDescription)model.getElementAt(i);
                            if (!oad.getDescription().equals(sValue)) continue;
                            cb.setSelectedIndex(i);
                            break block39;
                        }
                        break block39;
                    }
                    if (container instanceof TableFilterPanel) {
                        TableFilterPanel cb = (TableFilterPanel)container;
                        cb.setPhrase(cb.getPhrase());
                    }
                    break block39;
                }
                if (param instanceof ParameterNumericalValue || param instanceof ParameterString) {
                    if (!sValue.equals("#")) {
                        JTextField tf = (JTextField)container;
                        tf.setText(sValue);
                    }
                } else if (param instanceof ParameterFilepath) {
                    FileSelectionPanel fsp = (FileSelectionPanel)container;
                    fsp.setFilepath(sValue);
                } else if (param instanceof ParameterFixedTable) {
                    this.setFixedTableValue(param, (FixedTablePanel)container, sValue);
                } else if (param instanceof ParameterBoolean) {
                    if (!sValue.equals("#")) {
                        JCheckBox cb = (JCheckBox)container;
                        boolean bValue = sValue.equals("true");
                        cb.setSelected(bValue);
                    }
                } else if (param instanceof ParameterSelection) {
                    if (!sValue.equals("#")) {
                        int iIndex = Integer.parseInt(sValue);
                        AdditionalInfoSelection ai = (AdditionalInfoSelection)param.getParameterAdditionalInfo();
                        if (iIndex >= 0 && iIndex < ai.getValues().length) {
                            JComboBox cb = (JComboBox)container;
                            cb.setSelectedIndex(iIndex);
                        }
                    }
                } else if (param instanceof ParameterMultipleInput) {
                    int j;
                    ArrayList selectedIndices = new ArrayList();
                    String[] sObjects = sValue.split(",");
                    CheckComboBox ccb = (CheckComboBox)container;
                    Object[] objs = new Object[ccb.getModel().getSize()];
                    for (j = 0; j < objs.length; ++j) {
                        objs[j] = ccb.getModel().getElementAt(j);
                    }
                    block12: for (j = 0; j < objs.length; ++j) {
                        for (int i = 0; i < sObjects.length; ++i) {
                            if (objs[j] instanceof IDataObject) {
                                IDataObject ido = (IDataObject)objs[j];
                                if (!ido.getName().equals(sObjects[i].trim())) continue;
                                ccb.getModel().addCheck(new Object[]{objs[j]});
                                continue block12;
                            }
                            if (!(objs[j] instanceof RasterLayerAndBand)) continue;
                            try {
                                RasterLayerAndBand rlab = (RasterLayerAndBand)objs[j];
                                if (!rlab.getRasterLayer().getName().equals(sObjects[i].trim()) || Integer.parseInt(sObjects[i + 1].trim()) - 1 != rlab.getBand()) continue;
                                ccb.getModel().addCheck(new Object[]{objs[j]});
                                continue block12;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                } else if (param instanceof ParameterPoint) {
                    StringTokenizer st = new StringTokenizer(sValue, ",");
                    if (st.countTokens() == 2) {
                        double x = Double.parseDouble(st.nextToken());
                        double y = Double.parseDouble(st.nextToken());
                        PointSelectionPanel psp = (PointSelectionPanel)container;
                        psp.setPoint(new Point2D.Double(x, y));
                    }
                } else if (param instanceof ParameterTableField || param instanceof ParameterBand) {
                    JComboBox cb = (JComboBox)container;
                    try {
                        cb.setSelectedIndex(Integer.parseInt(sValue));
                    }
                    catch (Exception exception) {
                    }
                }
            }
            catch (NullParameterAdditionalInfoException e) {
                Sextante.addErrorToLog((Throwable)e);
            }
            catch (NumberFormatException e) {
                Sextante.addErrorToLog((Throwable)e);
            }
        }
    }

    protected void setFixedTableValue(Parameter param, FixedTablePanel container, String sValue) {
        int iToken = 0;
        StringTokenizer st = new StringTokenizer(sValue, ",");
        try {
            AdditionalInfoFixedTable ai = (AdditionalInfoFixedTable)param.getParameterAdditionalInfo();
            int iCols = ai.getColsCount();
            int iTokens = st.countTokens();
            int iRows = st.countTokens() / iCols;
            boolean bIsNumberOfRowsFixed = ai.isNumberOfRowsFixed();
            FixedTableModel tableModel = new FixedTableModel(ai.getCols(), iRows, bIsNumberOfRowsFixed);
            if (bIsNumberOfRowsFixed ? iRows != ai.getRowsCount() : st.countTokens() % iCols != 0) {
                return;
            }
            while (st.hasMoreTokens()) {
                int iRow = (int)Math.floor((double)iToken / (double)iCols);
                int iCol = iToken % iCols;
                String sToken = st.nextToken().trim();
                tableModel.setValueAt((Object)sToken, iRow, iCol);
                ++iToken;
            }
            container.setTableModel(tableModel);
        }
        catch (NullParameterAdditionalInfoException nullParameterAdditionalInfoException) {
            // empty catch block
        }
    }
}

