/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.algorithm;

import es.unex.sextante.core.ParametersSet;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.WrongOutputChannelDataException;
import es.unex.sextante.gui.algorithm.OutputChannelSelectionDialog;
import es.unex.sextante.outputs.DatabaseOutputChannel;
import es.unex.sextante.outputs.FileOutputChannel;
import es.unex.sextante.outputs.IOutputChannel;
import es.unex.sextante.outputs.NullOutputChannel;
import es.unex.sextante.outputs.Output;
import es.unex.sextante.outputs.OutputVectorLayer;
import es.unex.sextante.outputs.OverwriteOutputChannel;
import es.unex.sextante.parameters.Parameter;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jsh.shell.Utils;

public class OutputChannelSelectionPanel
extends JPanel {
    private JTextField textField;
    private JButton button;
    private final Output m_Output;
    private final ParametersSet m_ParametersSet;

    public OutputChannelSelectionPanel(Output out, ParametersSet paramSet) {
        this.m_Output = out;
        this.m_ParametersSet = paramSet;
        this.initGUI();
    }

    private void initGUI() {
        this.button = new JButton("...");
        this.textField = new JTextField(Sextante.getText((String)"[Save_to_temporary_file]"));
        this.textField.setMaximumSize(new Dimension(340, 18));
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OutputChannelSelectionPanel.this.showDialog();
            }
        });
        TableLayout thisLayout = new TableLayout((double[][])new double[][]{{-1.0, 25.0}, {-1.0}});
        this.setLayout((LayoutManager)thisLayout);
        this.add((Component)this.textField, "0,  0");
        this.add((Component)this.button, "1,  0");
    }

    public IOutputChannel getOutputChannel() throws WrongOutputChannelDataException {
        String s = this.textField.getText();
        if (s.equals(Sextante.getText((String)"[Save_to_temporary_file]")) || s.trim().equals("")) {
            return new FileOutputChannel(Utils.constructPath(null));
        }
        if (s.equals(Sextante.getText((String)"[Overwrite]"))) {
            try {
                Parameter param = this.m_ParametersSet.getParameter(((OutputVectorLayer)this.m_Output).getInputLayerToOverwrite());
                IVectorLayer layer = param.getParameterValueAsVectorLayer();
                return new OverwriteOutputChannel(layer);
            }
            catch (Exception e) {
                throw new WrongOutputChannelDataException();
            }
        }
        if (s.equals(Sextante.getText((String)"[Do_not_create_output]"))) {
            return new NullOutputChannel();
        }
        IOutputChannel channel = DatabaseOutputChannel.getFromString((String)s);
        if (channel == null) {
            channel = new FileOutputChannel(Utils.constructPath(s));
        }
        return channel;
    }

    private void showDialog() {
        OutputChannelSelectionDialog dialog = new OutputChannelSelectionDialog(this.m_Output);
        dialog.pack();
        dialog.setVisible(true);
        String ret = dialog.getOutputChannelString();
        if (ret != null) {
            this.textField.setText(ret);
        }
    }

    @Override
    public void setToolTipText(String sText) {
        this.textField.setToolTipText(sText);
    }

    public void setText(String sValue) {
        if (sValue.equals("#")) {
            this.textField.setText(Sextante.getText((String)"[Save_to_temporary_file]"));
        } else if (sValue.equals("$")) {
            this.textField.setText(Sextante.getText((String)"[Overwrite]"));
        } else if (sValue.equals("!")) {
            this.textField.setText(Sextante.getText((String)"[Do_not_create_output]"));
        } else {
            String sNewValue = sValue.replace("\\\\", "\\");
            while (!sNewValue.equals(sValue)) {
                sValue = sNewValue;
                sNewValue = sValue.replace("\\\\", "\\");
            }
            this.textField.setText(sNewValue);
        }
    }
}

