/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.algorithm;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.I3DRasterLayer;
import es.unex.sextante.dataObjects.ILayer;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.WrongAnalysisExtentException;
import es.unex.sextante.gui.algorithm.AnalysisExtentPanel;
import es.unex.sextante.gui.exceptions.TooLargeGridExtentException;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class TridimensionalAnalysisExtentPanel
extends AnalysisExtentPanel {
    private JTextField jTextFieldZMin;
    private JTextField jTextFieldZMax;
    private JLabel jLabelRangeZ;
    private JLabel jLabelCellSizeZ;
    private JLabel jLabelColsZ;
    private JTextField jTextFieldColsZ;
    private JTextField jTextFieldCellSizeZ;

    public TridimensionalAnalysisExtentPanel(GeoAlgorithm algorithm) {
        super(algorithm);
    }

    @Override
    public void assignExtent() throws TooLargeGridExtentException, WrongAnalysisExtentException {
        this.m_Algorithm.setAnalysisExtent((AnalysisExtent)null);
        if (this.getJRadioButtonAdjustToInputDataExtent().isSelected()) {
            if (!this.m_Algorithm.adjustOutputExtent()) {
                throw new WrongAnalysisExtentException(Sextante.getText((String)"Wrong_or_missing_region"));
            }
            return;
        }
        AnalysisExtent outputExtent = new AnalysisExtent();
        try {
            outputExtent.setCellSize(Double.parseDouble(this.jTextFieldCellSize.getText()));
            outputExtent.setCellSizeZ(Double.parseDouble(this.jTextFieldCellSizeZ.getText()));
            outputExtent.setXRange(Double.parseDouble(this.jTextFieldXMin.getText()), Double.parseDouble(this.jTextFieldXMax.getText()), true);
            outputExtent.setYRange(Double.parseDouble(this.jTextFieldYMin.getText()), Double.parseDouble(this.jTextFieldYMax.getText()), true);
            outputExtent.setZRange(Double.parseDouble(this.jTextFieldZMin.getText()), Double.parseDouble(this.jTextFieldZMax.getText()), true);
            this.m_Algorithm.setAnalysisExtent(outputExtent);
        }
        catch (NumberFormatException e) {
            throw new WrongAnalysisExtentException(Sextante.getText((String)"Wrong_or_missing_raster_extent_definition"));
        }
        int numCells = outputExtent.getNX() * outputExtent.getNY();
    }

    @Override
    protected JPanel getJPanelAnalysisExtentValues() {
        if (this.jPanelAnalysisExtentValues == null) {
            this.jPanelAnalysisExtentValues = new JPanel();
            TableLayout jPanelRasterExtentValuesLayout = new TableLayout((double[][])new double[][]{{255.0, -1.0, -1.0}, {-3.0, -3.0, -3.0, -3.0, -3.0, -3.0, -3.0}});
            jPanelRasterExtentValuesLayout.setHGap(5);
            jPanelRasterExtentValuesLayout.setVGap(5);
            this.jPanelAnalysisExtentValues.setLayout((LayoutManager)jPanelRasterExtentValuesLayout);
            this.jPanelAnalysisExtentValues.setBorder(BorderFactory.createTitledBorder(Sextante.getText((String)"Extent__values")));
            this.jPanelAnalysisExtentValues.setPreferredSize(new Dimension(660, 145));
            this.jPanelAnalysisExtentValues.add((Component)this.getJLabelRangeX(), "0, 0");
            this.jPanelAnalysisExtentValues.add((Component)this.getJTextFieldXMin(), "1, 0");
            this.jPanelAnalysisExtentValues.add((Component)this.getJTextFieldXMax(), "2, 0");
            this.jPanelAnalysisExtentValues.add((Component)this.getJLabelRangeY(), "0, 1");
            this.jPanelAnalysisExtentValues.add((Component)this.getJTextFieldYMin(), "1, 1");
            this.jPanelAnalysisExtentValues.add((Component)this.getJTextFieldYMax(), "2, 1");
            this.jPanelAnalysisExtentValues.add((Component)this.getJLabelCellSize(), "0, 2");
            this.jPanelAnalysisExtentValues.add((Component)this.getJTextFieldCellSize(), "1, 2");
            this.jPanelAnalysisExtentValues.add((Component)this.getJLabelRowsCols(), "0, 3");
            this.jPanelAnalysisExtentValues.add((Component)this.getJTextFieldRows(), "1, 3");
            this.jPanelAnalysisExtentValues.add((Component)this.getJTextFieldCols(), "2, 3");
            this.jPanelAnalysisExtentValues.add((Component)this.getJLabelRangeZ(), "0, 4");
            this.jPanelAnalysisExtentValues.add((Component)this.getJTextFieldZMin(), "1, 4");
            this.jPanelAnalysisExtentValues.add((Component)this.getJTextFieldZMax(), "2, 4");
            this.jPanelAnalysisExtentValues.add((Component)this.getJLabelCellSizeZ(), "0, 5");
            this.jPanelAnalysisExtentValues.add((Component)this.getJTextFieldCellSizeZ(), "1, 5");
            this.jPanelAnalysisExtentValues.add((Component)this.getJLabelColsZ(), "0, 6");
            this.jPanelAnalysisExtentValues.add((Component)this.getJTextFieldColsZ(), "1, 6");
        }
        return this.jPanelAnalysisExtentValues;
    }

    protected JTextField getJTextFieldZMin() {
        if (this.jTextFieldZMin == null) {
            this.jTextFieldZMin = this.getNewJTextFieldZ();
        }
        return this.jTextFieldZMin;
    }

    protected JTextField getJTextFieldZMax() {
        if (this.jTextFieldZMax == null) {
            this.jTextFieldZMax = this.getNewJTextFieldZ();
        }
        return this.jTextFieldZMax;
    }

    private JTextField getNewJTextFieldZ() {
        JTextField jTextField = new JTextField();
        jTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                JTextField textField = (JTextField)e.getSource();
                String content = textField.getText();
                if (content.length() != 0) {
                    try {
                        double d = Double.parseDouble(content);
                        TridimensionalAnalysisExtentPanel.this.extentZHasChanged();
                    }
                    catch (NumberFormatException nfe) {
                        TridimensionalAnalysisExtentPanel.this.getToolkit().beep();
                        textField.requestFocus();
                    }
                }
            }
        });
        jTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent event) {
                TridimensionalAnalysisExtentPanel.this.validateKeyTypingZ(event);
            }
        });
        return jTextField;
    }

    protected JLabel getJLabelRangeZ() {
        if (this.jLabelRangeZ == null) {
            this.jLabelRangeZ = new JLabel();
            this.jLabelRangeZ.setText(Sextante.getText((String)"Range_Z"));
        }
        return this.jLabelRangeZ;
    }

    protected JLabel getJLabelCellSizeZ() {
        if (this.jLabelCellSizeZ == null) {
            this.jLabelCellSizeZ = new JLabel();
            this.jLabelCellSizeZ.setText(Sextante.getText((String)"Cell_sizeZ"));
        }
        return this.jLabelCellSizeZ;
    }

    protected JTextField getJTextFieldCellSizeZ() {
        if (this.jTextFieldCellSizeZ == null) {
            this.jTextFieldCellSizeZ = new JTextField();
            this.jTextFieldCellSizeZ.setText("1");
            this.jTextFieldCellSizeZ.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    JTextField textField = (JTextField)e.getSource();
                    String content = textField.getText();
                    if (content.length() != 0) {
                        try {
                            double d = Double.parseDouble(content);
                            if (d <= 0.0) {
                                throw new NumberFormatException();
                            }
                            TridimensionalAnalysisExtentPanel.this.extentZHasChanged();
                        }
                        catch (NumberFormatException nfe) {
                            TridimensionalAnalysisExtentPanel.this.getToolkit().beep();
                            textField.requestFocus();
                        }
                    }
                }
            });
            this.jTextFieldCellSizeZ.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent event) {
                    TridimensionalAnalysisExtentPanel.this.validateKeyTypingZ(event);
                }
            });
        }
        return this.jTextFieldCellSizeZ;
    }

    private void validateKeyTypingZ(KeyEvent event) {
        String text = ((JTextField)event.getSource()).getText();
        switch (event.getKeyChar()) {
            case '\n': {
                this.extentZHasChanged();
                break;
            }
            default: {
                text = text + event.getKeyChar();
            }
        }
    }

    protected JLabel getJLabelColsZ() {
        if (this.jLabelColsZ == null) {
            this.jLabelColsZ = new JLabel();
            this.jLabelColsZ.setText(Sextante.getText((String)"Number_of_cols_z"));
        }
        return this.jLabelColsZ;
    }

    protected JTextField getJTextFieldColsZ() {
        if (this.jTextFieldColsZ == null) {
            this.jTextFieldColsZ = new JTextField();
            this.jTextFieldColsZ.setEnabled(false);
        }
        return this.jTextFieldColsZ;
    }

    @Override
    protected void setTextFieldsEnabled(boolean bEnabled) {
        this.getJPanelAnalysisExtentValues().setVisible(true);
        this.getJTextFieldXMin().setEnabled(bEnabled);
        this.getJTextFieldXMax().setEnabled(bEnabled);
        this.getJTextFieldYMin().setEnabled(bEnabled);
        this.getJTextFieldYMax().setEnabled(bEnabled);
    }

    @Override
    protected JComboBox getJComboBoxLayers() {
        if (this.jComboBoxLayers == null) {
            DefaultComboBoxModel<ILayer> jComboBoxLayersModel = new DefaultComboBoxModel<ILayer>(this.m_Layers);
            this.jComboBoxLayers = new JComboBox();
            this.jComboBoxLayers.setModel(jComboBoxLayersModel);
            this.jComboBoxLayers.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (TridimensionalAnalysisExtentPanel.this.getJRadioButtonExtentFromLayer().isSelected()) {
                        try {
                            ILayer layer = (ILayer)TridimensionalAnalysisExtentPanel.this.jComboBoxLayers.getSelectedItem();
                            double dCoord = layer.getFullExtent().getMinX();
                            TridimensionalAnalysisExtentPanel.this.getJTextFieldXMin().setText(new Double(dCoord).toString());
                            dCoord = layer.getFullExtent().getMaxX();
                            TridimensionalAnalysisExtentPanel.this.getJTextFieldXMax().setText(new Double(dCoord).toString());
                            dCoord = layer.getFullExtent().getMinY();
                            TridimensionalAnalysisExtentPanel.this.getJTextFieldYMin().setText(new Double(dCoord).toString());
                            dCoord = layer.getFullExtent().getMaxY();
                            TridimensionalAnalysisExtentPanel.this.getJTextFieldYMax().setText(new Double(dCoord).toString());
                            if (layer instanceof IRasterLayer) {
                                TridimensionalAnalysisExtentPanel.this.getJTextFieldCellSize().setText(new Double(((IRasterLayer)layer).getLayerCellSize()).toString());
                            } else if (layer instanceof I3DRasterLayer) {
                                I3DRasterLayer raster3d = (I3DRasterLayer)layer;
                                TridimensionalAnalysisExtentPanel.this.getJTextFieldCellSizeZ().setText(new Double(raster3d.getCellSizeZ()).toString());
                                dCoord = raster3d.getLayerExtent().getZMin();
                                TridimensionalAnalysisExtentPanel.this.getJTextFieldZMin().setText(new Double(dCoord).toString());
                                dCoord = raster3d.getLayerExtent().getZMax();
                                TridimensionalAnalysisExtentPanel.this.getJTextFieldZMax().setText(new Double(dCoord).toString());
                                TridimensionalAnalysisExtentPanel.this.extentZHasChanged();
                            }
                            TridimensionalAnalysisExtentPanel.this.extentHasChanged();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
        }
        return this.jComboBoxLayers;
    }

    private void extentZHasChanged() {
        try {
            double dRange = Math.abs(Double.parseDouble(this.getJTextFieldZMax().getText()) - Double.parseDouble(this.getJTextFieldZMin().getText()));
            double dCellSize = Double.parseDouble(this.getJTextFieldCellSizeZ().getText());
            int iCols = (int)Math.floor(dRange / dCellSize);
            this.getJTextFieldColsZ().setText(Integer.toString(iCols));
        }
        catch (NumberFormatException e) {
            return;
        }
    }

    @Override
    public void setExtent(AnalysisExtent ge) {
        this.getJRadioButtonUserDefinedExtent().setSelected(true);
        this.setTextFieldsEnabled(true);
        this.getJTextFieldCellSize().setText(Double.toString(ge.getCellSize()));
        this.getJTextFieldXMin().setText(Double.toString(ge.getXMin()));
        this.getJTextFieldXMax().setText(Double.toString(ge.getXMax()));
        this.getJTextFieldYMin().setText(Double.toString(ge.getYMin()));
        this.getJTextFieldYMax().setText(Double.toString(ge.getYMax()));
        this.extentHasChanged();
        this.getJTextFieldCellSizeZ().setText(Double.toString(ge.getCellSizeZ()));
        this.getJTextFieldZMin().setText(Double.toString(ge.getZMin()));
        this.getJTextFieldZMax().setText(Double.toString(ge.getZMax()));
        this.extentZHasChanged();
    }
}

