/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.algorithm.iterative;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import es.unex.sextante.dataObjects.AbstractVectorLayer;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.gui.algorithm.iterative.SingleFeatureIterator;
import es.unex.sextante.outputs.IOutputChannel;
import java.awt.geom.Rectangle2D;
import org.gvsig.tools.exception.BaseException;

public class SingleFeatureVectorLayer
extends AbstractVectorLayer {
    private String m_sName;
    private Object[] m_Record;
    private Geometry m_Geometry;
    private final String[] m_sFields;
    private final Object m_CRS;
    private IVectorLayer m_OriginalLayer;
    private final int m_iShapeType;
    private int m_ID;

    public SingleFeatureVectorLayer(IVectorLayer layer) {
        this.m_sFields = layer.getFieldNames();
        this.m_CRS = layer.getCRS();
        this.m_OriginalLayer = layer;
        this.m_sName = layer.getName();
        this.m_iShapeType = layer.getShapeType();
    }

    public void setFeature(Geometry geometry, Object[] record) {
        this.m_Geometry = geometry;
        this.m_Record = record;
    }

    public void addFeature(Geometry geometry, Object[] attributes) {
    }

    public int getFieldCount() {
        return this.m_Record.length;
    }

    public String getFieldName(int iIndex) {
        return this.m_sFields[iIndex];
    }

    public Class getFieldType(int iIndex) {
        return this.m_Record[iIndex].getClass();
    }

    public int getShapeType() {
        return this.m_iShapeType;
    }

    public IFeatureIterator iterator() {
        return new SingleFeatureIterator(this.m_Geometry, this.m_Record);
    }

    public Object getCRS() {
        return this.m_CRS;
    }

    public Rectangle2D getFullExtent() {
        Envelope env = this.m_Geometry.getEnvelopeInternal();
        return new Rectangle2D.Double(env.getMinX(), env.getMinY(), env.getWidth(), env.getHeight());
    }

    public void close() {
    }

    public IOutputChannel getOutputChannel() {
        return null;
    }

    public String getName() {
        return this.m_sName;
    }

    public void open() {
    }

    public void postProcess() throws Exception {
    }

    public void setName(String sName) {
        this.m_sName = sName;
    }

    public void setID(int ID) {
        this.m_ID = ID;
    }

    public int getID() {
        return this.m_ID;
    }

    public IVectorLayer getOriginalLayer() {
        return this.m_OriginalLayer;
    }

    public void addFilter(IVectorLayerFilter filter) {
    }

    public void removeFilters() {
    }

    public Object getBaseDataObject() {
        return null;
    }

    public void free() {
        this.m_OriginalLayer = null;
    }

    public boolean canBeEdited() {
        return false;
    }

    public int getSubType() throws BaseException {
        return this.m_OriginalLayer.getSubType();
    }

    public String getContextName() {
        return null;
    }

    public boolean hasSelection() {
        return false;
    }
}

