/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.batch;

import es.unex.sextante.additionalInfo.AdditionalInfoDataObject;
import es.unex.sextante.additionalInfo.AdditionalInfoFixedTable;
import es.unex.sextante.additionalInfo.AdditionalInfoMultipleInput;
import es.unex.sextante.additionalInfo.AdditionalInfoNumericalValue;
import es.unex.sextante.additionalInfo.AdditionalInfoSelection;
import es.unex.sextante.outputs.Output;
import es.unex.sextante.parameters.ParameterDataObject;
import es.unex.sextante.parameters.ParameterFixedTable;
import es.unex.sextante.parameters.ParameterMultipleInput;
import es.unex.sextante.parameters.ParameterNumericalValue;
import es.unex.sextante.parameters.ParameterPoint;
import es.unex.sextante.parameters.ParameterSelection;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.util.StringTokenizer;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class ParameterCellPanelRenderer
extends DefaultTableCellRenderer {
    private final Object m_Object;
    private String m_sValue;

    public ParameterCellPanelRenderer(Object obj) {
        this.m_Object = obj;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int colIndex) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, rowIndex, colIndex);
        this.m_sValue = (String)table.getModel().getValueAt(rowIndex, colIndex);
        this.setText(this.m_sValue);
        if (this.isValueOK()) {
            this.setForeground(Color.BLACK);
        } else {
            this.setForeground(Color.RED);
        }
        return this;
    }

    public boolean isValueOK() {
        if (this.m_Object instanceof ParameterPoint) {
            return this.isPointOK();
        }
        if (this.m_Object instanceof ParameterDataObject) {
            return this.isDataObjectOK();
        }
        if (this.m_Object instanceof ParameterFixedTable) {
            return this.isFixedTableOK();
        }
        if (this.m_Object instanceof ParameterSelection) {
            return this.isSelectionOK();
        }
        if (this.m_Object instanceof ParameterNumericalValue) {
            return this.isNumericalValueOK();
        }
        if (this.m_Object instanceof ParameterMultipleInput) {
            return this.isMultipleInputOK();
        }
        if (this.m_Object instanceof Output) {
            return this.isOutputOK();
        }
        return true;
    }

    private boolean isOutputOK() {
        return !this.m_sValue.trim().equals("");
    }

    private boolean isMultipleInputOK() {
        AdditionalInfoMultipleInput ai;
        int iCount = 0;
        boolean bLastTokenIsFile = false;
        ParameterMultipleInput parameter = (ParameterMultipleInput)this.m_Object;
        try {
            ai = (AdditionalInfoMultipleInput)parameter.getParameterAdditionalInfo();
            String[] sTokens = this.m_sValue.split(",");
            if (ai.getDataType() == 7) {
                for (String element : sTokens) {
                    if (this.isPositiveInteger(element)) {
                        if (!bLastTokenIsFile) {
                            return false;
                        }
                        bLastTokenIsFile = false;
                        ++iCount;
                        continue;
                    }
                    File f = new File(element.trim());
                    if (!f.exists()) {
                        return false;
                    }
                    if (bLastTokenIsFile) {
                        return false;
                    }
                    bLastTokenIsFile = true;
                }
            } else {
                for (String element : sTokens) {
                    File f = new File(element.trim());
                    if (!f.exists()) {
                        return false;
                    }
                    ++iCount;
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return (!ai.getIsMandatory() || iCount > 0) && !bLastTokenIsFile;
    }

    private boolean isPositiveInteger(String s) {
        try {
            int i = Integer.parseInt(s);
            return i > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isFixedTableOK() {
        StringTokenizer st = new StringTokenizer(this.m_sValue, ",");
        ParameterFixedTable parameter = (ParameterFixedTable)this.m_Object;
        try {
            AdditionalInfoFixedTable ai = (AdditionalInfoFixedTable)parameter.getParameterAdditionalInfo();
            int iCols = ai.getColsCount();
            int iRows = ai.getRowsCount();
            boolean bIsNumberOfRowsFixed = ai.isNumberOfRowsFixed();
            if (bIsNumberOfRowsFixed ? st.countTokens() != iCols * iRows : st.countTokens() % iCols != 0) {
                return false;
            }
            while (st.hasMoreTokens()) {
                Double.parseDouble(st.nextToken().trim());
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isDataObjectOK() {
        ParameterDataObject parameter = (ParameterDataObject)this.m_Object;
        try {
            AdditionalInfoDataObject ai = (AdditionalInfoDataObject)parameter.getParameterAdditionalInfo();
            if (this.m_sValue.trim().equals("")) {
                return !ai.getIsMandatory();
            }
            File f = new File(this.m_sValue);
            return f.exists();
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isSelectionOK() {
        try {
            String[] sValues;
            ParameterSelection parameter = (ParameterSelection)this.m_Object;
            AdditionalInfoSelection ai = (AdditionalInfoSelection)parameter.getParameterAdditionalInfo();
            for (String element : sValues = ai.getValues()) {
                if (!this.m_sValue.equals(element)) continue;
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    private boolean isNumericalValueOK() {
        try {
            ParameterNumericalValue parameter = (ParameterNumericalValue)this.m_Object;
            AdditionalInfoNumericalValue ai = (AdditionalInfoNumericalValue)parameter.getParameterAdditionalInfo();
            double dMin = ai.getMinValue();
            double dMax = ai.getMaxValue();
            double dVal = Double.parseDouble(this.m_sValue);
            return !(dVal < dMin) && !(dMax < dVal);
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isPointOK() {
        String[] s = this.m_sValue.split(",");
        if (s.length != 2) {
            return false;
        }
        try {
            Double.parseDouble(s[0]);
            Double.parseDouble(s[1]);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }
}

