/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.cmd;

import es.unex.sextante.core.Sextante;
import es.unex.sextante.gui.algorithm.GenericFileFilter;
import es.unex.sextante.gui.cmd.ScriptAlgorithmProvider;
import es.unex.sextante.gui.core.SextanteGUI;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ScriptEditingPanel
extends JPanel {
    private String m_sFilename;
    private JButton jButtonOpen;
    private JTextArea jScriptTextArea;
    private JScrollPane jScrollPaneTextArea;
    private JButton jButtonSave;

    public ScriptEditingPanel() {
        this.initGUI();
    }

    public ScriptEditingPanel(String sScriptFilename) {
        this.m_sFilename = sScriptFilename;
        this.initGUI();
        this.openFromFile(new File(sScriptFilename));
    }

    private void initGUI() {
        TableLayout layout = new TableLayout((double[][])new double[][]{{-1.0, 70.0, 5.0, 70.0, 5.0}, {-1.0, 5.0, 25.0, 5.0}});
        layout.setHGap(5);
        layout.setVGap(5);
        this.setLayout((LayoutManager)layout);
        this.setPreferredSize(new Dimension(600, 500));
        this.setSize(new Dimension(600, 500));
        this.jScriptTextArea = new JTextArea();
        this.jScriptTextArea.setEditable(true);
        this.jScriptTextArea.setLineWrap(false);
        this.jScrollPaneTextArea = new JScrollPane(this.jScriptTextArea, 20, 30);
        this.add((Component)this.jScrollPaneTextArea, "0,0,4,0");
        this.jScriptTextArea.setBorder(BorderFactory.createBevelBorder(1));
        this.jButtonOpen = new JButton(Sextante.getText((String)"Open"));
        this.add((Component)this.jButtonOpen, "1, 2");
        this.jButtonOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptEditingPanel.this.open();
            }
        });
        this.jButtonSave = new JButton(Sextante.getText((String)"Save"));
        this.add((Component)this.jButtonSave, "3, 2");
        this.jButtonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptEditingPanel.this.save();
            }
        });
    }

    protected void save() {
        JFileChooser fc = new JFileChooser();
        GenericFileFilter filter = new GenericFileFilter("bsh", Sextante.getText((String)"BeanShell_script"));
        fc.setFileFilter(filter);
        if (this.m_sFilename != null) {
            File file = null;
            file = this.m_sFilename.endsWith(".bsh") ? new File(this.m_sFilename) : new File(this.m_sFilename + ".bsh");
            fc.setSelectedFile(file);
        } else {
            String sFolder = SextanteGUI.getSettingParameterValue("ScriptsFolder");
            fc.setCurrentDirectory(new File(sFolder));
        }
        int returnVal = fc.showSaveDialog(this);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            this.m_sFilename = file.getAbsolutePath();
            if (!this.m_sFilename.endsWith(".bsh")) {
                this.m_sFilename = this.m_sFilename + ".bsh";
            }
            this.saveToFile();
            SextanteGUI.updateAlgorithmProvider(ScriptAlgorithmProvider.class);
            SextanteGUI.getGUIFactory().updateToolbox();
        }
    }

    private void saveToFile() {
        Writer output = null;
        try {
            output = new BufferedWriter(new FileWriter(this.m_sFilename));
            output.write(this.jScriptTextArea.getText());
        }
        catch (IOException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    Sextante.addErrorToLog((Throwable)e);
                }
            }
        }
    }

    protected void open() {
        JFileChooser fc = new JFileChooser();
        String sFolder = SextanteGUI.getSettingParameterValue("ScriptsFolder");
        fc.setFileFilter(new GenericFileFilter("bsh", Sextante.getText((String)"BeanShell_script")));
        fc.setCurrentDirectory(new File(sFolder));
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            this.openFromFile(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openFromFile(File file) {
        BufferedReader input = null;
        try {
            input = new BufferedReader(new FileReader(file));
            StringBuffer sText = new StringBuffer();
            String sLine = null;
            while ((sLine = input.readLine()) != null) {
                sText.append(sLine + "\n");
            }
            this.jScriptTextArea.setText(sText.toString());
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException e) {
                Sextante.addErrorToLog((Throwable)e);
            }
        }
    }
}

