/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.core;

import es.unex.sextante.gui.core.IDataRenderer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;

public abstract class DefaultDataRenderer
implements IDataRenderer {
    private HashMap<String, HashMap<String, Object>> m_Map = new HashMap();
    private final String m_sFilename;

    public DefaultDataRenderer(String sFile) {
        this.m_sFilename = sFile;
    }

    @Override
    public Object getRenderingForLayer(String sAlgCmdName, String sOutputLayer) {
        HashMap<String, Object> algRenderer = this.m_Map.get(sAlgCmdName);
        if (algRenderer != null) {
            return algRenderer.get(sOutputLayer);
        }
        return null;
    }

    @Override
    public void open() {
        try {
            if (!new File(this.m_sFilename).exists()) {
                return;
            }
            FileInputStream fis = new FileInputStream(this.m_sFilename);
            ObjectInputStream ois = new ObjectInputStream(fis);
            this.m_Map = (HashMap)ois.readObject();
            ois.close();
            fis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void save() {
        try {
            FileOutputStream fileOut = new FileOutputStream(this.m_sFilename);
            ObjectOutputStream out = new ObjectOutputStream(fileOut);
            out.writeObject(this.m_Map);
            out.close();
            fileOut.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setRenderingForAlgorithm(String algCmdName, HashMap<String, Object> renderingData) {
        this.m_Map.put(algCmdName, renderingData);
    }
}

