/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.core;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IDataObject;
import es.unex.sextante.gui.additionalResults.AdditionalResultsDialog;
import es.unex.sextante.gui.algorithm.DefaultParametersPanel;
import es.unex.sextante.gui.algorithm.GeoAlgorithmParametersPanel;
import es.unex.sextante.gui.batch.BatchProcessDialog;
import es.unex.sextante.gui.cmd.BSHDialog;
import es.unex.sextante.gui.core.GenericDialog;
import es.unex.sextante.gui.core.GenericInfoDialog;
import es.unex.sextante.gui.core.IGUIFactory;
import es.unex.sextante.gui.core.NameAndIcon;
import es.unex.sextante.gui.core.NamedPoint;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.gui.core.ToolboxAction;
import es.unex.sextante.gui.dataExplorer.DataExplorerDialog;
import es.unex.sextante.gui.exceptions.WrongViewNameException;
import es.unex.sextante.gui.help.HelpEditionDialog;
import es.unex.sextante.gui.help.HelpIO;
import es.unex.sextante.gui.help.SextanteHelpWindow;
import es.unex.sextante.gui.history.DateAndCommand;
import es.unex.sextante.gui.history.HistoryDialog;
import es.unex.sextante.gui.history.HistoryPanel;
import es.unex.sextante.gui.modeler.AlgorithmDialog;
import es.unex.sextante.gui.modeler.DefaultModelerParametersPanel;
import es.unex.sextante.gui.modeler.GeoAlgorithmModelerParametersPanel;
import es.unex.sextante.gui.modeler.ModelAlgorithm;
import es.unex.sextante.gui.modeler.ModelerDialog;
import es.unex.sextante.gui.settings.SextanteConfigurationDialog;
import es.unex.sextante.gui.toolbox.ToolboxDialog;
import es.unex.sextante.gui.toolbox.ToolboxPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.tuple.Pair;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.temporarystorage.TemporaryStorageGroup;
import org.gvsig.temporarystorage.TemporaryStorageLocator;
import org.gvsig.temporarystorage.TemporaryStorageManager;

public class DefaultGUIFactory
implements IGUIFactory {
    protected static ToolboxPanel m_Toolbox;
    protected static HistoryPanel m_History;
    private final ArrayList<NamedPoint> m_Coordinates = new ArrayList();

    @Override
    public void showToolBoxDialog() {
        SextanteGUI.getInputFactory().createDataObjects();
        ToolboxDialog toolbox = new ToolboxDialog(SextanteGUI.getMainFrame());
        m_Toolbox = toolbox.getToolboxPanel();
        toolbox.pack();
        toolbox.setVisible(true);
        SextanteGUI.getInputFactory().clearDataObjects();
        m_Toolbox = null;
    }

    @Override
    public int showAlgorithmDialog(GeoAlgorithm alg, JDialog parent, ArrayList<DateAndCommand> commands) {
        GeoAlgorithmParametersPanel paramPanel = null;
        Class paramPanelClass = SextanteGUI.getParametersPanel(alg.getCommandLineName());
        if (paramPanelClass == null) {
            paramPanelClass = this.getDefaultParametersPanel();
        }
        try {
            paramPanel = (GeoAlgorithmParametersPanel)paramPanelClass.newInstance();
        }
        catch (Exception e) {
            try {
                paramPanel = (GeoAlgorithmParametersPanel)this.getDefaultParametersPanel().newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Object[] objs = SextanteGUI.getInputFactory().getDataObjects();
        if (alg.meetsDataRequirements(objs)) {
            es.unex.sextante.gui.algorithm.AlgorithmDialog dialog = parent != null ? new es.unex.sextante.gui.algorithm.AlgorithmDialog(alg, parent, paramPanel, commands) : new es.unex.sextante.gui.algorithm.AlgorithmDialog(alg, paramPanel, commands);
            dialog.pack();
            dialog.setVisible(true);
            return dialog.getDialogReturn();
        }
        return 0;
    }

    @Override
    public int showAlgorithmDialogForModeler(GeoAlgorithm algorithm, String sName, String sDescription, ModelAlgorithm modelAlgorithm, HashMap dataObjects, JDialog parent) {
        GeoAlgorithmModelerParametersPanel paramPanel = null;
        Class paramPanelClass = SextanteGUI.getModelerParametersPanel(algorithm.getCommandLineName());
        if (paramPanelClass == null) {
            paramPanelClass = this.getDefaultModelerParametersPanel();
        }
        try {
            paramPanel = (GeoAlgorithmModelerParametersPanel)paramPanelClass.newInstance();
        }
        catch (Exception e) {
            try {
                paramPanel = (GeoAlgorithmModelerParametersPanel)this.getDefaultModelerParametersPanel().newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            AlgorithmDialog dialog = parent != null ? new AlgorithmDialog(algorithm.getNewInstance(), sName, sDescription, modelAlgorithm, paramPanel, dataObjects, parent) : new AlgorithmDialog(algorithm.getNewInstance(), sName, sDescription, modelAlgorithm, paramPanel, dataObjects);
            dialog.pack();
            dialog.setVisible(true);
            return dialog.getDialogReturn();
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public void showSettingsDialog(ToolboxPanel panel, JDialog parent) {
        SextanteConfigurationDialog dialog = parent != null ? new SextanteConfigurationDialog(panel, parent) : new SextanteConfigurationDialog(panel);
        dialog.pack();
        dialog.setVisible(true);
    }

    @Override
    public void showModelerDialog() {
        ModelerDialog dialog = new ModelerDialog(SextanteGUI.getMainFrame());
        dialog.pack();
        dialog.setVisible(true);
    }

    @Override
    public void showModelerDialog(ModelAlgorithm alg) {
        ModelerDialog dialog = new ModelerDialog(SextanteGUI.getMainFrame());
        dialog.getModelerPanel().checkChangesAndOpenModel(alg.getFilename());
        dialog.pack();
        dialog.setVisible(true);
    }

    @Override
    public void showHelpEditionDialog(GeoAlgorithm alg) {
        HelpEditionDialog dialog = new HelpEditionDialog(alg, SextanteGUI.getMainFrame());
        dialog.pack();
        dialog.setVisible(true);
    }

    @Override
    public void showHelpDialog(GeoAlgorithm algorithm) {
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setEditable(false);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setPreferredSize(new Dimension(800, 600));
        scrollPane.setSize(new Dimension(800, 600));
        scrollPane.setMaximumSize(new Dimension(800, 600));
        scrollPane.setViewportView(jEditorPane);
        scrollPane.setHorizontalScrollBarPolicy(32);
        jEditorPane.setBorder(BorderFactory.createEtchedBorder(1));
        jEditorPane.setContentType("text/html");
        Object help = SextanteGUI.getAlgorithmHelp(algorithm);
        if (help instanceof String) {
            jEditorPane.setText((String)help);
        } else if (help instanceof URL) {
            try {
                jEditorPane.setPage((URL)help);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        jEditorPane.setCaretPosition(0);
        SextanteGUI.getGUIFactory().showGenericInfoDialog(scrollPane, Sextante.getText((String)"Help"));
    }

    @Override
    public void showHelpDialog(String sTopic) {
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setEditable(false);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setPreferredSize(new Dimension(800, 600));
        scrollPane.setViewportView(jEditorPane);
        scrollPane.setHorizontalScrollBarPolicy(32);
        jEditorPane.setBorder(BorderFactory.createEtchedBorder(1));
        jEditorPane.setContentType("text/html");
        try {
            String sFilepath = HelpIO.getHelpFile(sTopic);
            URL url = new URL("file:///" + sFilepath);
            jEditorPane.setPage(url);
        }
        catch (Exception exception) {
            // empty catch block
        }
        jEditorPane.setCaretPosition(0);
        SextanteGUI.getGUIFactory().showGenericInfoDialog(scrollPane, Sextante.getText((String)"Help"));
    }

    @Override
    public void showAdditionalResultsDialog(final ArrayList components) {
        if (components.size() != 0) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    AdditionalResultsDialog dialog = new AdditionalResultsDialog(components, SextanteGUI.getMainFrame());
                    dialog.pack();
                    dialog.setVisible(true);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void showHistoryDialog() {
        SextanteGUI.getInputFactory().createDataObjects();
        HistoryDialog dialog = new HistoryDialog(SextanteGUI.getMainFrame());
        SextanteGUI.setLastCommandOrigin(0);
        SextanteGUI.setLastCommandOriginParentDialog(dialog);
        m_History = dialog.getHistoryPanel();
        dialog.pack();
        dialog.setVisible(true);
        SextanteGUI.getInputFactory().clearDataObjects();
        m_History = null;
    }

    @Override
    public void showCommandLineDialog() {
        SextanteGUI.getInputFactory().createDataObjects();
        BSHDialog dialog = new BSHDialog(SextanteGUI.getMainFrame());
        SextanteGUI.setLastCommandOrigin(1);
        SextanteGUI.setLastCommandOriginParentDialog(dialog);
        dialog.pack();
        dialog.setVisible(true);
        SextanteGUI.getInputFactory().clearDataObjects();
    }

    @Override
    public void showGenericInfoDialog(Component component, String text) {
        GenericInfoDialog dialog = new GenericInfoDialog(component, text, SextanteGUI.getMainFrame());
        dialog.setVisible(true);
    }

    @Override
    public void showBatchProcessingDialog(GeoAlgorithm alg, JDialog parent) {
        BatchProcessDialog dialog = parent != null ? new BatchProcessDialog(alg, parent) : new BatchProcessDialog(alg);
        dialog.pack();
        dialog.setVisible(true);
    }

    @Override
    public void showBatchProcessingFromGISDialog(GeoAlgorithm alg, JDialog parent) {
        es.unex.sextante.gui.batch.nonFileBased.BatchProcessDialog dialog = parent != null ? new es.unex.sextante.gui.batch.nonFileBased.BatchProcessDialog(alg, parent) : new es.unex.sextante.gui.batch.nonFileBased.BatchProcessDialog(alg);
        dialog.pack();
        dialog.setVisible(true);
    }

    @Override
    public void updateToolbox() {
        if (m_Toolbox != null) {
            m_Toolbox.fillTreesWithAllAlgorithms();
        }
    }

    @Override
    public void updateHistory() {
        if (m_History != null) {
            m_History.updateContent();
        }
    }

    @Override
    public List<NamedPoint> getCoordinatesList() {
        ArrayList<NamedPoint> coordsList = new ArrayList<NamedPoint>();
        try {
            TemporaryStorageManager manager = TemporaryStorageLocator.getTemporaryStorageManager();
            TemporaryStorageGroup points = manager.get("Points");
            for (Pair pair : points.asList()) {
                String key = (String)pair.getKey();
                Point value = (Point)pair.getValue();
                double xx = value.getX();
                double yy = value.getY();
                Point2D.Double pp = new Point2D.Double(xx, yy);
                NamedPoint np = new NamedPoint(key, pp);
                coordsList.add(np);
            }
        }
        catch (Exception ex) {
            Sextante.addErrorToLog((String)"Not able to load 'Points' from temporary storage coordinates tool");
        }
        return Collections.unmodifiableList(coordsList);
    }

    @Override
    public void showDataExplorer() {
        SextanteGUI.getInputFactory().createDataObjects();
        DataExplorerDialog dialog = new DataExplorerDialog(SextanteGUI.getMainFrame());
        dialog.pack();
        dialog.setVisible(true);
        if (m_Toolbox == null) {
            SextanteGUI.getInputFactory().clearDataObjects();
        }
    }

    public Class getDefaultModelerParametersPanel() {
        return DefaultModelerParametersPanel.class;
    }

    @Override
    public Class getDefaultParametersPanel() {
        return DefaultParametersPanel.class;
    }

    @Override
    public void showHelpWindow() {
        SextanteHelpWindow window = new SextanteHelpWindow();
        window.setExtendedState(window.getExtendedState() | 6);
        window.pack();
        window.setVisible(true);
    }

    @Override
    public void addToView(IDataObject obj, String viewName) throws WrongViewNameException {
    }

    @Override
    public HashMap<NameAndIcon, ArrayList<ToolboxAction>> getToolboxActions() {
        return new HashMap<NameAndIcon, ArrayList<ToolboxAction>>();
    }

    @Override
    public void showGenericDialog(String name, Component component) {
        GenericDialog dialog = new GenericDialog(component, name, SextanteGUI.getMainFrame());
        dialog.pack();
        dialog.setVisible(true);
    }
}

