/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.core;

import es.unex.sextante.core.ITaskMonitor;
import es.unex.sextante.gui.core.ProgressMonitor;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public class DefaultTaskMonitor
implements ITaskMonitor {
    private ProgressMonitor m_ProgressMonitor;

    public DefaultTaskMonitor(final String sText, final boolean bDeterminate, final JDialog parent) {
        try {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (parent != null) {
                        DefaultTaskMonitor.this.m_ProgressMonitor = new ProgressMonitor(sText, bDeterminate, parent);
                    } else {
                        DefaultTaskMonitor.this.m_ProgressMonitor = new ProgressMonitor(sText, bDeterminate);
                    }
                    DefaultTaskMonitor.this.m_ProgressMonitor.pack();
                    DefaultTaskMonitor.this.m_ProgressMonitor.setVisible(true);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeAndWait(runnable);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isCanceled() {
        if (this.m_ProgressMonitor != null) {
            return this.m_ProgressMonitor.isCanceled();
        }
        return true;
    }

    public void setProgress(int iStep) {
        if (this.m_ProgressMonitor != null) {
            this.m_ProgressMonitor.setProgress(iStep);
        }
    }

    public void setProgressText(String sText) {
        if (this.m_ProgressMonitor != null) {
            this.m_ProgressMonitor.setProgressText(sText);
        }
    }

    public void close() {
        if (this.m_ProgressMonitor != null) {
            this.m_ProgressMonitor.dispose();
            this.m_ProgressMonitor.setVisible(false);
        }
    }

    public void setProgress(int iStep, int iTotalNumberOfSteps) {
        if (this.m_ProgressMonitor != null && iTotalNumberOfSteps != 0) {
            double dPercent = (double)iStep / (double)iTotalNumberOfSteps;
            dPercent = Math.min(Math.max(0.0, dPercent), 1.0);
            int iCurrentStep = Math.min((int)(dPercent * 100.0), 100);
            this.m_ProgressMonitor.setProgress(iCurrentStep);
        }
    }

    public void setDeterminate(boolean bDeterminate) {
        if (this.m_ProgressMonitor != null) {
            this.m_ProgressMonitor.setDeterminate(bDeterminate);
        }
    }

    public void setProcessDescription(String sDescription) {
        if (this.m_ProgressMonitor != null) {
            this.m_ProgressMonitor.setDescription(sDescription);
        }
    }

    public void setDescriptionPrefix(String sPrefix) {
        if (this.m_ProgressMonitor != null) {
            this.m_ProgressMonitor.setDescriptionPrefix(sPrefix);
        }
    }
}

