/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.grass;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.gui.core.IAlgorithmProvider;
import es.unex.sextante.gui.core.IToolboxRightButtonAction;
import es.unex.sextante.gui.core.NameAndIcon;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.gui.core.ToolboxAction;
import es.unex.sextante.gui.exceptions.WrongGrassFolderException;
import es.unex.sextante.gui.grass.GrassAlgorithm;
import es.unex.sextante.gui.grass.GrassBlackList;
import es.unex.sextante.gui.grass.GrassModelerParametersPanel;
import es.unex.sextante.gui.grass.GrassParametersPanel;
import es.unex.sextante.gui.grass.GrassUtils;
import es.unex.sextante.gui.grass.UnwrappableGrassProcessException;
import es.unex.sextante.gui.settings.Setting;
import es.unex.sextante.gui.settings.SextanteGrassSettings;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.swing.ImageIcon;

public class GrassAlgorithmProvider
implements IAlgorithmProvider {
    private static HashMap<String, GeoAlgorithm> m_Algs = new HashMap();
    private static StringBuffer m_Message = new StringBuffer();
    private static final ImageIcon GRASS_ICON = new ImageIcon(GrassAlgorithmProvider.class.getClassLoader().getResource("images/grass.png"));

    private static GrassAlgorithm createAlgorithm(String sFile) {
        GrassAlgorithm alg = new GrassAlgorithm();
        try {
            alg.initialize(sFile);
            return alg;
        }
        catch (UnwrappableGrassProcessException e) {
            return null;
        }
    }

    @Override
    public void initialize() {
        GrassUtils.createTempMapsetName();
        this.createAlgorithmsMap();
    }

    private void createAlgorithmsMap() {
        m_Algs.clear();
        if (GrassAlgorithmProvider.getGrassDescriptionFolder() == null) {
            SextanteGUI.setSettingParameterValue("GrassActivate", new Boolean(false).toString());
            return;
        }
        if (GrassAlgorithmProvider.getGrassDescriptionFolder().length() < 1) {
            SextanteGUI.setSettingParameterValue("GrassActivate", new Boolean(false).toString());
            return;
        }
        try {
            File file = new File(GrassAlgorithmProvider.getGrassDescriptionFolder());
            String[] files = file.list();
            if (files != null) {
                for (String element : files) {
                    GrassAlgorithm alg;
                    if (!element.endsWith(".xml") || (alg = GrassAlgorithmProvider.createAlgorithm(GrassAlgorithmProvider.getGrassDescriptionFolder() + File.separator + element)) == null || GrassBlackList.isInBlackList(alg)) continue;
                    m_Algs.put(alg.getCommandLineName(), alg);
                }
            }
        }
        catch (Exception e) {
            m_Algs.clear();
        }
    }

    public static void deleteDescriptionFiles() {
        File file = new File(GrassAlgorithmProvider.getGrassDescriptionFolder());
        String[] files = file.list();
        if (files != null) {
            for (String element : files) {
                new File(file.getAbsoluteFile() + File.separator + element).delete();
            }
        }
    }

    public static int createAlgorithmsDescriptionFiles() throws WrongGrassFolderException {
        int iAlgorithms = 0;
        StringBuffer sb = new StringBuffer();
        try {
            String sFolder = SextanteGUI.getSettingParameterValue("GrassBinariesFolder");
            File file = new File(sFolder + File.separator + "bin");
            String[] files = file.list();
            if (files != null) {
                if (Sextante.isUnix() || Sextante.isMacOSX()) {
                    String sCommand;
                    int i;
                    for (i = 0; i < files.length; ++i) {
                        if (!files[i].startsWith("v.") && !files[i].startsWith("r.") || files[i].startsWith("r3.") || files[i].equals("r.mapcalc") || files[i].equals("r3.mapcalc") || GrassBlackList.isInBlackList(sCommand = files[i])) continue;
                        ++iAlgorithms;
                        sb.append(sCommand + " --interface-description > \"" + GrassAlgorithmProvider.getGrassDescriptionFolder() + File.separator + sCommand + ".xml\"\n");
                    }
                    file = new File(sFolder + File.separator + "scripts");
                    files = file.list();
                    if (files != null) {
                        for (i = 0; i < files.length; ++i) {
                            if (!files[i].startsWith("v.") && !files[i].startsWith("r.") || files[i].equals("r.out.gdal.sh") || files[i].startsWith("r3.") || GrassBlackList.isInBlackList(sCommand = files[i])) continue;
                            ++iAlgorithms;
                            sb.append(sCommand + " --interface-description > \"" + GrassAlgorithmProvider.getGrassDescriptionFolder() + File.separator + sCommand + ".xml\"\n");
                        }
                    }
                } else {
                    for (int i = 0; i < files.length; ++i) {
                        String sCommand;
                        if (!files[i].endsWith(".exe") && !files[i].endsWith(".bat") || !files[i].startsWith("v.") && !files[i].startsWith("r.") || files[i].startsWith("r3.") || files[i].contains("r.out.gdal.sh") || files[i].equals("r.mapcalc.exe") || files[i].equals("r3.mapcalc.exe") || GrassBlackList.isInBlackList(sCommand = files[i].substring(0, files[i].length() - 4))) continue;
                        ++iAlgorithms;
                        if (files[i].endsWith(".bat")) {
                            sb.append("cmd.exe /C " + sCommand + " --interface-description > \"" + GrassAlgorithmProvider.getGrassDescriptionFolder() + File.separator + sCommand + ".xml\"\n");
                            continue;
                        }
                        sb.append(sCommand + " --interface-description > \"" + GrassAlgorithmProvider.getGrassDescriptionFolder() + File.separator + sCommand + ".xml\"\n");
                    }
                }
            }
            if (iAlgorithms == 0) {
                throw new WrongGrassFolderException();
            }
        }
        catch (Exception e) {
            throw new WrongGrassFolderException();
        }
        try {
            GrassUtils.createTempMapset();
            GrassUtils.runGRASS(sb, "Creating GRASS algorithm descriptions", null);
        }
        catch (Exception e) {
            throw new WrongGrassFolderException();
        }
        Sextante.addInfoToLog((String)"SEXTANTE GRASS interface: Done setting up GRASS.");
        return iAlgorithms;
    }

    public static String getGrassDescriptionFolder() {
        String sPath = SextanteGUI.getSextanteInstallPath() + File.separator + "grass" + File.separator + "description";
        File file = new File(sPath);
        if (!file.exists()) {
            file.mkdir();
        }
        return sPath;
    }

    public static GrassAlgorithm getGrassAlgorithm(String sAlgName) {
        return (GrassAlgorithm)m_Algs.get(sAlgName);
    }

    @Override
    public HashMap<String, GeoAlgorithm> getAlgorithms() {
        if (Boolean.parseBoolean(SextanteGUI.getSettingParameterValue("GrassActivate"))) {
            return m_Algs;
        }
        return new HashMap<String, GeoAlgorithm>();
    }

    @Override
    public String getName() {
        return "GRASS";
    }

    @Override
    public HashMap<String, Class> getCustomModelerParameterPanels() {
        HashMap<String, Class> map = new HashMap<String, Class>();
        Set<String> set = m_Algs.keySet();
        Iterator<String> iter = set.iterator();
        while (iter.hasNext()) {
            map.put(iter.next(), GrassModelerParametersPanel.class);
        }
        return map;
    }

    @Override
    public HashMap<String, Class> getCustomParameterPanels() {
        HashMap<String, Class> map = new HashMap<String, Class>();
        Set<String> set = m_Algs.keySet();
        Iterator<String> iter = set.iterator();
        while (iter.hasNext()) {
            map.put(iter.next(), GrassParametersPanel.class);
        }
        return map;
    }

    @Override
    public ImageIcon getIcon() {
        return GRASS_ICON;
    }

    @Override
    public Setting getSettings() {
        return new SextanteGrassSettings();
    }

    @Override
    public void update() {
        this.createAlgorithmsMap();
    }

    @Override
    public Object getAlgorithmHelp(GeoAlgorithm alg) {
        String sFolder = SextanteGUI.getSettingParameterValue("GrassBinariesFolder");
        String sName = alg.getName();
        if (sName.contains("(")) {
            sName = sName.substring(0, sName.indexOf("(")).trim();
        }
        String sFilename = sName + ".html";
        String sURLPath = "file:///" + sFolder + File.separator + "docs" + File.separator + "html" + File.separator + sFilename;
        try {
            return new URL(sURLPath);
        }
        catch (MalformedURLException e1) {
            return null;
        }
    }

    @Override
    public String getAlgorithmHelpFilename(GeoAlgorithm alg, boolean forceCurrentLocale) {
        String sFolder = SextanteGUI.getSettingParameterValue("GrassBinariesFolder");
        String sFilename = alg.getName() + ".html";
        String sFullPath = sFolder + File.separator + "docs" + File.separator + "html" + File.separator + sFilename;
        return sFullPath;
    }

    @Override
    public boolean canEditHelp() {
        return false;
    }

    public static void deleteAlgorithms() {
        m_Algs.clear();
    }

    @Override
    public HashMap<NameAndIcon, ArrayList<ToolboxAction>> getToolboxActions() {
        return new HashMap<NameAndIcon, ArrayList<ToolboxAction>>();
    }

    @Override
    public IToolboxRightButtonAction[] getToolboxRightButtonActions() {
        return new IToolboxRightButtonAction[0];
    }

    public static void addMessage(String s) {
        m_Message.append(s + "\n");
    }

    public static void publishMessage(String sDescription) {
        Sextante.getLogger().addToLog(m_Message.toString(), "GRASS", sDescription);
    }
}

