/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.grass;

import es.unex.sextante.core.Sextante;
import es.unex.sextante.gui.grass.GrassExecutionException;
import es.unex.sextante.gui.grass.GrassUtils;
import es.unex.sextante.gui.grass.Is3DStreamGobbler;
import es.unex.sextante.gui.grass.NumGeomStreamGobbler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;

public class GrassVInfoUtils {
    public static final int GEOM_TYPE_POINT = 0;
    public static final int GEOM_TYPE_LINE = 1;
    public static final int GEOM_TYPE_POLYGON = 2;
    public static final int GEOM_TYPE_FACE = 3;
    public static final int GEOM_TYPE_KERNEL = 4;

    public static int getNumGeoms(String sMapName, int iGeomType) throws GrassExecutionException {
        String cmdline = "v.info -t " + sMapName;
        Integer numGeoms = 0;
        if (!Sextante.isWindows()) {
            Writer output = null;
            try {
                output = new BufferedWriter(new FileWriter(GrassUtils.getBatchJobFile()));
                output.write(cmdline);
            }
            catch (Exception e) {
                throw new GrassExecutionException();
            }
            finally {
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (IOException e) {
                        throw new GrassExecutionException();
                    }
                }
                GrassUtils.setExecutable(GrassUtils.getBatchJobFile());
            }
        }
        try {
            ProcessBuilder pb = GrassUtils.getGrassExecutable(cmdline);
            Process process = pb.start();
            if (Sextante.isUnix() || Sextante.isMacOSX()) {
                String line;
                InputStream is = process.getErrorStream();
                InputStreamReader isr = new InputStreamReader(is);
                BufferedReader br = null;
                br = new BufferedReader(isr);
                process.waitFor();
                while ((line = br.readLine()) != null) {
                    if (line.contains("points=") && iGeomType == 0) {
                        numGeoms = Integer.parseInt(line.substring(line.indexOf("=") + 1));
                        break;
                    }
                    if (line.contains("lines=") && iGeomType == 1) {
                        numGeoms = Integer.parseInt(line.substring(line.indexOf("=") + 1));
                        break;
                    }
                    if (line.contains("areas=") && iGeomType == 2) {
                        numGeoms = Integer.parseInt(line.substring(line.indexOf("=") + 1));
                        break;
                    }
                    if (line.contains("faces=") && iGeomType == 3) {
                        numGeoms = Integer.parseInt(line.substring(line.indexOf("=") + 1));
                        break;
                    }
                    if (!line.contains("kernels=") || iGeomType != 4) continue;
                    numGeoms = Integer.parseInt(line.substring(line.indexOf("=") + 1));
                    break;
                }
                return numGeoms;
            }
            NumGeomStreamGobbler errorGobbler = new NumGeomStreamGobbler(process.getErrorStream(), iGeomType);
            NumGeomStreamGobbler outputGobbler = new NumGeomStreamGobbler(process.getInputStream(), iGeomType);
            errorGobbler.start();
            outputGobbler.start();
            process.waitFor();
            return outputGobbler.getNumGeoms();
        }
        catch (Exception e) {
            throw new GrassExecutionException();
        }
    }

    public static int getNumPoints(String sMapName) throws GrassExecutionException {
        int result = 0;
        try {
            result = GrassVInfoUtils.getNumGeoms(sMapName, 0);
        }
        catch (Exception e) {
            throw new GrassExecutionException();
        }
        return result;
    }

    public static int getNumLines(String sMapName) throws GrassExecutionException {
        int result = 0;
        try {
            result = GrassVInfoUtils.getNumGeoms(sMapName, 1);
        }
        catch (Exception e) {
            throw new GrassExecutionException();
        }
        return result;
    }

    public static int getNumPolygons(String sMapName) throws GrassExecutionException {
        int result = 0;
        try {
            result = GrassVInfoUtils.getNumGeoms(sMapName, 2);
        }
        catch (Exception e) {
            throw new GrassExecutionException();
        }
        return result;
    }

    public static int getNumFaces(String sMapName) throws GrassExecutionException {
        int result = 0;
        try {
            result = GrassVInfoUtils.getNumGeoms(sMapName, 3);
        }
        catch (Exception e) {
            throw new GrassExecutionException();
        }
        return result;
    }

    public static int getNumKernels(String sMapName) throws GrassExecutionException {
        int result = 0;
        try {
            result = GrassVInfoUtils.getNumGeoms(sMapName, 4);
        }
        catch (Exception e) {
            throw new GrassExecutionException();
        }
        return result;
    }

    public static boolean isMap3D(String sMapName) throws GrassExecutionException {
        boolean is3D;
        block16: {
            is3D = false;
            String cmdline = "v.info -t " + sMapName;
            if (!Sextante.isWindows()) {
                Writer output = null;
                try {
                    output = new BufferedWriter(new FileWriter(GrassUtils.getBatchJobFile()));
                    output.write(cmdline);
                }
                catch (Exception e) {
                    throw new GrassExecutionException();
                }
                finally {
                    if (output != null) {
                        try {
                            output.close();
                        }
                        catch (IOException e) {
                            throw new GrassExecutionException();
                        }
                    }
                    GrassUtils.setExecutable(GrassUtils.getBatchJobFile());
                }
            }
            try {
                ProcessBuilder pb = GrassUtils.getGrassExecutable(cmdline);
                Process process = pb.start();
                if (Sextante.isUnix() || Sextante.isMacOSX()) {
                    String line;
                    InputStream is = process.getErrorStream();
                    InputStreamReader isr = new InputStreamReader(is);
                    Object fis = null;
                    Object in = null;
                    BufferedReader br = null;
                    br = new BufferedReader(isr);
                    process.waitFor();
                    while ((line = br.readLine()) != null) {
                        if (!line.contains("map3d=1")) continue;
                        is3D = true;
                        break block16;
                    }
                    break block16;
                }
                Is3DStreamGobbler errorGobbler = new Is3DStreamGobbler(process.getErrorStream());
                Is3DStreamGobbler outputGobbler = new Is3DStreamGobbler(process.getInputStream());
                errorGobbler.start();
                outputGobbler.start();
                process.waitFor();
                return outputGobbler.is3D();
            }
            catch (Exception e) {
                throw new GrassExecutionException();
            }
        }
        return is3D;
    }
}

