/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.help;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.OutputObjectsSet;
import es.unex.sextante.core.ParametersSet;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.gui.help.AlgorithmTreeCellRenderer;
import es.unex.sextante.gui.help.ElementEditionPanel;
import es.unex.sextante.gui.help.HelpElement;
import es.unex.sextante.gui.help.HelpIO;
import es.unex.sextante.outputs.Output;
import es.unex.sextante.parameters.Parameter;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class HelpEditionDialog
extends JDialog {
    private JSplitPane jSplitPane;
    private JTree jTree;
    private JScrollPane jScrollPaneTree;
    private final GeoAlgorithm m_Alg;
    private ArrayList m_Elements;
    private JButton jButtonOK;
    private JButton jButtonCancel;
    private ElementEditionPanel jElementEditionPanel;
    private TreePath m_Path = null;

    public HelpEditionDialog(GeoAlgorithm ga, Frame parent) {
        super(parent, ga.getName(), true);
        this.m_Alg = ga;
        this.initGUI();
        this.setLocationRelativeTo(null);
    }

    private void initGUI() {
        try {
            TableLayout thisLayout = new TableLayout((double[][])new double[][]{{-1.0, 100.0, 100.0, 5.0}, {-1.0, 5.0, 30.0, 5.0}});
            thisLayout.setHGap(5);
            thisLayout.setVGap(5);
            this.setLayout((LayoutManager)thisLayout);
            this.setPreferredSize(new Dimension(800, 500));
            this.setSize(new Dimension(800, 500));
            this.jSplitPane = new JSplitPane();
            this.add((Component)this.jSplitPane, "0, 0, 2, 0");
            this.jTree = new JTree();
            this.jTree.setCellRenderer(new AlgorithmTreeCellRenderer());
            MouseAdapter ml = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    DefaultMutableTreeNode node;
                    Object ob;
                    HelpEditionDialog.this.m_Path = HelpEditionDialog.this.jTree.getPathForLocation(e.getX(), e.getY());
                    if (HelpEditionDialog.this.m_Path != null && (ob = (node = (DefaultMutableTreeNode)HelpEditionDialog.this.m_Path.getLastPathComponent()).getUserObject()) instanceof HelpElement) {
                        HelpEditionDialog.this.setElement((HelpElement)ob);
                    }
                }
            };
            this.jTree.addMouseListener(ml);
            this.jTree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    DefaultMutableTreeNode node;
                    Object obj;
                    HelpEditionDialog.this.m_Path = e.getPath();
                    if (HelpEditionDialog.this.m_Path != null && (obj = (node = (DefaultMutableTreeNode)HelpEditionDialog.this.m_Path.getLastPathComponent()).getUserObject()) instanceof HelpElement) {
                        HelpEditionDialog.this.setElement((HelpElement)obj);
                    }
                }
            });
            this.jScrollPaneTree = new JScrollPane(this.jTree, 22, 30);
            this.jElementEditionPanel = new ElementEditionPanel(this.m_Alg);
            this.jScrollPaneTree.setPreferredSize(new Dimension(200, 450));
            this.jSplitPane.add((Component)this.jElementEditionPanel, "right");
            this.jSplitPane.add((Component)this.jScrollPaneTree, "left");
            this.jButtonOK = new JButton();
            this.add((Component)this.jButtonOK, "1, 2");
            this.jButtonOK.setText(Sextante.getText((String)"OK"));
            this.jButtonOK.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    HelpEditionDialog.this.saveHelp();
                }
            });
            this.jButtonCancel = new JButton();
            this.add((Component)this.jButtonCancel, "2, 2");
            this.jButtonCancel.setText(Sextante.getText((String)"Cancel"));
            this.jButtonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    HelpEditionDialog.this.cancel();
                }
            });
            this.createElementsList();
            this.fillTree();
            this.expandAll();
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private void expandAll() {
        TreeNode root = (TreeNode)this.jTree.getModel().getRoot();
        this.expandAll(this.jTree, new TreePath(root), true);
    }

    private void expandAll(JTree tree, TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandAll(tree, path, expand);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    protected void setElement(HelpElement element) {
        this.jElementEditionPanel.saveElement();
        this.jElementEditionPanel.setElement(element);
    }

    protected void cancel() {
        this.dispose();
        this.setVisible(false);
    }

    protected void saveHelp() {
        this.jElementEditionPanel.saveElement();
        HelpIO.save(this.m_Elements, SextanteGUI.getAlgorithmHelpFilename(this.m_Alg, true));
        this.cancel();
    }

    private void createElementsList() {
        if (!this.createElementsListFromFile()) {
            this.m_Elements = new ArrayList();
            this.m_Elements.add(new HelpElement("DESCRIPTION", Sextante.getText((String)"Description"), 0));
            this.m_Elements.add(new HelpElement("ADDITIONAL_INFO", Sextante.getText((String)"Additional_information"), 0));
            this.m_Elements.add(new HelpElement("EXTENSION_AUTHOR", Sextante.getText((String)"Algorithm_created_by"), 0));
            this.m_Elements.add(new HelpElement("HELP_AUTHOR", Sextante.getText((String)"Help_file_created_by"), 0));
            this.m_Elements.add(new HelpElement("USER_NOTES", Sextante.getText((String)"User_notes"), 0));
            ParametersSet params = this.m_Alg.getParameters();
            for (int i = 0; i < params.getNumberOfParameters(); ++i) {
                Parameter param = params.getParameter(i);
                this.m_Elements.add(new HelpElement(param.getParameterName(), param.getParameterDescription(), 3));
            }
            this.m_Elements.add(new HelpElement("OUTPUT_DESCRIPTION", Sextante.getText((String)"Description"), 2));
            OutputObjectsSet oo = this.m_Alg.getOutputObjects();
            for (int i = 0; i < oo.getOutputObjectsCount(); ++i) {
                Output out = oo.getOutput(i);
                this.m_Elements.add(new HelpElement(out.getName(), out.getDescription(), 2));
            }
        }
    }

    private boolean createElementsListFromFile() {
        String sFilename = SextanteGUI.getAlgorithmHelpFilename(this.m_Alg, true);
        this.m_Elements = HelpIO.open(sFilename);
        return this.m_Elements != null;
    }

    public void fillTree() {
        DefaultMutableTreeNode outputsNode = new DefaultMutableTreeNode(Sextante.getText((String)"Outputs"));
        DefaultMutableTreeNode paramsNode = new DefaultMutableTreeNode(Sextante.getText((String)"Parameters"));
        DefaultMutableTreeNode infoNode = new DefaultMutableTreeNode(Sextante.getText((String)"Information"));
        block5: for (int i = 0; i < this.m_Elements.size(); ++i) {
            HelpElement element = (HelpElement)this.m_Elements.get(i);
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(element);
            switch (element.getType()) {
                case 0: {
                    infoNode.add(node);
                    continue block5;
                }
                case 2: {
                    outputsNode.add(node);
                    continue block5;
                }
                case 3: {
                    paramsNode.add(node);
                }
            }
        }
        DefaultMutableTreeNode selectedNode = null;
        DefaultMutableTreeNode mainNode = new DefaultMutableTreeNode(Sextante.getText((String)"Elements"));
        if (infoNode.getChildCount() != 0) {
            mainNode.add(infoNode);
            selectedNode = (DefaultMutableTreeNode)infoNode.getChildAt(0);
        }
        if (paramsNode.getChildCount() != 0) {
            mainNode.add(paramsNode);
        }
        if (outputsNode.getChildCount() != 0) {
            mainNode.add(outputsNode);
        }
        DefaultTreeModel model = new DefaultTreeModel(mainNode);
        this.jTree.setModel(model);
        TreePath path = new TreePath(model.getPathToRoot(selectedNode));
        this.jTree.setSelectionPath(path);
        this.jTree.scrollPathToVisible(path);
        this.jElementEditionPanel.setElement((HelpElement)selectedNode.getUserObject());
    }
}

