/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.help;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.ObjectAndDescription;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.gui.core.IAlgorithmProvider;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.gui.grass.GrassAlgorithm;
import es.unex.sextante.gui.help.AlgorithmTreeCellRenderer;
import es.unex.sextante.gui.help.HelpIO;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SextanteHelpWindow
extends JFrame {
    private JSplitPane jSplitPane;
    private JTree jTree;
    private JEditorPane jEditorPane;
    private JScrollPane jScrollPane;
    private JScrollPane jScrollPanePage;
    private TreePath m_Path;
    private JMenuItem menuItemEditHelp;
    private JPopupMenu popupMenu;
    private GeoAlgorithm m_Alg;

    public SextanteHelpWindow() {
        super(Sextante.getText((String)"Help"));
        this.initGUI();
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.setLayout(thisLayout);
            this.setPreferredSize(new Dimension(800, 500));
            this.setSize(new Dimension(800, 500));
            this.jSplitPane = new JSplitPane();
            this.add((Component)this.jSplitPane, "Center");
            this.jTree = new JTree();
            this.jTree.setCellRenderer(new AlgorithmTreeCellRenderer());
            MouseAdapter ml = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    DefaultMutableTreeNode node;
                    Object ob;
                    SextanteHelpWindow.this.m_Path = SextanteHelpWindow.this.jTree.getPathForLocation(e.getX(), e.getY());
                    SextanteHelpWindow.this.showHelp(SextanteHelpWindow.this.m_Path);
                    SextanteHelpWindow.this.jTree.setSelectionPath(SextanteHelpWindow.this.m_Path);
                    if (e.getButton() == 3 && SextanteHelpWindow.this.m_Path != null && (ob = (node = (DefaultMutableTreeNode)SextanteHelpWindow.this.m_Path.getLastPathComponent()).getUserObject()) instanceof GeoAlgorithm) {
                        SextanteHelpWindow.this.m_Alg = (GeoAlgorithm)ob;
                        SextanteHelpWindow.this.showPopupMenu(e);
                    }
                }
            };
            this.jTree.addMouseListener(ml);
            this.jTree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    DefaultMutableTreeNode node;
                    Object ob;
                    SextanteHelpWindow.this.m_Path = e.getPath();
                    if (SextanteHelpWindow.this.m_Path != null) {
                        SextanteHelpWindow.this.showHelp(SextanteHelpWindow.this.m_Path);
                    }
                    if ((ob = (node = (DefaultMutableTreeNode)SextanteHelpWindow.this.m_Path.getLastPathComponent()).getUserObject()) instanceof GeoAlgorithm) {
                        SextanteHelpWindow.this.m_Alg = (GeoAlgorithm)ob;
                    }
                }
            });
            this.jTree.addKeyListener(new KeyListener(){

                @Override
                public void keyPressed(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                }

                @Override
                public void keyTyped(KeyEvent e) {
                    DefaultMutableTreeNode node;
                    Object ob;
                    if (e.getKeyChar() == ' ' && (ob = (node = (DefaultMutableTreeNode)SextanteHelpWindow.this.m_Path.getLastPathComponent()).getUserObject()) instanceof GeoAlgorithm) {
                        SextanteHelpWindow.this.showPopupMenu(e);
                    }
                }
            });
            this.fillTree();
            this.jEditorPane = new JEditorPane();
            this.jEditorPane.setEditable(false);
            this.jEditorPane.getDocument().putProperty("IgnoreCharsetDirective", Boolean.TRUE);
            this.jEditorPane.setContentType("text/html");
            this.jScrollPane = new JScrollPane(this.jTree, 22, 30);
            this.jScrollPanePage = new JScrollPane(this.jEditorPane, 22, 30);
            this.jScrollPane.setPreferredSize(new Dimension(300, 450));
            this.jScrollPane.setMinimumSize(new Dimension(300, 450));
            this.jSplitPane.add((Component)this.jScrollPanePage, "right");
            this.jSplitPane.add((Component)this.jScrollPane, "left");
            this.popupMenu = new JPopupMenu("Menu");
            this.menuItemEditHelp = new JMenuItem(Sextante.getText((String)"Edit_help"));
            this.menuItemEditHelp.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SextanteHelpWindow.this.editHelp();
                }
            });
            this.popupMenu.add(this.menuItemEditHelp);
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    protected void editHelp() {
        SextanteGUI.getGUIFactory().showHelpEditionDialog(this.m_Alg);
    }

    protected void showPopupMenu(MouseEvent e) {
        boolean bCanEdit = true;
        ArrayList<IAlgorithmProvider> providers = SextanteGUI.getAlgorithmProviders();
        String sName = Sextante.getAlgorithmProviderName((GeoAlgorithm)this.m_Alg);
        for (int i = 0; i < providers.size(); ++i) {
            if (!providers.get(i).getName().equals(sName)) continue;
            bCanEdit = providers.get(i).canEditHelp();
        }
        if (this.m_Alg != null && bCanEdit) {
            this.jTree.setSelectionPath(this.m_Path);
            this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    protected void showPopupMenu(KeyEvent e) {
        if (this.m_Alg != null && !(this.m_Alg instanceof GrassAlgorithm)) {
            this.jTree.setSelectionPath(this.m_Path);
            Rectangle pathBounds = this.jTree.getPathBounds(this.m_Path);
            this.popupMenu.show(e.getComponent(), pathBounds.x, pathBounds.y);
        }
    }

    protected void showHelp(TreePath path) {
        if (path != null) {
            try {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                Object ob = node.getUserObject();
                if (ob instanceof GeoAlgorithm) {
                    Object help = SextanteGUI.getAlgorithmHelp((GeoAlgorithm)ob);
                    if (help instanceof String) {
                        this.jEditorPane.setText((String)help);
                    } else if (help instanceof URL) {
                        this.jEditorPane.setPage((URL)help);
                    }
                } else if (ob instanceof ObjectAndDescription) {
                    ObjectAndDescription oad = (ObjectAndDescription)ob;
                    String sHtmlFile = (String)oad.getObject();
                    try {
                        URL url = new URL("file:///" + sHtmlFile);
                        this.jEditorPane.setPage(url);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.jEditorPane.setCaretPosition(0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void fillTree() {
        DefaultMutableTreeNode mainNode = new DefaultMutableTreeNode(Sextante.getText((String)"Help"));
        DefaultMutableTreeNode algsNode = new DefaultMutableTreeNode(Sextante.getText((String)"Algorithms"));
        DefaultMutableTreeNode generalNode = new DefaultMutableTreeNode(Sextante.getText((String)"Basic_concepts"));
        generalNode.add(new DefaultMutableTreeNode(new ObjectAndDescription(Sextante.getText((String)"SEXTANTE_toolbox"), (Object)HelpIO.getHelpFile("toolbox"))));
        generalNode.add(new DefaultMutableTreeNode(new ObjectAndDescription(Sextante.getText((String)"Batch_processing"), (Object)HelpIO.getHelpFile("batch"))));
        generalNode.add(new DefaultMutableTreeNode(new ObjectAndDescription(Sextante.getText((String)"Models"), (Object)HelpIO.getHelpFile("modeler"))));
        generalNode.add(new DefaultMutableTreeNode(new ObjectAndDescription(Sextante.getText((String)"Command_line"), (Object)HelpIO.getHelpFile("cmd"))));
        generalNode.add(new DefaultMutableTreeNode(new ObjectAndDescription(Sextante.getText((String)"History"), (Object)HelpIO.getHelpFile("history"))));
        generalNode.add(new DefaultMutableTreeNode(new ObjectAndDescription(Sextante.getText((String)"ConfiguringProviders"), (Object)HelpIO.getHelpFile("providers"))));
        mainNode.add(generalNode);
        mainNode.add(algsNode);
        this.setCursor(new Cursor(3));
        HashMap algs2 = Sextante.getAlgorithms();
        Set groupKeys = algs2.keySet();
        Iterator groupIter = groupKeys.iterator();
        while (groupIter.hasNext()) {
            HashMap<String, DefaultMutableTreeNode> baseGroups = new HashMap<String, DefaultMutableTreeNode>();
            String groupKey = (String)groupIter.next();
            DefaultMutableTreeNode toolsNode = new DefaultMutableTreeNode(groupKey);
            algsNode.add(toolsNode);
            HashMap groupAlgs = (HashMap)algs2.get(groupKey);
            Set keys = groupAlgs.keySet();
            Iterator iter = keys.iterator();
            while (iter.hasNext()) {
                GeoAlgorithm alg = (GeoAlgorithm)groupAlgs.get(iter.next());
                DefaultMutableTreeNode child = new DefaultMutableTreeNode(alg);
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)baseGroups.get(alg.getGroup());
                if (node == null) {
                    node = new DefaultMutableTreeNode(alg.getGroup());
                    baseGroups.put(alg.getGroup(), node);
                    this.addNodeInSortedOrder(toolsNode, node);
                }
                this.addNodeInSortedOrder(node, child);
            }
        }
        this.setCursor(new Cursor(0));
        this.jTree.setModel(new DefaultTreeModel(mainNode));
    }

    private void addNodeInSortedOrder(DefaultMutableTreeNode parent, DefaultMutableTreeNode child) {
        int n = parent.getChildCount();
        if (n == 0) {
            parent.add(child);
            return;
        }
        Collator collator = Collator.getInstance();
        collator.setStrength(0);
        DefaultMutableTreeNode node = null;
        for (int i = 0; i < n; ++i) {
            node = (DefaultMutableTreeNode)parent.getChildAt(i);
            try {
                if (collator.compare(node.toString(), child.toString()) <= 0) continue;
                parent.insert(child, i);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        parent.add(child);
    }

    private DefaultMutableTreeNode findNode(GeoAlgorithm alg) {
        String sName = alg.getName();
        DefaultTreeModel data2 = (DefaultTreeModel)this.jTree.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)data2.getRoot();
        DefaultMutableTreeNode node = null;
        if (root != null) {
            Enumeration<TreeNode> e = root.breadthFirstEnumeration();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode current = (DefaultMutableTreeNode)e.nextElement();
                Object ob = current.getUserObject();
                if (!(ob instanceof GeoAlgorithm) || !((GeoAlgorithm)ob).getName().equals(sName)) continue;
                node = current;
                break;
            }
        }
        return node;
    }
}

