/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.modeler;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.gui.core.IAlgorithmProvider;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.gui.modeler.AlgorithmsPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;

public class AlgorithmCellRenderer
extends JLabel
implements TreeCellRenderer {
    private final AlgorithmsPanel m_AlgorithmsPanel;

    public AlgorithmCellRenderer(AlgorithmsPanel algorithmsPanel) {
        this.m_AlgorithmsPanel = algorithmsPanel;
    }

    protected Icon getCustomIcon(Object value) {
        ArrayList<IAlgorithmProvider> providers = SextanteGUI.getAlgorithmProviders();
        Object obj = ((DefaultMutableTreeNode)value).getUserObject();
        if (obj instanceof GeoAlgorithm) {
            return SextanteGUI.getAlgorithmIcon((GeoAlgorithm)obj);
        }
        for (int i = 0; i < providers.size(); ++i) {
            if (!value.toString().equals(providers.get(i).getName())) continue;
            return providers.get(i).getIcon();
        }
        if (value.toString().equals("SEXTANTE")) {
            return SextanteGUI.SEXTANTE_ICON;
        }
        return null;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.setFont(tree.getFont());
        this.setIcon(this.getCustomIcon(value));
        String sName = tree.convertValueToText(value, sel, expanded, leaf, row, hasFocus);
        this.setEnabled(tree.isEnabled());
        this.setText(sName);
        try {
            if (leaf) {
                if (sel) {
                    this.setForeground(Color.blue);
                } else {
                    GeoAlgorithm alg = (GeoAlgorithm)((DefaultMutableTreeNode)value).getUserObject();
                    if (!this.m_AlgorithmsPanel.isAlgorithmEnabled(alg)) {
                        this.setForeground(Color.gray);
                    } else {
                        this.setForeground(Color.black);
                    }
                }
            } else {
                boolean activeAlgs = false;
                for (int i = 0; !activeAlgs && i < tree.getModel().getChildCount(value); ++i) {
                    DefaultMutableTreeNode childValue = (DefaultMutableTreeNode)tree.getModel().getChild(value, i);
                    Object childNode = childValue.getUserObject();
                    if (childNode instanceof GeoAlgorithm) {
                        GeoAlgorithm alg = (GeoAlgorithm)childNode;
                        if (!this.m_AlgorithmsPanel.isAlgorithmEnabled(alg)) continue;
                        activeAlgs = true;
                        continue;
                    }
                    activeAlgs = true;
                }
                this.setFont(new Font("Tahoma", 1, 11));
                if (sel) {
                    this.setForeground(Color.blue);
                } else if (activeAlgs) {
                    this.setForeground(Color.black);
                } else {
                    this.setForeground(Color.gray);
                }
            }
        }
        catch (ClassCastException e) {
            this.setForeground(Color.black);
        }
        return this;
    }
}

