/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.modeler;

import es.unex.sextante.additionalInfo.AdditionalInfo3DRasterLayer;
import es.unex.sextante.additionalInfo.AdditionalInfoBand;
import es.unex.sextante.additionalInfo.AdditionalInfoBoolean;
import es.unex.sextante.additionalInfo.AdditionalInfoDataObject;
import es.unex.sextante.additionalInfo.AdditionalInfoFilepath;
import es.unex.sextante.additionalInfo.AdditionalInfoFixedTable;
import es.unex.sextante.additionalInfo.AdditionalInfoMultipleInput;
import es.unex.sextante.additionalInfo.AdditionalInfoNumericalValue;
import es.unex.sextante.additionalInfo.AdditionalInfoRasterLayer;
import es.unex.sextante.additionalInfo.AdditionalInfoSelection;
import es.unex.sextante.additionalInfo.AdditionalInfoTable;
import es.unex.sextante.additionalInfo.AdditionalInfoTableField;
import es.unex.sextante.additionalInfo.AdditionalInfoVectorLayer;
import es.unex.sextante.core.ObjectAndDescription;
import es.unex.sextante.core.OutputObjectsSet;
import es.unex.sextante.core.ParametersSet;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.exceptions.NullParameterAdditionalInfoException;
import es.unex.sextante.exceptions.WrongParameterIDException;
import es.unex.sextante.gui.algorithm.FileSelectionComboPanel;
import es.unex.sextante.gui.algorithm.ParameterContainer;
import es.unex.sextante.gui.modeler.FixedTableSelectionPanel;
import es.unex.sextante.gui.modeler.GeoAlgorithmModelerParametersPanel;
import es.unex.sextante.gui.modeler.OutputLayerSettingsPanel;
import es.unex.sextante.gui.modeler.OutputParameterContainer;
import es.unex.sextante.modeler.elements.ModelElement3DRasterLayer;
import es.unex.sextante.modeler.elements.ModelElementBand;
import es.unex.sextante.modeler.elements.ModelElementBoolean;
import es.unex.sextante.modeler.elements.ModelElementFilepath;
import es.unex.sextante.modeler.elements.ModelElementFixedTable;
import es.unex.sextante.modeler.elements.ModelElementInputArray;
import es.unex.sextante.modeler.elements.ModelElementNumericalValue;
import es.unex.sextante.modeler.elements.ModelElementPoint;
import es.unex.sextante.modeler.elements.ModelElementRasterLayer;
import es.unex.sextante.modeler.elements.ModelElementSelection;
import es.unex.sextante.modeler.elements.ModelElementString;
import es.unex.sextante.modeler.elements.ModelElementTable;
import es.unex.sextante.modeler.elements.ModelElementTableField;
import es.unex.sextante.modeler.elements.ModelElementVectorLayer;
import es.unex.sextante.outputs.Output;
import es.unex.sextante.outputs.Output3DRasterLayer;
import es.unex.sextante.outputs.OutputRasterLayer;
import es.unex.sextante.outputs.OutputTable;
import es.unex.sextante.outputs.OutputVectorLayer;
import es.unex.sextante.parameters.FixedTableModel;
import es.unex.sextante.parameters.Parameter;
import es.unex.sextante.parameters.Parameter3DRasterLayer;
import es.unex.sextante.parameters.ParameterBand;
import es.unex.sextante.parameters.ParameterBoolean;
import es.unex.sextante.parameters.ParameterDataObject;
import es.unex.sextante.parameters.ParameterFilepath;
import es.unex.sextante.parameters.ParameterFixedTable;
import es.unex.sextante.parameters.ParameterMultipleInput;
import es.unex.sextante.parameters.ParameterNumericalValue;
import es.unex.sextante.parameters.ParameterPoint;
import es.unex.sextante.parameters.ParameterRasterLayer;
import es.unex.sextante.parameters.ParameterSelection;
import es.unex.sextante.parameters.ParameterString;
import es.unex.sextante.parameters.ParameterTable;
import es.unex.sextante.parameters.ParameterTableField;
import es.unex.sextante.parameters.ParameterVectorLayer;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.japura.gui.Anchor;
import org.japura.gui.BatchSelection;
import org.japura.gui.CheckComboBox;
import org.japura.gui.EmbeddedComponent;

public class DefaultModelerParametersPanel
extends GeoAlgorithmModelerParametersPanel {
    public static int CELL_HEIGHT = 18;
    private static int COLUMN_WIDTH = 250;
    private static final int MAX_BANDS = 10;
    protected int m_iCurrentRow = 0;
    private JScrollPane jScrollPanelParameters;
    private JPanel jPanelParameters;
    protected final ArrayList m_InputParameterContainer = new ArrayList();
    protected final ArrayList m_OutputParameterDefinitionContainer = new ArrayList();
    private ArrayList m_ComboBox = new ArrayList();

    @Override
    protected void initGUI() {
        this.m_ComboBox = new ArrayList();
        this.jScrollPanelParameters = new JScrollPane();
        this.add(this.jScrollPanelParameters);
        this.jScrollPanelParameters.setPreferredSize(new Dimension(650, 300));
        this.jScrollPanelParameters.setHorizontalScrollBarPolicy(31);
        this.jScrollPanelParameters.setVerticalScrollBarPolicy(20);
        this.jPanelParameters = new JPanel();
        TableLayout jPanelParametersLayout = new TableLayout(this.getTableLayoutMatrix());
        jPanelParametersLayout.setHGap(5);
        jPanelParametersLayout.setVGap(5);
        this.jPanelParameters.setLayout((LayoutManager)jPanelParametersLayout);
        this.jScrollPanelParameters.setViewportView(this.jPanelParameters);
        this.jPanelParameters.setSize(new Dimension(630, 300));
        if (this.m_Algorithm.requiresRasterLayers() || this.m_Algorithm.requiresMultipleRasterLayers() || this.m_Algorithm.requiresMultipleRasterBands()) {
            this.addRasterLayers(this.jPanelParameters);
        }
        if (this.m_Algorithm.requires3DRasterLayers()) {
            this.add3DRasterLayers(this.jPanelParameters);
        }
        if (this.m_Algorithm.requiresVectorLayers() || this.m_Algorithm.requiresMultipleVectorLayers()) {
            this.addVectorLayers(this.jPanelParameters);
        }
        if (this.m_Algorithm.requiresTables() || this.m_Algorithm.requiresMultipleTables()) {
            this.addTables(this.jPanelParameters);
        }
        if (this.m_Algorithm.requiresNonDataObjects()) {
            this.addNonDataObjects(this.jPanelParameters);
        }
        if (this.m_Algorithm.generatesLayersOrTables()) {
            this.addOutputObjects(this.jPanelParameters);
        }
    }

    protected void addOutputObjects(JPanel pane) {
        try {
            OutputObjectsSet ooset = this.m_Algorithm.getOutputObjects();
            OutputObjectsSet oosetGlobal = this.m_GlobalAlgorithm.getOutputObjects();
            this.addTitleLabel(pane, Sextante.getText((String)"Output_objects"), this.m_iCurrentRow, true);
            ++this.m_iCurrentRow;
            for (int i = 0; i < ooset.getOutputObjectsCount(); ++i) {
                Output out = ooset.getOutput(i);
                if (!(out instanceof OutputRasterLayer) && !(out instanceof OutputVectorLayer) && !(out instanceof OutputTable) && !(out instanceof Output3DRasterLayer)) continue;
                OutputLayerSettingsPanel olsp = new OutputLayerSettingsPanel();
                String sDescription = out.getDescription();
                String sKey = out.getName();
                this.addTitleLabel(pane, sDescription + "[" + out.getTypeDescription() + "]", this.m_iCurrentRow, false);
                if (!oosetGlobal.containsKey(sKey + this.m_sAlgorithmName)) {
                    sDescription = "\"" + sDescription + "\" " + Sextante.getText((String)"from") + " " + this.m_sAlgorithmDescription;
                    olsp.setKeepAsFinalResult(false);
                } else {
                    out = oosetGlobal.getOutput(sKey + this.m_sAlgorithmName);
                    sDescription = out.getDescription();
                    olsp.setKeepAsFinalResult(true);
                }
                olsp.setName(sDescription);
                pane.add((Component)olsp, this.getStringTableCoords(2, this.m_iCurrentRow));
                ++this.m_iCurrentRow;
                this.m_OutputParameterDefinitionContainer.add(new OutputParameterContainer(sKey, olsp));
            }
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private void addRasterLayers(JPanel pane) {
        ArrayList<Integer> childComboBoxIndex = new ArrayList<Integer>();
        boolean bIsOptional = false;
        ParametersSet parameters = this.m_Algorithm.getParameters();
        this.addTitleLabel(pane, Sextante.getText((String)"Raster_layers"), this.m_iCurrentRow, true);
        ++this.m_iCurrentRow;
        for (int i = 0; i < this.m_Algorithm.getNumberOfParameters(); ++i) {
            Parameter parameter = parameters.getParameter(i);
            if (parameter instanceof ParameterRasterLayer) {
                String sKey;
                JComboBox comboBox;
                childComboBoxIndex.clear();
                String sParameterName = parameter.getParameterName();
                for (int j = 0; j < this.m_Algorithm.getNumberOfParameters(); ++j) {
                    Parameter subParameter = parameters.getParameter(j);
                    if (!(subParameter instanceof ParameterBand)) continue;
                    try {
                        if (!((AdditionalInfoBand)subParameter.getParameterAdditionalInfo()).getParentParameterName().equals(sParameterName)) continue;
                        ++this.m_iCurrentRow;
                        this.addTitleLabel(pane, "      " + subParameter.getParameterDescription(), this.m_iCurrentRow, false);
                        comboBox = this.getBandSelectionComboBox();
                        childComboBoxIndex.add(new Integer(this.m_ComboBox.size()));
                        this.m_ComboBox.add(comboBox);
                        pane.add((Component)comboBox, this.getStringTableCoords(2, this.m_iCurrentRow));
                        this.m_InputParameterContainer.add(new ParameterContainer(subParameter, comboBox));
                        ObjectAndDescription oad = (ObjectAndDescription)this.getParameterValue(subParameter);
                        if (oad == null) continue;
                        Object value = oad.getObject();
                        if (value instanceof Integer) {
                            int iValue = (Integer)value;
                            comboBox.setSelectedIndex(comboBox.getItemCount() - 250 + iValue);
                            continue;
                        }
                        if (!(value instanceof String)) continue;
                        String sDesc = ((ObjectAndDescription)this.m_DataObjects.get(value)).getDescription();
                        comboBox.setSelectedItem(sDesc);
                        continue;
                    }
                    catch (Exception e) {
                        Sextante.addErrorToLog((Throwable)e);
                    }
                }
                try {
                    if (((AdditionalInfoRasterLayer)parameter.getParameterAdditionalInfo()).getIsMandatory()) {
                        bIsOptional = false;
                        this.addTitleLabel(pane, parameter.getParameterDescription(), this.m_iCurrentRow - childComboBoxIndex.size(), false);
                    } else {
                        bIsOptional = true;
                        this.addTitleLabel(pane, parameter.getParameterDescription() + Sextante.getText((String)"[optional]"), this.m_iCurrentRow - childComboBoxIndex.size(), false);
                    }
                }
                catch (NullParameterAdditionalInfoException e) {
                    Sextante.addErrorToLog((Throwable)e);
                }
                comboBox = this.getRasterLayerSelectionComboBox(childComboBoxIndex, bIsOptional);
                if (bIsOptional) {
                    comboBox.setSelectedIndex(0);
                }
                if ((sKey = this.m_GlobalAlgorithm.getInputAsignment(sParameterName, this.m_Algorithm)) != null) {
                    for (int k = 0; k < comboBox.getModel().getSize(); ++k) {
                        ObjectAndDescription oad = (ObjectAndDescription)comboBox.getModel().getElementAt(k);
                        Object ob = oad.getObject();
                        if (ob == null || !oad.getObject().equals(sKey)) continue;
                        comboBox.setSelectedIndex(k);
                        break;
                    }
                }
                pane.add((Component)comboBox, this.getStringTableCoords(2, this.m_iCurrentRow - childComboBoxIndex.size()));
                ++this.m_iCurrentRow;
                this.m_InputParameterContainer.add(new ParameterContainer(parameter, comboBox));
                continue;
            }
            if (!(parameter instanceof ParameterMultipleInput)) continue;
            try {
                AdditionalInfoMultipleInput additionalInfo = (AdditionalInfoMultipleInput)parameter.getParameterAdditionalInfo();
                if (additionalInfo.getDataType() != 1 && additionalInfo.getDataType() != 7) continue;
                this.addMultipleInput(pane, (ParameterMultipleInput)parameter);
                continue;
            }
            catch (NullParameterAdditionalInfoException e) {
                Sextante.addErrorToLog((Throwable)e);
            }
        }
    }

    private void add3DRasterLayers(JPanel pane) {
        ArrayList childComboBoxIndex = new ArrayList();
        boolean bIsOptional = false;
        ParametersSet parameters = this.m_Algorithm.getParameters();
        this.addTitleLabel(pane, Sextante.getText((String)"3D_Raster_layers"), this.m_iCurrentRow, true);
        ++this.m_iCurrentRow;
        for (int i = 0; i < this.m_Algorithm.getNumberOfParameters(); ++i) {
            String sKey;
            Parameter parameter = parameters.getParameter(i);
            String sParameterName = parameter.getParameterName();
            if (!(parameter instanceof Parameter3DRasterLayer)) continue;
            try {
                if (((AdditionalInfo3DRasterLayer)parameter.getParameterAdditionalInfo()).getIsMandatory()) {
                    bIsOptional = false;
                    this.addTitleLabel(pane, parameter.getParameterDescription(), this.m_iCurrentRow, false);
                } else {
                    bIsOptional = true;
                    this.addTitleLabel(pane, parameter.getParameterDescription() + Sextante.getText((String)"[optional]"), this.m_iCurrentRow, false);
                }
            }
            catch (NullParameterAdditionalInfoException e) {
                Sextante.addErrorToLog((Throwable)e);
            }
            JComboBox comboBox = this.getRasterLayerSelectionComboBox(childComboBoxIndex, bIsOptional);
            if (bIsOptional) {
                comboBox.setSelectedIndex(0);
            }
            if ((sKey = this.m_GlobalAlgorithm.getInputAsignment(sParameterName, this.m_Algorithm)) != null) {
                for (int k = 0; k < comboBox.getModel().getSize(); ++k) {
                    ObjectAndDescription oad = (ObjectAndDescription)comboBox.getModel().getElementAt(k);
                    Object ob = oad.getObject();
                    if (ob == null || !oad.getObject().equals(sKey)) continue;
                    comboBox.setSelectedIndex(k);
                    break;
                }
            }
            pane.add((Component)comboBox, this.getStringTableCoords(2, this.m_iCurrentRow));
            ++this.m_iCurrentRow;
            this.m_InputParameterContainer.add(new ParameterContainer(parameter, comboBox));
        }
    }

    private void addVectorLayers(JPanel pane) {
        boolean bAddNotSetField = false;
        int iChildFields = 0;
        ParametersSet parameters = this.m_Algorithm.getParameters();
        this.addTitleLabel(pane, Sextante.getText((String)"Vector_layer"), this.m_iCurrentRow, true);
        ++this.m_iCurrentRow;
        for (int i = 0; i < this.m_Algorithm.getNumberOfParameters(); ++i) {
            Parameter parameter = parameters.getParameter(i);
            if (parameter instanceof ParameterVectorLayer) {
                iChildFields = 0;
                String sParameterName = parameter.getParameterName();
                for (int j = 0; j < this.m_Algorithm.getNumberOfParameters(); ++j) {
                    Parameter subParameter = parameters.getParameter(j);
                    if (!(subParameter instanceof ParameterTableField)) continue;
                    try {
                        if (!((AdditionalInfoTableField)subParameter.getParameterAdditionalInfo()).getParentParameterName().equals(sParameterName)) continue;
                        ++this.m_iCurrentRow;
                        ++iChildFields;
                        this.addTitleLabel(pane, "      " + subParameter.getParameterDescription(), this.m_iCurrentRow, false);
                        JComboBox childComboBox = this.getVectorLayerFieldSelectionTextField();
                        ObjectAndDescription oad = (ObjectAndDescription)this.getParameterValue(subParameter);
                        if (oad != null) {
                            Object value = oad.getObject();
                            if (value instanceof Integer) {
                                int iValue = (Integer)value;
                                childComboBox.setSelectedIndex(iValue);
                            } else if (value instanceof String) {
                                JTextField textField = (JTextField)childComboBox.getEditor().getEditorComponent();
                                textField.setText((String)value);
                            }
                        }
                        pane.add((Component)childComboBox, this.getStringTableCoords(2, this.m_iCurrentRow));
                        this.m_InputParameterContainer.add(new ParameterContainer(subParameter, childComboBox));
                        continue;
                    }
                    catch (NullParameterAdditionalInfoException e) {
                        Sextante.addErrorToLog((Throwable)e);
                    }
                }
                try {
                    String sKey;
                    AdditionalInfoVectorLayer ai = (AdditionalInfoVectorLayer)parameter.getParameterAdditionalInfo();
                    if (ai.getIsMandatory()) {
                        bAddNotSetField = false;
                        this.addTitleLabel(pane, parameter.getParameterDescription(), this.m_iCurrentRow - iChildFields, false);
                    } else {
                        bAddNotSetField = true;
                        this.addTitleLabel(pane, parameter.getParameterDescription() + Sextante.getText((String)"[optional]"), this.m_iCurrentRow - iChildFields, false);
                    }
                    JComboBox comboBox = this.getVectorLayerSelectionComboBox(bAddNotSetField, ai.getShapeType());
                    if (bAddNotSetField) {
                        comboBox.setSelectedIndex(0);
                    }
                    if ((sKey = this.m_GlobalAlgorithm.getInputAsignment(sParameterName, this.m_Algorithm)) != null) {
                        for (int k = 0; k < comboBox.getModel().getSize(); ++k) {
                            ObjectAndDescription oad = (ObjectAndDescription)comboBox.getModel().getElementAt(k);
                            Object ob = oad.getObject();
                            if (ob == null || !oad.getObject().equals(sKey)) continue;
                            comboBox.setSelectedIndex(k);
                            break;
                        }
                    }
                    pane.add((Component)comboBox, this.getStringTableCoords(2, this.m_iCurrentRow - iChildFields));
                    ++this.m_iCurrentRow;
                    this.m_InputParameterContainer.add(new ParameterContainer(parameter, comboBox));
                }
                catch (NullParameterAdditionalInfoException e) {
                    Sextante.addErrorToLog((Throwable)e);
                }
                continue;
            }
            if (!(parameter instanceof ParameterMultipleInput)) continue;
            try {
                AdditionalInfoMultipleInput additionalInfo = (AdditionalInfoMultipleInput)parameter.getParameterAdditionalInfo();
                if (additionalInfo.getDataType() != 2 && additionalInfo.getDataType() != 3 && additionalInfo.getDataType() != 4 && additionalInfo.getDataType() != 5) continue;
                this.addMultipleInput(pane, (ParameterMultipleInput)parameter);
                continue;
            }
            catch (NullParameterAdditionalInfoException e) {
                Sextante.addErrorToLog((Throwable)e);
            }
        }
    }

    private void addTables(JPanel pane) {
        boolean bIsOptional = false;
        ParametersSet parameters = this.m_Algorithm.getParameters();
        int iChildFields = 0;
        this.addTitleLabel(pane, Sextante.getText((String)"Tables"), this.m_iCurrentRow, true);
        ++this.m_iCurrentRow;
        for (int i = 0; i < this.m_Algorithm.getNumberOfParameters(); ++i) {
            Parameter parameter = parameters.getParameter(i);
            if (parameter instanceof ParameterTable) {
                String sKey;
                iChildFields = 0;
                String sParameterName = parameter.getParameterName();
                for (int j = 0; j < this.m_Algorithm.getNumberOfParameters(); ++j) {
                    Parameter subParameter = parameters.getParameter(j);
                    if (!(subParameter instanceof ParameterTableField)) continue;
                    try {
                        if (!((AdditionalInfoTableField)subParameter.getParameterAdditionalInfo()).getParentParameterName().equals(sParameterName)) continue;
                        ++this.m_iCurrentRow;
                        ++iChildFields;
                        this.addTitleLabel(pane, "      " + subParameter.getParameterDescription(), this.m_iCurrentRow, false);
                        JComboBox childComboBox = this.getTableFieldSelectionTextField();
                        ObjectAndDescription oad = (ObjectAndDescription)this.getParameterValue(subParameter);
                        if (oad != null) {
                            Object value = oad.getObject();
                            if (value instanceof Integer) {
                                int iValue = (Integer)value;
                                childComboBox.setSelectedIndex(iValue);
                            } else if (value instanceof String) {
                                JTextField textField = (JTextField)childComboBox.getEditor().getEditorComponent();
                                textField.setText((String)value);
                            }
                        }
                        pane.add((Component)childComboBox, this.getStringTableCoords(2, this.m_iCurrentRow));
                        this.m_InputParameterContainer.add(new ParameterContainer(subParameter, childComboBox));
                        continue;
                    }
                    catch (NullParameterAdditionalInfoException e) {
                        Sextante.addErrorToLog((Throwable)e);
                    }
                }
                try {
                    if (((AdditionalInfoTable)parameter.getParameterAdditionalInfo()).getIsMandatory()) {
                        bIsOptional = false;
                        this.addTitleLabel(pane, parameter.getParameterDescription(), this.m_iCurrentRow - iChildFields, false);
                    } else {
                        bIsOptional = true;
                        this.addTitleLabel(pane, parameter.getParameterDescription() + Sextante.getText((String)"[optional]"), this.m_iCurrentRow - iChildFields, false);
                    }
                }
                catch (NullParameterAdditionalInfoException e) {
                    Sextante.addErrorToLog((Throwable)e);
                }
                JComboBox comboBox = this.getTableSelectionComboBox(bIsOptional);
                if (bIsOptional) {
                    comboBox.setSelectedIndex(0);
                }
                if ((sKey = this.m_GlobalAlgorithm.getInputAsignment(sParameterName, this.m_Algorithm)) != null) {
                    for (int k = 0; k < comboBox.getModel().getSize(); ++k) {
                        ObjectAndDescription oad = (ObjectAndDescription)comboBox.getModel().getElementAt(k);
                        Object ob = oad.getObject();
                        if (ob == null || !oad.getObject().equals(sKey)) continue;
                        comboBox.setSelectedIndex(k);
                        break;
                    }
                }
                pane.add((Component)comboBox, this.getStringTableCoords(2, this.m_iCurrentRow - iChildFields));
                ++this.m_iCurrentRow;
                this.m_InputParameterContainer.add(new ParameterContainer(parameter, comboBox));
                continue;
            }
            if (!(parameter instanceof ParameterMultipleInput)) continue;
            try {
                AdditionalInfoMultipleInput additionalInfo = (AdditionalInfoMultipleInput)parameter.getParameterAdditionalInfo();
                if (additionalInfo.getDataType() != 6) continue;
                this.addMultipleInput(pane, (ParameterMultipleInput)parameter);
                continue;
            }
            catch (NullParameterAdditionalInfoException e) {
                Sextante.addErrorToLog((Throwable)e);
            }
        }
    }

    private void addNonDataObjects(JPanel pane) {
        ParametersSet parameters = this.m_Algorithm.getParameters();
        this.addTitleLabel(pane, Sextante.getText((String)"Options"), this.m_iCurrentRow, true);
        ++this.m_iCurrentRow;
        for (int i = 0; i < this.m_Algorithm.getNumberOfParameters(); ++i) {
            Parameter parameter = parameters.getParameter(i);
            if (parameter instanceof ParameterNumericalValue) {
                this.addNumericalTextField(pane, (ParameterNumericalValue)parameter);
                continue;
            }
            if (parameter instanceof ParameterString) {
                this.addStringTextField(pane, (ParameterString)parameter);
                continue;
            }
            if (parameter instanceof ParameterSelection) {
                this.addSelection(pane, (ParameterSelection)parameter);
                continue;
            }
            if (parameter instanceof ParameterFixedTable) {
                this.addFixedTable(pane, (ParameterFixedTable)parameter);
                continue;
            }
            if (parameter instanceof ParameterPoint) {
                this.addPoint(pane, (ParameterPoint)parameter);
                continue;
            }
            if (parameter instanceof ParameterBoolean) {
                this.addCheckBox(pane, (ParameterBoolean)parameter);
                continue;
            }
            if (!(parameter instanceof ParameterFilepath)) continue;
            this.addFilepath(pane, (ParameterFilepath)parameter);
        }
    }

    private void addMultipleInput(JPanel pane, ParameterMultipleInput parameter) {
        ArrayList<ObjectAndDescription> validArrays = new ArrayList<ObjectAndDescription>();
        try {
            int i;
            int[] iDataTypes;
            ObjectAndDescription[] objects;
            AdditionalInfoMultipleInput additionalInfo = (AdditionalInfoMultipleInput)parameter.getParameterAdditionalInfo();
            switch (additionalInfo.getDataType()) {
                case 1: {
                    objects = this.getElementsOfClass(ModelElementRasterLayer.class, true);
                    iDataTypes = new int[]{1};
                    break;
                }
                case 8: {
                    objects = this.getElementsOfClass(ModelElement3DRasterLayer.class, true);
                    iDataTypes = new int[]{8};
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objects = this.getElementsOfClass(ModelElementVectorLayer.class, true);
                    iDataTypes = new int[]{additionalInfo.getDataType()};
                    break;
                }
                case 6: {
                    objects = this.getElementsOfClass(ModelElementTable.class, true);
                    iDataTypes = new int[]{6};
                    break;
                }
                case 7: {
                    objects = this.getElementsOfClass(ModelElementRasterLayer.class, true);
                    iDataTypes = new int[]{1, 7};
                    break;
                }
                default: {
                    return;
                }
            }
            ObjectAndDescription[] arrays = this.getElementsOfClass(ModelElementInputArray.class, true);
            ParametersSet ps = this.m_GlobalAlgorithm.getParameters();
            block11: for (i = 0; i < arrays.length; ++i) {
                String sKey = (String)arrays[i].getObject();
                try {
                    Parameter param = ps.getParameter(sKey);
                    AdditionalInfoMultipleInput ainfo = (AdditionalInfoMultipleInput)param.getParameterAdditionalInfo();
                    for (int element : iDataTypes) {
                        if (ainfo.getDataType() != element) continue;
                        validArrays.add(arrays[i]);
                        continue block11;
                    }
                    continue;
                }
                catch (WrongParameterIDException e) {
                    Sextante.addErrorToLog((Throwable)e);
                }
            }
            ObjectAndDescription[] allObjects = new ObjectAndDescription[validArrays.size() + objects.length];
            for (i = 0; i < objects.length; ++i) {
                allObjects[i] = objects[i];
            }
            for (i = 0; i < validArrays.size(); ++i) {
                allObjects[i + objects.length] = (ObjectAndDescription)validArrays.get(i);
            }
            this.addTitleLabel(pane, parameter.getParameterDescription(), this.m_iCurrentRow, false);
            CheckComboBox ccb = new CheckComboBox();
            ccb.setTextFor(CheckComboBox.NONE, Sextante.getText((String)"no_elements_selected"));
            ccb.setTextFor(CheckComboBox.MULTIPLE, Sextante.getText((String)"multiple_elements_selected"));
            BatchSelection.CheckBox bs = new BatchSelection.CheckBox();
            EmbeddedComponent comp = new EmbeddedComponent((JComponent)bs, Anchor.NORTH);
            ccb.setEmbeddedComponent(comp);
            for (int j = 0; j < allObjects.length; ++j) {
                ccb.getModel().addElement(new Object[]{allObjects[j]});
            }
            ObjectAndDescription oad = (ObjectAndDescription)this.getParameterValue((Parameter)parameter);
            if (oad != null) {
                ArrayList list = (ArrayList)oad.getObject();
                for (int j = 0; j < list.size(); ++j) {
                    for (int k = 0; k < allObjects.length; ++k) {
                        if (!allObjects[k].getObject().equals(list.get(j))) continue;
                        ccb.getModel().addCheck(new Object[]{allObjects[k]});
                    }
                }
            }
            this.addTitleLabel(pane, parameter.getParameterDescription(), this.m_iCurrentRow, false);
            pane.add((Component)ccb, this.getStringTableCoords(2, this.m_iCurrentRow));
            this.m_InputParameterContainer.add(new ParameterContainer((Parameter)parameter, (JComponent)ccb));
            ++this.m_iCurrentRow;
        }
        catch (NullParameterAdditionalInfoException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private void addFixedTable(JPanel pane, ParameterFixedTable parameter) {
        try {
            AdditionalInfoFixedTable additionalInfo = (AdditionalInfoFixedTable)parameter.getParameterAdditionalInfo();
            int iRows = additionalInfo.getRowsCount();
            String[] sCols = additionalInfo.getCols();
            boolean bIsNumberOfRowsFixed = additionalInfo.isNumberOfRowsFixed();
            this.addTitleLabel(pane, parameter.getParameterDescription(), this.m_iCurrentRow, false);
            ObjectAndDescription[] tables = this.getElementsOfClass(ModelElementFixedTable.class, true);
            AdditionalInfoFixedTable addInfo = new AdditionalInfoFixedTable(sCols, iRows, bIsNumberOfRowsFixed);
            FixedTableSelectionPanel fixedTablePanel = new FixedTableSelectionPanel(addInfo, tables, this.m_DataObjects, this.m_GlobalAlgorithm);
            String sKey = this.m_GlobalAlgorithm.getInputAsignment(parameter.getParameterName(), this.m_Algorithm);
            ObjectAndDescription oad = (ObjectAndDescription)this.m_DataObjects.get(sKey);
            if (oad != null) {
                if (oad.getObject() instanceof FixedTableModel) {
                    fixedTablePanel.setTable(oad.getObject());
                } else {
                    fixedTablePanel.setTable(sKey);
                }
            }
            this.addTitleLabel(pane, parameter.getParameterDescription(), this.m_iCurrentRow, false);
            pane.add((Component)fixedTablePanel, this.getStringTableCoords(2, this.m_iCurrentRow));
            this.m_InputParameterContainer.add(new ParameterContainer((Parameter)parameter, fixedTablePanel));
            ++this.m_iCurrentRow;
        }
        catch (NullParameterAdditionalInfoException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private void addPoint(JPanel pane, ParameterPoint parameter) {
        JComboBox<ObjectAndDescription> comboBox = new JComboBox<ObjectAndDescription>();
        ObjectAndDescription[] values = this.getElementsOfClass(ModelElementPoint.class, true);
        DefaultComboBoxModel<ObjectAndDescription> defaultModel = new DefaultComboBoxModel<ObjectAndDescription>(values);
        String sKey = this.m_GlobalAlgorithm.getInputAsignment(parameter.getParameterName(), this.m_Algorithm);
        if (sKey != null) {
            for (int k = 0; k < comboBox.getModel().getSize(); ++k) {
                ObjectAndDescription oad = (ObjectAndDescription)comboBox.getModel().getElementAt(k);
                if (!oad.getObject().equals(sKey)) continue;
                comboBox.setSelectedIndex(k);
                break;
            }
        }
        comboBox.setModel(defaultModel);
        this.addTitleLabel(pane, parameter.getParameterDescription(), this.m_iCurrentRow, false);
        pane.add(comboBox, this.getStringTableCoords(2, this.m_iCurrentRow));
        ++this.m_iCurrentRow;
        this.m_InputParameterContainer.add(new ParameterContainer((Parameter)parameter, comboBox));
    }

    private void addSelection(JPanel pane, ParameterSelection parameter) {
        try {
            int i;
            JComboBox<String> comboBox = new JComboBox<String>();
            String[] sValues = ((AdditionalInfoSelection)parameter.getParameterAdditionalInfo()).getValues();
            ObjectAndDescription[] values = this.getElementsOfClass(ModelElementSelection.class, true);
            String[] sValuesForCombo = new String[sValues.length + values.length];
            for (i = 0; i < sValues.length; ++i) {
                sValuesForCombo[i] = sValues[i];
            }
            for (i = 0; i < values.length; ++i) {
                sValuesForCombo[i + sValues.length] = values[i].getDescription();
            }
            DefaultComboBoxModel<String> defaultModel = new DefaultComboBoxModel<String>(sValuesForCombo);
            comboBox.setModel(defaultModel);
            comboBox.setSelectedIndex(0);
            this.addTitleLabel(pane, parameter.getParameterDescription(), this.m_iCurrentRow, false);
            pane.add(comboBox, this.getStringTableCoords(2, this.m_iCurrentRow));
            String sKey = this.m_GlobalAlgorithm.getInputAsignment(parameter.getParameterName(), this.m_Algorithm);
            ObjectAndDescription oad = (ObjectAndDescription)this.m_DataObjects.get(sKey);
            if (oad != null) {
                if (oad.getObject() instanceof Integer) {
                    int iValue = (Integer)oad.getObject();
                    comboBox.setSelectedIndex(iValue);
                } else {
                    for (i = 0; i < values.length; ++i) {
                        if (!values[i].getObject().equals(sKey)) continue;
                        comboBox.setSelectedIndex(sValues.length + i);
                        break;
                    }
                }
            }
            ++this.m_iCurrentRow;
            this.m_InputParameterContainer.add(new ParameterContainer((Parameter)parameter, comboBox));
        }
        catch (NullParameterAdditionalInfoException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private void addNumericalTextField(JPanel pane, ParameterNumericalValue parameter) {
        try {
            AdditionalInfoNumericalValue additionalInfo = (AdditionalInfoNumericalValue)parameter.getParameterAdditionalInfo();
            int iType = additionalInfo.getType();
            this.addTitleLabel(pane, parameter.getParameterDescription(), this.m_iCurrentRow, false);
            JComboBox<ObjectAndDescription> comboBox = new JComboBox<ObjectAndDescription>();
            ObjectAndDescription[] values = this.getElementsOfClass(ModelElementNumericalValue.class, true);
            DefaultComboBoxModel<ObjectAndDescription> jComboBoxNumericalInputModel = new DefaultComboBoxModel<ObjectAndDescription>(values);
            comboBox.setModel(jComboBoxNumericalInputModel);
            comboBox.setSelectedIndex(-1);
            comboBox.setEditable(true);
            JTextField textField = (JTextField)comboBox.getEditor().getEditorComponent();
            if (iType == 2) {
                textField.setText(Double.toString(additionalInfo.getDefaultValue()));
            } else {
                textField.setText(Integer.toString((int)additionalInfo.getDefaultValue()));
            }
            String sKey = this.m_GlobalAlgorithm.getInputAsignment(parameter.getParameterName(), this.m_Algorithm);
            ObjectAndDescription oad = (ObjectAndDescription)this.m_DataObjects.get(sKey);
            if (oad != null) {
                if (oad.getObject() instanceof Number) {
                    double dValue = ((Number)oad.getObject()).doubleValue();
                    textField.setText(Double.toString(dValue));
                } else {
                    for (int i = 0; i < values.length; ++i) {
                        if (!values[i].getObject().equals(sKey)) continue;
                        comboBox.setSelectedIndex(i);
                        comboBox.updateUI();
                        break;
                    }
                }
            }
            pane.add(comboBox, this.getStringTableCoords(2, this.m_iCurrentRow));
            this.m_InputParameterContainer.add(new ParameterContainer((Parameter)parameter, comboBox));
            ++this.m_iCurrentRow;
        }
        catch (NullParameterAdditionalInfoException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    protected void validateKeyTyping(KeyEvent event) {
        JTextField textField = (JTextField)event.getSource();
        String text = textField.getText() + event.getKeyChar();
        try {
            Double.parseDouble(text);
            textField.setText(text);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void addStringTextField(JPanel pane, ParameterString parameter) {
        this.addTitleLabel(pane, parameter.getParameterDescription(), this.m_iCurrentRow, false);
        JComboBox<ObjectAndDescription> comboBox = new JComboBox<ObjectAndDescription>();
        ObjectAndDescription[] values = this.getElementsOfClassAOrB(ModelElementString.class, ModelElementNumericalValue.class, true);
        DefaultComboBoxModel<ObjectAndDescription> jComboBoxModel = new DefaultComboBoxModel<ObjectAndDescription>(values);
        comboBox.setModel(jComboBoxModel);
        comboBox.setSelectedIndex(-1);
        comboBox.setEditable(true);
        String sKey = this.m_GlobalAlgorithm.getInputAsignment(parameter.getParameterName(), this.m_Algorithm);
        ObjectAndDescription oad = (ObjectAndDescription)this.m_DataObjects.get(sKey);
        if (oad != null) {
            if (oad.getObject() instanceof String) {
                JTextField textField = (JTextField)comboBox.getEditor().getEditorComponent();
                textField.setText((String)oad.getObject());
            } else {
                for (int i = 0; i < values.length; ++i) {
                    if (!values[i].getObject().equals(sKey)) continue;
                    comboBox.setSelectedIndex(i);
                    comboBox.updateUI();
                    break;
                }
            }
        }
        pane.add(comboBox, this.getStringTableCoords(2, this.m_iCurrentRow));
        this.m_InputParameterContainer.add(new ParameterContainer((Parameter)parameter, comboBox));
        ++this.m_iCurrentRow;
    }

    private void addFilepath(JPanel pane, ParameterFilepath parameter) {
        this.addTitleLabel(pane, parameter.getParameterDescription(), this.m_iCurrentRow, false);
        ObjectAndDescription[] values = this.getElementsOfClass(ModelElementFilepath.class, true);
        try {
            AdditionalInfoFilepath additionalInfo = (AdditionalInfoFilepath)parameter.getParameterAdditionalInfo();
            String sExtension = "*.*";
            String[] sExtensions = additionalInfo.getExtensions();
            if (sExtensions != null) {
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < sExtensions.length; ++i) {
                    sb.append(sExtensions[i]);
                    if (i >= sExtensions.length - 1) continue;
                    sb.append(",");
                }
                sExtension = sb.toString();
            }
            FileSelectionComboPanel fileSelectionPanel = new FileSelectionComboPanel(additionalInfo.isFolder(), additionalInfo.isOpenDialog(), additionalInfo.getExtensions(), Sextante.getText((String)"Files") + " " + sExtension);
            DefaultComboBoxModel<ObjectAndDescription> jComboBoxModel = new DefaultComboBoxModel<ObjectAndDescription>(values);
            fileSelectionPanel.getComboBox().setModel(jComboBoxModel);
            fileSelectionPanel.getComboBox().setSelectedIndex(-1);
            fileSelectionPanel.getComboBox().setEditable(true);
            String sKey = this.m_GlobalAlgorithm.getInputAsignment(parameter.getParameterName(), this.m_Algorithm);
            ObjectAndDescription oad = (ObjectAndDescription)this.m_DataObjects.get(sKey);
            if (oad != null) {
                if (oad.getObject() instanceof String) {
                    JTextField textField = (JTextField)fileSelectionPanel.getComboBox().getEditor().getEditorComponent();
                    textField.setText((String)oad.getObject());
                } else {
                    for (int i = 0; i < values.length; ++i) {
                        if (!values[i].getObject().equals(sKey)) continue;
                        fileSelectionPanel.getComboBox().setSelectedIndex(i);
                        fileSelectionPanel.getComboBox().updateUI();
                        break;
                    }
                }
            }
            pane.add((Component)fileSelectionPanel, this.getStringTableCoords(2, this.m_iCurrentRow));
            this.m_InputParameterContainer.add(new ParameterContainer((Parameter)parameter, fileSelectionPanel.getComboBox()));
            ++this.m_iCurrentRow;
        }
        catch (NullParameterAdditionalInfoException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private void addCheckBox(JPanel pane, ParameterBoolean parameter) {
        int i;
        JComboBox<String> comboBox = new JComboBox<String>();
        ObjectAndDescription[] values = this.getElementsOfClass(ModelElementBoolean.class, true);
        String[] sValuesForCombo = new String[2 + values.length];
        sValuesForCombo[0] = Sextante.getText((String)"Yes");
        sValuesForCombo[1] = Sextante.getText((String)"No");
        for (i = 0; i < values.length; ++i) {
            sValuesForCombo[i + 2] = values[i].getDescription();
        }
        DefaultComboBoxModel<String> defaultModel = new DefaultComboBoxModel<String>(sValuesForCombo);
        comboBox.setModel(defaultModel);
        try {
            AdditionalInfoBoolean ai = (AdditionalInfoBoolean)parameter.getParameterAdditionalInfo();
            if (ai.getDefaultValue()) {
                comboBox.setSelectedIndex(0);
            } else {
                comboBox.setSelectedIndex(1);
            }
        }
        catch (NullParameterAdditionalInfoException e) {
            comboBox.setSelectedIndex(0);
        }
        this.addTitleLabel(pane, parameter.getParameterDescription(), this.m_iCurrentRow, false);
        String sKey = this.m_GlobalAlgorithm.getInputAsignment(parameter.getParameterName(), this.m_Algorithm);
        ObjectAndDescription oad = (ObjectAndDescription)this.m_DataObjects.get(sKey);
        if (oad != null) {
            if (oad.getObject() instanceof Boolean) {
                Boolean b = (Boolean)oad.getObject();
                if (b.booleanValue()) {
                    comboBox.setSelectedIndex(0);
                } else {
                    comboBox.setSelectedIndex(1);
                }
                comboBox.updateUI();
            } else {
                for (i = 0; i < values.length; ++i) {
                    if (!values[i].getObject().equals(sKey)) continue;
                    comboBox.setSelectedIndex(i + 2);
                    break;
                }
            }
        }
        pane.add(comboBox, this.getStringTableCoords(2, this.m_iCurrentRow));
        ++this.m_iCurrentRow;
        this.m_InputParameterContainer.add(new ParameterContainer((Parameter)parameter, comboBox));
    }

    protected void addTitleLabel(JPanel pane, String sText, int iRow, boolean isSectionTitleLabel) {
        JLabel label = new JLabel();
        label.setText(sText);
        label.setPreferredSize(new Dimension(COLUMN_WIDTH, CELL_HEIGHT));
        if (isSectionTitleLabel) {
            label.setFont(new Font("Tahoma", 1, 11));
        }
        pane.add((Component)label, this.getStringTableCoords(1, iRow));
    }

    protected String getStringTableCoords(int iCol, int iRow) {
        StringBuffer sCellCoords = new StringBuffer();
        sCellCoords.append(Integer.toString(iCol));
        sCellCoords.append(",");
        sCellCoords.append(Integer.toString(iRow));
        return sCellCoords.toString();
    }

    protected double[][] getTableLayoutMatrix() {
        int i;
        OutputObjectsSet ooSet;
        int iOutput;
        int iRows = 0;
        double[] iSizeColumns = new double[]{10.0, -1.0, 360.0, 10.0};
        iRows += this.m_Algorithm.getNumberOfParameters();
        if (this.m_Algorithm.requiresRasterLayers() || this.m_Algorithm.requiresMultipleRasterLayers() || this.m_Algorithm.requiresMultipleRasterBands()) {
            ++iRows;
        }
        if (this.m_Algorithm.requiresVectorLayers() || this.m_Algorithm.requiresMultipleVectorLayers()) {
            ++iRows;
        }
        if (this.m_Algorithm.requiresTables() || this.m_Algorithm.requiresMultipleTables()) {
            ++iRows;
        }
        if (this.m_Algorithm.requires3DRasterLayers()) {
            ++iRows;
        }
        if (this.m_Algorithm.requiresNonDataObjects()) {
            ++iRows;
        }
        if ((iOutput = (ooSet = this.m_Algorithm.getOutputObjects()).getOutputObjectsCount()) != 0) {
            iRows += iOutput + 1;
        }
        double[] iSizeRows = new double[iRows];
        for (i = 0; i < iRows - iOutput; ++i) {
            iSizeRows[i] = CELL_HEIGHT;
        }
        for (i = iRows - iOutput; i < iRows; ++i) {
            iSizeRows[i] = (double)CELL_HEIGHT * 2.5;
        }
        double[][] iSize = new double[][]{iSizeColumns, iSizeRows};
        return iSize;
    }

    private JComboBox getRasterLayerSelectionComboBox(ArrayList childComboBoxes, boolean bIsOptional) {
        final JComboBox<ObjectAndDescription> comboBox = new JComboBox<ObjectAndDescription>();
        ObjectAndDescription[] sObjects = this.getElementsOfClass(ModelElementRasterLayer.class, bIsOptional);
        final Integer[] childsArray = new Integer[childComboBoxes.size()];
        for (int i = 0; i < childsArray.length; ++i) {
            childsArray[i] = (Integer)childComboBoxes.get(i);
        }
        DefaultComboBoxModel<ObjectAndDescription> defaultModel = new DefaultComboBoxModel<ObjectAndDescription>(sObjects);
        if (bIsOptional) {
            defaultModel.insertElementAt(new ObjectAndDescription(Sextante.getText((String)"[Not_selected]"), null), 0);
        }
        comboBox.setModel(defaultModel);
        comboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                String[] sNames = null;
                ObjectAndDescription ob = (ObjectAndDescription)comboBox.getSelectedItem();
                ObjectAndDescription oad = (ObjectAndDescription)DefaultModelerParametersPanel.this.m_DataObjects.get(ob.getObject());
                if (oad != null) {
                    int iBands = ((ModelElementRasterLayer)oad.getObject()).getNumberOfBands();
                    for (int i = 0; i < childsArray.length; ++i) {
                        int iIndex = childsArray[i];
                        sNames = DefaultModelerParametersPanel.this.getBandNames(iBands);
                        if (sNames == null) continue;
                        DefaultComboBoxModel<String> defaultModel = new DefaultComboBoxModel<String>(sNames);
                        ((JComboBox)DefaultModelerParametersPanel.this.m_ComboBox.get(iIndex)).setModel(defaultModel);
                    }
                }
            }
        });
        return comboBox;
    }

    private JComboBox getVectorLayerSelectionComboBox(boolean bIsOptional, int iShapeType) {
        JComboBox<ObjectAndDescription> comboBox = new JComboBox<ObjectAndDescription>();
        ObjectAndDescription[] allLayers = this.getElementsOfClass(ModelElementVectorLayer.class, bIsOptional);
        ArrayList<ObjectAndDescription> list = new ArrayList<ObjectAndDescription>();
        for (ObjectAndDescription element : allLayers) {
            String sKey = (String)element.getObject();
            ObjectAndDescription oad = (ObjectAndDescription)this.m_DataObjects.get(sKey);
            ModelElementVectorLayer mevl = (ModelElementVectorLayer)oad.getObject();
            if (mevl.getShapeType() != iShapeType && mevl.getShapeType() != -1 && iShapeType != -1) continue;
            list.add(element);
        }
        ObjectAndDescription[] layers = new ObjectAndDescription[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            layers[i] = (ObjectAndDescription)list.get(i);
        }
        DefaultComboBoxModel<ObjectAndDescription> defaultModel = new DefaultComboBoxModel<ObjectAndDescription>(layers);
        if (bIsOptional) {
            defaultModel.insertElementAt(new ObjectAndDescription(Sextante.getText((String)"[Not_selected]"), null), 0);
        }
        comboBox.setModel(defaultModel);
        return comboBox;
    }

    private JComboBox getTableFieldSelectionTextField() {
        JComboBox<ObjectAndDescription> comboBox = new JComboBox<ObjectAndDescription>();
        ObjectAndDescription[] oadArray = this.getElementsOfClass(ModelElementTableField.class, true);
        ArrayList<ObjectAndDescription> valuesArrayList = new ArrayList<ObjectAndDescription>();
        for (ObjectAndDescription element : oadArray) {
            try {
                ObjectAndDescription oad = element;
                String sKey = (String)oad.getObject();
                ParameterTableField param = (ParameterTableField)this.m_GlobalAlgorithm.getParameters().getParameter(sKey);
                AdditionalInfoTableField ai = (AdditionalInfoTableField)param.getParameterAdditionalInfo();
                sKey = ai.getParentParameterName();
                Parameter parentParam = this.m_GlobalAlgorithm.getParameters().getParameter(sKey);
                if (parentParam == null) continue;
                valuesArrayList.add(oad);
            }
            catch (NullParameterAdditionalInfoException e) {
                Sextante.addErrorToLog((Throwable)e);
            }
            catch (WrongParameterIDException e) {
                Sextante.addErrorToLog((Throwable)e);
            }
        }
        ObjectAndDescription[] values = new ObjectAndDescription[valuesArrayList.size()];
        for (int i = 0; i < valuesArrayList.size(); ++i) {
            values[i] = (ObjectAndDescription)valuesArrayList.get(i);
        }
        DefaultComboBoxModel<ObjectAndDescription> jComboBoxModel = new DefaultComboBoxModel<ObjectAndDescription>(values);
        comboBox.setModel(jComboBoxModel);
        comboBox.setEditable(true);
        return comboBox;
    }

    private JComboBox getVectorLayerFieldSelectionTextField() {
        JComboBox<ObjectAndDescription> comboBox = new JComboBox<ObjectAndDescription>();
        ObjectAndDescription[] oadArray = this.getElementsOfClass(ModelElementTableField.class, true);
        ArrayList<ObjectAndDescription> valuesArrayList = new ArrayList<ObjectAndDescription>();
        for (ObjectAndDescription element : oadArray) {
            try {
                ObjectAndDescription oad = element;
                String sKey = (String)oad.getObject();
                ParameterTableField param = (ParameterTableField)this.m_GlobalAlgorithm.getParameters().getParameter(sKey);
                AdditionalInfoTableField ai = (AdditionalInfoTableField)param.getParameterAdditionalInfo();
                sKey = ai.getParentParameterName();
                Parameter parentParam = this.m_GlobalAlgorithm.getParameters().getParameter(sKey);
                if (parentParam == null) continue;
                valuesArrayList.add(oad);
            }
            catch (NullParameterAdditionalInfoException e) {
                Sextante.addErrorToLog((Throwable)e);
            }
            catch (WrongParameterIDException e) {
                Sextante.addErrorToLog((Throwable)e);
            }
        }
        ObjectAndDescription[] values = new ObjectAndDescription[valuesArrayList.size()];
        for (int i = 0; i < valuesArrayList.size(); ++i) {
            values[i] = (ObjectAndDescription)valuesArrayList.get(i);
        }
        DefaultComboBoxModel<ObjectAndDescription> jComboBoxModel = new DefaultComboBoxModel<ObjectAndDescription>(values);
        comboBox.setModel(jComboBoxModel);
        comboBox.setSelectedIndex(-1);
        comboBox.setEditable(true);
        return comboBox;
    }

    private JComboBox getBandSelectionComboBox() {
        ObjectAndDescription[] layers = this.getElementsOfClass(ModelElementRasterLayer.class, true);
        ObjectAndDescription oad = (ObjectAndDescription)this.m_DataObjects.get(layers[0].getObject());
        int iBands = ((ModelElementRasterLayer)oad.getObject()).getNumberOfBands();
        if (layers.length > 0) {
            JComboBox<String> comboBox = new JComboBox<String>();
            DefaultComboBoxModel<String> defaultModel = new DefaultComboBoxModel<String>(this.getBandNames(iBands));
            comboBox.setModel(defaultModel);
            return comboBox;
        }
        return new JComboBox();
    }

    private String[] getBandNames(int iBands) {
        int i;
        ObjectAndDescription[] values = this.getElementsOfClass(ModelElementBand.class, true);
        if (iBands == -1) {
            iBands = 10;
        }
        String[] sValues = new String[values.length + iBands];
        for (i = 0; i < values.length; ++i) {
            sValues[i] = values[i].getDescription();
        }
        for (i = 0; i < iBands; ++i) {
            sValues[i + values.length] = iBands == 10 && i != 0 ? Integer.toString(i + 1) + "[" + Sextante.getText((String)"unchecked") + "]" : Integer.toString(i + 1);
        }
        return sValues;
    }

    private JComboBox getTableSelectionComboBox(boolean bIsOptional) {
        JComboBox<ObjectAndDescription> comboBox = new JComboBox<ObjectAndDescription>();
        ObjectAndDescription[] sObjects = this.getElementsOfClass(ModelElementTable.class, bIsOptional);
        DefaultComboBoxModel<ObjectAndDescription> defaultModel = new DefaultComboBoxModel<ObjectAndDescription>(sObjects);
        if (bIsOptional) {
            defaultModel.insertElementAt(new ObjectAndDescription(Sextante.getText((String)"[Not_selected]"), null), 0);
        }
        comboBox.setModel(defaultModel);
        return comboBox;
    }

    @Override
    public boolean assignParameters(HashMap map) {
        int i;
        boolean bAssigningOK = true;
        for (i = 0; i < this.m_InputParameterContainer.size(); ++i) {
            ParameterContainer parameterContainer = (ParameterContainer)this.m_InputParameterContainer.get(i);
            if (parameterContainer.getType().equals("Table") || parameterContainer.getType().equals("Vector Layer") || parameterContainer.getType().equals("Raster Layer") || parameterContainer.getType().equals("Point")) {
                this.makeDataObjectAssignment(map, parameterContainer);
            } else if (parameterContainer.getType().equals("Multiple Input")) {
                this.makeMultipleInputAssignment(map, parameterContainer);
            } else if (parameterContainer.getType().equals("Numerical Value")) {
                bAssigningOK = this.makeNumericalValueAssignment(map, parameterContainer);
            } else if (parameterContainer.getType().equals("String")) {
                bAssigningOK = this.makeStringAssignment(map, parameterContainer);
            } else if (parameterContainer.getType().equals("Boolean")) {
                bAssigningOK = this.makeBooleanAssignment(map, parameterContainer);
            } else if (parameterContainer.getType().equals("Fixed Table")) {
                bAssigningOK = this.makeFixedTableAssignment(map, parameterContainer);
            } else if (parameterContainer.getType().equals("Filepath")) {
                bAssigningOK = this.makeFilepathAssignment(map, parameterContainer);
            } else if (parameterContainer.getType().equals("Band")) {
                bAssigningOK = this.makeRasterBandAssignment(map, parameterContainer);
            } else if (parameterContainer.getType().equals("Table Field")) {
                bAssigningOK = this.makeTableFieldAssignment(map, parameterContainer);
            } else if (parameterContainer.getType().equals("Selection")) {
                bAssigningOK = this.makeSelectionAssignment(map, parameterContainer);
            }
            if (bAssigningOK) continue;
            return false;
        }
        OutputObjectsSet oosetGlobal = this.m_GlobalAlgorithm.getOutputObjects();
        OutputObjectsSet ooset = this.m_Algorithm.getOutputObjects();
        for (i = 0; i < this.m_OutputParameterDefinitionContainer.size(); ++i) {
            OutputParameterContainer opc = (OutputParameterContainer)this.m_OutputParameterDefinitionContainer.get(i);
            OutputLayerSettingsPanel olsp = (OutputLayerSettingsPanel)opc.getContainer();
            String sName = opc.getName() + this.m_sAlgorithmName;
            if (olsp.getKeepAsFinalResult()) {
                try {
                    Output out = ooset.getOutput(opc.getName());
                    Output outToAdd = (Output)out.getClass().newInstance();
                    outToAdd.setName(sName);
                    outToAdd.setDescription(olsp.getName());
                    oosetGlobal.add(outToAdd);
                }
                catch (Exception exception) {}
                continue;
            }
            oosetGlobal.remove(sName);
        }
        return true;
    }

    protected void makeDataObjectAssignment(HashMap map, ParameterContainer pc) {
        Parameter parameter = pc.getParameter();
        JComboBox container = (JComboBox)pc.getContainer();
        String sKey = parameter.getParameterName();
        ObjectAndDescription oad = (ObjectAndDescription)container.getSelectedItem();
        String sAssignment = (String)oad.getObject();
        map.put(sKey, sAssignment);
    }

    protected boolean makeMultipleInputAssignment(HashMap map, ParameterContainer pc) {
        boolean bMandatory;
        Parameter parameter;
        boolean bContainsOnlyOptionalObjects = true;
        ArrayList<Object> array = new ArrayList<Object>();
        CheckComboBox ccb = (CheckComboBox)pc.getContainer();
        List selectedObjects = ccb.getModel().getCheckeds();
        for (int i = 0; i < selectedObjects.size(); ++i) {
            try {
                ObjectAndDescription oad = (ObjectAndDescription)selectedObjects.get(i);
                array.add(oad.getObject());
                Parameter object = this.m_GlobalAlgorithm.getParameters().getParameter((String)oad.getObject());
                if (object instanceof ParameterDataObject) {
                    parameter = (ParameterDataObject)object;
                    bMandatory = ((AdditionalInfoDataObject)parameter.getParameterAdditionalInfo()).getIsMandatory();
                    if (!bMandatory) continue;
                    bContainsOnlyOptionalObjects = false;
                    continue;
                }
                if (!(object instanceof ParameterMultipleInput) || !(bMandatory = ((AdditionalInfoMultipleInput)(parameter = (ParameterMultipleInput)object).getParameterAdditionalInfo()).getIsMandatory())) continue;
                bContainsOnlyOptionalObjects = false;
                continue;
            }
            catch (WrongParameterIDException e) {
                bContainsOnlyOptionalObjects = false;
                continue;
            }
            catch (Exception e) {
                Sextante.addErrorToLog((Throwable)e);
                return false;
            }
        }
        parameter = pc.getParameter();
        try {
            bMandatory = ((AdditionalInfoMultipleInput)parameter.getParameterAdditionalInfo()).getIsMandatory();
            if (bMandatory && bContainsOnlyOptionalObjects) {
                return false;
            }
        }
        catch (NullParameterAdditionalInfoException e) {
            Sextante.addErrorToLog((Throwable)e);
            return false;
        }
        String sKey = parameter.getParameterName();
        String sArrayKey = this.getInnerParameterKey();
        map.put(sKey, sArrayKey);
        this.m_DataObjects.put(sArrayKey, new ObjectAndDescription("Multiple Input", array));
        return true;
    }

    protected boolean makeTableFieldAssignment(HashMap map, ParameterContainer parameterContainer) {
        Parameter parameter = null;
        String sKey = null;
        JComboBox comboBox = (JComboBox)parameterContainer.getContainer();
        JTextField textField = (JTextField)comboBox.getEditor().getEditorComponent();
        try {
            parameter = this.m_Algorithm.getParameters().getParameter(parameterContainer.getName());
            sKey = parameter.getParameterName();
            Object selItem = comboBox.getSelectedItem();
            ObjectAndDescription oad = (ObjectAndDescription)selItem;
            String sAssignment = (String)oad.getObject();
            map.put(sKey, sAssignment);
            return true;
        }
        catch (ClassCastException e) {
            String sInnerKey = this.getInnerParameterKey();
            map.put(sKey, sInnerKey);
            this.m_DataObjects.put(sInnerKey, new ObjectAndDescription("Field", (Object)textField.getText()));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected boolean makeSelectionAssignment(HashMap map, ParameterContainer parameterContainer) {
        try {
            JComboBox comboBox = (JComboBox)parameterContainer.getContainer();
            ParameterSelection parameter = (ParameterSelection)this.m_Algorithm.getParameters().getParameter(parameterContainer.getName());
            AdditionalInfoSelection ai = (AdditionalInfoSelection)parameter.getParameterAdditionalInfo();
            int iMaxIndex = ai.getValues().length;
            int iIndex = comboBox.getSelectedIndex();
            String sKey = parameter.getParameterName();
            if (iIndex >= iMaxIndex) {
                ObjectAndDescription[] values = this.getElementsOfClass(ModelElementSelection.class, true);
                String sAssignment = (String)values[iIndex - iMaxIndex].getObject();
                map.put(sKey, sAssignment);
                return true;
            }
            String sInnerKey = this.getInnerParameterKey();
            map.put(sKey, sInnerKey);
            Integer selection = new Integer(iIndex);
            this.m_DataObjects.put(sInnerKey, new ObjectAndDescription("Selection", (Object)selection));
            return true;
        }
        catch (NullParameterAdditionalInfoException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (WrongParameterIDException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        return false;
    }

    protected boolean makeRasterBandAssignment(HashMap map, ParameterContainer parameterContainer) {
        try {
            ParameterBand parameter = (ParameterBand)this.m_Algorithm.getParameters().getParameter(parameterContainer.getName());
            JComboBox comboBox = (JComboBox)parameterContainer.getContainer();
            int iMaxIndex = comboBox.getModel().getSize() - 10;
            int iIndex = comboBox.getSelectedIndex();
            String sKey = parameter.getParameterName();
            if (iIndex < iMaxIndex) {
                ObjectAndDescription[] values = this.getElementsOfClass(ModelElementBand.class, true);
                String sAssignment = (String)values[iIndex].getObject();
                map.put(sKey, sAssignment);
                return true;
            }
            String sInnerKey = this.getInnerParameterKey();
            map.put(sKey, sInnerKey);
            Integer selection = new Integer(iIndex - iMaxIndex);
            this.m_DataObjects.put(sInnerKey, new ObjectAndDescription("Band", (Object)selection));
            return true;
        }
        catch (WrongParameterIDException e) {
            Sextante.addErrorToLog((Throwable)e);
            return false;
        }
    }

    private boolean makeNumericalValueAssignment(HashMap map, ParameterContainer parameterContainer) {
        Parameter parameter = null;
        String sKey = null;
        JComboBox comboBox = (JComboBox)parameterContainer.getContainer();
        JTextField textField = (JTextField)comboBox.getEditor().getEditorComponent();
        String sValue = textField.getText();
        try {
            parameter = this.m_Algorithm.getParameters().getParameter(parameterContainer.getName());
            AdditionalInfoNumericalValue ai = (AdditionalInfoNumericalValue)parameter.getParameterAdditionalInfo();
            double dMin = ai.getMinValue();
            double dMax = ai.getMaxValue();
            sKey = parameter.getParameterName();
            Object ob = comboBox.getSelectedItem();
            if (ob instanceof ObjectAndDescription) {
                ObjectAndDescription oad = (ObjectAndDescription)ob;
                String sAssignment = (String)oad.getObject();
                map.put(sKey, sAssignment);
                return true;
            }
            try {
                double dValue = Double.parseDouble(sValue);
                if (dValue < dMin || dValue > dMax) {
                    return false;
                }
                String sInnerKey = this.getInnerParameterKey();
                map.put(sKey, sInnerKey);
                Double value = new Double(dValue);
                this.m_DataObjects.put(sInnerKey, new ObjectAndDescription("Numerical Value", (Object)value));
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
            return false;
        }
    }

    protected boolean makeFixedTableAssignment(HashMap map, ParameterContainer parameterContainer) {
        try {
            FixedTableSelectionPanel panel = (FixedTableSelectionPanel)parameterContainer.getContainer();
            Parameter parameter = this.m_Algorithm.getParameters().getParameter(parameterContainer.getName());
            String sKey = parameter.getParameterName();
            String sAssignment = panel.getTableKey();
            if (sAssignment == null) {
                FixedTableModel table = panel.getTableModel();
                String sInnerKey = this.getInnerParameterKey();
                map.put(sKey, sInnerKey);
                this.m_DataObjects.put(sInnerKey, new ObjectAndDescription("Fixed Table", (Object)table));
            } else {
                map.put(sKey, sAssignment);
            }
            return true;
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
            return false;
        }
    }

    protected boolean makeStringAssignment(HashMap map, ParameterContainer parameterContainer) {
        Parameter parameter = null;
        String sKey = null;
        JComboBox comboBox = (JComboBox)parameterContainer.getContainer();
        JTextField textField = (JTextField)comboBox.getEditor().getEditorComponent();
        try {
            parameter = this.m_Algorithm.getParameters().getParameter(parameterContainer.getName());
            sKey = parameter.getParameterName();
            Object selItem = comboBox.getSelectedItem();
            ObjectAndDescription oad = (ObjectAndDescription)selItem;
            String sAssignment = (String)oad.getObject();
            map.put(sKey, sAssignment);
            return true;
        }
        catch (Exception e) {
            String sInnerKey = this.getInnerParameterKey();
            map.put(sKey, sInnerKey);
            this.m_DataObjects.put(sInnerKey, new ObjectAndDescription("String", (Object)textField.getText()));
            return true;
        }
    }

    protected boolean makeFilepathAssignment(HashMap map, ParameterContainer parameterContainer) {
        Parameter parameter = null;
        String sKey = null;
        JComboBox comboBox = (JComboBox)parameterContainer.getContainer();
        JTextField textField = (JTextField)comboBox.getEditor().getEditorComponent();
        try {
            parameter = this.m_Algorithm.getParameters().getParameter(parameterContainer.getName());
            sKey = parameter.getParameterName();
            Object selItem = comboBox.getSelectedItem();
            ObjectAndDescription oad = (ObjectAndDescription)selItem;
            String sAssignment = (String)oad.getObject();
            map.put(sKey, sAssignment);
            return true;
        }
        catch (Exception e) {
            String sInnerKey = this.getInnerParameterKey();
            map.put(sKey, sInnerKey);
            this.m_DataObjects.put(sInnerKey, new ObjectAndDescription("String", (Object)textField.getText()));
            return true;
        }
    }

    protected boolean makeBooleanAssignment(HashMap map, ParameterContainer parameterContainer) {
        try {
            JComboBox comboBox = (JComboBox)parameterContainer.getContainer();
            ParameterBoolean parameter = (ParameterBoolean)this.m_Algorithm.getParameters().getParameter(parameterContainer.getName());
            int iIndex = comboBox.getSelectedIndex();
            String sKey = parameter.getParameterName();
            if (iIndex >= 2) {
                ObjectAndDescription[] values = this.getElementsOfClass(ModelElementBoolean.class, true);
                String sAssignment = (String)values[iIndex - 2].getObject();
                map.put(sKey, sAssignment);
                return true;
            }
            String sInnerKey = this.getInnerParameterKey();
            map.put(sKey, sInnerKey);
            Boolean bool = new Boolean(iIndex == 0);
            this.m_DataObjects.put(sInnerKey, new ObjectAndDescription("Boolean", (Object)bool));
            return true;
        }
        catch (WrongParameterIDException e) {
            Sextante.addErrorToLog((Throwable)e);
            return false;
        }
    }
}

