/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.modeler;

import es.unex.sextante.core.ObjectAndDescription;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.gui.modeler.ModelerPanel;
import es.unex.sextante.gui.modeler.parameters.BooleanPanel;
import es.unex.sextante.gui.modeler.parameters.FilepathPanel;
import es.unex.sextante.gui.modeler.parameters.FixedTablePanel;
import es.unex.sextante.gui.modeler.parameters.MultipleInputPanel;
import es.unex.sextante.gui.modeler.parameters.NumericalValuePanel;
import es.unex.sextante.gui.modeler.parameters.ParameterPanel;
import es.unex.sextante.gui.modeler.parameters.PointPanel;
import es.unex.sextante.gui.modeler.parameters.Raster3DLayerPanel;
import es.unex.sextante.gui.modeler.parameters.RasterBandPanel;
import es.unex.sextante.gui.modeler.parameters.RasterLayerPanel;
import es.unex.sextante.gui.modeler.parameters.SelectionPanel;
import es.unex.sextante.gui.modeler.parameters.StringPanel;
import es.unex.sextante.gui.modeler.parameters.TableFieldPanel;
import es.unex.sextante.gui.modeler.parameters.TablePanel;
import es.unex.sextante.gui.modeler.parameters.VectorLayerPanel;
import es.unex.sextante.modeler.elements.ModelElementFactory;
import es.unex.sextante.parameters.Parameter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class InputsPanel
extends JPanel {
    private JTree jTree;
    private JScrollPane jScrollPaneTree;
    private final HashMap m_DataObjects;
    private final ArrayList m_InputKeys;
    private final ModelerPanel m_ModelerPanel;
    private final JDialog m_Parent;

    public InputsPanel(ModelerPanel modelerPanel, JDialog parent) {
        this.m_DataObjects = modelerPanel.getDataObjects();
        this.m_InputKeys = modelerPanel.getInputKeys();
        this.m_ModelerPanel = modelerPanel;
        this.m_Parent = parent;
        this.initGUI();
    }

    private void initGUI() {
        this.jScrollPaneTree = new JScrollPane();
        this.jTree = new JTree();
        this.jScrollPaneTree.setViewportView(this.jTree);
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TreePath path = InputsPanel.this.jTree.getPathForLocation(e.getX(), e.getY());
                if (e.getClickCount() == 2) {
                    InputsPanel.this.addSelectedInput(path);
                }
            }
        };
        this.jTree.addMouseListener(ml);
        this.jTree.setCellRenderer(new MyCellRenderer());
        BorderLayout thisLayout = new BorderLayout();
        this.setLayout(thisLayout);
        this.add((Component)this.jScrollPaneTree, "Center");
        this.fillTree();
    }

    private void fillTree() {
        DefaultMutableTreeNode mainNode = new DefaultMutableTreeNode(Sextante.getText((String)"node_Inputs"));
        DefaultMutableTreeNode layersNode = new DefaultMutableTreeNode(Sextante.getText((String)"node_Layers"));
        mainNode.add(layersNode);
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(this.getNewVectorLayerPanel());
        layersNode.add(node);
        node = new DefaultMutableTreeNode(this.getNewRasterLayerPanel());
        layersNode.add(node);
        node = new DefaultMutableTreeNode(this.getNewRasterBandPanel());
        layersNode.add(node);
        node = new DefaultMutableTreeNode(this.getNew3DRasterLayerPanel());
        layersNode.add(node);
        DefaultMutableTreeNode valuesNode = new DefaultMutableTreeNode(Sextante.getText((String)"node_Values"));
        mainNode.add(valuesNode);
        node = new DefaultMutableTreeNode(this.getNewNumericalValuePanel());
        valuesNode.add(node);
        node = new DefaultMutableTreeNode(this.getNewStringPanel());
        valuesNode.add(node);
        node = new DefaultMutableTreeNode(this.getNewBooleanPanel());
        valuesNode.add(node);
        DefaultMutableTreeNode fandtNode = new DefaultMutableTreeNode(Sextante.getText((String)"node_Fields_and_Tables"));
        mainNode.add(fandtNode);
        node = new DefaultMutableTreeNode(this.getNewTableFieldPanel());
        fandtNode.add(node);
        node = new DefaultMutableTreeNode(this.getNewTablePanel());
        fandtNode.add(node);
        node = new DefaultMutableTreeNode(this.getNewFixedTablePanel());
        fandtNode.add(node);
        DefaultMutableTreeNode othersNode = new DefaultMutableTreeNode(Sextante.getText((String)"node_Others"));
        mainNode.add(othersNode);
        node = new DefaultMutableTreeNode(this.getNewFilepathPanel());
        othersNode.add(node);
        node = new DefaultMutableTreeNode(this.getNewPointPanel());
        othersNode.add(node);
        node = new DefaultMutableTreeNode(this.getNewMultipleInputPanel());
        othersNode.add(node);
        node = new DefaultMutableTreeNode(this.getNewSelectionPanel());
        othersNode.add(node);
        this.jTree.setModel(new DefaultTreeModel(mainNode));
    }

    public JTree getTree() {
        return this.jTree;
    }

    private Object getNewNumericalValuePanel() {
        if (this.m_Parent != null) {
            return new NumericalValuePanel(this.m_Parent, this.m_ModelerPanel);
        }
        return new NumericalValuePanel(this.m_ModelerPanel);
    }

    private Object getNewBooleanPanel() {
        if (this.m_Parent != null) {
            return new BooleanPanel(this.m_Parent, this.m_ModelerPanel);
        }
        return new BooleanPanel(this.m_ModelerPanel);
    }

    private Object getNewRasterLayerPanel() {
        if (this.m_Parent != null) {
            return new RasterLayerPanel(this.m_Parent, this.m_ModelerPanel);
        }
        return new RasterLayerPanel(this.m_ModelerPanel);
    }

    private Object getNewRasterBandPanel() {
        if (this.m_Parent != null) {
            return new RasterBandPanel(this.m_Parent, this.m_ModelerPanel);
        }
        return new RasterBandPanel(this.m_ModelerPanel);
    }

    private Object getNew3DRasterLayerPanel() {
        if (this.m_Parent != null) {
            return new Raster3DLayerPanel(this.m_Parent, this.m_ModelerPanel);
        }
        return new Raster3DLayerPanel(this.m_ModelerPanel);
    }

    private Object getNewVectorLayerPanel() {
        if (this.m_Parent != null) {
            return new VectorLayerPanel(this.m_Parent, this.m_ModelerPanel);
        }
        return new VectorLayerPanel(this.m_ModelerPanel);
    }

    private Object getNewStringPanel() {
        if (this.m_Parent != null) {
            return new StringPanel(this.m_Parent, this.m_ModelerPanel);
        }
        return new StringPanel(this.m_ModelerPanel);
    }

    private Object getNewTableFieldPanel() {
        if (this.m_Parent != null) {
            return new TableFieldPanel(this.m_Parent, this.m_ModelerPanel);
        }
        return new TableFieldPanel(this.m_ModelerPanel);
    }

    private Object getNewTablePanel() {
        if (this.m_Parent != null) {
            return new TablePanel(this.m_Parent, this.m_ModelerPanel);
        }
        return new TablePanel(this.m_ModelerPanel);
    }

    private Object getNewPointPanel() {
        if (this.m_Parent != null) {
            return new PointPanel(this.m_Parent, this.m_ModelerPanel);
        }
        return new PointPanel(this.m_ModelerPanel);
    }

    private Object getNewFixedTablePanel() {
        if (this.m_Parent != null) {
            return new FixedTablePanel(this.m_Parent, this.m_ModelerPanel);
        }
        return new FixedTablePanel(this.m_ModelerPanel);
    }

    private Object getNewSelectionPanel() {
        if (this.m_Parent != null) {
            return new SelectionPanel(this.m_Parent, this.m_ModelerPanel);
        }
        return new SelectionPanel(this.m_ModelerPanel);
    }

    private Object getNewMultipleInputPanel() {
        if (this.m_Parent != null) {
            return new MultipleInputPanel(this.m_Parent, this.m_ModelerPanel);
        }
        return new MultipleInputPanel(this.m_ModelerPanel);
    }

    private Object getNewFilepathPanel() {
        if (this.m_Parent != null) {
            return new FilepathPanel(this.m_Parent, this.m_ModelerPanel);
        }
        return new FilepathPanel(this.m_ModelerPanel);
    }

    public void addSelectedInput() {
        this.addSelectedInput(this.jTree.getSelectionPath());
    }

    protected void addSelectedInput(TreePath path) {
        if (path == null) {
            return;
        }
        try {
            ParameterPanel paramPanel;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (node.getUserObject() instanceof ParameterPanel && (paramPanel = (ParameterPanel)node.getUserObject()).parameterCanBeAdded()) {
                paramPanel.updateOptions();
                paramPanel.pack();
                paramPanel.setVisible(true);
                Parameter param = paramPanel.getParameter();
                if (param != null) {
                    String sKey = this.getValidName();
                    param.setParameterName(sKey);
                    this.m_ModelerPanel.getAlgorithm().addInput(param);
                    ObjectAndDescription oad = new ObjectAndDescription(param.getParameterDescription(), (Object)ModelElementFactory.getParameterAsModelElement((Parameter)param));
                    this.m_DataObjects.put(sKey, oad);
                    this.m_InputKeys.add(sKey);
                    this.m_ModelerPanel.setHasChanged(true);
                    this.m_ModelerPanel.getGraph().addInput(sKey);
                    this.m_ModelerPanel.updatePanel(true);
                }
            }
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public String getValidName() {
        String sName;
        boolean bFound;
        int i = 0;
        do {
            if (this.m_InputKeys.contains(sName = "INPUT" + Integer.toString(i))) {
                ++i;
                bFound = false;
                continue;
            }
            bFound = true;
        } while (!bFound);
        return sName;
    }

    class MyCellRenderer
    extends JLabel
    implements TreeCellRenderer {
        ImageIcon m_ModuleIcon = new ImageIcon(this.getClass().getClassLoader().getResource("images/list-add.png"));

        MyCellRenderer() {
        }

        protected Icon getCustomIcon(Object value) {
            if (((DefaultMutableTreeNode)value).getUserObject() instanceof ParameterPanel) {
                return this.m_ModuleIcon;
            }
            return null;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            this.setFont(tree.getFont());
            this.setIcon(this.getCustomIcon(value));
            String sName = tree.convertValueToText(value, sel, expanded, leaf, row, hasFocus);
            this.setEnabled(tree.isEnabled());
            this.setText(sName);
            try {
                if (!leaf) {
                    this.setFont(new Font("Tahoma", 1, 11));
                    this.setForeground(Color.black);
                } else {
                    ParameterPanel panel = (ParameterPanel)((DefaultMutableTreeNode)value).getUserObject();
                    if (!panel.parameterCanBeAdded()) {
                        this.setForeground(Color.gray);
                    } else if (sel) {
                        this.setForeground(Color.blue);
                    } else {
                        this.setForeground(Color.black);
                    }
                }
            }
            catch (ClassCastException e) {
                this.setForeground(Color.black);
            }
            return this;
        }
    }
}

