/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.modeler;

import es.unex.sextante.additionalInfo.AdditionalInfo3DRasterLayer;
import es.unex.sextante.additionalInfo.AdditionalInfoBand;
import es.unex.sextante.additionalInfo.AdditionalInfoBoolean;
import es.unex.sextante.additionalInfo.AdditionalInfoFilepath;
import es.unex.sextante.additionalInfo.AdditionalInfoFixedTable;
import es.unex.sextante.additionalInfo.AdditionalInfoMultipleInput;
import es.unex.sextante.additionalInfo.AdditionalInfoNumericalValue;
import es.unex.sextante.additionalInfo.AdditionalInfoRasterLayer;
import es.unex.sextante.additionalInfo.AdditionalInfoString;
import es.unex.sextante.additionalInfo.AdditionalInfoTable;
import es.unex.sextante.additionalInfo.AdditionalInfoTableField;
import es.unex.sextante.additionalInfo.AdditionalInfoVectorLayer;
import es.unex.sextante.core.ParametersSet;
import es.unex.sextante.exceptions.NullParameterAdditionalInfoException;
import es.unex.sextante.gui.modeler.ModelAlgorithm;
import es.unex.sextante.parameters.Parameter;
import es.unex.sextante.parameters.Parameter3DRasterLayer;
import es.unex.sextante.parameters.ParameterBand;
import es.unex.sextante.parameters.ParameterBoolean;
import es.unex.sextante.parameters.ParameterFilepath;
import es.unex.sextante.parameters.ParameterFixedTable;
import es.unex.sextante.parameters.ParameterMultipleInput;
import es.unex.sextante.parameters.ParameterNumericalValue;
import es.unex.sextante.parameters.ParameterPoint;
import es.unex.sextante.parameters.ParameterRasterLayer;
import es.unex.sextante.parameters.ParameterString;
import es.unex.sextante.parameters.ParameterTable;
import es.unex.sextante.parameters.ParameterTableField;
import es.unex.sextante.parameters.ParameterVectorLayer;

public class ModelCodeCreator {
    public static String getJavaCode(ModelAlgorithm alg) {
        StringBuffer code = new StringBuffer();
        ModelCodeCreator.addHeader(code, alg);
        ModelCodeCreator.addOpening(code, alg);
        ModelCodeCreator.addConstants(code, alg);
        ModelCodeCreator.addDefineCharacteristics(code, alg);
        ModelCodeCreator.addProcessAlgorithm(code, alg);
        ModelCodeCreator.addClosing(code, alg);
        return code.toString();
    }

    private static void addConstants(StringBuffer code, ModelAlgorithm alg) {
        ParametersSet params = alg.getParameters();
        for (int i = 0; i < params.getNumberOfParameters(); ++i) {
            Parameter param = params.getParameter(i);
            String sName = ModelCodeCreator.getParameterNameFromDescription(param);
            code.append("\tpublic static final String " + sName + "=\"" + sName + "\";\n");
        }
    }

    private static void addOpening(StringBuffer code, ModelAlgorithm alg) {
        code.append("\npublic class UnnamedAlgorithm extends  GeoAlgorithm {\n\n");
    }

    private static void addClosing(StringBuffer code, ModelAlgorithm alg) {
        code.append("}\n");
    }

    private static void addProcessAlgorithm(StringBuffer code, ModelAlgorithm alg) {
        code.append("\n\tpublic boolean processAlgorithm() {\n\n");
        String sAs = null;
        String sClass = null;
        ParametersSet params = alg.getParameters();
        for (int i = 0; i < params.getNumberOfParameters(); ++i) {
            String sName;
            Parameter param = params.getParameter(i);
            if (param instanceof ParameterRasterLayer) {
                sAs = "RasterLayer";
                sClass = "IRasterLayer";
            } else if (param instanceof ParameterMultipleInput) {
                sAs = "ArrayList";
                sClass = "ArrayList";
            } else if (param instanceof ParameterVectorLayer) {
                sAs = "VectorLayer";
                sClass = "IVectorLayer";
            } else if (param instanceof ParameterTable) {
                sAs = "Table";
                sClass = "ITable";
            } else if (param instanceof ParameterNumericalValue) {
                sAs = "Double";
                sClass = "Double";
            } else if (param instanceof ParameterString) {
                sAs = "String";
                sClass = "String";
            } else {
                if (param instanceof ParameterFixedTable) {
                    sAs = "Object";
                    sClass = "FixedTableModel";
                    sName = ModelCodeCreator.getParameterNameFromDescription(param);
                    code.append("\t\t" + sClass + " " + sName.toLowerCase() + " = (FixedTableModel) m_Parameters.getParameterValueAs" + sAs + "(" + sName + ");\n");
                    continue;
                }
                if (param instanceof ParameterPoint) {
                    sAs = "Point";
                    sClass = "Point2D";
                } else if (param instanceof ParameterBoolean) {
                    sAs = "Boolean";
                    sClass = "Boolean";
                }
            }
            sName = ModelCodeCreator.getParameterNameFromDescription(param);
            code.append("\t\t" + sClass + " " + sName.toLowerCase() + " = m_Parameters.getParameterValueAs" + sAs + "(" + sName + ");\n");
        }
        code.append("\n\t\treturn !m_Task.isCanceled();\n");
        code.append("\t}\n\n");
    }

    private static void addParameters(StringBuffer code, ModelAlgorithm alg) {
        StringBuffer dependentCode = new StringBuffer();
        ParametersSet params = alg.getParameters();
        for (int i = 0; i < params.getNumberOfParameters(); ++i) {
            String sType;
            AdditionalInfoRasterLayer ai2;
            Parameter param = params.getParameter(i);
            if (param instanceof ParameterRasterLayer) {
                try {
                    ai2 = (AdditionalInfoRasterLayer)param.getParameterAdditionalInfo();
                    code.append("\t\t\tm_Parameters.addInputRasterLayer(" + ModelCodeCreator.getParameterNameFromDescription(param) + ", \"" + param.getParameterDescription() + "\", " + new Boolean(ai2.getIsMandatory()).toString() + ");\n");
                }
                catch (NullParameterAdditionalInfoException ai2) {}
                continue;
            }
            if (param instanceof Parameter3DRasterLayer) {
                try {
                    ai2 = (AdditionalInfo3DRasterLayer)param.getParameterAdditionalInfo();
                    code.append("\t\t\tm_Parameters.addInput3DRasterLayer(" + ModelCodeCreator.getParameterNameFromDescription(param) + ", \"" + param.getParameterDescription() + "\", " + new Boolean(ai2.getIsMandatory()).toString() + ");\n");
                }
                catch (NullParameterAdditionalInfoException ai3) {}
                continue;
            }
            if (param instanceof ParameterMultipleInput) {
                try {
                    ai2 = (AdditionalInfoMultipleInput)param.getParameterAdditionalInfo();
                    switch (ai2.getDataType()) {
                        case 7: {
                            sType = "AdditionalInfoMultipleInput.DATA_TYPE_BAND";
                            break;
                        }
                        case 1: {
                            sType = "AdditionalInfoMultipleInput.DATA_TYPE_RASTER";
                            break;
                        }
                        case 8: {
                            sType = "AdditionalInfoMultipleInput.DATA_TYPE_RASTER_3D";
                            break;
                        }
                        case 6: {
                            sType = "AdditionalInfoMultipleInput.DATA_TYPE_TABLE";
                            break;
                        }
                        case 5: {
                            sType = "AdditionalInfoMultipleInput.DATA_TYPE_VECTOR_ANY";
                            break;
                        }
                        case 3: {
                            sType = "AdditionalInfoMultipleInput.DATA_TYPE_VECTOR_LINE";
                            break;
                        }
                        case 2: {
                            sType = "AdditionalInfoMultipleInput.DATA_TYPE_VECTOR_POINT";
                            break;
                        }
                        default: {
                            sType = "AdditionalInfoMultipleInput.DATA_TYPE_VECTOR_POLYGON";
                        }
                    }
                    code.append("\t\t\tm_Parameters.addMultipleInput(" + ModelCodeCreator.getParameterNameFromDescription(param) + ", \"" + param.getParameterDescription() + "\", " + sType + "," + new Boolean(ai2.getIsMandatory()).toString() + ");\n");
                }
                catch (NullParameterAdditionalInfoException ai4) {}
                continue;
            }
            if (param instanceof ParameterVectorLayer) {
                try {
                    ai2 = (AdditionalInfoVectorLayer)param.getParameterAdditionalInfo();
                    switch (ai2.getShapeType()) {
                        case -1: {
                            sType = "AdditionalInfoVectorLayer.SHAPE_TYPE_ANY";
                            break;
                        }
                        case 1: {
                            sType = "AdditionalInfoVectorLayer.SHAPE_TYPE_LINE";
                            break;
                        }
                        case 0: {
                            sType = "AdditionalInfoVectorLayer.SHAPE_TYPE_POINT";
                            break;
                        }
                        default: {
                            sType = "AdditionalInfoVectorLayer.SHAPE_TYPE_POLYGON";
                        }
                    }
                    code.append("\t\t\tm_Parameters.addInputVectorLayer(" + ModelCodeCreator.getParameterNameFromDescription(param) + ", \"" + param.getParameterDescription() + "\", " + sType + ", " + new Boolean(ai2.getIsMandatory()).toString() + ");\n");
                }
                catch (NullParameterAdditionalInfoException ai5) {}
                continue;
            }
            if (param instanceof ParameterTable) {
                try {
                    ai2 = (AdditionalInfoTable)param.getParameterAdditionalInfo();
                    code.append("\t\t\tm_Parameters.addInputTable(" + ModelCodeCreator.getParameterNameFromDescription(param) + ", \"" + param.getParameterDescription() + "\", " + new Boolean(ai2.getIsMandatory()).toString() + ");\n");
                }
                catch (NullParameterAdditionalInfoException ai6) {}
                continue;
            }
            if (param instanceof ParameterNumericalValue) {
                try {
                    ai2 = (AdditionalInfoNumericalValue)param.getParameterAdditionalInfo();
                    switch (ai2.getType()) {
                        case 1: {
                            sType = "AdditionalInfoNumericalValue.NUMERICAL_VALUE_INTEGER";
                            break;
                        }
                        default: {
                            sType = "AdditionalInfoNumericalValue.NUMERICAL_VALUE_DOUBLE";
                        }
                    }
                    code.append("\t\t\tm_Parameters.addNumericalValue(" + ModelCodeCreator.getParameterNameFromDescription(param) + ", \"" + param.getParameterDescription() + "\", " + sType + ", " + Double.toString(ai2.getDefaultValue()) + ", " + Double.toString(ai2.getMinValue()) + ", " + Double.toString(ai2.getMaxValue()) + ");\n");
                }
                catch (NullParameterAdditionalInfoException ai7) {}
                continue;
            }
            if (param instanceof ParameterString) {
                try {
                    ai2 = (AdditionalInfoString)param.getParameterAdditionalInfo();
                    code.append("\t\t\tm_Parameters.addString(" + ModelCodeCreator.getParameterNameFromDescription(param) + ", \"" + param.getParameterDescription() + "\", " + ai2.getDefaultString().toString() + ");\n");
                }
                catch (NullParameterAdditionalInfoException ai8) {}
                continue;
            }
            if (param instanceof ParameterFilepath) {
                try {
                    ai2 = (AdditionalInfoFilepath)param.getParameterAdditionalInfo();
                    String ext = ai2.getExtensions() != null && ai2.getExtensions().length > 0 && ai2.getExtensions()[0] != null && ai2.getExtensions()[0].length() > 0 ? new String(ai2.getExtensions()[0]) : new String("");
                    code.append("\t\t\tm_Parameters.addFilepath(" + ModelCodeCreator.getParameterNameFromDescription(param) + ", \"" + param.getParameterDescription() + "\", " + new Boolean(ai2.isFolder()).toString() + "\", " + new Boolean(ai2.isOpenDialog()).toString() + "\", " + new Boolean(ai2.getIsVoxelData()).toString() + "\", " + ext + ");\n");
                }
                catch (NullParameterAdditionalInfoException ai9) {}
                continue;
            }
            if (param instanceof ParameterFixedTable) {
                try {
                    ai2 = (AdditionalInfoFixedTable)param.getParameterAdditionalInfo();
                    code.append("\t\t\tm_Parameters.addFixedTable(" + ModelCodeCreator.getParameterNameFromDescription(param) + ", \"" + param.getParameterDescription() + "\", " + ai2.getRowsCount() + ", " + ai2.getColsCount() + ", " + Boolean.toString(ai2.isNumberOfRowsFixed()) + ");\n");
                }
                catch (NullParameterAdditionalInfoException ai10) {}
                continue;
            }
            if (param instanceof ParameterPoint) {
                code.append("\t\t\tm_Parameters.addString(" + ModelCodeCreator.getParameterNameFromDescription(param) + ", \"" + param.getParameterDescription() + "\");\n");
                continue;
            }
            if (param instanceof ParameterBoolean) {
                try {
                    ai2 = (AdditionalInfoBoolean)param.getParameterAdditionalInfo();
                    code.append("\t\t\tm_Parameters.addBoolean(" + ModelCodeCreator.getParameterNameFromDescription(param) + ", \"" + param.getParameterDescription() + "\", " + Boolean.toString(ai2.getDefaultValue()) + ");\n");
                }
                catch (NullParameterAdditionalInfoException ai11) {}
                continue;
            }
            if (param instanceof ParameterBand) {
                try {
                    ai2 = (AdditionalInfoBand)param.getParameterAdditionalInfo();
                    dependentCode.append("\t\t\tm_Parameters.addBand(" + ModelCodeCreator.getParameterNameFromDescription(param) + ", \"" + param.getParameterDescription() + "\", " + ai2.getParentParameterName() + ");\n");
                }
                catch (NullParameterAdditionalInfoException ai12) {}
                continue;
            }
            if (!(param instanceof ParameterTableField)) continue;
            try {
                ai2 = (AdditionalInfoTableField)param.getParameterAdditionalInfo();
                dependentCode.append("\t\t\tm_Parameters.addTableField(" + ModelCodeCreator.getParameterNameFromDescription(param) + ", \"" + param.getParameterDescription() + "\", " + ai2.getParentParameterName() + ");\n");
                continue;
            }
            catch (NullParameterAdditionalInfoException nullParameterAdditionalInfoException) {
                // empty catch block
            }
        }
        code.append(dependentCode);
    }

    private static String getParameterNameFromDescription(Parameter param) {
        String sDesc = param.getParameterDescription();
        return sDesc.replaceAll(" ", "_").toUpperCase();
    }

    private static void addDefineCharacteristics(StringBuffer code, ModelAlgorithm alg) {
        code.append("\n\tpublic void defineCharacteristics() {\n\n");
        code.append("\t\tsetName(Sextante.getText(\"" + alg.getName() + "\");\n");
        code.append("\t\tsetGroup(Sextante.getText(\"" + alg.getGroup() + "\");\n");
        code.append("\n");
        code.append("\t\ttry{\n");
        ModelCodeCreator.addParameters(code, alg);
        code.append("\t\t}\n");
        code.append("\t\tcatch(Exception e){}\n");
        code.append("\t}\n\n");
    }

    private static void addHeader(StringBuffer code, ModelAlgorithm alg) {
    }
}

