/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.modeler.parameters;

import es.unex.sextante.additionalInfo.AdditionalInfo;
import es.unex.sextante.additionalInfo.AdditionalInfoNumericalValue;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.exceptions.NullParameterAdditionalInfoException;
import es.unex.sextante.gui.modeler.ModelerPanel;
import es.unex.sextante.gui.modeler.parameters.ParameterPanel;
import es.unex.sextante.parameters.Parameter;
import es.unex.sextante.parameters.ParameterNumericalValue;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class NumericalValuePanel
extends ParameterPanel {
    private static int typeFloat = 0;
    private static int typeInteger = 1;
    private JCheckBox jCheckBoxMin;
    private JCheckBox jCheckBoxMax;
    private JLabel jLabelType;
    private JTextField jTextFieldMin;
    private JTextField jTextFieldMax;
    private JTextField jTextFieldDefault;
    private JComboBox jComboBoxType;
    private JLabel jLabelDefault;

    public NumericalValuePanel(JDialog parent, ModelerPanel panel) {
        super(parent, panel);
    }

    public NumericalValuePanel(ModelerPanel panel) {
        super(panel);
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        super.setTitle(Sextante.getText((String)"modeler_add_par_numerical"));
        super.setPreferredSize(new Dimension(400, 290));
        try {
            TableLayout thisLayout = new TableLayout((double[][])new double[][]{{-3.0, 5.0, -1.0}, {-3.0, 1.0, -3.0, 1.0, -3.0, 1.0, -3.0}});
            thisLayout.setHGap(5);
            thisLayout.setVGap(5);
            this.jPanelMiddle.setLayout((LayoutManager)thisLayout);
            this.jCheckBoxMin = new JCheckBox();
            this.jCheckBoxMin.setText(Sextante.getText((String)"Min_value"));
            this.jPanelMiddle.add((Component)this.jCheckBoxMin, "0, 0");
            this.jCheckBoxMin.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (NumericalValuePanel.this.jCheckBoxMin.isSelected()) {
                        NumericalValuePanel.this.jTextFieldMin.setEnabled(true);
                        NumericalValuePanel.this.jTextFieldMin.setEditable(true);
                    } else {
                        NumericalValuePanel.this.jTextFieldMin.setEnabled(false);
                        NumericalValuePanel.this.jTextFieldMin.setEditable(false);
                    }
                }
            });
            this.jCheckBoxMax = new JCheckBox();
            this.jCheckBoxMax.setText(Sextante.getText((String)"Max_value"));
            this.jPanelMiddle.add((Component)this.jCheckBoxMax, "0, 2");
            this.jCheckBoxMax.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (NumericalValuePanel.this.jCheckBoxMax.isSelected()) {
                        NumericalValuePanel.this.jTextFieldMax.setEnabled(true);
                        NumericalValuePanel.this.jTextFieldMax.setEditable(true);
                    } else {
                        NumericalValuePanel.this.jTextFieldMax.setEnabled(false);
                        NumericalValuePanel.this.jTextFieldMax.setEditable(false);
                    }
                }
            });
            this.jTextFieldMin = new JTextField();
            if (!this.jCheckBoxMin.isSelected()) {
                this.jTextFieldMin.setEnabled(false);
                this.jTextFieldMin.setEditable(false);
            } else {
                this.jTextFieldMin.setEnabled(true);
                this.jTextFieldMin.setEditable(true);
            }
            this.jPanelMiddle.add((Component)this.jTextFieldMin, "2, 0");
            this.jTextFieldMin.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    NumericalValuePanel.this.checkTextFieldContent((JTextField)e.getSource());
                }
            });
            this.jTextFieldMax = new JTextField();
            if (!this.jCheckBoxMax.isSelected()) {
                this.jTextFieldMax.setEnabled(false);
                this.jTextFieldMax.setEditable(false);
            } else {
                this.jTextFieldMax.setEnabled(true);
                this.jTextFieldMax.setEditable(true);
            }
            this.jPanelMiddle.add((Component)this.jTextFieldMax, "2, 2");
            this.jTextFieldMax.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    NumericalValuePanel.this.checkTextFieldContent((JTextField)e.getSource());
                }
            });
            this.jLabelDefault = new JLabel();
            this.jPanelMiddle.add((Component)this.jLabelDefault, "0, 4");
            this.jLabelDefault.setText(Sextante.getText((String)"Default_value"));
            this.jTextFieldDefault = new JTextField();
            this.jPanelMiddle.add((Component)this.jTextFieldDefault, "2, 4");
            this.jTextFieldDefault.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    NumericalValuePanel.this.checkTextFieldContent((JTextField)e.getSource());
                }
            });
            this.jLabelType = new JLabel();
            this.jPanelMiddle.add((Component)this.jLabelType, "0, 6");
            this.jLabelType.setText(Sextante.getText((String)"Value_type"));
            DefaultComboBoxModel<String> jComboBoxTypeModel = new DefaultComboBoxModel<String>(new String[]{Sextante.getText((String)"Float"), Sextante.getText((String)"Integer")});
            this.jComboBoxType = new JComboBox();
            this.jPanelMiddle.add((Component)this.jComboBoxType, "2, 6");
            this.jComboBoxType.setModel(jComboBoxTypeModel);
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private double truncNumeric(String number) throws Exception {
        Integer Value = Integer.parseInt(number);
        return Value.intValue();
    }

    @Override
    protected boolean prepareParameter() {
        double dMax;
        double dMin;
        double dDefault;
        int iType;
        try {
            double dAbsoluteMax;
            double dAbsoluteMin;
            if (this.jComboBoxType.getSelectedIndex() == typeInteger) {
                iType = 1;
                dAbsoluteMin = -2.147483648E9;
                dAbsoluteMax = 2.147483647E9;
            } else {
                iType = 2;
                dAbsoluteMin = Double.NEGATIVE_INFINITY;
                dAbsoluteMax = Double.MAX_VALUE;
            }
            dDefault = iType == 1 ? this.truncNumeric(this.jTextFieldDefault.getText()) : Double.parseDouble(this.jTextFieldDefault.getText());
            dMin = this.jCheckBoxMin.isSelected() ? (iType == 1 ? this.truncNumeric(this.jTextFieldMin.getText()) : Double.parseDouble(this.jTextFieldMin.getText())) : dAbsoluteMin;
            dMax = this.jCheckBoxMax.isSelected() ? (iType == 1 ? this.truncNumeric(this.jTextFieldMax.getText()) : Double.parseDouble(this.jTextFieldMax.getText())) : dAbsoluteMax;
            if (dDefault < dMin || dDefault > dMax || dMin > dMax) {
                JOptionPane.showMessageDialog(null, Sextante.getText((String)"Invalid_parameters"), Sextante.getText((String)"Warning"), 2);
                return false;
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, Sextante.getText((String)"Invalid_parameters"), Sextante.getText((String)"Warning"), 2);
            return false;
        }
        String sDescription = this.jTextFieldDescription.getText();
        if (sDescription.length() != 0) {
            AdditionalInfoNumericalValue addInfo = new AdditionalInfoNumericalValue(iType, dDefault, Math.min(dMin, dMax), Math.max(dMin, dMax));
            this.m_Parameter = new ParameterNumericalValue();
            this.m_Parameter.setParameterAdditionalInfo((AdditionalInfo)addInfo);
            this.m_Parameter.setParameterDescription(this.jTextFieldDescription.getText());
            this.m_Parameter.setColorR(this.m_Color.getRed());
            this.m_Parameter.setColorG(this.m_Color.getGreen());
            this.m_Parameter.setColorB(this.m_Color.getBlue());
            this.m_Parameter.setColorAlpha(this.m_Color.getAlpha());
            return true;
        }
        JOptionPane.showMessageDialog(null, Sextante.getText((String)"Invalid_description"), Sextante.getText((String)"Warning"), 2);
        return false;
    }

    @Override
    public void setParameter(Parameter param) {
        super.setParameter(param);
        boolean isInt = false;
        try {
            AdditionalInfoNumericalValue ai = (AdditionalInfoNumericalValue)param.getParameterAdditionalInfo();
            if (ai.getType() == 1) {
                this.jComboBoxType.setSelectedIndex(typeInteger);
                isInt = true;
            } else {
                this.jComboBoxType.setSelectedIndex(typeFloat);
            }
            if (ai.getMaxValue() != Double.MAX_VALUE && ai.getMaxValue() != 2.147483647E9) {
                this.jCheckBoxMax.setSelected(true);
                this.jTextFieldMax.setEnabled(true);
                this.jTextFieldMax.setEditable(true);
                if (!isInt) {
                    this.jTextFieldMax.setText(Double.toString(ai.getMaxValue()));
                } else {
                    this.jTextFieldMax.setText(Integer.toString((int)ai.getMaxValue()));
                }
            }
            if (ai.getMinValue() != Double.NEGATIVE_INFINITY && ai.getMinValue() != -2.147483648E9) {
                this.jCheckBoxMin.setSelected(true);
                this.jTextFieldMin.setEnabled(true);
                this.jTextFieldMin.setEditable(true);
                if (!isInt) {
                    this.jTextFieldMin.setText(Double.toString(ai.getMinValue()));
                } else {
                    this.jTextFieldMin.setText(Integer.toString((int)ai.getMinValue()));
                }
            }
            if (!isInt) {
                this.jTextFieldDefault.setText(Double.toString(ai.getDefaultValue()));
            } else {
                this.jTextFieldDefault.setText(Integer.toString((int)ai.getDefaultValue()));
            }
        }
        catch (NullParameterAdditionalInfoException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getParameterDescription() {
        return Sextante.getText((String)"Numerical_value");
    }

    private void checkTextFieldContent(JTextField textField) {
        String content = textField.getText();
        if (content.length() != 0) {
            try {
                Double.parseDouble(content);
                return;
            }
            catch (NumberFormatException nfe) {
                this.getToolkit().beep();
                textField.requestFocus();
            }
        }
    }

    @Override
    public boolean parameterCanBeAdded() {
        return true;
    }
}

