/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.gui.settings;

import es.unex.sextante.core.Sextante;
import es.unex.sextante.gui.algorithm.FileSelectionPanel;
import es.unex.sextante.gui.core.SextanteGUI;
import es.unex.sextante.gui.exceptions.WrongSettingValuesException;
import es.unex.sextante.gui.settings.AlgorithmGroupsConfigurationDialog;
import es.unex.sextante.gui.settings.SettingPanel;
import es.unex.sextante.gui.toolbox.AlgorithmGroupConfiguration;
import es.unex.sextante.gui.toolbox.AlgorithmGroupsOrganizer;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class SextanteGeneralSettingsPanel
extends SettingPanel {
    private JCheckBox jCheckBoxChangeNames;
    private JLabel jLabelResults;
    private FileSelectionPanel jFolderResults;
    private JLabel jLabelNoDataValue;
    private JLabel jLabelToolboxSettings;
    private JLabel jLabelConfigPath;
    private JTextField jTextFieldNoData;
    private JCheckBox jCheckBoxUseInternalNames;
    private JButton jButtonConfigureGroups;
    private JCheckBox jCheckBoxShowMostRecent;
    private JTextField jTextFieldConfigPath;

    @Override
    protected void initGUI() {
        TableLayout thisLayout = new TableLayout((double[][])new double[][]{{3.0, -1.0, -1.0, 3.0}, {3.0, -3.0, -3.0, -3.0, -3.0, -3.0, -3.0, -3.0, -3.0, -1.0, -3.0, 3.0}});
        thisLayout.setHGap(5);
        thisLayout.setVGap(5);
        this.setLayout((LayoutManager)thisLayout);
        boolean bUseInternalNames = new Boolean(SextanteGUI.getSettingParameterValue("UseInternalNames"));
        boolean bModiFyResultsNames = new Boolean(SextanteGUI.getSettingParameterValue("ModifyNames"));
        boolean bShowMostRecent = new Boolean(SextanteGUI.getSettingParameterValue("ShowMostRecent"));
        this.jLabelResults = new JLabel();
        this.add((Component)this.jLabelResults, "1, 1");
        this.jLabelResults.setText(Sextante.getText((String)"Output_folder"));
        this.jFolderResults = new FileSelectionPanel(true, true, (String[])null, Sextante.getText((String)"selector_choose_folder"));
        this.add((Component)this.jFolderResults, "2,1");
        this.jFolderResults.setFilepath(SextanteGUI.getOutputFolder());
        this.jCheckBoxChangeNames = new JCheckBox();
        this.jCheckBoxChangeNames.setText(Sextante.getText((String)"Modify_output_names"));
        this.jCheckBoxChangeNames.setSelected(bModiFyResultsNames);
        this.add((Component)this.jCheckBoxChangeNames, "1, 2, 2, 2");
        this.jCheckBoxUseInternalNames = new JCheckBox();
        this.jCheckBoxUseInternalNames.setText(Sextante.getText((String)"Use_internal_names_for_outputs"));
        this.jCheckBoxUseInternalNames.setSelected(bUseInternalNames);
        this.add((Component)this.jCheckBoxUseInternalNames, "1, 3, 2, 3");
        this.add((Component)new JSeparator(0), "1, 4, 2, 4");
        this.jLabelNoDataValue = new JLabel();
        this.jLabelNoDataValue.setText(Sextante.getText((String)"Default_no_data_value"));
        this.add((Component)this.jLabelNoDataValue, "1, 5");
        this.jTextFieldNoData = new JTextField();
        String sNoDataValue = Double.toString(SextanteGUI.getOutputFactory().getDefaultNoDataValue());
        this.jTextFieldNoData.setText(sNoDataValue);
        this.add((Component)this.jTextFieldNoData, "2, 5");
        this.add((Component)new JSeparator(0), "1, 6, 2, 6");
        this.jButtonConfigureGroups = new JButton(Sextante.getText((String)"ConfigureAlgGroups") + "...");
        this.jButtonConfigureGroups.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SextanteGeneralSettingsPanel.this.configureGroups();
            }
        });
        this.add((Component)this.jButtonConfigureGroups, "2, 7, 2, 7");
        this.jLabelToolboxSettings = new JLabel();
        this.jLabelToolboxSettings.setText(Sextante.getText((String)"Toolbox"));
        this.add((Component)this.jLabelToolboxSettings, "1, 7");
        this.jCheckBoxShowMostRecent = new JCheckBox(Sextante.getText((String)"ShowMostRecent"));
        this.jCheckBoxShowMostRecent.setSelected(bShowMostRecent);
        this.add((Component)this.jCheckBoxShowMostRecent, "1, 8, 2, 8");
        this.jLabelConfigPath = new JLabel();
        this.jLabelConfigPath.setText(Sextante.getText((String)"Config_path_label"));
        this.add((Component)this.jLabelConfigPath, "1, 10");
        this.jTextFieldConfigPath = new JTextField();
        this.jTextFieldConfigPath.setText(SextanteGUI.getUserFolder());
        this.jTextFieldConfigPath.setEditable(false);
        this.add((Component)this.jTextFieldConfigPath, "2, 10");
    }

    protected void configureGroups() {
        AlgorithmGroupsConfigurationDialog dialog = new AlgorithmGroupsConfigurationDialog();
        dialog.setVisible(true);
        HashMap<String, AlgorithmGroupConfiguration> map = dialog.getGrouppingsMap();
        if (map != null) {
            AlgorithmGroupsOrganizer.setConfiguration(map);
            AlgorithmGroupsOrganizer.saveSettings();
        }
    }

    @Override
    public HashMap<String, String> getValues() throws WrongSettingValuesException {
        HashMap<String, String> map = new HashMap<String, String>();
        String path = this.jFolderResults.getFilepath();
        if (path != null) {
            map.put("ResultsFolder", path);
        }
        map.put("ModifyNames", new Boolean(this.jCheckBoxChangeNames.isSelected()).toString());
        map.put("UseInternalNames", new Boolean(this.jCheckBoxUseInternalNames.isSelected()).toString());
        map.put("ShowMostRecent", new Boolean(this.jCheckBoxShowMostRecent.isSelected()).toString());
        try {
            double dValue = Double.parseDouble(this.jTextFieldNoData.getText());
            SextanteGUI.getOutputFactory().setDefaultNoDataValue(dValue);
        }
        catch (Exception e) {
            throw new WrongSettingValuesException();
        }
        map.put("NoDataValue", this.jTextFieldNoData.getText());
        return map;
    }
}

