/*
 * Decompiled with CFR 0.152.
 */
package jsh.shell;

import es.unex.sextante.gui.core.SextanteGUI;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;

public class Utils {
    public static String[] subarray(String[] arr, int first, int last) {
        String[] newArr = new String[last - first + 1];
        int i = 0;
        while (i < newArr.length) {
            newArr[i] = arr[first];
            ++i;
            ++first;
        }
        return newArr;
    }

    public static String[] subarray(String[] arr, int first) {
        return Utils.subarray(arr, first, arr.length - 1);
    }

    public static String fmtBytes(long bytes) {
        return Long.toString(bytes / 1024L) + "K";
    }

    public static String fmtTime(long ms) {
        return Float.toString((float)ms / 1000.0f) + "s";
    }

    public static String getSpaces(int len) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            buf.append(' ');
        }
        return buf.toString();
    }

    public static String[] toArray(Vector strings) {
        String[] arr = new String[strings.size()];
        for (int i = 0; i < strings.size(); ++i) {
            arr[i] = (String)strings.elementAt(i);
        }
        return arr;
    }

    public static String[] getWildCardMatches(String s, boolean sort) {
        String args = new String(s.trim());
        Vector<String> filesThatMatchVector = new Vector<String>();
        String[] files = new File(Utils.getUserDirectory()).list();
        for (int i = 0; i < files.length; ++i) {
            if (!Utils.match(args, files[i])) continue;
            File temp = new File(Utils.getUserDirectory(), files[i]);
            filesThatMatchVector.addElement(new String(temp.getName()));
        }
        Object[] filesThatMatch = new String[filesThatMatchVector.size()];
        filesThatMatchVector.copyInto(filesThatMatch);
        if (sort) {
            Utils.sortStrings((String[])filesThatMatch);
        }
        return filesThatMatch;
    }

    public static boolean match(String pattern, String string) {
        int p = 0;
        while (true) {
            int s = 0;
            while (true) {
                boolean pEnd;
                boolean sEnd = s >= string.length();
                boolean bl = pEnd = p >= pattern.length() || pattern.charAt(p) == '|';
                if (sEnd && pEnd) {
                    return true;
                }
                if (sEnd || pEnd) break;
                if (pattern.charAt(p) != '?') {
                    if (pattern.charAt(p) == '*') {
                        ++p;
                        for (int i = string.length(); i >= s; --i) {
                            if (!Utils.match(pattern.substring(p), string.substring(i))) continue;
                            return true;
                        }
                        break;
                    }
                    if (pattern.charAt(p) != string.charAt(s)) break;
                }
                ++p;
                ++s;
            }
            if ((p = pattern.indexOf(124, p)) == -1) {
                return false;
            }
            ++p;
        }
    }

    public static void sortStrings(String[] strings) {
        Utils.sortStrings(strings, 0, strings.length - 1);
    }

    public static void sortStrings(String[] a, int lo0, int hi0) {
        int lo = lo0;
        int hi = hi0;
        if (hi0 > lo0) {
            String mid = a[(lo0 + hi0) / 2];
            while (lo <= hi) {
                while (lo < hi0 && a[lo].compareTo(mid) < 0) {
                    ++lo;
                }
                while (hi > lo0 && a[hi].compareTo(mid) > 0) {
                    --hi;
                }
                if (lo > hi) continue;
                Utils.swap(a, lo, hi);
                ++lo;
                --hi;
            }
            if (lo0 < hi) {
                Utils.sortStrings(a, lo0, hi);
            }
            if (lo < hi0) {
                Utils.sortStrings(a, lo, hi0);
            }
        }
    }

    public static void swap(String[] a, int i, int j) {
        String T = a[i];
        a[i] = a[j];
        a[j] = T;
    }

    public static String getUserDirectory() {
        String folder = SextanteGUI.getOutputFolder();
        if (folder == null) {
            folder = System.getProperty("user.home");
        }
        return folder;
    }

    public static String getShortStringOf(String longString, int maxLength) {
        int len = longString.length();
        if (len < maxLength) {
            return longString;
        }
        return longString.substring(0, maxLength / 2) + "..." + longString.substring(len - maxLength / 2);
    }

    public static File[] listFiles(String[] names, boolean construct) {
        File[] files = new File[names.length];
        String path = Utils.getUserDirectory();
        if (construct && !path.endsWith(File.separator)) {
            path = path + File.separator;
        }
        for (int i = 0; i < files.length; ++i) {
            files[i] = construct ? new File(path + names[i]) : new File(names[i]);
        }
        return files;
    }

    public static int getSize(Enumeration enu) {
        int size = 0;
        while (enu.hasMoreElements()) {
            ++size;
            enu.nextElement();
        }
        return size;
    }

    public static String constructPath(String change) {
        if (change == null || Utils.beginsWithRoot(change)) {
            return change;
        }
        String newPath = Utils.getUserDirectory();
        int lastChar = 0;
        boolean toAdd = false;
        StringBuffer buf = new StringBuffer(change.length());
        block5: for (int i = 0; i < change.length(); ++i) {
            int current = change.charAt(i);
            switch (current) {
                case 46: {
                    if (lastChar == 46) {
                        String parent = new File(newPath).getParent();
                        if (parent != null) {
                            newPath = parent;
                        }
                    } else if (lastChar != 0 && lastChar != 92 && lastChar != 47) {
                        buf.append('.');
                    }
                    lastChar = 46;
                    continue block5;
                }
                case 47: 
                case 92: {
                    if (lastChar == 0) {
                        newPath = Utils.getRoot(newPath);
                    } else {
                        newPath = !newPath.endsWith("\\") ? newPath + File.separator + buf.toString() : newPath + buf.toString();
                        buf = new StringBuffer();
                        toAdd = false;
                    }
                    lastChar = 92;
                    continue block5;
                }
                case 126: {
                    if (i < change.length() - 1) {
                        if (change.charAt(i + 1) == '\\' || change.charAt(i + 1) == '/') {
                            newPath = System.getProperties().getProperty("user.home");
                        } else {
                            buf.append('~');
                        }
                    } else if (i == 0) {
                        newPath = System.getProperties().getProperty("user.home");
                    } else {
                        buf.append('~');
                    }
                    lastChar = 126;
                    continue block5;
                }
                default: {
                    lastChar = current;
                    buf.append((char)current);
                    toAdd = true;
                }
            }
        }
        if (toAdd) {
            newPath = !newPath.endsWith(File.separator) ? newPath + File.separator + buf.toString() : newPath + buf.toString();
        }
        return newPath;
    }

    public static String getRoot(String path) {
        File[] roots = Utils.listRoots(new File(path));
        for (int i = 0; i < roots.length; ++i) {
            if (!path.startsWith(roots[i].getPath())) continue;
            return roots[i].getPath();
        }
        return path;
    }

    public static boolean beginsWithRoot(String path) {
        File[] roots = Utils.listRoots(new File(path));
        for (int i = 0; i < roots.length; ++i) {
            if (!path.regionMatches(true, 0, roots[i].getPath(), 0, roots[i].getPath().length())) continue;
            return true;
        }
        return false;
    }

    public static File[] listRoots(File f) {
        if (System.getProperty("os.name").startsWith("Windows")) {
            return new File[]{new File("A:\\"), new File("B:\\"), new File("C:\\"), new File("D:\\"), new File("E:\\"), new File("F:\\"), new File("G:\\"), new File("H:\\"), new File("I:\\")};
        }
        return new File[]{new File("/")};
    }

    public boolean isHidden(File file) {
        return false;
    }
}

