/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.fmap.mapcontext.rendering.legend.styling;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import org.apache.batik.ext.awt.geom.DefaultPathLength;
import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IProjection;
import org.gvsig.compat.print.PrintAttributes;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontext.layers.vectorial.SpatialEvaluatorsFactory;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.ILabelingMethod;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.IPlacementConstraints;
import org.gvsig.fmap.mapcontext.rendering.legend.styling.IZoomConstraints;
import org.gvsig.symbology.fmap.mapcontext.rendering.legend.styling.DefaultLabelingMethod;
import org.gvsig.symbology.fmap.mapcontext.rendering.legend.styling.IAttrInTableLabelingStrategy;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.impl.AbstractCartographicSupport;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.text.impl.SimpleTextSymbol;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.evaluator.Evaluator;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.task.Cancellable;
import org.gvsig.tools.util.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttrInTableLabelingStrategy
extends AbstractCartographicSupport
implements IAttrInTableLabelingStrategy {
    private static final String FIELD_LABELING_METHOD = "labelingMethod";
    private static final String FIELD_ZOOM_CONSTRAINTS = "zoomConstraints";
    private static final String FIELD_COLOR_FONT = "colorFont";
    private static final String FIELD_REFERENCE_SYSTEM = "referenceSystem";
    private static final String FIELD_FIXED_COLOR = "fixedColor";
    private static final String FIELD_USE_FIXED_COLOR = "useFixedColor";
    private static final String FIELD_FIXED_SIZE = "fixedSize";
    private static final String FIELD_USE_FIXED_SIZE = "useFixedSize";
    private static final String FIELD_FONT = "font";
    private static final String FIELD_UNIT = "Unit";
    private static final String FIELD_ROTATION = "RotationField";
    private static final String FIELD_COLOR = "ColorField";
    private static final String FIELD_HEIGHT = "HeightField";
    private static final String FIELD_TEXT = "TextField";
    private static final Logger logger = LoggerFactory.getLogger(AttrInTableLabelingStrategy.class);
    public static final double MIN_TEXT_SIZE = 3.0;
    private static final String ATTR_IN_TABLE_LABELING_STRATEGY_PERSISTENCE_DEFINITION_NAME = "AttrInTableLabelingStrategy";
    private ILabelingMethod method = new DefaultLabelingMethod();
    private IZoomConstraints zoom;
    private FLyrVect layer;
    private double fixedSize = 10.0;
    private Color fixedColor;
    private boolean useFixedSize;
    private boolean useFixedColor;
    private String[] usedFields = null;
    private Font font;
    private Color colorFont;
    private String textFieldName;
    private String rotationFieldName;
    private String heightFieldName;
    private String colorFieldName;

    public ILabelingMethod getLabelingMethod() {
        return this.method;
    }

    public void setLabelingMethod(ILabelingMethod method) {
        this.method = method;
    }

    public IPlacementConstraints getPlacementConstraints() {
        return null;
    }

    public void setPlacementConstraints(IPlacementConstraints constraints) {
    }

    public IZoomConstraints getZoomConstraints() {
        return this.zoom;
    }

    public void setZoomConstraints(IZoomConstraints constraints) {
        this.zoom = constraints;
    }

    private void draw(BufferedImage image, Graphics2D g, double scale, ViewPort viewPort, Cancellable cancel, PrintAttributes props) throws ReadException {
        this.setCartographicContext(viewPort, props, null);
        SimpleTextSymbol sym = new SimpleTextSymbol();
        sym.setFont(this.getFont());
        sym.setCartographicContext(this.getCartographicContext());
        if (this.zoom == null || this.zoom.isUserDefined() && scale >= (double)this.zoom.getMaxScale() && scale <= (double)this.zoom.getMinScale()) {
            FeatureSet set = null;
            DisposableIterator iterator = null;
            try {
                FilteredLogger logger = new FilteredLogger(AttrInTableLabelingStrategy.logger, 10);
                ArrayList<String> fields = new ArrayList<String>();
                int heightPos = -1;
                int rotationPos = -1;
                int textPos = -1;
                int colorPos = -1;
                if (!this.usesFixedSize() && this.getHeightField() != null) {
                    heightPos = fields.size();
                    fields.add(this.getHeightField());
                }
                if (this.getRotationField() != null) {
                    rotationPos = fields.size();
                    fields.add(this.getRotationField());
                }
                if (this.getTextField() != null) {
                    textPos = fields.size();
                    fields.add(this.getTextField());
                }
                if (!this.usesFixedColor() && this.getColorField() != null) {
                    colorPos = fields.size();
                    fields.add(this.getColorField());
                }
                FeatureStore featureStore = this.layer.getFeatureStore();
                ICoordTrans ct = this.layer.getCoordTrans();
                String geomName = featureStore.getDefaultFeatureType().getDefaultGeometryAttributeName();
                fields.add(geomName);
                FeatureQuery featureQuery = this.layer.createFeatureQuery();
                if (viewPort.getAdjustedEnvelope().contains(this.layer.getFullEnvelope())) {
                    set = featureStore.getFeatureSet(featureQuery);
                } else {
                    Evaluator iee = null;
                    IProjection data_proj = null;
                    Envelope env_in_store_crs = null;
                    if (ct == null) {
                        env_in_store_crs = viewPort.getAdjustedEnvelope();
                        data_proj = viewPort.getProjection();
                    } else {
                        env_in_store_crs = viewPort.getAdjustedEnvelope().convert(ct.getInverted());
                        data_proj = ct.getPOrig();
                    }
                    iee = SpatialEvaluatorsFactory.getInstance().intersects(env_in_store_crs, data_proj, featureStore);
                    featureQuery.setAttributeNames(fields.toArray(new String[fields.size()]));
                    featureQuery.setFilter(iee);
                    set = featureStore.getFeatureSet(featureQuery);
                }
                iterator = set.fastIterator();
                while (iterator.hasNext()) {
                    if (cancel.isCanceled()) {
                        return;
                    }
                    try {
                        Color color;
                        double size;
                        Geometry geom;
                        Feature feature;
                        block46: {
                            block45: {
                                feature = (Feature)iterator.next();
                                geom = feature.getDefaultGeometry();
                                if (geom == null) continue;
                                size = 0.0;
                                color = null;
                                if (this.useFixedSize) {
                                    size = this.fixedSize;
                                } else {
                                    if (this.heightFieldName != null) {
                                        try {
                                            size = feature.getDouble((String)fields.get(heightPos));
                                            break block45;
                                        }
                                        catch (Exception e) {
                                            logger.warn("Null text height value for text '" + feature.getString((String)fields.get(textPos)) + "'.");
                                            continue;
                                        }
                                    }
                                    size = sym.getFont().getSize();
                                }
                            }
                            double the_dpi = viewPort.getDPI();
                            if (props != null) {
                                int len = PrintAttributes.PRINT_QUALITY_DPI.length;
                                int priq = props.getPrintQuality();
                                if (priq < 0 || priq >= len) {
                                    throw new ReadException(featureStore.getName(), (Throwable)new Exception("Bad print quality value: " + priq));
                                }
                                the_dpi = PrintAttributes.PRINT_QUALITY_DPI[priq];
                            }
                            if ((size = this.toCartographicUnits(size)) <= 3.0) continue;
                            sym.setFontSize(size);
                            if (this.useFixedColor) {
                                color = this.fixedColor;
                            } else {
                                if (this.colorFieldName != null) {
                                    try {
                                        color = new Color(feature.getInt((String)fields.get(colorPos)));
                                        break block46;
                                    }
                                    catch (ClassCastException ccEx) {
                                        if (feature.get((String)fields.get(colorPos)) != null) {
                                            throw new ReadException("Unknown", (Throwable)ccEx);
                                        }
                                        logger.warn("Null color value for text '" + feature.getString(this.textFieldName) + "'.");
                                        continue;
                                    }
                                }
                                color = sym.getTextColor();
                            }
                        }
                        sym.setTextColor(color);
                        if (ct != null) {
                            geom = geom.cloneGeometry();
                            geom.reProject(ct);
                        }
                        double rotation = 0.0;
                        Point p = null;
                        if (this.rotationFieldName != null) {
                            rotation = -Math.toRadians(((Number)feature.get((String)fields.get(rotationPos))).doubleValue());
                            p = this.createLabelPoint(geom);
                        } else {
                            GeometryType gty = geom.getGeometryType();
                            if (gty.isTypeOf(2) || gty.isTypeOf(8)) {
                                Geometry aux_geom = geom.cloneGeometry();
                                aux_geom.transform(viewPort.getAffineTransform());
                                DefaultPathLength pathLen = new DefaultPathLength((Shape)aux_geom);
                                float length = pathLen.lengthOfPath();
                                float distance = (float)((double)length * 0.4);
                                rotation = pathLen.angleAtLength(distance);
                                if (rotation < -1.5707963267948966) {
                                    rotation += Math.PI;
                                } else if (rotation > 1.5707963267948966) {
                                    rotation -= Math.PI;
                                }
                                double norm = -rotation + 1.5707963267948966;
                                Point2D p2 = pathLen.pointAtLength(distance);
                                Point2D.Double p2_anchor = new Point2D.Double();
                                try {
                                    viewPort.getAffineTransform().inverseTransform(p2, p2_anchor);
                                }
                                catch (NoninvertibleTransformException e) {
                                    logger.warn("While computing anchor point", e);
                                }
                                double font_offset = 0.8 * size / viewPort.getAffineTransform().getScaleX();
                                ((Point2D)p2_anchor).setLocation(((Point2D)p2_anchor).getX() + font_offset * Math.cos(norm), ((Point2D)p2_anchor).getY() + font_offset * Math.sin(norm));
                                p = GeometryLocator.getGeometryManager().createPoint(((Point2D)p2_anchor).getX(), ((Point2D)p2_anchor).getY(), 0);
                            } else {
                                p = this.createLabelPoint(geom);
                            }
                        }
                        sym.setText(feature.getString((String)fields.get(textPos)));
                        sym.setRotation(rotation);
                        if (p == null) continue;
                        if (props == null) {
                            sym.draw(g, viewPort.getAffineTransform(), (Geometry)p, feature, cancel);
                            continue;
                        }
                        sym.print(g, viewPort.getAffineTransform(), (Geometry)p, props);
                    }
                    catch (Exception ex) {
                        logger.warn("", ex);
                    }
                }
            }
            catch (BaseException e) {
                throw new ReadException("Could not draw annotation in the layer.", (Throwable)e);
            }
            finally {
                if (iterator != null) {
                    iterator.dispose();
                }
                if (set != null) {
                    set.dispose();
                }
            }
        }
    }

    public void draw(BufferedImage image, Graphics2D g, double scale, ViewPort viewPort, Cancellable cancel, double dpi) throws ReadException {
        this.draw(image, g, scale, viewPort, cancel, null);
    }

    private Point createLabelPoint(Geometry geom) throws CreateGeometryException {
        try {
            return geom.centroid();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getRotationField() {
        return this.rotationFieldName;
    }

    public String getTextField() {
        return this.textFieldName;
    }

    public String getHeightField() {
        return this.heightFieldName;
    }

    public String getColorField() {
        return this.colorFieldName;
    }

    public void setTextField(String textFieldName) {
        this.textFieldName = textFieldName;
        this.usedFields = null;
    }

    public void setRotationField(String rotationFieldName) {
        this.rotationFieldName = rotationFieldName;
        this.usedFields = null;
    }

    public void setHeightField(String heightFieldName) {
        this.heightFieldName = heightFieldName;
        this.usedFields = null;
    }

    public void setColorField(String colorFieldName) {
        this.colorFieldName = colorFieldName;
    }

    public void print(Graphics2D g, double scale, ViewPort viewPort, Cancellable cancel, PrintAttributes props) throws ReadException {
        this.draw(null, g, scale, viewPort, cancel, props);
    }

    public void setUsesFixedSize(boolean b) {
        this.useFixedSize = b;
        this.usedFields = null;
    }

    public boolean usesFixedSize() {
        return this.useFixedSize;
    }

    public double getFixedSize() {
        return this.fixedSize;
    }

    public void setFixedSize(double fixedSize) {
        this.fixedSize = fixedSize;
        this.usedFields = null;
    }

    public void setUsesFixedColor(boolean b) {
        this.useFixedColor = b;
        this.usedFields = null;
    }

    public boolean usesFixedColor() {
        return this.useFixedColor;
    }

    public Color getFixedColor() {
        return this.fixedColor;
    }

    public void setFixedColor(Color fixedColor) {
        this.fixedColor = fixedColor;
    }

    public String[] getUsedFields() {
        if (this.usedFields == null) {
            ArrayList<String> v = new ArrayList<String>(4);
            if (!this.usesFixedSize() && this.getHeightField() != null) {
                v.add(this.getHeightField());
            }
            if (this.getRotationField() != null) {
                v.add(this.getRotationField());
            }
            if (this.getTextField() != null) {
                v.add(this.getTextField());
            }
            if (!this.usesFixedColor() && this.getColorField() != null) {
                v.add(this.getColorField());
            }
            this.usedFields = v.toArray(new String[v.size()]);
        }
        return this.usedFields;
    }

    public void setLayer(FLayer layer) {
        FeatureType type;
        this.layer = (FLyrVect)layer;
        if (layer == null) {
            return;
        }
        try {
            type = this.layer.getFeatureStore().getDefaultFeatureType();
        }
        catch (DataException e) {
            throw new RuntimeException(((Object)((Object)this)).getClass().getName(), e);
        }
        if (this.textFieldName == null || type.getIndex(this.textFieldName) < 0) {
            // empty if block
        }
        if (this.rotationFieldName == null || type.getIndex(this.rotationFieldName) < 0) {
            // empty if block
        }
        if (this.heightFieldName == null || type.getIndex(this.heightFieldName) < 0) {
            // empty if block
        }
        if (this.colorFieldName == null || type.getIndex(this.colorFieldName) < 0) {
            // empty if block
        }
    }

    public boolean shouldDrawLabels(double scale) {
        return this.layer.isWithinScale(scale);
    }

    public Color getColorFont() {
        return this.colorFont;
    }

    public void setColorFont(Color colorFont) {
        this.colorFont = colorFont;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font selFont) {
        this.font = selFont;
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.setTextField(state.getString(FIELD_TEXT));
        this.setHeightField(state.getString(FIELD_HEIGHT));
        this.setColorField(state.getString(FIELD_COLOR));
        this.setRotationField(state.getString(FIELD_ROTATION));
        this.setUnit(state.getInt(FIELD_UNIT));
        this.setFont((Font)state.get(FIELD_FONT));
        this.useFixedSize = state.getBoolean(FIELD_USE_FIXED_SIZE);
        this.setFixedSize(state.getDouble(FIELD_FIXED_SIZE));
        this.useFixedColor = state.getBoolean(FIELD_USE_FIXED_COLOR);
        this.setFixedColor((Color)state.get(FIELD_FIXED_COLOR));
        this.setReferenceSystem(state.getInt(FIELD_REFERENCE_SYSTEM));
        this.setColorFont((Color)state.get(FIELD_COLOR_FONT));
        this.setZoomConstraints((IZoomConstraints)state.get(FIELD_ZOOM_CONSTRAINTS));
        this.setLabelingMethod((ILabelingMethod)state.get(FIELD_LABELING_METHOD));
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set(FIELD_TEXT, this.getTextField());
        state.set(FIELD_HEIGHT, this.getHeightField());
        state.set(FIELD_COLOR, this.getColorField());
        state.set(FIELD_ROTATION, this.getRotationField());
        state.set(FIELD_UNIT, this.getUnit());
        state.set(FIELD_FONT, (Object)this.getFont());
        state.set(FIELD_USE_FIXED_SIZE, this.useFixedSize);
        state.set(FIELD_FIXED_SIZE, this.getFixedSize());
        state.set(FIELD_USE_FIXED_COLOR, this.useFixedColor);
        state.set(FIELD_FIXED_COLOR, (Object)this.getFixedColor());
        state.set(FIELD_REFERENCE_SYSTEM, this.getReferenceSystem());
        state.set(FIELD_COLOR_FONT, (Object)this.getColorFont());
        state.set(FIELD_ZOOM_CONSTRAINTS, (Persistent)this.getZoomConstraints());
        state.set(FIELD_LABELING_METHOD, (Persistent)this.getLabelingMethod());
    }

    public static class RegisterPersistence
    implements Callable {
        public Object call() throws Exception {
            PersistenceManager manager = ToolsLocator.getPersistenceManager();
            if (manager.getDefinition(AttrInTableLabelingStrategy.ATTR_IN_TABLE_LABELING_STRATEGY_PERSISTENCE_DEFINITION_NAME) == null) {
                DynStruct definition = manager.addDefinition(AttrInTableLabelingStrategy.class, AttrInTableLabelingStrategy.ATTR_IN_TABLE_LABELING_STRATEGY_PERSISTENCE_DEFINITION_NAME, "AttrInTableLabelingStrategy Persistence definition", null, null);
                definition.addDynFieldString(AttrInTableLabelingStrategy.FIELD_TEXT).setMandatory(true);
                definition.addDynFieldString(AttrInTableLabelingStrategy.FIELD_HEIGHT).setMandatory(false);
                definition.addDynFieldString(AttrInTableLabelingStrategy.FIELD_COLOR).setMandatory(false);
                definition.addDynFieldString(AttrInTableLabelingStrategy.FIELD_ROTATION).setMandatory(false);
                definition.addDynFieldInt(AttrInTableLabelingStrategy.FIELD_UNIT).setMandatory(true);
                definition.addDynFieldObject(AttrInTableLabelingStrategy.FIELD_FONT).setMandatory(false).setClassOfValue(Font.class);
                definition.addDynFieldBoolean(AttrInTableLabelingStrategy.FIELD_USE_FIXED_SIZE).setMandatory(true);
                definition.addDynFieldDouble(AttrInTableLabelingStrategy.FIELD_FIXED_SIZE).setMandatory(false);
                definition.addDynFieldBoolean(AttrInTableLabelingStrategy.FIELD_USE_FIXED_COLOR).setMandatory(true);
                definition.addDynFieldObject(AttrInTableLabelingStrategy.FIELD_FIXED_COLOR).setMandatory(false).setClassOfValue(Color.class);
                definition.addDynFieldInt(AttrInTableLabelingStrategy.FIELD_REFERENCE_SYSTEM).setMandatory(true);
                definition.addDynFieldObject(AttrInTableLabelingStrategy.FIELD_COLOR_FONT).setMandatory(false).setClassOfValue(Color.class);
                definition.addDynFieldObject(AttrInTableLabelingStrategy.FIELD_ZOOM_CONSTRAINTS).setMandatory(false).setClassOfValue(IZoomConstraints.class);
                definition.addDynFieldObject(AttrInTableLabelingStrategy.FIELD_LABELING_METHOD).setMandatory(true).setClassOfValue(ILabelingMethod.class);
            }
            return Boolean.TRUE;
        }
    }

    static class FilteredLogger {
        private int count = 0;
        private final Logger logger;
        private final int max;

        public FilteredLogger(Logger logger, int max) {
            this.max = max;
            this.logger = logger;
        }

        public void warn(String msg, Throwable th) {
            if (++this.count < this.max) {
                this.logger.warn(msg, th);
            } else if (this.count == this.max) {
                this.logger.warn(msg, th);
                this.logger.warn("Too many errors, don't dump more in this process.");
            }
        }

        public void warn(String msg) {
            if (++this.count < this.max) {
                this.logger.warn(msg);
            } else if (this.count == this.max) {
                this.logger.warn(msg);
                this.logger.warn("Too many errors, don't dump more in this process.");
            }
        }

        public void info(String msg) {
            if (++this.count < this.max) {
                this.logger.info(msg);
            } else if (this.count == this.max) {
                this.logger.info(msg);
                this.logger.info("Too many errors, don't dump more in this process.");
            }
        }
    }
}

