/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.impl;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gvsig.compat.print.PrintAttributes;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.rendering.symbols.CartographicSupport;
import org.gvsig.fmap.mapcontext.rendering.symbols.IMultiLayerSymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolManager;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.IMarkerSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.IMarkerSymbol_v2;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.IMultiLayerMarkerSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.impl.AbstractMarkerSymbol;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.task.Cancellable;
import org.gvsig.tools.util.Callable;

public class MultiLayerMarkerSymbol
extends AbstractMarkerSymbol
implements IMarkerSymbol,
IMultiLayerSymbol,
IMultiLayerMarkerSymbol {
    public static final String MULTILAYER_MARKER_SYMBOL_PERSISTENCE_DEFINITION_NAME = "MultiLayerMarkerSymbol";
    private static final String FIELD_LAYERS = "layers";
    private static final String FIELD_ROTATION = "rotation";
    private IMarkerSymbol[] layers = new IMarkerSymbol[0];
    private MultiLayerMarkerSymbol selectionSymbol;
    private double markerSize;
    private double rotation;

    @Override
    public Color getColor() {
        return null;
    }

    @Override
    public double getRotation() {
        return this.rotation;
    }

    @Override
    public void setColor(Color color) {
        for (int i = 0; this.layers != null && i < this.layers.length; ++i) {
            if (this.layers[i] == null) continue;
            this.layers[i].setColor(color);
        }
    }

    @Override
    public void setRotation(double rotation) {
        this.rotation = rotation;
    }

    @Override
    public double getSize() {
        double myMarkerSize = 0.0;
        for (int i = 0; i < this.getLayerCount(); ++i) {
            ISymbol layer = this.getLayer(i);
            if (layer == null) continue;
            myMarkerSize = Math.max(myMarkerSize, ((IMarkerSymbol)layer).getSize());
        }
        if (this.markerSize != myMarkerSize) {
            this.markerSize = myMarkerSize;
        }
        return this.markerSize;
    }

    @Override
    public void setSize(double size) {
        if (size > 0.0 && size != this.getSize()) {
            double scale = size / this.getSize();
            this.markerSize = size;
            for (int i = 0; this.layers != null && i < this.layers.length; ++i) {
                if (this.layers[i] == null) continue;
                double lSize = this.layers[i].getSize();
                this.layers[i].setSize(lSize * scale);
            }
        }
    }

    public void draw(Graphics2D g, AffineTransform affineTransform, Geometry geom, Feature f, Cancellable cancel, Rectangle r) {
        Point p;
        if (r != null) {
            geom = this.getSampleGeometry(r);
        }
        try {
            p = geom.centroid();
        }
        catch (Exception ex) {
            return;
        }
        g.rotate(this.rotation, p.getX(), p.getY());
        for (int i = 0; !(cancel != null && cancel.isCanceled() || this.layers == null || i >= this.layers.length); ++i) {
            IMarkerSymbol layer = this.layers[i];
            if (layer == null) continue;
            layer.setCartographicContext(this.getCartographicContext());
            if (layer instanceof IMarkerSymbol_v2) {
                ((IMarkerSymbol_v2)layer).draw(g, affineTransform, geom, f, cancel, r);
                continue;
            }
            layer.draw(g, affineTransform, geom, f, cancel);
        }
        g.rotate(-this.rotation, p.getX(), p.getY());
    }

    public ISymbol getSymbolForSelection() {
        if (this.selectionSymbol == null) {
            this.selectionSymbol = new MultiLayerMarkerSymbol();
            this.selectionSymbol.setDescription(this.getDescription());
            for (int i = 0; this.layers != null && i < this.layers.length; ++i) {
                this.selectionSymbol.addLayer(this.layers[i].getSymbolForSelection());
            }
        } else {
            for (int i = 0; i < this.selectionSymbol.getLayerCount(); ++i) {
                this.selectionSymbol.setLayer(i, this.selectionSymbol.getLayer(i).getSymbolForSelection());
            }
        }
        if (this.selectionSymbol instanceof CartographicSupport) {
            this.selectionSymbol.setUnit(this.getUnit());
        }
        return this.selectionSymbol;
    }

    @Override
    public boolean isSuitableFor(Geometry geom) {
        return geom.getType() == 1;
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void print(Graphics2D g, AffineTransform at, Geometry geom, PrintAttributes properties) {
        for (int i = 0; this.layers != null && i < this.layers.length; ++i) {
            if (this.layers[i] == null) continue;
            this.layers[i].print(g, at, geom, properties);
        }
    }

    public void setLayer(int index, ISymbol layer) throws IndexOutOfBoundsException {
        this.layers[index] = (IMarkerSymbol)layer;
    }

    public void swapLayers(int index1, int index2) {
        ISymbol aux1 = this.getLayer(index1);
        ISymbol aux2 = this.getLayer(index2);
        this.layers[index2] = (IMarkerSymbol)aux1;
        this.layers[index1] = (IMarkerSymbol)aux2;
    }

    public ISymbol getLayer(int layerIndex) {
        return this.layers[layerIndex];
    }

    public int getLayerCount() {
        return this.layers.length;
    }

    public void addLayer(ISymbol newLayer) {
        this.addLayer(newLayer, this.layers.length);
    }

    public void addLayer(ISymbol newLayer, int layerIndex) throws IndexOutOfBoundsException {
        if (newLayer == null) {
            return;
        }
        if (!(newLayer instanceof IMarkerSymbol_v2)) {
            LOGGER.info("Symbol " + newLayer.getClass().getName() + " does not implement IMarkerSymbol_v2");
        }
        IMarkerSymbol newMarker = (IMarkerSymbol)newLayer;
        if (this.getLayerCount() == 0) {
            this.setReferenceSystem(newMarker.getReferenceSystem());
            this.markerSize = newMarker.getSize();
            this.setUnit(newMarker.getUnit());
        } else {
            if (newMarker.getSize() > this.getSize()) {
                this.markerSize = newMarker.getSize();
            }
            newMarker.setReferenceSystem(this.getReferenceSystem());
            newMarker.setUnit(this.getUnit());
        }
        this.selectionSymbol = null;
        if (layerIndex < 0 || this.layers.length < layerIndex) {
            throw new IndexOutOfBoundsException(layerIndex + " < 0 or " + layerIndex + " > " + this.layers.length);
        }
        ArrayList<IMarkerSymbol> newLayers = new ArrayList<IMarkerSymbol>();
        newLayers.addAll(Arrays.asList(this.layers));
        try {
            newLayers.add(layerIndex, (IMarkerSymbol)newLayer);
            this.layers = newLayers.toArray(new IMarkerSymbol[newLayers.size()]);
        }
        catch (ArrayStoreException asEx) {
            throw new ClassCastException(newLayer.getClass().getName() + " is not an IMarkerSymbol");
        }
    }

    public boolean removeLayer(ISymbol layer) {
        int capacity = this.layers.length;
        ArrayList<IMarkerSymbol> lst = new ArrayList<IMarkerSymbol>(capacity);
        for (int i = 0; i < capacity; ++i) {
            lst.add(this.layers[i]);
        }
        boolean contains = lst.remove((IMarkerSymbol)layer);
        this.layers = lst.toArray(new IMarkerSymbol[0]);
        return contains;
    }

    public void setUnit(int unit) {
        super.setUnit(unit);
        for (int i = 0; this.layers != null && i < this.layers.length; ++i) {
            if (this.layers[i] == null) continue;
            this.layers[i].setUnit(unit);
        }
    }

    public void setReferenceSystem(int system) {
        super.setReferenceSystem(system);
        for (int i = 0; this.layers != null && i < this.layers.length; ++i) {
            if (this.layers[i] == null) continue;
            this.layers[i].setReferenceSystem(system);
        }
    }

    @Override
    public void setAlpha(int alpha) {
        int i;
        int maxAlpha = Integer.MIN_VALUE;
        int maxAlphaLayerIndex = 0;
        for (i = 0; this.layers != null && i < this.layers.length; ++i) {
            if (this.layers[i] == null || this.layers[i].getColor().getAlpha() <= maxAlpha) continue;
            maxAlpha = this.layers[i].getColor().getAlpha();
            maxAlphaLayerIndex = i;
        }
        for (i = 0; this.layers != null && i < this.layers.length; ++i) {
            if (this.layers[i] == null) continue;
            int r = this.layers[i].getColor().getRed();
            int g = this.layers[i].getColor().getGreen();
            int b = this.layers[i].getColor().getBlue();
            if (i != maxAlphaLayerIndex) {
                double scaledAlpha = (double)this.layers[i].getColor().getAlpha() / (double)maxAlpha;
                int myAlpha = (int)((double)alpha * scaledAlpha);
                if (myAlpha == 0) {
                    myAlpha = 1;
                }
                this.layers[i].setColor(new Color(r, g, b, myAlpha));
                continue;
            }
            int myAlpha = alpha;
            if (myAlpha == 0) {
                myAlpha = 1;
            }
            this.layers[i].setColor(new Color(r, g, b, myAlpha));
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        MultiLayerMarkerSymbol copy = (MultiLayerMarkerSymbol)((Object)super.clone());
        if (this.layers != null) {
            IMarkerSymbol[] layersCopy = new IMarkerSymbol[this.layers.length];
            for (int i = 0; i < this.layers.length; ++i) {
                if (this.layers[i] == null) continue;
                layersCopy[i] = (IMarkerSymbol)this.layers[i].clone();
            }
            copy.layers = layersCopy;
        }
        if (this.selectionSymbol != null) {
            copy.selectionSymbol = (MultiLayerMarkerSymbol)((Object)this.selectionSymbol.clone());
        }
        return copy;
    }

    @Override
    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        List theLayers = state.getList(FIELD_LAYERS);
        if (theLayers != null) {
            for (int i = 0; i < theLayers.size(); ++i) {
                Object layer = theLayers.get(i);
                if (layer == null) continue;
                this.addLayer((ISymbol)layer);
            }
        }
        this.setRotation(state.getDouble(FIELD_ROTATION));
    }

    @Override
    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        if (this.layers != null && this.layers.length > 0) {
            state.set(FIELD_LAYERS, Arrays.asList(this.layers));
        }
        state.set(FIELD_ROTATION, this.getRotation());
    }

    public static class RegisterSymbol
    implements Callable {
        public Object call() throws Exception {
            SymbolManager manager = MapContextLocator.getSymbolManager();
            int[] shapeTypes = new int[]{1, 7};
            manager.registerMultiLayerSymbol("marker", shapeTypes, MultiLayerMarkerSymbol.class);
            return true;
        }
    }

    public static class RegisterPersistence
    implements Callable {
        public Object call() throws Exception {
            PersistenceManager manager = ToolsLocator.getPersistenceManager();
            if (manager.getDefinition(MultiLayerMarkerSymbol.MULTILAYER_MARKER_SYMBOL_PERSISTENCE_DEFINITION_NAME) == null) {
                DynStruct definition = manager.addDefinition(MultiLayerMarkerSymbol.class, MultiLayerMarkerSymbol.MULTILAYER_MARKER_SYMBOL_PERSISTENCE_DEFINITION_NAME, "MultiLayerMarkerSymbol Persistence definition", null, null);
                definition.extend(manager.getDefinition("MarkerSymbol"));
                definition.addDynFieldList(MultiLayerMarkerSymbol.FIELD_LAYERS).setClassOfItems(IMarkerSymbol.class);
                definition.addDynFieldDouble(MultiLayerMarkerSymbol.FIELD_ROTATION).setMandatory(true);
            }
            return true;
        }
    }
}

