/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.impl;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.net.URL;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.rendering.symbols.CartographicSupport;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolDrawingException;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolManager;
import org.gvsig.i18n.Messages;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.IPictureMarkerSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.impl.AbstractMarkerSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style.BackgroundFileStyle;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.task.Cancellable;
import org.gvsig.tools.util.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PictureMarkerSymbol
extends AbstractMarkerSymbol
implements IPictureMarkerSymbol {
    private final Logger LOG = LoggerFactory.getLogger(PictureMarkerSymbol.class);
    public static final String PICTURE_MARKER_SYMBOL_PERSISTENCE_DEFINITION_NAME = "PictureMarkerSymbol";
    private static final String SELECTED = "selected";
    private static final String SELECTION_SYMBOL = "selectionSym";
    private static final String BACKGROUND_IMAGE = "bgImage";
    private static final String BACKGROUND_SELECTION_IMAGE = "bgSelImage";
    private boolean selected;
    private PictureMarkerSymbol selectionSym;
    private BackgroundFileStyle bgImage;
    private BackgroundFileStyle bgSelImage;

    public PictureMarkerSymbol() {
        this.setSize(18.0);
    }

    public PictureMarkerSymbol(URL imageURL, URL selImageURL) throws IOException {
        this.setImage(imageURL);
        if (selImageURL != null) {
            this.setSelImage(selImageURL);
        } else {
            this.setSelImage(imageURL);
        }
    }

    public final void setImage(URL imageUrl) throws IOException {
        this.bgImage = BackgroundFileStyle.createStyleByURL(imageUrl);
        this.bgImage.setSymbolTable(this.getSymbolTable(this.getFeature()));
    }

    public final void setSelImage(URL imageFileUrl) throws IOException {
        this.bgSelImage = BackgroundFileStyle.createStyleByURL(imageFileUrl);
        this.bgSelImage.setSymbolTable(this.getSymbolTable(this.getFeature()));
    }

    public ISymbol getSymbolForSelection(Color selectionColor) {
        if (this.selectionSym == null) {
            try {
                this.selectionSym = this.clone();
                this.selectionSym.setColor(selectionColor);
            }
            catch (CloneNotSupportedException e) {
                this.LOG.warn("Error creating the selection symbol for the symbol " + (Object)((Object)this), (Throwable)e);
            }
            this.selectionSym.selected = true;
            this.selectionSym.selectionSym = this.selectionSym;
        } else {
            this.selectionSym.setColor(selectionColor);
        }
        if (this.selectionSym instanceof CartographicSupport) {
            this.selectionSym.setUnit(this.getUnit());
        }
        return this.selectionSym;
    }

    public void draw(Graphics2D g, AffineTransform affineTransform, Geometry geom, Feature f, Cancellable cancel, Rectangle r) {
        Point p;
        double size_d = this.getEfectiveSize(f);
        size_d = this.getAdjustedSize(r, size_d);
        int size_i = (int)Math.round(size_d);
        if (r != null) {
            geom = this.getSampleGeometry(r);
        }
        try {
            p = geom.centroid();
        }
        catch (Exception ex) {
            return;
        }
        if (affineTransform != null) {
            p.transform(affineTransform);
        }
        double halfSize = size_d / 2.0;
        double x = p.getX() - halfSize;
        double y = p.getY() - halfSize;
        Point2D theOffset = this.getEfectiveOffset(f);
        int xOffset = (int)theOffset.getX();
        int yOffset = (int)theOffset.getY();
        if (size_i > 0) {
            if (this.isDrawLineToOffset()) {
                g.setColor(this.getEfectiveLineToOffsetColor(f));
                g.drawLine((int)p.getX(), (int)p.getY(), (int)p.getX() + xOffset, (int)p.getY() + yOffset);
            }
            BackgroundFileStyle bg = !this.selected ? this.bgImage : this.bgSelImage;
            Rectangle rect = new Rectangle(size_i, size_i);
            g.translate(x + (double)xOffset, y + (double)yOffset);
            double auxRotation = this.getEfectiveRotationInRadians(f);
            g.rotate(auxRotation, halfSize, halfSize);
            if (bg != null) {
                try {
                    bg.setSymbolTable(this.getSymbolTable(f));
                    bg.drawInsideRectangle(g, rect);
                }
                catch (SymbolDrawingException e) {
                    this.LOG.warn(Messages.getText((String)"label_style_could_not_be_painted") + ": " + bg.getSource().toString(), (Throwable)e);
                }
            } else {
                this.LOG.warn(Messages.getText((String)"label_style_could_not_be_painted") + ": bg is Null");
            }
            g.rotate(-auxRotation, halfSize, halfSize);
            g.translate(-(x + (double)xOffset), -(y + (double)yOffset));
        }
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public URL getSource() {
        return this.bgImage.getSource();
    }

    public URL getSelectedSource() {
        return this.bgSelImage.getSource();
    }

    public PictureMarkerSymbol clone() throws CloneNotSupportedException {
        PictureMarkerSymbol copy = (PictureMarkerSymbol)((Object)super.clone());
        if (this.selectionSym != null) {
            copy.selectionSym = this == this.selectionSym ? copy : this.selectionSym.clone();
        }
        if (this.bgImage != null) {
            copy.bgImage = (BackgroundFileStyle)((Object)this.bgImage.clone());
        }
        if (this.bgSelImage != null) {
            copy.bgSelImage = (BackgroundFileStyle)((Object)this.bgSelImage.clone());
        }
        return copy;
    }

    @Override
    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        this.selected = (Boolean)state.get(SELECTED);
        this.selectionSym = (PictureMarkerSymbol)((Object)state.get(SELECTION_SYMBOL));
        this.bgImage = (BackgroundFileStyle)((Object)state.get(BACKGROUND_IMAGE));
        this.bgSelImage = (BackgroundFileStyle)((Object)state.get(BACKGROUND_SELECTION_IMAGE));
    }

    @Override
    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        state.set(SELECTED, this.selected);
        state.set(SELECTION_SYMBOL, (Persistent)this.getSymbolForSelection());
        state.set(BACKGROUND_IMAGE, (Persistent)this.bgImage);
        state.set(BACKGROUND_SELECTION_IMAGE, (Persistent)this.bgSelImage);
    }

    public String[] getRequiredFeatureAttributeNames(FeatureStore featureStore) throws DataException {
        FeatureType ftype = featureStore.getDefaultFeatureTypeQuietly();
        String[] res = new String[ftype.size()];
        int cont = 0;
        for (FeatureAttributeDescriptor attr : ftype) {
            res[cont++] = attr.getName();
        }
        return res;
    }

    public void setFeature(Feature feature) {
        super.setFeature(feature);
        if (this.bgImage != null) {
            this.bgImage.setSymbolTable(this.getSymbolTable(this.getFeature()));
        }
        if (this.bgSelImage != null) {
            this.bgSelImage.setSymbolTable(this.getSymbolTable(this.getFeature()));
        }
    }

    public static class RegisterSymbol
    implements Callable {
        public Object call() throws Exception {
            SymbolManager manager = MapContextLocator.getSymbolManager();
            manager.registerSymbol(PictureMarkerSymbol.PICTURE_MARKER_SYMBOL_PERSISTENCE_DEFINITION_NAME, PictureMarkerSymbol.class);
            return true;
        }
    }

    public static class RegisterPersistence
    implements Callable {
        public Object call() throws Exception {
            PersistenceManager manager = ToolsLocator.getPersistenceManager();
            if (manager.getDefinition(PictureMarkerSymbol.PICTURE_MARKER_SYMBOL_PERSISTENCE_DEFINITION_NAME) == null) {
                DynStruct definition = manager.addDefinition(PictureMarkerSymbol.class, PictureMarkerSymbol.PICTURE_MARKER_SYMBOL_PERSISTENCE_DEFINITION_NAME, "PictureMarkerSymbol Persistence definition", null, null);
                definition.extend(manager.getDefinition("MarkerSymbol"));
                definition.addDynFieldBoolean(PictureMarkerSymbol.SELECTED).setMandatory(false);
                definition.addDynFieldObject(PictureMarkerSymbol.SELECTION_SYMBOL).setMandatory(false).setClassOfValue(PictureMarkerSymbol.class).setMandatory(false);
                definition.addDynFieldObject(PictureMarkerSymbol.BACKGROUND_IMAGE).setClassOfValue(BackgroundFileStyle.class).setMandatory(false);
                definition.addDynFieldObject(PictureMarkerSymbol.BACKGROUND_SELECTION_IMAGE).setClassOfValue(BackgroundFileStyle.class).setMandatory(false);
            }
            return true;
        }
    }
}

