/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.apache.batik.ext.awt.geom.DefaultPathLength;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.mapcontext.rendering.symbols.CartographicSupport;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol_v2;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.line.ILineSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.IArrowMarkerSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.IMarkerSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.impl.ArrowMarkerSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style.AbstractStyle;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style.IArrowDecoratorStyle;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.util.Callable;

public class ArrowDecoratorStyle
extends AbstractStyle
implements IArrowDecoratorStyle {
    public static final String ARROR_DECORATOR_STYLE_PERSISTENCE_DEFINITION_NAME = "ArrowDecoratorStyle";
    private static final String FIELD_FLIP_ALL = "flipAll";
    private static final String FIELD_FLIP_FIRST = "flipFirst";
    private static final String FIELD_ARROW_MARKER_COUNT = "arrowMarkerCount";
    private static final String FIELD_FOLLOW_LINE_ANGLE = "followLineAngle";
    private static final String FIELD_MARKER = "marker";
    private static final GeometryManager geomManager = GeometryLocator.getGeometryManager();
    private boolean flipAll = false;
    private boolean flipFirst = false;
    private int arrowMarkerCount = 2;
    private boolean followLineAngle = true;
    private IMarkerSymbol marker = this.getDefaultMarker();

    public ArrowDecoratorStyle() {
        this.marker.setSize(10.0);
        ((IArrowMarkerSymbol)this.marker).setSharpness(30.0);
    }

    private IMarkerSymbol getDefaultMarker() {
        return new ArrowMarkerSymbol();
    }

    public int getArrowMarkerCount() {
        return this.arrowMarkerCount;
    }

    public void setArrowMarkerCount(int arrowMarkerCount) {
        this.arrowMarkerCount = arrowMarkerCount;
    }

    public boolean isFlipAll() {
        return this.flipAll;
    }

    public void setFlipAll(boolean flipAll) {
        this.flipAll = flipAll;
    }

    public boolean isFlipFirst() {
        return this.flipFirst;
    }

    public void setFlipFirst(boolean flipFirst) {
        this.flipFirst = flipFirst;
    }

    public boolean isFollowLineAngle() {
        return this.followLineAngle;
    }

    public void setFollowLineAngle(boolean followLineAngle) {
        this.followLineAngle = followLineAngle;
    }

    public void draw(Graphics2D g, AffineTransform affineTransform, Geometry geom, Feature feature) throws CreateGeometryException {
        Point2D p;
        if (this.arrowMarkerCount <= 0) {
            return;
        }
        Geometry geomToDraw = geom;
        if (affineTransform != null) {
            geomToDraw = geom.cloneGeometry();
            geomToDraw.transform(affineTransform);
        }
        DefaultPathLength pl = new DefaultPathLength(geomToDraw.getShape());
        float size = (float)this.marker.getSize();
        if (this.marker instanceof CartographicSupport) {
            this.marker.setCartographicContext(this.getCartographicContext());
            size = (float)this.marker.toCartographicUnits((double)size);
        }
        this.marker.setRotation(0.0);
        float myLineLength = pl.lengthOfPath();
        if (size > myLineLength) {
            return;
        }
        float step = this.arrowMarkerCount > 2 ? myLineLength / (float)(this.arrowMarkerCount - 1) : pl.lengthOfPath();
        float rotation1 = 0.0f;
        float rotation2 = 0.0f;
        Point startP = null;
        float theLength = pl.lengthOfPath();
        if ((this.flipFirst || this.flipAll) && this.flipFirst != this.flipAll && this.followLineAngle) {
            p = pl.pointAtLength(theLength - size);
            if (p != null) {
                startP = geomManager.createPoint(p.getX(), p.getY(), 0);
                if (this.followLineAngle) {
                    rotation1 = pl.angleAtLength(theLength - size);
                    rotation2 = pl.angleAtLength(theLength);
                    this.marker.setRotation((double)rotation1);
                }
                if (this.marker instanceof ISymbol_v2) {
                    ((ISymbol_v2)this.marker).draw(g, new AffineTransform(), (Geometry)startP, feature, null, null);
                } else {
                    this.marker.draw(g, new AffineTransform(), (Geometry)startP, feature, null);
                }
            }
        } else {
            p = pl.pointAtLength(theLength);
            if (p != null) {
                startP = geomManager.createPoint(p.getX(), p.getY(), 0);
                if (this.followLineAngle) {
                    rotation1 = pl.angleAtLength(theLength - size) + (float)Math.PI;
                    rotation2 = pl.angleAtLength(theLength) + (float)Math.PI;
                    this.marker.setRotation((double)rotation2);
                }
                if (this.marker instanceof ISymbol_v2) {
                    ((ISymbol_v2)this.marker).draw(g, new AffineTransform(), (Geometry)startP, feature, null, null);
                } else {
                    this.marker.draw(g, new AffineTransform(), (Geometry)startP, feature, null);
                }
            }
        }
        for (int i = 1; i < this.arrowMarkerCount - 1; ++i) {
            Point2D p2;
            float aLength = step * (float)i;
            if (this.flipAll && this.followLineAngle) {
                p2 = pl.pointAtLength(aLength - size);
                if (p2 == null) {
                    p2 = pl.pointAtLength(theLength);
                }
                startP = geomManager.createPoint(p2.getX(), p2.getY(), 0);
                if (this.followLineAngle) {
                    rotation1 = pl.angleAtLength(aLength);
                    rotation2 = pl.angleAtLength(aLength + size);
                    this.marker.setRotation((double)rotation1);
                }
                if (this.marker instanceof ISymbol_v2) {
                    ((ISymbol_v2)this.marker).draw(g, new AffineTransform(), (Geometry)startP, feature, null, null);
                    continue;
                }
                this.marker.draw(g, new AffineTransform(), (Geometry)startP, feature, null);
                continue;
            }
            p2 = pl.pointAtLength(aLength + size);
            if (p2 == null) {
                p2 = pl.pointAtLength(theLength);
            }
            startP = geomManager.createPoint(p2.getX(), p2.getY(), 0);
            if (this.followLineAngle) {
                rotation1 = (float)((double)pl.angleAtLength(aLength) + Math.PI);
                rotation2 = (float)((double)pl.angleAtLength(aLength + size) + Math.PI);
                this.marker.setRotation((double)rotation2);
            }
            if (this.marker instanceof ISymbol_v2) {
                ((ISymbol_v2)this.marker).draw(g, new AffineTransform(), (Geometry)startP, feature, null, null);
                continue;
            }
            this.marker.draw(g, new AffineTransform(), (Geometry)startP, feature, null);
        }
        startP = null;
        if (this.arrowMarkerCount > 1) {
            if (this.flipAll) {
                Point2D p3 = null;
                p3 = pl.pointAtLength(0.0f);
                if (p3 != null) {
                    startP = geomManager.createPoint(p3.getX(), p3.getY(), 0);
                    if (this.followLineAngle) {
                        rotation1 = pl.angleAtLength(size);
                        rotation2 = pl.angleAtLength(0.0f);
                        this.marker.setRotation((double)rotation2);
                    }
                    if (this.marker instanceof ISymbol_v2) {
                        ((ISymbol_v2)this.marker).draw(g, new AffineTransform(), (Geometry)startP, feature, null, null);
                    } else {
                        this.marker.draw(g, new AffineTransform(), (Geometry)startP, feature, null);
                    }
                }
            } else {
                Point2D p4 = null;
                p4 = this.followLineAngle ? pl.pointAtLength(size) : pl.pointAtLength(0.0f);
                if (p4 != null) {
                    startP = geomManager.createPoint(p4.getX(), p4.getY(), 0);
                    if (this.followLineAngle) {
                        rotation1 = (float)((double)pl.angleAtLength(size) + Math.PI);
                        rotation2 = (float)((double)pl.angleAtLength(0.0f) + Math.PI);
                        this.marker.setRotation((double)rotation1);
                    }
                    if (this.marker instanceof ISymbol_v2) {
                        ((ISymbol_v2)this.marker).draw(g, new AffineTransform(), (Geometry)startP, feature, null, null);
                    } else {
                        this.marker.draw(g, new AffineTransform(), (Geometry)startP, feature, null);
                    }
                }
            }
        }
    }

    public void drawInsideRectangle(Graphics2D g, Rectangle r) {
        throw new Error("Not yet implemented!");
    }

    public void drawOutline(Graphics2D g, Rectangle r) {
        throw new Error("Not yet implemented!");
    }

    public boolean isSuitableFor(ISymbol symbol) {
        return symbol instanceof ILineSymbol;
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public IMarkerSymbol getMarker() {
        if (this.marker == null) {
            this.marker = this.getDefaultMarker();
        }
        return this.marker;
    }

    public void setMarker(IMarkerSymbol marker) {
        this.marker = marker;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ArrowDecoratorStyle copy = (ArrowDecoratorStyle)((Object)super.clone());
        if (this.marker != null) {
            copy.marker = (IMarkerSymbol)this.marker.clone();
        }
        return copy;
    }

    @Override
    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        this.setArrowMarkerCount(state.getInt(FIELD_ARROW_MARKER_COUNT));
        this.setFlipAll(state.getBoolean(FIELD_FLIP_ALL));
        this.setFlipFirst(state.getBoolean(FIELD_FLIP_FIRST));
        this.setFollowLineAngle(state.getBoolean(FIELD_FOLLOW_LINE_ANGLE));
        this.setMarker((IMarkerSymbol)state.get(FIELD_MARKER));
    }

    @Override
    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        state.set(FIELD_ARROW_MARKER_COUNT, this.getArrowMarkerCount());
        state.set(FIELD_FLIP_ALL, this.isFlipAll());
        state.set(FIELD_FLIP_FIRST, this.isFlipFirst());
        state.set(FIELD_FOLLOW_LINE_ANGLE, this.isFollowLineAngle());
        state.set(FIELD_MARKER, (Persistent)this.getMarker());
    }

    public void setCartographicContext(CartographicSupport.CartographicContext ctx) {
        super.setCartographicContext(ctx);
        if (this.marker instanceof CartographicSupport.CartographicContext) {
            this.marker.setCartographicContext(ctx);
        }
    }

    public static class RegisterPersistence
    implements Callable {
        public Object call() throws Exception {
            PersistenceManager manager = ToolsLocator.getPersistenceManager();
            if (manager.getDefinition(ArrowDecoratorStyle.ARROR_DECORATOR_STYLE_PERSISTENCE_DEFINITION_NAME) == null) {
                DynStruct definition = manager.addDefinition(ArrowDecoratorStyle.class, ArrowDecoratorStyle.ARROR_DECORATOR_STYLE_PERSISTENCE_DEFINITION_NAME, "ArrowDecoratorStyle Persistence definition", null, null);
                definition.extend(manager.getDefinition("Style"));
                definition.addDynFieldInt(ArrowDecoratorStyle.FIELD_ARROW_MARKER_COUNT).setMandatory(true);
                definition.addDynFieldBoolean(ArrowDecoratorStyle.FIELD_FLIP_ALL).setMandatory(true);
                definition.addDynFieldBoolean(ArrowDecoratorStyle.FIELD_FLIP_FIRST).setMandatory(true);
                definition.addDynFieldBoolean(ArrowDecoratorStyle.FIELD_FOLLOW_LINE_ANGLE).setMandatory(true);
                definition.addDynFieldObject(ArrowDecoratorStyle.FIELD_MARKER).setClassOfValue(IMarkerSymbol.class).setMandatory(true);
            }
            return Boolean.TRUE;
        }
    }
}

