/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.GeneralPathX;
import org.gvsig.fmap.geom.primitive.Surface;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.fill.IFillSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style.AbstractStyle;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style.IMask;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.util.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMask
extends AbstractStyle
implements IMask {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultMask.class);
    public static final String DEFAULT_MASK_PERSISTENCE_DEFINITION_NAME = "DefaultMask";
    private static final String FIELD_SIZE = "size";
    private static final String FIELD_FILL_SYMBOL = "fillSymbol";
    private static final GeometryManager geomManager = GeometryLocator.getGeometryManager();
    private double size;
    private IFillSymbol fill;

    public double getSize() {
        return this.size;
    }

    public void setSize(double size) {
        this.size = size;
    }

    public IFillSymbol getFillSymbol() {
        return this.fill;
    }

    public void setFillSymbol(IFillSymbol fill) {
        this.fill = fill;
    }

    public void drawInsideRectangle(Graphics2D g, Rectangle r) {
        LOG.error("TODO: Not yet implemented");
        throw new Error("Not yet implemented!");
    }

    public Geometry getHaloShape(Shape shp) {
        BasicStroke stroke = new BasicStroke((int)this.getSize());
        Shape myShp = stroke.createStrokedShape(shp);
        Surface haloShape = null;
        try {
            haloShape = geomManager.createSurface(new GeneralPathX(myShp.getBounds2D().getPathIterator(null)), 0);
        }
        catch (CreateGeometryException e) {
            LOG.error("Error creating a surface", (Throwable)e);
        }
        return haloShape;
    }

    public boolean isSuitableFor(ISymbol symbol) {
        LOG.error("TODO: Not yet implemented");
        throw new Error("Not yet implemented!");
    }

    public void drawOutline(Graphics2D g, Rectangle r) {
        LOG.error("TODO: Not yet implemented");
        throw new Error("Not yet implemented!");
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DefaultMask copy = (DefaultMask)((Object)super.clone());
        if (this.fill != null) {
            copy.fill = (IFillSymbol)this.fill.clone();
        }
        return copy;
    }

    @Override
    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        this.setFillSymbol((IFillSymbol)state.get(FIELD_FILL_SYMBOL));
        this.setSize(state.getDouble(FIELD_SIZE));
    }

    @Override
    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        if (this.getFillSymbol() != null) {
            state.set(FIELD_FILL_SYMBOL, (Persistent)this.getFillSymbol());
        }
        state.set(FIELD_SIZE, this.getSize());
    }

    public static class RegisterPersistence
    implements Callable {
        public Object call() throws Exception {
            PersistenceManager manager = ToolsLocator.getPersistenceManager();
            if (manager.getDefinition(DefaultMask.DEFAULT_MASK_PERSISTENCE_DEFINITION_NAME) == null) {
                DynStruct definition = manager.addDefinition(DefaultMask.class, DefaultMask.DEFAULT_MASK_PERSISTENCE_DEFINITION_NAME, "DefaultMask Persistence definition", null, null);
                definition.extend(manager.getDefinition("Style"));
                definition.addDynFieldObject(DefaultMask.FIELD_FILL_SYMBOL).setClassOfValue(IFillSymbol.class);
                definition.addDynFieldDouble(DefaultMask.FIELD_SIZE).setMandatory(true);
            }
            return Boolean.TRUE;
        }
    }
}

