/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.catalog.csw.drivers;

import java.net.URL;
import org.apache.commons.httpclient.NameValuePair;
import org.gvsig.catalog.csw.drivers.CSWCatalogServiceDriver;
import org.gvsig.catalog.csw.drivers.profiles.CSWebRIMProfile;
import org.gvsig.catalog.drivers.profiles.IProfile;
import org.gvsig.catalog.metadataxml.XMLNode;
import org.gvsig.catalog.protocols.HTTPGetProtocol;

public class CSWebRIMCatalogServiceDriver
extends CSWCatalogServiceDriver {
    public static String SERVICE_NAME = "CSW/ebRIM";

    @Override
    public String getServiceName() {
        return SERVICE_NAME;
    }

    @Override
    public IProfile getProfile() {
        return new CSWebRIMProfile();
    }

    @Override
    protected XMLNode[] retrieveResults(XMLNode root) {
        XMLNode resultNode = root.searchNode("SearchResults");
        if (resultNode == null) {
            return new XMLNode[0];
        }
        XMLNode[] results = new XMLNode[resultNode.getNumSubNodes()];
        for (int i = 0; i < resultNode.getNumSubNodes(); ++i) {
            results[i] = resultNode.getSubNode(i);
        }
        return this.getEbRIMNodes(results);
    }

    private XMLNode[] getEbRIMNodes(XMLNode[] nodes) {
        if (this.capabilities.getOperations().getGetExtrinsicContent().size() == 0) {
            return nodes;
        }
        XMLNode[] auxNodes = new XMLNode[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            String id = nodes[i].searchAtribute("id");
            URL url = (URL)this.capabilities.getOperations().getGetExtrinsicContent().get("Get");
            auxNodes[i] = (XMLNode)new HTTPGetProtocol().doQuery(url, this.getEbRIMRequestParameters(id), 0).toArray()[0];
        }
        return auxNodes;
    }

    private NameValuePair[] getEbRIMRequestParameters(String id) {
        NameValuePair nvp1 = new NameValuePair("request", "getExtrinsicContent");
        NameValuePair nvp2 = new NameValuePair("id", id);
        return new NameValuePair[]{nvp1, nvp2};
    }
}

